/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


/*----------------------------------------


        video.h


        see video.c for implementation


----------------------------------------*/


#ifndef DEF_INC_VIDEO_H
#define DEF_INC_VIDEO_H


// **** include general libraries concerning definitions

//#ifndef DEF_ASMLIB
//#define DEF_ASMLIB            // set by dapple.h
//#endif

//#include <stdio.h>            // included by dapple.h
//#include <string.h>           // included by dapple.h
//#include "..\libs\general.h"  // included by dapple.h
//#include "..\libs\asmlib.h"   // included by dapple.h
#include "dapple.h"


// **** public functions

void            virtinit                (void);
void            virtreset               (void);

unsigned char   *virtstore              (unsigned int winprotocol, FILE *file, unsigned int percent);
unsigned char   *virtrestore            (unsigned int winprotocol, FILE *file, unsigned int percent);

void            virtsetmode             (void);
void            virtcacheinit           (void);
void            virtsetcharset          (Charset charset);
Charset         virtgetcharset          (void);
void            virtsettextmode         (unsigned int mode);
unsigned int    virtgettextmode         (void);
void            virtsetlresmode         (unsigned int mode);
unsigned int    virtgetlresmode         (void);
void            virtsethresmode         (unsigned int mode);
unsigned int    virtgethresmode         (void);
void            virtsetdhrsmode         (unsigned int mode);
unsigned int    virtgetdhrsmode         (void);
void            virtsetmonochrome       (unsigned int mode);
unsigned int    virtgetmonochrome       (void);

void            virtpaletteset          (unsigned int index, unsigned int r,unsigned int g, unsigned int b);
void            virtsetpalette          (unsigned int mode);
unsigned int    virtgetpalette          (void);
void            virtpaletteinit         (void);

unsigned int    virtcalcline            (unsigned char *virtptr, unsigned int rastline);
void            virtline                (void);

void            virtwrite0400           (unsigned int addr);
void            virtwrite0400aux        (unsigned int addr);
void            virtwrite0800           (unsigned int addr);
void            virtwrite0800aux        (unsigned int addr);
void            virtwrite2000           (unsigned int addr);
void            virtwrite2000aux        (unsigned int addr);
void            virtwrite4000           (unsigned int addr);
void            virtwrite4000aux        (unsigned int addr);

void            virtmenu                (void);


// **** public global variables

extern  unsigned char   virtvideobyte;
extern  unsigned int    virtrasterline;
extern  unsigned char   virtscanline;
extern  unsigned char   virtdouble;
extern  Charset         virtcharset;

// Warning! Only access the following for speed reasons
// Otherwise very bad style!
extern  unsigned char   virtgraphic;
extern  unsigned char   virtmixed;
extern  unsigned char   virtpage2;
extern  unsigned char   virthgr;
extern  unsigned char   virt80col;
extern  unsigned char   virtaltchar;
extern  unsigned char   virtdhres;
extern  unsigned char   virtiou;
extern  unsigned int    virtcachemode;
extern  unsigned char   virtvideobyte;
extern  unsigned char   *virtfontptr;
extern  unsigned char   *virtfontflashptr;
extern  unsigned char   virtfontalt[2048];


// --> #ifndef DEF_INC_VIDEO_H
#endif
