/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  LLDISK:  code for handling raw 1.44MB disks in drive A:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */

/*
 * Error listing:  Unless noted, all errors return 2.  TC++ 1.01
 *
 *   0: No error (data accepted)
 *   1: Bad command
 *   2: Address mark not found
 *   3: Write protected (returns 1)
 *   4: Sector not found
 *   5: Reset failed (hard disk)
 *   6: Disk changed
 *   7: Drive parameter activity failed
 *   8: DMA overrun
 *   9: DMA crosses segment boundary
 *  10: Bad sector detected
 *  11: Bad track detected
 *  12: Unsupported track
 *  16: CRC error
 *  17: CRC error, compensated (data accepted)
 *  32: Controller failure
 *  64: Seek error
 * 128: Attachment failed to respond
 * 170: Hard disk not ready
 * 187: ???
 * 204: Write fault
 * 224: Status error
 * 255: Sense operation failed
 */


/*----------------------------------------


        lldisk.c


        see include file lldisk.h for definitions


----------------------------------------*/


#ifndef DEF_INC_LLDISK_C
#define DEF_INC_LLDISK_C


// **** include general definition files

#include <bios.h>
#include <dos.h>
//#include <string.h>           // included by lldisk.h
//#include <stdio.h>            // included by lldisk.h
#include <unistd.h>             // used by chdir()
//#include "..\libs\asmlib.h"   // included by lldisk.h
//#include "..\libs\general.h"  // included by lldisk.h
//#include "dapple.h"           // included by lldisk.h


// **** include definition file of this source

#include "lldisk.h"


// **** include further Emu][ specific files

#include "gui.h"
#include "memory.h"


// **** local definitions

#define MS_DMA

/*
;Mass-storage device I/O
; $0 - Writing the ProDOS command here will perform that command.
;      It is important to setup the other locations first.
;      0=Status,1=Read,2=Write,3=Format
; $1 - Unit number $0-$3
; $2 - ProDOS buffer low byte
; $3 - ProDOS buffer high byte
; $4 - Block low byte
; $5 - Block high byte
; $6 - Data register
*/

#define PS_OK    0x00
#define PS_IOERR 0x27
#define PS_NODEV 0x28
#define PS_WRPRO 0x2b

#define STATUS_OFF 0
#define STATUS_RD  1
#define STATUS_WR  2



typedef struct
{
 unsigned int head;
 unsigned int track;
 unsigned int sector;
} drvptr;


// **** variables

static  unsigned char   lldiskrom[256];
static  unsigned char   lldiskpresent;
        unsigned char   lldiskactive;


unsigned int RawDiskSlot;


// const unsigned int RMaxBlock = 2880;

unsigned int RVolumeSize[ 4 ];          /* size of volumes in bytes */
int  RWritePro[ 4 ];                    /* if a volume is write-protected */
int  RValidBlock[ 4 ];                  /* if current block buffer contains valid data */
unsigned int  RBlock[ 4 ];              /* block # in buffer */
unsigned char RBuffer[ 4 ][ 512 ];      /* 512 byte buffer for each unit */

unsigned char RUnit;                    /* current unit */
unsigned int  RProDOSBuf;               /* Apple memory location to ProDOS buffer */
unsigned int  RByte[ 4 ];               /* current byte offset in buffer */
unsigned char RDataReg;                 /* current value of data register */
unsigned char RStatus;                  /* current status of device */






/*--------------------------------------*/


      void lldisklight(void) {

        if (((!lldiskpresent) || (!lldiskactive)) && (appletype != APPLEIIC)) {
          imagefillbox(window, SLOTX1, SLOT5Y, SLOTX1+1, SLOT5Y+1, 0);
        }
        else {
          imagefillbox(window, SLOTX1, SLOT5Y, SLOTX1+1, SLOT5Y+1, RGBLGHTOFF);
        }

      } // lldisklight


/*--------------------------------------*/


      void lldiskinit(void) {

        memset(lldiskrom, 0xff, sizeof(lldiskrom));
        lldiskpresent = 0;
        lldiskactive  = 1;
        lldisklight();

      } // lldiskinit


/*--------------------------------------*/


      void lldiskloadrom(unsigned int keyboard, unsigned int window) {
        FILE *file;
        unsigned char filepath[260];
        unsigned char oldcwd[260];

        cwdxchgslash(oldcwd, 256);                              // read old directory path
        chdir(inirompath);                                      // set rom directory

        strcpy(filepath, "slotmstr.a65");                       // search for source code
        file=fopen(filepath,"rb");
        if (!file) {
          strcpy(filepath, "slotmstr.s");
          file=fopen(filepath,"rb");
          if (!file) {
            strcpy(filepath, "slotmstr.asm");
            file=fopen(filepath,"rb");
          }
        }
        if (file) {
          fclose(file);                                         // close file again
          stringwritemessage(window,
"!\
EAssemble source code for massstore slot rom...\r;\
GAssembliere Source Code fr das Massstore-Slotrom...\r;\
;");
          screenupdate = 1;
          taskswitch();
          memset(lldiskrom, 0x00, sizeof(lldiskrom));
          assembler(lldiskrom, sizeof(lldiskrom), filepath);    // assemble source code
          lldiskpresent = 1;
        }
        else {
          strcpy(filepath, "massstor.rom");;                    // search binary rom file
          file=fopen(filepath,"rb");
          if (file) {
            stringwritemessage(window,
"!\
EReading massstore slot rom from file...\r;\
GLese Massstore-Slotrom aus Datei...\r;\
;");
            screenupdate = 1;
            taskswitch();
            fread(lldiskrom, sizeof(lldiskrom), 1, file);       // read binary rom file
            fclose(file);
            lldiskpresent = 1;
          }
          else {
            stringwritemessage(window,
"!\
ENo separate massstore slot rom found\r;\
GKein gesondertes Massstore-Slotrom vorhanden\r;\
;");
            screenupdate = 1;
            taskswitch();
            lldiskpresent = 0;
            lldiskactive  = 0;
          }
        }
        chdir(oldcwd);                                          // restore original directory
//      windowpresskey(keyboard, window);
//      debugger(lldiskrom, sizeof(lldiskrom));

      } // lldiskloadrom


/*--------------------------------------*/


      void InitRawDisk (unsigned int slot) {
        register unsigned int i;

        RawDiskSlot = slot;

        for (i=0; i < 4; i++ ) {
          RUnit = i;
          RValidBlock[i] = 0;
        }

        RVolumeSize[0] = 1474560;
        RStatus = 0;
        RUnit = 0;

      } // InitRawDisk


/*--------------------------------------*/


      void sec2hts (drvptr *hts, unsigned int sector) {
        register unsigned int avgtrk;

        hts->sector=sector%18;
        avgtrk=(sector-hts->sector)/18;
        hts->head=avgtrk%2;
        hts->track=(avgtrk-hts->head)/2;

// hts->track++;
        hts->sector++;
      } /* sec2hts */


/*--------------------------------------*/


      int llread (int sector, char *buf) {
        drvptr hts;
        register int error;

        imagefillbox(window, SLOTX1, SLOT5Y, SLOTX1+1, SLOT5Y+1, RGBLGHTON);
        screenupdate = 1;
        taskswitch();

        sec2hts(&hts, sector);

        error = biosdisk(2, 0, hts.head, hts.track, hts.sector, 1, buf);

        imagefillbox(window, SLOTX1, SLOT5Y, SLOTX1+1, SLOT5Y+1, RGBLGHTOFF);
        screenupdate = 1;

        if ((error==0) || (error==17)) return 0;
        if (error==3) return 1;
        return -1;
      } /* llread */


/*--------------------------------------*/


      int llwrite (int sector, char *buf) {
        drvptr hts;
        register int error;

        imagefillbox(window, SLOTX1, SLOT5Y, SLOTX1+1, SLOT5Y+1, RGBLGHTON);
        screenupdate = 1;
        taskswitch();

        sec2hts(&hts, sector);

        error = biosdisk(3, 0, hts.head, hts.track, hts.sector, 1, buf);

        imagefillbox(window, SLOTX1, SLOT5Y, SLOTX1+1, SLOT5Y+1, RGBLGHTOFF);
        screenupdate = 1;

        if ((error==0) || (error==17)) return 0;
        if (error==3) return 1;
        return -1;
      } /* llwrite */


/*--------------------------------------*/


/* This doesn't actually format the disk yet, we've got to work on that... */
      void RFormatVolume (void) {
 /* RStatus = PS_WRPRO; if write protected. */

// int travel, error;
// char zeroes[9216];

// for (travel=0; travel<9216; travel++)
// {
//  zeroes[travel]=0;
// }

// for (travel=0; travel<80; travel++)
// {
//   virtplot(314,2,COL_DRV_ON);
//   screenupdate = 1; /* force redraw of screen */
//   virtscreencopy();

//   error=biosdisk(3,0,0,travel,0,18,zeroes);

//   virtplot(314,2,COL_DRV_OFF);
//   screenupdate = 1; /* force redraw of screen */
//   virtscreencopy();

// if (error!=0&&error!=17) {RStatus=PS_IOERR; return;}
//   if (error==3) {RStatus=PS_WRPRO; return;}

//   error=biosdisk(3,0,1,travel,0,18,zeroes);
// if (error!=0&&error!=17) {RStatus=PS_IOERR; return;}
//   if (error==3) {RStatus=PS_WRPRO; return;}
// }
      } /* RFormatVolume */


/*--------------------------------------*/


      void RReadBlock(void) {
#ifdef MS_DMA
        register unsigned int bufptr;
#endif
        register int error;

        if ( !RValidBlock[RUnit] ) {
        /* get block from disk */
          if (RUnit) {
            RStatus = PS_NODEV;
          }
          else {

            error = llread(RBlock[RUnit], RBuffer[RUnit]);
            if (error == 2) {
              RStatus = PS_IOERR;
            }
            else {
              RValidBlock[RUnit] = 1;
              RByte[RUnit] = 0;
            }
          }
        }
        if (RStatus == PS_OK) {
#ifdef MS_DMA
          for ( bufptr = 0; bufptr < 512; bufptr++ ) {
            memorywrite( (RProDOSBuf + bufptr) & 0xffff, RBuffer[ RUnit ][ bufptr ] );
          }
#else
          RDataReg = RBuffer[ RUnit ][ RByte[ RUnit ] ];
          RByte[ RUnit ]++;
          if ( RByte[ RUnit ] == 0x200 ) {
            RByte[ RUnit ] = 0;
          }
#endif
        }
      } /* RReadBlock */


/*--------------------------------------*/


      void RWriteBlock(void) {
#ifdef MS_DMA
        register unsigned int bufptr;
#endif
        register int error;

#ifdef MS_DMA
        for ( bufptr = 0; bufptr < 512; bufptr++ ) {
          RBuffer[ RUnit ][ bufptr ] = memoryread( (RProDOSBuf + bufptr) & 0xffff );
        }
        RByte[ RUnit ] = 0;
#else
        RBuffer[ RUnit ][ RByte[ RUnit ] ] = RDataReg;
        RByte[ RUnit ]++;
        if ( RByte[ RUnit ] == 0x200 ) {
          RByte[ RUnit ] = 0;
        }
#endif
        /* If not a valid filehandle, then no device error */
        if (RUnit) {
          RStatus = PS_NODEV;
          return;
        }

        /* Only write when the buffer is full */
        if (RByte[RUnit] == 0) {

          error = llwrite(RBlock[RUnit],RBuffer[RUnit]);
          if (error == 1) {
            RStatus = PS_WRPRO;
            return;
          }
          if (error) {
            RStatus = PS_IOERR;
            return;
          }
        }
      } /* RWriteBlock */


/*--------------------------------------*/


      unsigned char *lldisknew(slot *slotpointer, unsigned int slotnumber) {

        slotpointer->slotclose          = (void *)&slotnofunction;
        slotpointer->slotreset          = (void *)&slotnofunction;
        slotpointer->slotstore          = (void *)&lldiskstore;
        slotpointer->slotrestore        = (void *)&lldiskrestore;
        slotpointer->slotget            = (void *)&lldiskread;
        slotpointer->slotset            = (void *)&lldiskwrite;
        slotpointer->slotromget         = (void *)&lldiskromread;
        slotpointer->slotromset         = (void *)&lldiskromwrite;
        slotpointer->slotmenu           = (void *)&lldiskmenu;
        slotpointer->slotshift          = (void *)&slotnofunction;
        slotpointer->slotctrl           = (void *)&slotnofunction;
        slotpointer->slotshiftctrl      = (void *)&slotnofunction;
        slotpointer->slottype           = SLOTTYPEMASSSTORE;
        slotpointer->slotdata           = NULL;
        slotpointer->slotname           =
"!\
EMass Store Device;\
GMassenspeicherungsgert;\
";

        if (!lldiskpresent) {
          return taskseterror("No rom present");        // no rom present ==> emulation not possible
        }
        return NULL;                                    // no error

      } // lldisknew


/*---------------------------------------*/


      unsigned char *lldiskstore(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        memset(header, 0x00, sizeof(header));
        strcpy(header, "MASS STORE DEVICE STATE V0.31");
        fwrite(header,                  sizeof(header),                 1,file);

        fwrite(lldiskrom,               sizeof(lldiskrom),              1,file);
        fwrite(&lldiskpresent,          sizeof(lldiskpresent),          1,file);
        fwrite(&lldiskactive,           sizeof(lldiskactive),           1,file);

        guipercent(winprotocol, percent,
"!\
EMass store device stored.;\
GMassenspeicherungsgert gespeichert.;\
");

        return NULL;            // no error

      } // lldiskstore


/*--------------------------------------*/


      unsigned char *lldiskrestore(void *slotdata, unsigned int winprotocol, FILE *file, unsigned int percent) {
        unsigned char header[32];

        fread(header,                   sizeof(header),                 1,file);
        if (strcmp(header, "MASS STORE DEVICE STATE V0.31")) {
          stringwrite(winprotocol, "Mass store device emulation data not found.\r");
          return taskseterror("Mass store device emulation data not found.");
        }

        fread(lldiskrom,                sizeof(lldiskrom),              1,file);
        fread(&lldiskpresent,           sizeof(lldiskpresent),          1,file);
        fread(&lldiskactive,            sizeof(lldiskactive),           1,file);

        guipercent(winprotocol, percent,
"!\
EMass store device restored.;\
GMassenspeicherungsgert geladen.;\
");

        return NULL;            // no error

      } // lldiskrestore


/*--------------------------------------*/


      unsigned char lldiskread(void *slotdata, unsigned int address) {
        register unsigned char v;

        if ((inidebugflag) || (!lldiskactive)) {
          return 0xff;
        }

        v = 0xff;
        switch (address & 0x0f) {
          case 0x01:
            v = RUnit;
          break;
          case 0x02:
#ifdef MS_DMA
            v = RProDOSBuf & 0xff;
#else
            v = RByte[RUnit] & 0xff;
#endif
            break;
          case 0x03:
#ifdef MS_DMA
            v = RProDOSBuf >> 8;
#else
            v = RByte[RUnit] >> 8;
#endif
            break;
          case 0x04:
            v = RBlock[RUnit] & 0xff;
            break;
          case 0x05:
            v = RBlock[RUnit] >> 8;
            break;
          case 0x06:
            v = RDataReg;
            break;
          case 0x07:
            v = RStatus;
            break;
        } // switch (address & 0x0f)

        return v;

      } // lldiskread


/*--------------------------------------*/


      void lldiskwrite(void *slotdata, unsigned int addr, unsigned char value) {

        if ((inidebugflag) || (!lldiskactive)) {
          return;
        }

        RStatus = PS_OK;
        switch (addr & 0x0f) {
          case 0x00:
            switch (value) {
              case 0x00:
                // Status
                // Set # blocks
                RBlock[ RUnit ] = 2880;
                break;
              case 0x01:
                RReadBlock();
                break;
              case 0x02:
                RWriteBlock();
                break;
              case 0x03:
                RFormatVolume();
                break;
            } // switch (value)
            break;
          case 0x01:
            RUnit = value;
            break;
          case 0x02:
#ifdef MS_DMA
            RProDOSBuf = ( RProDOSBuf & 0xff00 ) | value;
#else
            RByte[ RUnit ] = ( RByte[ RUnit ] & 0xff00 ) | value;
#endif
            break;
          case 0x03:
#ifdef MS_DMA
            RProDOSBuf = ( RProDOSBuf & 0x00ff ) | ( value << 8 );
#else
            RByte[ RUnit ] = ( RByte[ RUnit] & 0x00ff ) | ( value << 8 );
#endif
            break;
          case 0x04:
            RBlock[ RUnit ] = ( RBlock[ RUnit ] & 0xff00 ) | value;
            RValidBlock[ RUnit ] = 0;
            break;
          case 0x05:
            RBlock[ RUnit ] = ( RBlock[ RUnit ] & 0x00ff ) | ( value << 8 );
            RValidBlock[ RUnit ] = 0;
            break;
          case 0x06:
            RDataReg = value;
            break;
        } // switch (addr & 0x0f)
      } // lldiskwrite


/*--------------------------------------*/


      unsigned char lldiskromread(void *slotdata, unsigned int addr) {

        if (lldiskactive) {
          return lldiskrom[addr & 0xff];        // read from the rom which was separately loaded
        }
        else {
          return 0xff;
        }

      } // lldiskromread


/*--------------------------------------*/


      void lldiskromwrite(void *slotdata, unsigned int addr, unsigned char value) {

        return;         // Nothing happens here

      } // lldiskromwrite


/*--------------------------------------*/


      void lldiskmenu(void *slotdata) {
        unsigned int    menukeyboard;
        unsigned int    menuwindow;
        unsigned char   key;
        unsigned int    update;

        if (!windowaddio( -1, -1, WINDOWXSIZE, WINDOWYSIZE, -1, 1,
"!\
EMass Store Device Options;\
GMassenspeichergert Optionen;\
", 0, &menukeyboard, &menuwindow)) {
          update = 1;
          do {
            if (update) {
              channelout(menuwindow, 12);               // clear window
              stringwritemessage(menuwindow,
"!\
E\r[ESC] - Quit\r\r;\
G\r[ESC] - Verlasse Men\r\r;\
");
              if (appletype == APPLEIIC) {
                stringwritemessage(menuwindow,
"!\
E\rNo separate mass store device present on an Apple//c;\
G\rKein separates Massenspeicherungsgert vorhanden beim Apple//c;\
");
              }
              else {
                if (!lldiskpresent) {
                  stringwritemessage(menuwindow,
"!\
E\rNo mass store device present;\
G\rKein Massenspeicherungsgert vorhanden;\
");
                }
                else {
                  if (lldiskactive) {
                    stringwritemessage(menuwindow,
"!\
E\r[A] - Mass store device activated;\
G\r[A] - Massenspeicherungsgert aktiviert;\
");
                  }
                  else {
                    stringwritemessage(menuwindow,
"!\
E\r[A] - Mass store device inactive;\
G\r[A] - Massenspeicherungsgert deaktiviert;\
");
                  }
                }
              }
              update = 0;
              screenupdate = 1;
            }
            do {
              taskswitch();
              if (windowgetclose(menuwindow)) {
                key = 27;
              }
              else {
                key = (unsigned char)channelin(menukeyboard);
              }
            }
            while ((key == 0) && (!exitprogram));
            switch (key) {
              case 'a' :
              case 'A' :
                if (lldiskpresent && (!(appletype == APPLEIIC))) {
                  if (lldiskactive) {
                    lldiskactive = 0;
                  }
                  else {
                    lldiskactive = 1;
                  }
                  lldisklight();
                  update = 1;
                }
                break;
            } // switch (key)
          }
          while ((key != 27) && (key != 32) && (key != 13) && (!exitprogram));
          channelclose(menukeyboard);
          channelclose(menuwindow);
        }

      } // lldiskmenu



// --> #ifndef DEF_INC_LLDISK_C
#endif
