/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002, 2003 by the EMU][ Project/Dapple ][ Team
 *
 * Component:  Header file for Dapple shared components
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Current exception for ASMLIB.O linkage, if Z80.C is not used
 *
 * 20040428  New headers generated for v0.4 release
 *           Z80 core development
 *
 */


#ifndef DEF_INC_GUI_H
#define DEF_INC_GUI_H


// **** public constants

// rgb values
#define RGBBLACK        0x000000
#define RGBDARK         0x202020
#define RGBLIGHT        0xc0c0c0
#define RGBDGREY        0x404040
#define RGBGREY         0x808080
#define RGBLGREY        0xc0c0c0
#define RGBWHITE        0xffffff
#define RGBLBLUE        0x3050ff


// **** public functions

// draw a two-colour shadowed box
void            guishadowbox    (unsigned int window,
                                 unsigned int xleft,    unsigned int ytop,
                                 unsigned int xright,   unsigned int ydown,
                                 unsigned int darkcolour, unsigned int lightcolour);
// draw a shadowed 'in'-box
// RGB-values for box are defined by gui
void            guiinbox        (unsigned int window,
                                 unsigned int xleft,    unsigned int ytop,
                                 unsigned int xright,   unsigned int ydown);
// draw a shadowed 'out'-box
// RGB-values for box are defined by gui
void            guioutbox       (unsigned int window,
                                 unsigned int xleft,    unsigned int ytop,
                                 unsigned int xright,   unsigned int ydown);
// draw percentage bar
void            guipercent      (unsigned int window, unsigned int value, unsigned char *message);

// draw yes/no box and wait for either key or mouse
unsigned char   guiyesno        (unsigned int keyboard, unsigned int window);


// --> #ifndef DEF_INC_GUI_H
#endif
