/*
 * NEWER - determines if the target is newer than the source, or if it must
 * be rebuilt.  Used by Dapple ]['s mk.bat utility to avoid rebuilding a
 * file that hasn't been changed.  This program will build with Turbo C++
 * 1.01; it does now build with gcc, but no guarantees.
 *
 * Written by Steve Nickolas.  (C) 2003.  You may do whatever you want with
 * this file as long as (a) you do not remove this paragraph and (b) you
 * agree that use of this program is entirely at your own risk and all
 * warranties (including implied warranties of merchantability or fitness
 * for a particular purpose) are disclaimed.
 *
 * Version 1.00 2003.0213
 *
 * Usage:  newer target source
 * Returns 1 if target needs to be rebuilt, 0 if target does not need to be
 * rebuilt.  Any other return signifies an error.
 *
 * Note: this program is highly nonoptimal.  Who cares, it's certainly
 * faster than waiting for a CPU core to build on a 486 with gcc -O3.
 */

#include <dos.h>
// lfn_get_ftime
#include <io.h>
#include <fcntl.h>
#include <stdio.h>


      int main (int parmno, char **parmlist) {
	unsigned int file;
	unsigned int date;
	unsigned int time;
	register unsigned int stime;
	register unsigned int ttime;
	register unsigned int i;



	if (parmno < 3) {
	  fprintf (stderr,"usage: newer target source\n");
	  return -1;
	}


// open target file
	file = _open(parmlist[1], O_RDONLY);
	if (file == -1) {
	  return 1;				// assume need to update, if we can't open it
	}
	if (_dos_getftime(file, &date, &time)) {
	  _close(file);
	  fprintf(stderr,"Cannot get file time for ");
	  perror(parmlist[1]);
	  return -1;
	}
	_close(file);
	ttime = time | (date << 16);

//	printf("**** Target %s time = %x.\n", parmlist[1], ttime);


// open source files
	for (i=2; i < parmno; i++) {
	  file = _open(parmlist[i], O_RDONLY);
	  if (file == -1) {
	    fprintf(stderr,"Source file ");
	    perror(parmlist[i]);
	    return -1;
	  }
	  if (_dos_getftime(file, &date, &time)) {
	    _close(file);
	    fprintf(stderr,"Cannot get file time for ");
	    perror(parmlist[i]);
	    return -1;
	  }
	  _close(file);
	  stime = time | (date << 16);

//	  printf("/ Source %s time = %x.\n", parmlist[i], stime);

	  if (stime > ttime) return 1;		// needs updating
	}
	return 0;

      } // main
