#ifndef HDR_FILESYSTEM
#define HDR_FILESYSTEM

class DeviceMgr {
protected:
  char *Device;
  unsigned int BlockSize;
  unsigned int TotalBlocks;
public:
  DeviceMgr(char *dev);
  virtual ~DeviceMgr();
  virtual int Open(char *dev);
  virtual int Close();
  virtual unsigned int GetBlockSize();
  virtual unsigned int GetTotalBlocks();
  virtual int Format(unsigned int blocks,unsigned int blocksize);
  // Read/WriteBlock returns !0 on error, buf may be 0
  virtual int ReadBlock(unsigned int block,char *buf)=0;
  virtual int WriteBlock(unsigned int block,char *buf)=0;
};

class FileSystemMgr {
private:
  unsigned int FirstFree; // first available free block
public:
  virtual int IsAllocated(unsigned int block)=0;
  virtual int Allocate(unsigned int block)=0;
  virtual int Free(unsigned int block)=0;
};

class DirectoryEntry {
private:
  char *name;
  long size;
  struct date date;
  struct time time;
  unsigned int attrib;
public:
  DirectoryEntry();
  char *Name();
  long Size();
  void Date(struct date& d);
  void Time(struct time& t);
  unsigned int Attrib();
};

class DirectoryMgr {
friend DirectoryEntry;
protected:
  char *Directory;
public:
  DirectoryMgr(char *dir);
  virtual ~DirectoryMgr();
  virtual char Delimiter()=0;
  virtual int Open(char *dir);
  virtual int Close();
  virtual int FirstEntry(DirectoryEntry& ent,int Attrib=0)=0;
  virtual int NextEntry(DirectoryEntry& ent,int Attrib=0)=0;
  virtual int CreateEntry(char *name,int Attrib=0)=0;
};

class FileMgr {
private:
  long curPos;
protected:
  FileSystemMgr *Mgr;
  char *File;
public:
  FileMgr();
  FileMgr(DirectoryEntry *file);
  FileMgr(FileSystemMgr *mgr);
  FileMgr(FileSystemMgr *mgr,DirectoryEntry *file);
  virtual ~FileMgr();
  void SetFileSysMgr(FileSystemMgr *mgr);
  virtual int Open(DirectoryEntry *file);
  virtual int Close();
  virtual long Seek(int whence,long offset);
  virtual long Tell();
  virtual int Read(char *buf,int bytes);
  virtual int Write(char *buf,int bytes);
};

#endif /* HDR_FILESYSTEM */
