/***********************
 *                     *
 * FILE SYSTEM SUPPORT *
 *                     *
 ***********************/

/*
   Any data storage system can be divided into three sections:
     1. Device management. The physical device upon which data is stored.
     2. Directory management. The system of organisation of individual files.
        Even sequential devices such as tapes have need to have a method
        of locating and accessing individual files.
     3. File management. Accessing data within individual files on a byte-by-
        byte basis.
*/

#include <dos.h>
#include <string.h>

#include "filesys.h"

/******************
 *                *
 * DEVICE MANAGER *
 *                *
 ******************/

/* NOTES:

     Storage is allocated in allocation units only (also called blocks). Data
     is read and written in block size chunks.
*/

DeviceMgr::DeviceMgr(char *dev)
{
  Device=0;
  Open(dev);
}

DeviceMgr::~DeviceMgr()
{
  Close();
}

int DeviceMgr::Open(char *dev)
{
  if (Device) return 1;
  Device = new char[strlen(dev)+1];
  strcpy(Device,dev);
  return 0;
}

int DeviceMgr::Close()
{
  if (Device) {
    delete Device;
    Device=0;
  }
  return 0;
}

unsigned int DeviceMgr::GetBlockSize()
{
  return BlockSize;
}

unsigned int DeviceMgr::GetTotalBlocks()
{
  return TotalBlocks;
}

int DeviceMgr::Format(unsigned int blocks,unsigned int blocksize)
{
  TotalBlocks=blocks;
  BlockSize=blocksize;
  return 0;
}

/*********************
 *                   *
 * DIRECTORY MANAGER *
 *                   *
 *********************/

/*
   Attributes:
     Bit 15 : Entry deleted
     Bit 14 :
     :
     Bit  2 :
     Bit  1 : File is a directory
     Bit  0 : File is read only
*/

DirectoryEntry::DirectoryEntry()
{
  name=0;
  size=0;
  date.da_year=1980;
  date.da_mon =1;
  date.da_day =1;
  time.ti_hour=0;
  time.ti_min =0;
  time.ti_sec =0;
  time.ti_hund=0;
  attrib=0;
}

char *DirectoryEntry::Name()
{
  return name;
}

long DirectoryEntry::Size()
{
  return size;
}

void DirectoryEntry::Date(struct date& d)
{
  d=date;
}

void DirectoryEntry::Time(struct time& t)
{
  t=time;
}

unsigned int DirectoryEntry::Attrib()
{
  return attrib;
}

DirectoryMgr::DirectoryMgr(char *dir)
{
  Directory=0;
  Open(dir);
}

DirectoryMgr::~DirectoryMgr()
{
  Close();
}

int DirectoryMgr::Open(char *dir)
{
  if (Directory) return 1;
  Directory = new char[strlen(dir)+1];
  strcpy(Directory,dir);
  return 0;
}

int DirectoryMgr::Close()
{
  if (Directory) {
    delete Directory;
    Directory=0;
  }
  return 0;
}
