#define Uses_TApplication
#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TKeys
#define Uses_TLabel
#define Uses_TListViewer
#define Uses_TMenu
#define Uses_TMenuBar
#define Uses_MsgBox
#define Uses_TParamText
#define Uses_TProgram
#define Uses_TRect
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#include <tv.h>

#include <help.h>

#include <dir.h>
#include <dos.h>
#include <string.h>

#include <iostream.h>
#include <iomanip.h>
#include <strstrea.h>

#include <chgdir.h>
#include <whereis.h>

#include "gadgets.h"
#include "hierarch.h"
#include "diskutil.h"
#include "duhlp.h"

#include "..\a2icomms.h"
#include "..\diskclnt.h"

class TStatusWindow : public TWindow {
public:
  TStatusWindow(TRect& bounds,const char *aTitle);
};

TStatusWindow::TStatusWindow(TRect& bounds,const char *aTitle) :
  TWindow(bounds,aTitle,0),
  TWindowInit(&TStatusWindow::initFrame)
{
  flags=0;
  palette=wpGrayWindow;
  options|=ofCenterX|ofCenterY;
}

class TStatusMessage : public TStatusWindow {
public:
  TStatusMessage(const char *aTitle,const char *aMsg);
};

TStatusMessage::TStatusMessage(const char *aTitle,const char *aMsg) :
  TStatusWindow(TRect(1,1,strlen(aMsg)+5,4),aTitle),
  TWindowInit(&TStatusMessage::initFrame)
{
  insert(new TStaticText(TRect(2,1,2+strlen(aMsg),2),aMsg));
}

/*********************
 *                   *
 * STATUS LINE HINTS *
 *                   *
 *********************/

struct aStatusHint {
  ushort HelpCtx;
  char *helpString;
} StatusHints[]={
  {hcDragging                  ,"Drag the title bar to move window"},
  {hcHelp                      ,"Help"},
  {hcContents                  ,"Contents"},
  {hcAbout                     ,"Version information"},
  {0,NULL}
};

class THintStatusLine : public TStatusLine {
public:
  THintStatusLine(TRect r,TStatusDef& def):TStatusLine(r,def) {};
  virtual const char *hint(ushort aHelpCtx);
};

const char *THintStatusLine::hint(ushort aHelpCtx) {
  int Loop;

  Loop=0;
  while (StatusHints[Loop].helpString != NULL) {
    if (aHelpCtx==StatusHints[Loop].HelpCtx) {
      return(StatusHints[Loop].helpString);
    }
    Loop++;
  }
  return("");
};

/******************
 *                *
 * INITIALISATION *
 *                *
 ******************/

DiskUtilApp::DiskUtilApp() :
  TProgInit(&DiskUtilApp::initStatusLine,
            &DiskUtilApp::initMenuBar,
            &DiskUtilApp::initDeskTop)
{
  helpInUse=False;

  TRect r = getExtent();                      // Create the clock view.
  r.a.x = r.b.x - 9;      r.b.y = r.a.y + 1;
  clock = new TClockView( r );
  insert(clock);

  r = getExtent();                            // Create the heap view.
  r.a.x = r.b.x - 13;     r.a.y = r.b.y - 1;
  heap = new THeapView( r );
  insert(heap);

  TView *v = new TStatusMessage(0,"Checking for Remote...");
  insert(v);

  InitA2IComms();
  if (SynchroniseSequences()) {
    destroy(v);
    messageBox("No remote A2ICOMMS",mfError|mfOKButton);
  }
  else {
    if (!RmtConnected()) {
      destroy(v);
      messageBox("No Remote Disk Data Server",mfError|mfOKButton);
    }
    else destroy(v);
  }

  // Show the About window
  TEvent e;
  e.what=evCommand;
  e.message.command=cmAbout;
  putEvent(e);
}

DiskUtilApp::~DiskUtilApp()
{
}

void DiskUtilApp::getEvent(TEvent& event)
{
  TWindow *w;
  THelpFile *hFile;
  fpstream *helpStrm;
  char helpName[MAXPATH];
  char *progPath;
  char drive[MAXDRIVE];
  char dir[MAXDIR];

  TApplication::getEvent(event);

  // Handle on-line help request
  switch (event.what) {
    case evCommand:
      if ((event.message.command==cmHelp) && (helpInUse==False)) {
        // Determine help file location - it will always be with the
        // executable
        progPath=WhereIs(_argv[0]);
        fnsplit(progPath,drive,dir,0,0);
        strcpy(helpName,drive);
        strcat(helpName,dir);
        strcat(helpName,"DISKUTIL.HLP");
        // Open Help file
        helpInUse = True;
        helpStrm = new fpstream(helpName,ios::in|ios::binary);
        hFile = new THelpFile(*helpStrm);
        if (!helpStrm) {
          messageBox("Could not open help file",mfError|mfOKButton);
          delete hFile;
        }
        else {
          w = new THelpWindow(hFile,getHelpCtx());
          if (validView(w)!=0) {
            w->helpCtx=0xffff;
            execView(w);
            destroy(w);
          }
          clearEvent(event);
        }
        helpInUse = False;
      }
      break;
    case evMouseDown:
      if (event.mouse.buttons!=1) event.what = evNothing;
      break;
  }
}

//
// isTileable() function ( checks a view on desktop is tileable or not )
//

static Boolean isTileable(TView *p, void * )
{
   if( (p->options & ofTileable) != 0)
       return True;
   else
       return False;
}

void DiskUtilApp::idle()
{
  TApplication::idle();
  // Update various displays
  TProgram::idle();
  clock->update();
  heap->update();
  if (deskTop->firstThat(isTileable, 0) != 0 )
      {
      enableCommand(cmTile);
      enableCommand(cmCascade);
      }
  else
      {
      disableCommand(cmTile);
      disableCommand(cmCascade);
      }
}

class TDirectoryHItem : public TSortedTextHItem {
public:
  TDirectoryHItem(char *dirname);
  char *PathName();
};

TDirectoryHItem::TDirectoryHItem(char *dirname) :
  TSortedTextHItem(dirname)
{
}

// Returns the full path name of the given hierarchy item (not including
// drive).
char *TDirectoryHItem::PathName()
{
  static char path[256];
  char temp[256];
  TDirectoryHItem *ptr;

  *path=0;
  ptr=this;
  while (ptr) {
    // set up temporary & get directory name
    if (ptr->Ancestor) {
      *(temp+0)='\\';
      *(temp+1)=0;
      ptr->GetData(temp+1);
    }
    else {
      *temp=0;
      ptr->GetData(temp);
    }
    // prepend temporary onto path
    strcat(temp,path);
    strcpy(path,temp);
    // go up the tree
    ptr=(TDirectoryHItem*)(ptr->Ancestor);
  }
  return path;
}

class TDirTreeStatus : public TStatusWindow {
private:
  int NumFiles;
  int NumDirs;
public:
  TDirTreeStatus();
  void IncNumFiles();
  void IncNumDirs();
};

TDirTreeStatus::TDirTreeStatus() :
  TStatusWindow(TRect(28,8,52,14),"Reading"),
  TWindowInit(&TDirTreeStatus::initFrame)
{
  TView *control;

  NumFiles=0;
  NumDirs=0;
  insert(new TStaticText(TRect(8,2,14,3),"Files:"));
  insert(new TStaticText(TRect(2,3,14,4),"Directories:"));
  control = new TParamText(TRect(15,2,22,3),"%d",1);
  control->setData(&NumFiles);
  insert(control);
  control = new TParamText(TRect(15,3,22,4),"%d",1);
  control->setData(&NumDirs);
  insert(control);
}

void TDirTreeStatus::IncNumFiles()
{
  NumFiles++;
  // don't update status for every file, just every directory
}

void TDirTreeStatus::IncNumDirs()
{
  NumDirs++;
  redraw();
}

class TDirectoryTree {
protected:
  int Drive;
  TDirectoryHItem *RootDir;
  TDirTreeStatus *stat;
public:
  TDirectoryTree(char drive);
  TDirectoryTree(int drive);
  ~TDirectoryTree();
  void AddDirectory(TDirectoryHItem *i);
  void NewDrive(int drive);
  TDirectoryHItem *Root();
};

TDirectoryTree::TDirectoryTree(char drive)
{
  RootDir=0;
  NewDrive(drive-'A'+1);
}

TDirectoryTree::TDirectoryTree(int drive)
{
  RootDir=0;
  NewDrive(drive);
}

TDirectoryTree::~TDirectoryTree()
{
  delete RootDir;
}

// Given a directory hierarchy item
void TDirectoryTree::AddDirectory(TDirectoryHItem *i)
{
  TDirectoryHItem *newdir;
  char *path;
  struct ffblk fb;
  int err;

  // build directory path
  path=new char[256];
  strcpy(path,i->PathName());
  strcat(path,"\\*.*");
  // for each directory in the given directory
  err=findfirst(path,&fb,FA_DIREC);
  delete path;
  while (err==0) {
    if (strcmp(fb.ff_name,".")!=0 && strcmp(fb.ff_name,"..")!=0) {
      if (fb.ff_attrib & FA_DIREC) {
        stat->IncNumDirs();
        // handle it
        newdir=new TDirectoryHItem(fb.ff_name);
        newdir->DescendFrom(i);
        AddDirectory(newdir);
        newdir->HideDescendants();
      }
      else stat->IncNumFiles();
    }
    // next directory
    err=findnext(&fb);
  }
}

void TDirectoryTree::NewDrive(int drive)
{
  char drivestr[]="x:";

  stat = new TDirTreeStatus;
  TProgram::deskTop->insert(stat);
  delete RootDir;
  *drivestr=drive+'A'-1;
  RootDir = new TDirectoryHItem(drivestr);
  AddDirectory(RootDir);
  TObject::destroy(stat);
}

TDirectoryHItem *TDirectoryTree::Root()
{
  return RootDir;
}

class TTextHierarchyViewer : public THierarchyViewer {
public:
  TTextHierarchyViewer(TRect& bounds,TScrollBar *aHScrollBar,
                       TScrollBar *aVScrollBar,short iw,
                       THierarchyItem *r=0) :
      THierarchyViewer(bounds,aHScrollBar,aVScrollBar,iw,r) {} ;
  virtual void getHierarchyItemText(char *dest,THierarchyItem *i,short maxLen);
};

void TTextHierarchyViewer::getHierarchyItemText(char *dest,THierarchyItem *i,short maxLen)
{
  char buf[256];

  i->GetData(buf);
  *(buf+maxLen)=0;
  strcpy(dest,buf);
}

TDialog* makeDialog(THierarchyItem *root)
{
  TView *control;
  TDialog* dlg = new TDialog(TRect(8, 1, 66, 20), "Hierarchy Viewer Test");
  if (!dlg) return 0;


  control = new TScrollBar(TRect(43, 2, 44, 17));
  dlg->insert(control);

  control = new TTextHierarchyViewer(TRect(3, 2, 43, 17), (TScrollBar*)0, (TScrollBar*)control, 10, root);
  dlg->insert(control);

    dlg->insert(new TLabel(TRect(2, 1, 13, 2), "~H~ierarchy:", control));

  control = new TButton(TRect(45, 2, 55, 4), "O~K~", cmOK, bfDefault);
  dlg->insert(control);

  dlg->selectNext(False);
  return dlg;
}

void DiskUtilApp::TestHierarchyViewer()
{
  TTextHierarchyItem *ptr,*branch;
  TDirectoryTree *dt;

  dt=new TDirectoryTree('D');

  // create hierarchy
  TTextHierarchyItem *root=new TTextHierarchyItem("Root");
  ptr=new TTextHierarchyItem("Item 11");
  ptr->DescendFrom(root);
  ptr=new TTextHierarchyItem("Item 12");
  ptr->DescendFrom(root);
  branch=ptr=new TTextHierarchyItem("Item 13");
  ptr->DescendFrom(root);
  ptr=new TTextHierarchyItem("Item 14");
  ptr->DescendFrom(root);
  ptr=new TTextHierarchyItem("Item 131");
  ptr->DescendFrom(branch);
  ptr=new TTextHierarchyItem("Item 132");
  ptr->DescendFrom(branch);

  // create dialog
  TDialog *dlg=makeDialog(dt->Root());

  // execute dialog
  deskTop->execView(dlg);

  destroy(dlg);

  delete dt;

  delete root;
}

void DiskUtilApp::handleEvent(TEvent& event)
{
  TRect r;

  TApplication::handleEvent(event);
  if (event.what == evCommand) {
    switch (event.message.command) {
      case cmTestHierarchy:
        TestHierarchyViewer();
        break;
      case cmAbout:
        ShowAbout();
        break;
      default:
        return;
    }
    clearEvent(event);
  }
}

/******************
 *                *
 * INITIALISATION *
 *                *
 ******************/

TStatusLine *DiskUtilApp::initStatusLine(TRect r)
{
  r.a.y = r.b.y-1;
  return new THintStatusLine(r,
    *new TStatusDef(0,0)+
      *new TStatusItem("~F1~ Help",kbF1,cmHelp)+
      *new TStatusItem("~Alt-X~ Quit",kbAltX,cmQuit)+
      *new TStatusItem(0,kbF5,cmZoom)+
      *new TStatusItem(0,kbCtrlF5,cmResize)+
      *new TStatusItem(0,kbAltF3,cmClose)+
      *new TStatusItem(0,kbF10,cmMenu)+
    *new TStatusDef(1,0xfffe)+
      *new TStatusItem("~F1~ Help",kbF1,cmHelp)+
      *new TStatusItem(0,kbF5,cmZoom)+
      *new TStatusItem(0,kbCtrlF5,cmResize)+
      *new TStatusItem(0,kbAltF3,cmClose)+
      *new TStatusItem(0,kbF10,cmMenu)+
    *new TStatusDef(0xffff,0xffff)+
      *new TStatusItem("~F5~ Zoom",kbF5,cmZoom)+
      *new TStatusItem("~Ctrl-F5~ Resize",kbCtrlF5,cmResize)+
      *new TStatusItem("~Esc~/~Alt-F3~ Close",kbAltF3,cmClose)+
      *new TStatusItem(0,kbF10,cmMenu)
  );
}

TDeskTop *DiskUtilApp::initDeskTop(TRect r)
{
  r.a.y++;
  r.b.y--;
  return(new TDeskTop(r));
}

TMenuItem& operator +(TMenuItem& m1,TMenuItem& m2)
{
  TMenuItem *cur=&m1;

  while (cur->next) cur=cur->next;
  cur->next=&m2;
  return m1;
}

TMenuBar *DiskUtilApp::initMenuBar(TRect r)
{
  TSubMenu& SystemMenu =
    *new TSubMenu("~\xf0~",kbAltSpace,hcSystem)+
      *new TMenuItem("Test Hierarchy ~V~iewer",cmTestHierarchy,kbNoKey,hcNoContext)+
      *new TMenuItem("~O~ptions...",cmError,kbNoKey,hcNoContext)+
      *new TMenuItem("~T~ransfer",kbNoKey,new TMenu(
        *new TMenuItem("~A~2ICOMMS...",cmError,kbNoKey,hcNoContext)+
        *new TMenuItem("~F~TP...",cmError,kbNoKey,hcNoContext)+
        *new TMenuItem("~D~isk Data Server...",cmError,kbNoKey,hcNoContext)+
        *new TMenuItem("~R~OM Capture Utility...",cmError,kbNoKey,hcNoContext)+
         newLine()+
        *new TMenuItem("~C~apture ROMs...",cmError,kbNoKey,hcNoContext)
        ),hcNoContext)+
      *new TMenuItem("Enter ~S~erver Mode...",cmError,kbNoKey,hcNoContext)+
      *new TMenuItem("E~x~it",cmQuit,kbAltX,hcExit,"Alt-X");

  TSubMenu& FileMenu =
    *new TSubMenu("~F~ile",kbNoKey,hcNoContext)+
      *new TMenuItem("~C~opy...",cmError,kbAltC,hcNoContext,"Alt-C")+
      *new TMenuItem("~R~ename...",cmError,kbAltR,hcNoContext,"Alt-R")+
      *new TMenuItem("Delete...",cmError,kbDel,hcNoContext,"Del")+
      *new TMenuItem("~A~ttributes...",cmError,kbAltA,hcNoContext,"Alt-A")+
      *new TMenuItem("~I~nfo...",cmError,kbAltI,hcNoContext,"Alt-I")+
      *new TMenuItem("~E~ditor...",cmError,kbAltE,hcNoContext,"Alt-E")+
      *new TMenuItem("~B~locks...",cmError,kbNoKey,hcNoContext)+
      *new TMenuItem("Create ~D~irectory...",cmError,kbAltD,hcNoContext,"Alt-D");

  TSubMenu& DeviceMenu =
    *new TSubMenu("~D~evice",kbNoKey,hcNoContext)+
      *new TMenuItem("~O~pen...",cmError,kbAltD,hcNoContext,"Alt-D")+
      *new TMenuItem("~C~lose",cmError,kbNoKey,hcNoContext)+
      *new TMenuItem("~F~ormat...",cmError,kbNoKey,hcNoContext)+
      *new TMenuItem("~I~nfo...",cmError,kbNoKey,hcNoContext)+
      *new TMenuItem("~E~ditor...",cmError,kbNoKey,hcNoContext);

  TSubMenu& HelpMenu =
    *new TSubMenu("~H~elp",kbNoKey,hcHelp)+
      *new TMenuItem("~C~ontents",cmHelp,kbF1,hcContents,"F1")+
      *new TMenuItem("~A~bout...",cmAbout,kbNoKey,hcAbout);

  r.b.y = r.a.y+1;

  return (new TMenuBar(r,SystemMenu+FileMenu+DeviceMenu+HelpMenu));
}

/***********
 *         *
 * OPTIONS *
 *         *
 ***********/

TPalette& DiskUtilApp::getPalette() const
{
  static TPalette newcolor (cpColor cHelpColor,
                  sizeof(cpColor cHelpColor)-1);
  static TPalette newblackwhite(cpBlackWhite cHelpBlackWhite,
                  sizeof(cpBlackWhite cHelpBlackWhite)-1);
  static TPalette newmonochrome(cpMonochrome cHelpMonochrome,
                  sizeof(cpMonochrome cHelpMonochrome)-1);
  static TPalette *palettes[] = {
    &newcolor,
    &newblackwhite,
    &newmonochrome
  };
  return *(palettes[appPalette]);
}

void DiskUtilApp::outOfMemory()
{
  messageBox( "Not enough memory available to complete operation.",
    mfError | mfOKButton );
}

void DiskUtilApp::ShowAbout()
{
  TView *c;
  TDialog *pd = new TDialog(TRect(10,3,44,14),"About");
  pd->options |= ofCenterX|ofCenterY;

  if (pd) {
    c = new TStaticText(TRect(8,2,31,3),"Apple Disk/File Utility");
    c->options |= ofCenterX;
    pd->insert(c);

    c = new TStaticText(TRect(9,4,30,5),"Copyright (c) 1994 by");
    c->options |= ofCenterX;
    pd->insert(c);

    c = new TStaticText(TRect(9,5,27,6),"by Andrew Gregory");
    c->options |= ofCenterX;
    pd->insert(c);

    c = new TStaticText(TRect(9,6,39,7),"14 Whittington Ave Carine 6020");
    c->options |= ofCenterX;
    pd->insert(c);

    c = new TButton(TRect(25,8,35,10),"O~K~",cmOK,bfDefault);
    c->options |= ofCenterX;
    pd->insert(c);

    pd->helpCtx=hcAboutDialog;
	deskTop->execView(pd);
  }
  destroy(pd);
}

int main()
{
  char curDir[MAXPATH];

  DiskUtilApp *DiskUtil_Application;
  // Get current directory
  strcpy(curDir,GetCurDir());
  // Run application
  DiskUtil_Application = new DiskUtilApp;
  DiskUtil_Application->run();
  delete DiskUtil_Application;
  // Restore current directory
  ChangeDir(curDir);
  return 0;
}
