;ProDOS MLI Intercepter
;Should first check for the presence of A2ICOMMS.
;Should ask the user what slot to use as the 'remote' disk controller.
;Should only replace empty slots (i.e. slot to replace has the same vector as
;that for slot 0,drive 1). BOTH drives for a slot must be empty (to handle a
;/RAM disk on slot 3 drive 2).
;Once vectors have been replaced, update the device list.

CMD            .EQU $42
UNIT           .EQU $43
BUFFER         .EQU $44
BLOCK          .EQU $46
S6D1VECT       .EQU $BF1C
               .ORG $9000

;Save current slot 6,drive 1 vector
               LDA S6D1VECT
               STA CHAINADDR+1
               LDA S6D1VECT+1
               STA CHAINADDR+2

;Set MLI vector to point to internal handler
               LDA # ENTRY & $FF
               STA S6D1VECT
               LDA # ENTRY >> 8
               STA S6D1VECT+1

               RTS

;This is the new ProDOS MLI entry point
ENTRY          STA ORIGA       ;save A,X,Y and S registers
               STX ORIGX
               STY ORIGY
               TSX
               STX ORIGS

               LDA CMD

;If CMD is a READ BLOCK ($1) or WRITE BLOCK ($2) put an inverse R or W on the
;screen
               CMP #$1
               BEQ HANDLE_READ
               CMP #$2
               BEQ HANDLE_WRITE
               JMP CHAIN
HANDLE_READ    LDA #$12        ;inverse R
               STA $777        ;line 23,col 40
               JMP CHAIN
HANDLE_WRITE   LDA #$17        ;inverse W
               STA $777        ;line 23,col 40
               JMP CHAIN

;Now let all calls go through to ProDOS
;Call original handler
CHAIN          LDX ORIGS       ;restore A,X,Y and S registers
               TXS
               LDY ORIGY
               LDX ORIGX
               LDA ORIGA
CHAINADDR      JMP $FFFF       ;self-modifying

ORIGA          .DB
ORIGX          .DB
ORIGY          .DB
ORIGS          .DB

               .END
