;Clock card ROM
;Version 1.0
;22-Sep-1994
;Copyright (c) 1994
;by Andrew Gregory
;14 Whittington Ave
;Carine WA 6020
;Australia

;Clock I/O Offsets (all in BCD) eg. Saturday September 24th 1994 9:18:37pm
;
; $0 = Year low  byte eg. $94
; $1 = Year high byte eg. $19
; $2 = Month          eg. $09
; $3 = Day            eg. $24
; $4 = Day of week    eg. $06
; $5 = Hour           eg. $21
; $6 = Minute         eg. $18
; $7 = Second         eg. $37 (seconds are not supported)

;Clock mode characters (not currently supported):
;Derived from the ProDOS Technical Reference Manual and Nibble March 1986
;article "Catalog Clock".
; $A3 = '#' : ProDOS format
; $BE = '>' : Integer BASIC format
; $A0 = ' ' : Applesoft BASIC format
; $A5 = '%' : Applesoft BASIC format

STRING_LEN     .EQU $E         ;length of generated string
KSW            .EQU $38
TABLE_IDX      .EQU $FE
CLOCKTMP       .EQU $538
MODE           .EQU $5B8
CUR_CHAR       .EQU $638
CLOCKDEV       .EQU $C080      ;+$s0 accesses clock I/O
IORTS          .EQU $FF58

               .ORG 0

;NOTE: for ProDOS identification the following offsets must be set to the
;following values:
;$Cs00 = $08, $Cs02 = $28, $Cs04 = $58, $Cs06 = $70
; (from ProDOS Technical Reference, pg 105)
;Also, the STARTUP.BAS program supplied with ProDOS 1.0.1 looks for:
;$Cs00 = $08, $Cs01 = $78, $Cs02 = $28
;Also, a program given in Nibble March 1986 "Catalog Clock" looks for:
;$Cs05 = $FF, $Cs07 = $05
ENT0           PHP             ;First 8 bytes for ProDOS identification
               SEI
               PLP
               BIT IORTS
               BVS CLOCK_INIT

ENT_READ       CLC             ;ProDOS READ entry point
               BCC GO_GET_DT
ENT_WRITE      BNE PD_SET_MODE ;ProDOS WRITE entry point
                               ;Assume the ProDOS clock driver loads the
                               ;Accumulator with #$A3 and hence clears the
                               ;zero flag.

;Normal entry
CLOCK_INIT     CLC
               BCS $
               .ORG *-1
CLOCK_ENTRY    SEC
               PHA             ;Figure out what slot we're in.
               TXA             ; This returns the slot number s in the X
               PHA             ; register as $Cs. The Accumulator is unchanged
               TYA             ; and the Y register is set to the Accumulator.
               PHA             ; The original values of A,X,Y are saved on the
               PHP             ; stack.
               SEI
               JSR IORTS
               TSX
               PLA
               PLA
               PLA
               PLA
               TAY             ;get original A
               DEX
               TXS
               PLA
               PLP
               TAX             ;$Cs now in X
               TYA             ;original A

               BCS GET_CHAR    ;if Carry set, definitely getting data
;Carry is clear; this is either a set mode call (Applesoft->card) or the
;first get data call (card->Applesoft). If KSW not equals $Cs00 then it's
;a set mode call.
               CPX KSW+1
               BNE GOTO_SET_MODE
               LDY KSW
               BEQ INIT_GET_CHAR
GOTO_SET_MODE  CLC
               BCC SET_MODE
INIT_GET_CHAR  LDA #$00
               STA CUR_CHAR,X
               LDA #CLOCK_ENTRY
               STA KSW
;now get the current character
GET_CHAR       LDA TABLE_IDX   ;save some zero page locations
               PHA
               LDA TABLE_IDX+1
               PHA

               LDA #OFFSET_TABLE ;create base index to offset table
               STA TABLE_IDX
               STX TABLE_IDX+1
               LDY CUR_CHAR,X  ;get I/O offset
               LDA (TABLE_IDX),Y
               STA TABLE_IDX   ;create base index to I/O locations
               TXA
               ASL A
               ASL A
               ASL A
               ASL A           ;Carry is now clear since we shifted $Cx
               ADC TABLE_IDX   ;add $s0 and set bit 7
               ORA #$80
               STA TABLE_IDX
               LDA #$C0        ;$C0 hardware I/O page
               STA TABLE_IDX+1
               LDY #$00
               LDA (TABLE_IDX),Y ;get clock data
               PHA
               LDA #FORMAT_TABLE ;create base index to delimiter table
               STA TABLE_IDX
               STX TABLE_IDX+1

DO_CHAR        LDA CUR_CHAR,X
               TAY
               LDA (TABLE_IDX),Y
               BEQ HIGH_NIBBLE
               BMI LOW_NIBBLE
               TAY
               PLA
               CLC
               BCC DELIM_ONLY

GO_GET_DT      BCC GET_DATE_TIME ;'stepping-stone' to GET_DATE_TIME from ENT_READ

PD_SET_MODE    SEC
SET_MODE       CMP #$8D        ;ignore carriage-returns
               BEQ NO_SET
               STA MODE,X
NO_SET         BCS EXIT        ;Carry will be set only if entered via ENT_WRITE
CLOCK_EXIT     PLA             ;restore A,X,Y (see CLOCK_ENTRY above)
               TAY
               PLA
               TAX
               PLA
EXIT           RTS

LOW_NIBBLE     PLA
               AND #$0F
               ORA #$B0
               BNE INC_COUNTER
HIGH_NIBBLE    PLA
               LSR A
               LSR A
               LSR A
               LSR A
               ORA #$B0
               BNE INC_COUNTER
DELIM_ONLY     TYA
               ORA #$80

INC_COUNTER    TAY
               INC CUR_CHAR,X
               LDA CUR_CHAR,X
               CMP #STRING_LEN+1
               BNE RETURN_CHAR
               LDA #$00
               STA CUR_CHAR,X

RETURN_CHAR    PLA
               STA TABLE_IDX+1
               PLA
               STA TABLE_IDX
               PHP             ;modify Accumulator on stack (see CLOCK_ENTRY)
               SEI             ; disable interrupts
               TSX
               PLA             ; P
               PLA             ; original Y
               PLA             ; original X
               PLA             ; original A
               TYA
               PHA
               TXS
               PLP             ;restore processor status
               CLC
               BCC CLOCK_EXIT

;Get date and time info from the card
;The X register holds $Cn where n is the slot number
GET_DATE_TIME  LDA #$00
               STA CUR_CHAR,X
               TAY
;simulate a JSR to GET_CHAR
MORE_DATA      TXA             ;push return address onto stack
               PHA
               LDA #RETURN-1   ;RTS will increment PC
               PHA

               PHA             ;simulate action of CLOCK_ENTRY (see below)
               TXA             ;save X register
               PHA
               TYA             ;save Y register
               PHA

               TXA             ;push call address onto stack
               PHA
               LDA #GET_CHAR-1 ;RTS will increment PC
               PHA

               RTS             ;'JSR GET_CHAR'

RETURN         STA $0200,Y
               INY
               CPY #STRING_LEN+1
               BNE MORE_DATA
               RTS

;The Offset table contains what I/O location to access to get the data for
; the corresponding string position.
;The Format table contains formatting information for each string position.
; If the format is zero, the high nibble of the data is used. If bit 7 of the
; format is set then the low nibble of the data is used. Otherwise the format
; byte itself is used. The data returned will always have its bit 7 set.
;$20 = ' '
;$2C = ','
;$2D = '-'
;$3A = ':'
;$3B = ';'
OFFSET_TABLE   .DB $00,$00,$00,$02,$02,$00,$03,$03,$00,$05,$05,$00,$06,$06,$00
FORMAT_TABLE   .DB $00,$80,$2D,$00,$80,$2D,$00,$80,$20,$00,$80,$3B,$00,$80,$0D
;The following tables give Thunderclock support:
;OFFSET_TABLE   .DB $02,$02,$00,$04,$04,$00,$03,$03,$00,$05,$05,$00,$06,$06,$00
;FORMAT_TABLE   .DB $00,$80,$2C,$00,$80,$2C,$00,$80,$2C,$00,$80,$2C,$00,$80,$0D

               .END
