;A2ICOMMS tester
RECEIVEBYTE    .EQU $080B
SENDBYTE       .EQU $080E
INITCRC        .EQU $0811
CALCCRC        .EQU $0814
PRESENDCRC     .EQU $0817
VALIDCRCDATA   .EQU $081A
RECCLPKT       .EQU $081D
SENDCLPKT      .EQU $0820
RECPACKET      .EQU $0823
SENDPACKET     .EQU $0826
DATA           .EQU $0844
PKTINFO        .EQU $0849
PKT            .EQU $0887

STACK          .EQU $0100

COUT           .EQU $FDED

               .ORG $2000

;Receive byte test
;Receive 256 bytes
RECBYTETST     LDA #0
               STA CNT
RECNEXTBYTE    JSR RECEIVEBYTE
               BCS RECBYTEERR
               LDA DATA
               CMP CNT
               BNE RECBYTEERR
               INC CNT
               LDA CNT
               CMP #16
               BNE RECNEXTBYTE
               JSR MSGOUT
               .TEXT "\rRECEIVE BYTE TEST PASSED\r\000"
               RTS
RECBYTEERR     JSR MSGOUT
               .TEXT "\r\007RECEIVE BYTE TEST FAILED\r\000"
               RTS

;Send byte test
;Send 256 bytes
SNDBYTETEST    LDA #0
               STA CNT
SNDNEXTBYTE    LDA CNT
               STA DATA
               JSR SENDBYTE
               INC CNT
               LDA CNT
               CMP #16
               BNE SNDNEXTBYTE
               JSR MSGOUT
               .TEXT "\rSEND BYTE TEST COMPLETED\r\000"
               RTS

;Buffer fill for packet tests
FILLBUFFER     LDX #15
NEXTFILLBYTE   TXA
               STA BUFFER,X
               DEX
               BPL NEXTFILLBYTE
               RTS

;Buffer check for packet tests
CHECKBUFFER    LDA #15
               STA CNT
NEXTBUFCHK     LDX CNT
               LDA BUFFER,X
               CMP CNT
               BNE CHKBUFERR
               DEC CNT
               BPL NEXTBUFCHK
               CLC
               RTS
CHKBUFERR      SEC
               RTS

;Receive CL packet test
;Receive 1 16-byte packet
RECCLPKTTEST   LDA #0
               STA BUFERRCNT
               LDA #16   ;length
               STA PKT+2
               LDA #0
               STA PKT+3
               LDA # BUFFER & $00FF
               STA PKT+4
               LDA # BUFFER >> 8
               STA PKT+5
               JSR RECCLPKT
               BCS CLPKTTO
               JSR CHECKBUFFER
CLPKTTO        LDA BUFERRCNT
               ADC #0
               STA BUFERRCNT
               LDA BUFERRCNT
               BNE RECCLPKTERR
               JSR MSGOUT
               .TEXT "\rRECEIVE CL PACKET TEST PASSED\r\000"
               RTS
RECCLPKTERR    JSR MSGOUT
               .TEXT "\r\007RECEIVE CL PACKET TEST FAILED\r\000"
               RTS

;Send CL packet test
;Send 1 16-byte packet
SNDCLPKTTEST   JSR FILLBUFFER
               LDA #0
               STA PKT+0
               LDA #1
               STA PKT+1
               LDA #16
               STA PKT+2
               LDA #0
               STA PKT+3
               LDA # BUFFER & $00FF
               STA PKT+4
               LDA # BUFFER >> 8
               STA PKT+5
               JSR SENDCLPKT
               JSR MSGOUT
               .TEXT "\rSEND CL PACKET TEST COMPLETED\r\000"
               RTS

;Receive packet test
;Receive 16 16-byte packets
RECPKTTEST     LDA #0
               STA BUFERRCNT
               LDA #16
               STA PKTCNT
RECNEXTPKT     LDA #16   ;length
               STA PKTINFO+2
               LDA #0
               STA PKTINFO+3
               LDA # BUFFER & $00FF
               STA PKTINFO+4
               LDA # BUFFER >> 8
               STA PKTINFO+5
               JSR RECPACKET
               BCS PKTTO
               JSR CHECKBUFFER
PKTTO          LDA BUFERRCNT
               ADC #0
               STA BUFERRCNT
               DEC PKTCNT
               BNE RECNEXTPKT
               LDA BUFERRCNT
               BNE RECPKTERR
               JSR MSGOUT
               .TEXT "\rRECEIVE PACKET TEST PASSED\r\000"
               RTS
RECPKTERR      JSR MSGOUT
               .TEXT "\r\007RECEIVE PACKET TEST FAILED\r\000"
               RTS

;Send packet test
;Send 16 16-bytes packets
SNDPKTTEST     LDA #16
               STA PKTCNT
               JSR FILLBUFFER
SNDNEXTPKT     LDA #1
               STA PKTINFO+1
               LDA #16
               STA PKTINFO+2
               LDA #0
               STA PKTINFO+3
               LDA # BUFFER & $00FF
               STA PKTINFO+4
               LDA # BUFFER >> 8
               STA PKTINFO+5
               JSR SENDPACKET
               BCS SNDPKTERR
               DEC PKTCNT
               BNE SNDNEXTPKT
               JSR MSGOUT
               .TEXT "\rSEND PACKET TEST PASSED\r\000"
               RTS
SNDPKTERR      JSR MSGOUT
               .TEXT "\r\007SEND PACKET TEST FAILED\r\000"
               RTS

;Message Printer (originally by Andy Hertzfeld)
;Text to display must immediately follow the JSR calling MSGOUT and must be
;terminated with a zero. Control is returned to the address following the
;terminating zero.
MSGOUT         LDA $FE         ;save temporary locations
               PHA
               LDA $FF
               PHA
               TSX
               LDA STACK+3,X   ;get address of text
               STA $FE
               LDA STACK+4,X
               STA $FF
               LDY #0
MSGOUT1        INC $FE
               BNE MSGOUT2
               INC $FF
MSGOUT2        LDA ($FE),Y
               BEQ MSGOUT3
               ORA #$80
               JSR COUT
               BNE MSGOUT1
MSGOUT3        LDA $FF         ;update return address on the stack
               STA STACK+4,X   ; to point after end of string data
               LDA $FE
               STA STACK+3,X
               PLA             ;restore temporary locations
               STA $FF
               PLA
               STA $FE
               RTS

;Data
CNT            .DB
PKTCNT         .DB
BUFERRCNT      .DB
BUFFER
               .END
