#include "system.h"

#define MK_FP(seg,ofs)((void _seg *)(seg)+(void near *)(ofs))
#define FP_SEG(fp)((unsigned)(void _seg *)(void far *)(fp))
#define FP_OFF(fp)((unsigned)(fp))

char far *strcpy( char far *dest, char far *src )
{
    char far *d = dest;
    while ( ( *dest++ = *src++ ) != 0 );
    return d;
}

int Create( char far *filename )
{
    asm push ds
    _DS = FP_SEG( filename );
    _DX = FP_OFF( filename );
    _CX = 0;
    _AH = 0x3c;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return _AX;
    Error:
    return -1;
}

/* Returns filehandle */
int Open( char far *filename, char mode )
{
    int fh;

Again:
    asm push ds
    _DS = FP_SEG( filename );
    _DX = FP_OFF( filename );
    _AL = mode;
    _AH = 0x3d;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return _AX;
Error:
    if ( _AX == 0x02 && mode != O_RDONLY ) /* file not found error */
    {
        /* create it */
        fh = Create( filename );
        if ( fh == -1 )
        {
            return -1;
        }
        Close( fh );
        goto Again;
    }
    return -1;
}

unsigned int Read( int filehandle, char far *buffer, unsigned int size )
{
    asm push ds
    _BX = filehandle;
    _CX = size;
    _DS = FP_SEG( buffer );
    _DX = FP_OFF( buffer );
    _AH = 0x3f;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return _AX;
Error:
    return 0;
}

unsigned int Write( int filehandle, char far *buffer, unsigned int size )
{
    asm push ds
    _BX = filehandle;
    _CX = size;
    _DS = FP_SEG( buffer );
    _DX = FP_OFF( buffer );
    _AH = 0x40;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return _AX;
Error:
    return 0;
}

unsigned int Close( int filehandle )
{
  _BX = filehandle;
  _AH = 0x3e;
  asm int 0x21;
  asm jc  Error;
  return 0;
Error:
  return _AX;
}

/* from:0=start,1=current position,2=end of file */
long Seek( int filehandle, long pos, unsigned char from )
{
    unsigned int dx, ax;
    long ret;

    _BX = filehandle;                     /* [bp+4] */
    asm mov cx, word ptr [ bp + 8 ];      /* high word of pos */
    _DX = (unsigned int)( pos & 0xffff ); /* low word of pos: asm mov dx,word ptr [bp+6]; */
    _AH = 0x42;
    _AL = from;                           /* [bp+10] */
    asm int 0x21;
    asm jc  Error;
    dx = _DX;
    ax = _AX;
    ret = (long)(unsigned long)( ( (unsigned long)dx << 16 ) | (unsigned long)ax );
    return ret;
Error:
    return -1L;
}

long Tell( int filehandle )
{
    return Seek( filehandle, 0L, SEEK_CUR );
}

long FileSize( int filehandle )
{
    long oldpos, filelen;

    oldpos = Tell( filehandle );
    filelen = Seek( filehandle, 0L, SEEK_END );
    Seek( filehandle, oldpos, SEEK_SET );
    return filelen;
}

unsigned int DeleteFile( char far *filename )
{
    asm push ds
    _DS = FP_SEG( filename );
    _DX = FP_OFF( filename );
    _CL = 0;
    _AH = 0x41;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return 0;
Error:
    return _AX;
}

unsigned int GetAttrib( char far *filename )
{
    asm push ds
    _DS = FP_SEG( filename );
    _DX = FP_OFF( filename );
    _AX = 0x4300;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return _CX;
Error:
    return 0xffff;
}

unsigned int SetAttrib( char far *filename, unsigned int attribs )
{
    asm push ds
    _DS = FP_SEG( filename );
    _DX = FP_OFF( filename );
    _CX = attribs;
    _AX = 0x4301;
    asm int 0x21;
    asm pop ds;
    asm jc  Error;
    return 0;
Error:
    return 0xffff;
}

void interrupt ( far * GetVect( int intnum ) )()
{
    int es, bx;
    void interrupt ( far * isr )();

    asm push es;
    _AH = 0x35;
    _AL = intnum;
    asm int 0x21;
    bx = _BX;
    es = _ES;
    isr = MK_FP( es, bx );
    asm pop es;
    return isr;
}

void SetVect( int intnum, void interrupt ( far * isr )() )
{
  asm push ds;
  _AH = 0x25;
  _AL = intnum;
  _DS = FP_SEG( isr );
  _DX = FP_OFF( isr );
  asm int 0x21;
  asm pop ds;
}
