#include "ram.h"
#include "keyboard.h"
#include "cpu.h"

#include "system.h"
int fh;

extern int Quit;

extern int StopExec;
int debugFlag = 0;

unsigned int Key = 0;

int col = 0;

void CheckKB( void )
{
    /* Get next key if any */
    asm {
        mov ah, 0x11   /* Check for extended keystroke */
        int 0x16
        jz  NoKey
        mov Key, ax    /* Get it (ah=scan code,al=ASCII character) */
        mov ah, 0x10   /* Remove it from buffer (extended read) */
        int 0x16
        jmp IsKey
    }
NoKey:
    return;
IsKey:
    /* There is a keystroke */

    /* Handle special function keys */

    if ( Key == 0x3e00 )
    {
        /* F4 */
        int loop;
        for ( loop = 0x2000; loop < 0x3fff; loop++ )
        {
            unsigned char b[ 2 ][ 8 ] =
            {
                {
                    0x00, 0x2a, 0x55, 0x7f, 0x80, 0xaa, 0xd5, 0xff
                },
                {
                    0x00, 0x55, 0x2a, 0x7f, 0x80, 0xd5, 0xaa, 0xff
                }
            };
            WriteByte( loop, b[ loop & 1 ][ col & 7 ] );
        }
        col++;
        col &= 7;
        return ;
    }
    if ( Key == 0x8a00 )
    {
        /* Ctrl-F12 */
        ResetCPU();
        return;
    }

    /* Handle key re-mappings */

    /* Alt-A..Z -> A..Z */
    if ( Key == 0x1e00 ) Key = 0x1e61;
    if ( Key == 0x3000 ) Key = 0x3062;
    if ( Key == 0x2e00 ) Key = 0x2e63;
    if ( Key == 0x2000 ) Key = 0x2064;
    if ( Key == 0x1200 ) Key = 0x1265;
    if ( Key == 0x2100 ) Key = 0x2166;
    if ( Key == 0x2200 ) Key = 0x2267;
    if ( Key == 0x2300 ) Key = 0x2368;
    if ( Key == 0x1700 ) Key = 0x1769;
    if ( Key == 0x2400 ) Key = 0x246a;
    if ( Key == 0x2500 ) Key = 0x256b;
    if ( Key == 0x2600 ) Key = 0x266c;
    if ( Key == 0x3200 ) Key = 0x326d;
    if ( Key == 0x3100 ) Key = 0x316e;
    if ( Key == 0x1800 ) Key = 0x186f;
    if ( Key == 0x1900 ) Key = 0x1970;
    if ( Key == 0x1000 ) Key = 0x1071;
    if ( Key == 0x1300 ) Key = 0x1372;
    if ( Key == 0x1f00 ) Key = 0x1f73;
    if ( Key == 0x1400 ) Key = 0x1474;
    if ( Key == 0x1600 ) Key = 0x1675;
    if ( Key == 0x2f00 ) Key = 0x2f76;
    if ( Key == 0x1100 ) Key = 0x1177;
    if ( Key == 0x2d00 ) Key = 0x2d78;
    if ( Key == 0x1500 ) Key = 0x1579;
    if ( Key == 0x2c00 ) Key = 0x2c7a;

    /* Alt-1..0 -> 1..0 */
    if ( Key == 0x7800 ) Key = 0x0231;
    if ( Key == 0x7900 ) Key = 0x0332;
    if ( Key == 0x7a00 ) Key = 0x0433;
    if ( Key == 0x7b00 ) Key = 0x0534;
    if ( Key == 0x7c00 ) Key = 0x0635;
    if ( Key == 0x7d00 ) Key = 0x0736;
    if ( Key == 0x7e00 ) Key = 0x0837;
    if ( Key == 0x7f00 ) Key = 0x0938;
    if ( Key == 0x8000 ) Key = 0x0a39;
    if ( Key == 0x8100 ) Key = 0x0b30;

    /* Alt-Misc -> Misc */
    if ( Key == 0x8200 ) Key = 0x0c2d; /* - */
    if ( Key == 0x8300 ) Key = 0x0d3d; /* = */
    if ( Key == 0x1a00 ) Key = 0x1a5b; /* [ */
    if ( Key == 0x1b00 ) Key = 0x1b5d; /* ] */
    if ( Key == 0x2700 ) Key = 0x273b; /* : */
    if ( Key == 0x2600 ) Key = 0x2b5c; /* \ */
    if ( Key == 0x0e00 ) Key = 0x0e08; /* Backspace */
    if ( Key == 0xa000 ) Key = 0x50e0; /* Down arrow */
    if ( Key == 0xa600 ) Key = 0x1c0d; /* Enter */
    if ( Key == 0x0100 ) Key = 0x011b; /* Esc */
    if ( Key == 0x3700 ) Key = 0x372a; /* Keypad * */
    if ( Key == 0x4a00 ) Key = 0x4a2d; /* Keypad - */
    if ( Key == 0x4e00 ) Key = 0x4e2b; /* Keypad + */
    if ( Key == 0xa400 ) Key = 0x352f; /* Keypad / */
    if ( Key == 0x9b00 ) Key = 0x4be0; /* Left arrow */
    if ( Key == 0x9d00 ) Key = 0x4de0; /* Right arrow */
    if ( Key == 0xa500 ) Key = 0x0f09; /* Tab */
    if ( Key == 0x9800 ) Key = 0x48e0; /* Up arrow */

    if ( Key == 0x0e08 ) Key = 0x4be0; /* Backspace -> Left arrow */

    if ( Key == 0x4be0 ) Key = 0x2308; /* Left arrow  -> Ctrl-H */
    if ( Key == 0x4de0 ) Key = 0x1615; /* Right arrow -> Ctrl-U */
    if ( Key == 0x48e0 ) Key = 0x250b; /* Up arrow    -> Ctrl-K */
    if ( Key == 0x50e0 ) Key = 0x240a; /* Down arrow  -> Ctrl-J */

    if ( Key == 0x53e0 ) Key = 0x007f; /* Delete -> Apple Del */

    /* Process key */

//    if ( Key == 0x1c0d )
//    {
//        if ( debugFlag )
//        {
//            DoDebug = 1;
//        }
//        debugFlag = 1;
//    }
    Key &= 0xff;                    /* Get ASCII code */
    if ( Key == 'S' )
    {
//        StopExec = 1;
//        fh = Open( "extrom.rom", O_WRONLY );
//        Write( fh, MK_FP( MainSeg, 0x2100 ), 0xF00 );
//        Close( fh );
    }
    if ( Key < 1 || Key > 127 )
    {
        return;   /* Don't consider out-of-range chars */
    }
    Key |= 0x80;                    /* Set the strobe */
}

/* Read 0xc00? */
#pragma argsused
BYTE ReadKB( WORD Address )
{
  CheckKB();
  return Key;
}

/* Read 0xc010 */
#pragma argsused
BYTE ReadKBStrobe( WORD Address )
{
  register BYTE retval = Key;
  CheckKB();
  Key &= 0x7f;
  return retval;
}

/* Write 0xc01? */
#pragma argsused
void ClearKBStrobe( WORD Address, BYTE Data )
{
  CheckKB();
  Key &= 0x7f;
}
