#ifndef APPLEEMU_CPU_H
#define APPLEEMU_CPU_H

#include "defns.h"

typedef BYTE REG;

extern int DoDebug;

extern unsigned long ClockTick;

extern REG A;      /* Accumulator */
extern REG X;      /* X-Register */
extern REG Y;      /* Y-Register */
extern BYTE Carry; /* Processor Status */
extern BYTE Zero;
extern BYTE Interrupt;
extern BYTE Decimal;
extern BYTE Break;
extern BYTE Overflow;
extern BYTE Negative;
extern REG S;      /* Stack Pointer */
extern WORD PC;    /* Program Counter */

// Functions
void ResetCPU( void );
void ExecOpcode( void );

#endif /* APPLEEMU_CPU_H */
