#include <stdio.h>

#include "ram.h"
#include "cpu.h"
#include "system.h"
#include "disk.h"
#include "diags.h"

extern int Quit, KeyHit;
void WriteErrorMessage( char *Str );
void CheckKB( void );

int DoDebug = 0;

REG A;      /* Accumulator */
REG X;      /* X-Register */
REG Y;      /* Y-Register */
WORD P;     /* Processor Status */
BYTE Carry;
BYTE Zero;
BYTE Interrupt;
BYTE Decimal;
BYTE Break;
BYTE Overflow;
BYTE Negative;
REG S;      /* Stack Pointer */
WORD PC;    /* Program Counter */

WORD Address;

unsigned long ClockTick;

WORD ReadWord( WORD Address )
{
    return ReadByte( Address ) | ( ReadByte( Address + 1 ) << 8 );
}

void WriteWord( WORD Address, WORD Data )
{
    WriteByte( Address, Data & 0x00ff );
    WriteByte( Address + 1, Data >> 8 );
}

void ResetCPU( void )
{
    /* Initialise CPU registers */
    A = X = Y = 0;
    Carry = Zero = Interrupt = Decimal = Break = Overflow = Negative = 0;
    S = 0xff;
    PC = ReadWord( 0xfffc );
    ClockTick = 0;
    /* Reset RAM selections */
    /* set current memory segments */
    CurZPSSeg        = MainSeg;
    CurMainSeg       = MainSeg;
    CurSlotROMSeg    = MainSeg;
    CurAuxSlotROMSeg = ExpSlotSeg;
    CurBankSeg       = MainSeg;
    CurBank2Seg      = MainBankSeg;
    /* set read/write memory segments */
    ZPSRSeg   = CurZPSSeg;
    ZPSWSeg   = CurZPSSeg;
    MainRSeg  = CurMainSeg;
    MainWSeg  = CurMainSeg;
    Bank2RSeg = ROMSeg;
    Bank2WSeg = ROMSeg;
    BankRSeg  = ROMSeg;
    BankWSeg  = ROMSeg;
    /* initialise soft switches */
    IOUDisabled = 0xff;
    SlotCxROM = 0x0d;
    SlotC3ROM = 0x0d;
    RdBnk2 = 0x8d;
    /* Initialise devices */
    DiskReset();
}

#define MY_CPU
//#define PETER_KOCHS_CPU

#ifdef MY_CPU

unsigned long cADC, cAND, cASL, cBCC, cBCS, cBEQ, cBIT, cBMI, cBNE, cBPL,
              cBRA, cBRK, cBVC, cBVS, cCLC, cCLD, cCLI, cCLV, cCMP, cCPX,
              cCPY, cDEC, cDEX, cDEY, cEOR, cINC, cINX, cINY, cJMP, cJSR,
              cLDA, cLDX, cLDY, cLSR, cNOP, cORA, cPHA, cPHP, cPHX, cPHY,
              cPLA, cPLP, cPLX, cPLY, cROL, cROR, cRTI, cRTS, cSBC, cSEC,
              cSED, cSEI, cSTA, cSTX, cSTY, cSTZ, cTAX, cTAY, cTRB, cTSB,
              cTSX, cTXA, cTXS, cTYA;

#include "microcod.h"

#define DUMP( WHAT ) printf( "%7.7ld:" #WHAT "\n", WHAT );

void dumpStats( void )
{
    DUMP( cADC )
    DUMP( cAND )
    DUMP( cASL )
    DUMP( cBCC )
    DUMP( cBCS )
    DUMP( cBEQ )
    DUMP( cBIT )
    DUMP( cBMI )
    DUMP( cBNE )
    DUMP( cBPL )
    DUMP( cBRA )
    DUMP( cBRK )
    DUMP( cBVC )
    DUMP( cBVS )
    DUMP( cCLC )
    DUMP( cCLD )
    DUMP( cCLI )
    DUMP( cCLV )
    DUMP( cCMP )
    DUMP( cCPX )
    DUMP( cCPY )
    DUMP( cDEC )
    DUMP( cDEX )
    DUMP( cDEY )
    DUMP( cEOR )
    DUMP( cINC )
    DUMP( cINX )
    DUMP( cINY )
    DUMP( cJMP )
    DUMP( cJSR )
    DUMP( cLDA )
    DUMP( cLDX )
    DUMP( cLDY )
    DUMP( cLSR )
    DUMP( cNOP )
    DUMP( cORA )
    DUMP( cPHA )
    DUMP( cPHP )
    DUMP( cPHX )
    DUMP( cPHY )
    DUMP( cPLA )
    DUMP( cPLP )
    DUMP( cPLX )
    DUMP( cPLY )
    DUMP( cROL )
    DUMP( cROR )
    DUMP( cRTI )
    DUMP( cRTS )
    DUMP( cSBC )
    DUMP( cSEC )
    DUMP( cSED )
    DUMP( cSEI )
    DUMP( cSTA )
    DUMP( cSTX )
    DUMP( cSTY )
    DUMP( cSTZ )
    DUMP( cTAX )
    DUMP( cTAY )
    DUMP( cTRB )
    DUMP( cTSB )
    DUMP( cTSX )
    DUMP( cTXA )
    DUMP( cTXS )
    DUMP( cTYA )
}

void ExecOpcode( void )
{
    register BYTE Opcode, Data;
    register WORD OldPage;

Again:
    if ( KeyHit )
    {
        CheckKB();
        KeyHit = 0;
    }
//    if ( ( PC >> 8 ) == 0xc7 )
//    if ( PC == 0xc553 && ReadByte( 0x42 ) == 0x03 )
//    if ( PC == 0xc700 || PC == 0xc70f )
/*
    if ( PC == 0xc736 )
    {
        DoDebug = 1;
        StopExec = 1;
    }
    if ( DoDebug )
    {
        OutputCurrentState();
    }
*/
    if ( Quit )
    {
//        dumpStats();
        return;
    }
    Opcode = ReadByte( PC );    /* Get opcode */
    PC++;
    switch ( Opcode )
    {
#include "cpucode.c"
    }
    goto Again;
}
#endif

#ifdef PETER_KOCHS_CPU

/*
   This section is designed to use Peter Koch's 6502 CPU emulator.

   Use CPU2.C (only tested using 26-Jan-1993 version)
   Add CPU2.C to project

   needs following #pragmas in CPU2.C to compile with < 100 warnings:

   #pragma warn -wccc         - condition always false
   #pragma warn -rch          - unreachable code
   #pragma warn -pro          - no function prototype
   #pragma warn -nod          - no function declaration

   disable DISASM - #define DISASM if (0)

*/

extern unsigned char pcnt;
extern long clockticks;
extern void init6502( void );
extern void exec6502( void );

int get6502memory( unsigned int addr )
{
    return ReadByte( addr );
}

void put6502memory( unsigned int addr, unsigned char data )
{
    WriteByte( addr, data );
}

void ExecOpcode( void )
{
    init6502();
    pcnt = PC;
Again:
    if ( KeyHit )
    {
      CheckKB();
      KeyHit = 0;
    }
    if (Quit)
    {
        return;
    }
    exec6502();
    ClockTick = clockticks;
    goto Again;
}
#endif
