#include "ram.h"
#include "cpu.h"
#include "clock.h"
#include "system.h"

BYTE ClockData[16];

BYTE ReadClockIO(WORD Address)
{
  int Loop;

  for (Loop=8;Loop<16;Loop++) ClockData[Loop]=0xff;
  /* Get Date */
  _AH=0x2a;
  asm int 0x21;
  ClockData[0x00]=_CL; /* Year, low byte e.g. 1994=0x07ca, byte=0xca */
  ClockData[0x01]=_CH; /* Year, high byte, e.g. 0x07 */
  ClockData[0x02]=_DH; /* Month, Jan=1,... */
  ClockData[0x03]=_DL; /* Day, 1-31 */
  ClockData[0x04]=_AL; /* Day-of-week 0=Sunday,... */
  /* Get Time */
  _AH=0x2c;
  asm int 0x21;
  ClockData[0x05]=_CH; /* Hour, 0-23 */
  ClockData[0x06]=_CL; /* Minute 0-59 */
  ClockData[0x07]=_DH; /* Second 0-59 */
  /* Now that we've got everything - convert it into BCD */
  Loop=ClockData[0x01]*256+ClockData[0x00];
  ClockData[0x00]=Loop/  10%10*16+Loop    %10;
  ClockData[0x01]=Loop/1000%10*16+Loop/100%10;
  for (Loop=2;Loop<8;Loop++)
    ClockData[Loop]=ClockData[Loop]/10%10*16+ClockData[Loop]%10;
  /* Return appropriate value */
  return ClockData[Address&0x0f];
}

#pragma argsused
void WriteClockIO(WORD Address,BYTE Data)
{
  /* Update current clock data */
  ReadClockIO(Address);
  /* Set data */
  ClockData[Address&0x0f]=Data;
  /* Update system clock */
}
