#include "system.h"

#include "ram.h"
#include "cpu.h"
#include "video.h"
#include "gameport.h"
#include "disk.h"
#include "massstor.h"
#include "diags.h"

#include "a2icomms.h"

void __emit__( unsigned char __byte, ... );

int Quit = 0, KeyHit = 0;
int ExtendedScanCode = 0;

void interrupt ( far *OldInt15Handler )( void );

#pragma argsused
void interrupt Int15Handler( unsigned bp, unsigned di, unsigned si,
                             unsigned ds, unsigned es, unsigned dx,
                             unsigned cx, unsigned bx, unsigned ax,
                             unsigned ip, unsigned cs, unsigned flags)
{
    static unsigned ah, al;

    ah = ax >> 8;
    al = ax & 0xff;

    if ( ah == 0x85 )
    {
        /* SysReq key pressed */
        Quit = 1;
    }
    if ( ah == 0x4f )
    {
        /* debug - show scan code
        GotoXY( 0, 24 );
        SetAttr( 0x0d );
        if ( ExtendedScanCode )
        {
            PutChar( 'E' );
            PutChar( '0' );
        }
        else
        {
            PutChar( ' ' );
            PutChar( ' ' );
        }
        PutNum( ax, 2 );*/
        /* now handle keypress */
        KeyHit = 1;
        ah = 0x86;
        flags |= 1; /* set carry */
        if ( al == 0x3b )
        {
            Quit = 1; /* F1 will quit too */
        }
        if ( al == 0x3c )
        {
            /* F2 - Break and debug */
            DoDebug = 1;
            StopExec = 1;
        }
        if ( al == 0x38 )
        {
            /* An Alt key has been pressed */
            if ( ExtendedScanCode )
            {
                RightAltDown = 1;
            }
            else
            {
                LeftAltDown = 1;
            }
            /* and ignore it */
            flags ^= 1;
        }
        if ( al == 0xb8 )
        {
          /* An Alt key has been released */
          if ( ExtendedScanCode )
          {
              RightAltDown = 0;
          }
          else
          {
              LeftAltDown = 0;
          }
          /* and ignore it */
          flags ^= 1;
        }
        ExtendedScanCode = 0;
        if ( al == 0xe0 )
        {
            ExtendedScanCode = 1;
        }
        ax = ( ah << 8 ) | al;
        return;
    }

    _BX = bx;
    _CX = ax; /* Save ax */
     ax = FP_SEG( (void far *)OldInt15Handler ); /* Put address of old vector */
     bx = FP_OFF( (void far *)OldInt15Handler ); /* on the stack */
    _AX = _CX; /* Restore ax */
    asm pop bp; /* Restore other registers */
    asm pop di;
    asm pop si;
    asm pop ds;
    asm pop es;
    asm pop dx;
    asm pop cx;
    __emit__( 0xcb ); /* RETF - Indirect far jump to old vector */
}

main()
{
    unsigned int FileHandle;
    unsigned int Loop;

    /* Initialise A2ICOMMS */
//    InitA2IComms();
//    SynchroniseSequences();

    /* Force CapsLock on */
    pokeb( 0x40, 0x17, peekb( 0x40, 0x17 ) | 0x40 );

    /* Capture SysReq vector */
    OldInt15Handler = GetVect( 0x15 );
    SetVect( 0x15, Int15Handler );

    InitRAM();
    if ( MainSeg == 0 )
    {
        return 1;
    }

    InitVideo();
    InitDisk( 6 );
    InitMassStor( 5 );

    /* Blank out unused I/O ROM */
    for ( Loop = 0xc100; Loop < 0xd000; Loop++ )
    {
        pokeb( MainSeg, Loop, 0xff );
    }
    /* Load PIC (Parallel Interface Controller) ROM */
    FileHandle = Open( "parallel.rom", O_RDONLY );
    Read( FileHandle, MK_FP( MainSeg, 0xc100 ), 0x0100 );
    Close( FileHandle );
    /* Load Mass-storage ROM */
    FileHandle = Open( "massstor.rom", O_RDONLY );
    Read( FileHandle, MK_FP( MainSeg, 0xc500 ), 0x0100 );
    Close( FileHandle );
    /* Load Disk ][ ROM */
    FileHandle = Open( "disk.rom", O_RDONLY );
    Read( FileHandle, MK_FP( MainSeg, 0xc600 ), 0x0100 );
    Close( FileHandle );
    /* Load Clock ROM */
    FileHandle = Open( "clock.rom", O_RDONLY );
    Read( FileHandle, MK_FP( MainSeg, 0xc700 ), 0x0100 );
    Close( FileHandle );

    /* Initialise memory */
    for ( Loop = 0; Loop < 0xc000; Loop++ )
    {
        WriteByte( Loop, 0 );
    }

    ResetCPU();

    while ( !Quit )
    {
        ExecOpcode();
    }

    ShutdownMassStor();
    ShutdownDisk();

    FreeRAM();

    ResetVideo();

    SetVect( 0x15, OldInt15Handler );

    /* Force CapsLock off */
    pokeb( 0x40, 0x17, peekb( 0x40, 0x17 ) & 0xbf );

    return 0;
}
