#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#include "..\a2icomms.h"
#include "..\diskclnt.h"

/*******************
 * A2ICOMMS TESTER *
 *******************/

void EchoBytes(void)
{
  int d,c;
  char buffer[256];
  int inbuf,i;

  inbuf=0;
  while (!kbhit()) {
    d=ReceiveByte();
    if (d<0) {
      if (inbuf!=0) {
        for (i=0;i<inbuf;i++) {
          d=buffer[i];
          c=d/16;
          if (c>9) c+=7;
          putch(c+'0');
          c=d%16;
          if (c>9) c+=7;
          putch(c+'0');
          putch(' ');
        }
        putch('*');
        inbuf=0;
      }
//      else {
//        putch('-');
//        putch('-');
//        putch(' ');
//      }
    }
    else {
      buffer[inbuf++]=d;
    }
  }
}

void ReceiveByteTest(void)
{
  int i,d;

  for (i=0;i<16;i++) {
    d=ReceiveByte();
    if (d==-1 || d!=i) {
      printf("Receive byte test failed\n");
      return;
    }
  }
  printf("Receive byte test passed\n");
  return;
}

void SendByteTest(void)
{
  int i;

  for (i=0;i<16;i++) {
    SendByte(i);
  }
  printf("Send byte test completed\n");
  return;
}

void FillBuffer(unsigned char *buf)
{
  int i;

  for (i=0;i<16;i++) buf[i]=i;
}

int CheckBuffer(unsigned char *buf)
{
  int i;

  for (i=0;i<16;i++) if (buf[i]!=i) return 1;
  return 0;
}

void ReceiveCLPacketTest(void)
{
  int err,c;
  struct PacketInfo pkt;
  unsigned char buffer[16];

  err=0;
  pkt.length=16;
  pkt.data=buffer;
  c=ReceiveConnectionlessPacket(&pkt);
  if (c!=0) {
    err++;
  }
  else {
    if (CheckBuffer(buffer)) err++;
  }
  if (kbhit()) {
    printf("c=%d err=%d\n",c,err);
    return;
  }
  printf("c=%d err=%d\n",c,err);
  if (err==0) printf("Receive CL packet test passed\n");
  else printf("Receive CL packet test failed\n");
}

void SendCLPacketTest(void)
{
  struct PacketInfo pkt;
  unsigned char buffer[16];

  FillBuffer(buffer);
  pkt.seq=0;
  pkt.type=1;
  pkt.length=16;
  pkt.data=buffer;
  SendConnectionlessPacket(&pkt);
  if (kbhit()) return;
  printf("Send CL packet test completed\n");
}

void ReceivePacketTest(void)
{
  int i,err;
  struct PacketInfo pkt;
  unsigned char buffer[16];

  err=0;
  for (i=0;i<16;i++) {
    pkt.length=16;
    pkt.data=buffer;
    printf("Recing %d\n",i);
    if (ReceivePacket(&pkt)!=0) {
      err++;
      printf("TO\n");
    }
    else {
      if (CheckBuffer(buffer)) {
        err++;
        printf("bad buf\n");
      }
    }
    if (kbhit()) return;
  }
  if (err==0) printf("Receive packet test passed\n");
  else printf("Receive packet test failed\n");
}

void SendPacketTest(void)
{
  int i,err;
  struct PacketInfo pkt;
  unsigned char buffer[16];

  FillBuffer(buffer);
  err=0;
  for (i=0;i<16;i++) {
    pkt.type=1;
    pkt.length=16;
    pkt.data=buffer;
    if (SendPacket(&pkt)!=0) err++;
    if (kbhit()) return;
  }
  if (err==0) printf("Send packet test passed\n");
  else printf("Send packet test failed\n");
}

main()
{
  unsigned char buf[256];

  clrscr();

  InitA2IComms();

//  SynchroniseSequences();
//  EchoBytes();
//  ReceiveByteTest();
//  SendByteTest();
//  ReceiveCLPacketTest();
//  SendCLPacketTest();
//  ReceivePacketTest();
//  SendPacketTest();
//  if (getch()==0) getch();

  if (SynchroniseSequences()) {
    printf("No A2ICOMMS\n");
    return 1;
  }

  if (RmtConnected()) printf("Connected\n");
  else printf("Not connected\n");
//  RmtReadTrackSector(6,1,0,0,buf);
//  RmtDriveOff(6,2);
//  RmtRecalibrateDrive(6,2);

  return 0;
}
