Program WinApple;

{$X+}

Uses
  Windows,
  Messages,
  CommCtrl,
  CommDlg,
  SysUtils,
  Math,
  MMSystem,
  ShellAPI,
  MSVCRT;

Const AF_SIGN           =  $80;
      AF_OVERFLOW       =  $40;
      AF_RESERVED       =  $20;
      AF_BREAK          =  $10;
      AF_DECIMAL        =  $08;
      AF_INTERRUPT      =  $04;
      AF_ZERO           =  $02;
      AF_CARRY          =  $01;
      cNIBBLES          = 6656;
      cVIEWPORTX        =    5;
      cVIEWPORTY        =    5;
      cVIEWPORTCX       =  560;
      cVIEWPORTCY       =  384;
      cBUTTONX          = cVIEWPORTCX + (cVIEWPORTX Shl 1);
      cBUTTONY          =    0;
      BENCHOPCODES      = 33;
      BTN_HELP          =    0;
      BTN_RUN           =    1;
      BTN_DRIVE1        =    2;
      BTN_DRIVE2        =    3;
      BTN_FULLSCR       =    4;
      BTN_COLOR         =    5;
      BTN_DEBUG         =    6;
      BTN_SETUP         =    7;
      BREAKPOINTS       =    5;
      BUTTONCX          =   45;
      BUTTONCY          =   45;
      BUTTONS           =    8;
      BUTTONTIME        = 5000;
      COLOR_INSTBKG     =    0;
      COLOR_INSTTEXT    =    1;
      COLOR_INSTBP      =    2;
      COLOR_DATABKG     =    3;
      COLOR_DATATEXT    =    4;
      COLOR_STATIC      =    5;
      COLOR_BPDATA      =    6;
      COLOR_COMMAND     =    7;
      COLORS            =    8;
      COMMANDLINES      =    5;
      CPU_COMPILING     =    0;
      CPU_INTERPRETIVE  =    1;
      CPU_FASTPAGING    =    2;
      DEVICE_NONE       =    0;
      DEVICE_JOYSTICK   =    1;
      DEVICE_KEYBOARD   =    2;
      DEVICE_MOUSE      =    3;
      DRIVES            =    2;
      DRAW_BACKGROUND   =    1;
      DRAW_LEDS         =    2;
      DRAW_TITLE        =    4;
      FLAGNAME          = 'CZIDBRVN';
      FSBUTTONX         = 640 - BUTTONCX;
      FSBUTTONY         = (480 - cVIEWPORTCY Shr 1) - 1;
      FSVIEWPORTX       = 640 - BUTTONCX - 5 - cVIEWPORTCX;
      FSVIEWPORTY       = 480 - cVIEWPORTCY Shr 1;
      IMAGETYPES        =    7;
      MAXARGS           =   40;
      MAXEXPAGES        =  128;	         // user requested ram pages
      MAXIMAGES         =   16;
      MAX_EXT           =  256;
      MF_80STORE        = $00000001;
      MF_ALTZP          = $00000002;
      MF_AUXREAD        = $00000004;
      MF_AUXWRITE       = $00000008;
      MF_BANK2          = $00000010;
      MF_HIGHRAM        = $00000020;
      MF_HIRES          = $00000040;
      MF_IMAGEMASK      = $000003F7;
      MF_PAGE2          = $00000080;
      MF_SLOTC3ROM      = $00000100;
      MF_SLOTCXROM      = $00000200;
      MF_WRITERAM       = $00000400;
      COMMANDS          =        61;
      MODE_LOGO         =         0;
      MODE_PAUSED       =         1;
      MODE_RUNNING      =         2;
      MODE_DEBUG        =         3;
      MODE_STEPPING     =         4;
      MODE_NONE         =         0;
      MODE_STANDARD     =         1;
      MODE_CENTERING    =         2;
      MODE_SMOOTH       =         3;
      SPEED_NORMAL      =        10;
      SPEED_MAX         =        40;
      SCREENSPLIT1      =       356;
      SCREENSPLIT2      =       456;
      SHORTOPCODES      =        22;
      SOUND_NONE        =         0;
      SOUND_DIRECT      =         1;
      SOUND_SMART       =         2;
      SOUND_WAVE        =         3;
      SOURCELINES       =        19;
      SRCOFFS_40COL     =         0;
      SRCOFFS_80COL     = SRCOFFS_40COL  +  256;
      SRCOFFS_LORES     = SRCOFFS_80COL  +  128;
      SRCOFFS_HIRES     = SRCOFFS_LORES  +   16;
      SRCOFFS_DHIRES    = SRCOFFS_HIRES  +  512;
      SRCOFFS_TOTAL     = SRCOFFS_DHIRES + 2560;
      STACKLINES        =         9;
      TITLE             = 'Apple //e Emulator';
      TRACKS            =  35;
      VERSIONSTRING     = '4.10.5';
      VF_80COL          = $00000001;
      VF_DHIRES         = $00000002;
      VF_HIRES          = $00000004;
      VF_MASK2          = $00000008;
      VF_MIXED          = $00000010;
      VF_PAGE2          = $00000020;
      VF_TEXT           = $00000040;
      WATCHES           =         5;
      WAVEBUFFERS       =         8;
      BLACK             =       $00;
      DARK_RED          =       $01;
      DARK_GREEN        =       $02;
      DARK_YELLOW       =       $03;
      DARK_BLUE         =       $04;
      DARK_MAGENTA      =       $05;
      DARK_CYAN         =       $06;
      LIGHT_GRAY        =       $07;
      MONEY_GREEN       =       $08;
      SKY_BLUE          =       $09;
      CREAM             =       $F6;
      MEDIUM_GRAY       =       $F7;
      DARK_GRAY         =       $F8;
      RED               =       $F9;
      GREEN             =       $FA;
      YELLOW            =       $FB;
      BLUE              =       $FC;
      MAGENTA           =       $FD;
      CYAN              =       $FE;
      WHITE             =       $FF;
      DEEP_RED          =       $0A;
      LIGHT_BLUE        =       $0B;
      BROWN             =       $0C;
      ORANGE            =       $0D;
      PINK              =       $0E;
      AQUA              =       $0F;
      MONOCHROME        =       $10;
      INVALID1          =         1;
      INVALID2          =         2;
      INVALID3          =         3;
      ADDR_IMM          =         4;
      ADDR_ABS          =         5;
      ADDR_ZPG          =         6;
      ADDR_ABSX         =         7;
      ADDR_ABSY         =         8;
      ADDR_ZPGX         =         9;
      ADDR_ZPGY         =        10;
      ADDR_REL          =        11;
      ADDR_INDX         =        12;
      ADDR_ABSIINDX     =        13;
      ADDR_INDY         =        14;
      ADDR_IZPG         =        15;
      ADDR_IABS         =        16;

Type  Ok                = LongBool;
      hImage            = tHandle;
      tInstance         = LongWord;
      tWPARAM           = WPARAM;
      LPBITMAPINFO      = ^tBitmapInfo;
      LPBOOL            = ^Bool;
      LPBYTE            = ^Byte;
      LPBYTEPTR         = ^LPBYTE;
      LPDWORD           = ^DWord;
      LPIMAGE           = ^hImage;
      LPINT             = ^Integer;
      LPLONGINT         = ^LongInt;
      LPVOID            = ^Pointer;
      LPRECT            = ^tRect;
      LPWORD            = ^Word;
      CmdFunction       = Function(  Args           : Integer     ) : Bool;
      IoFunction        = Function(  Programcounter : Word;
                                     Address        : Byte;
                                     Write          : Byte;
                                     Value          : Byte        ) : Byte;  stdcall;
      CpuExecuteType    = Function(  p1             : DWord       ) : DWord; stdcall;
      CpuInitType       = Procedure( p1             : LPBYTE;
                                     p2,p3          : LPBYTE;
                                     p4,p5          : DWord;
                                     p6             : LPVOID;
                                     p7,p8          : IoFunction;
                                     p9             : LPBYTE      );         stdcall;
      CpuGetCodeType    = Procedure( p1             : Word;
                                     p2             : LPBYTEPTR;
                                     p3             : LPDWORD     );         stdcall;
      UpdateType        = Function(  x,y,
                                     xPixel,yPixel,
                                     Offset         : Integer     ) : Bool;
      tBpRec            = Record
                            Address         : Word;
                            Length          : Word;
                            Enabled         : Bool
                          End;
      BpRec             = tBpRec;
      BpPtr             = ^BpPtr;
      tRegsRec          = Record
                            A               : Byte;  // accumulator
                            X               : Byte;  // index X
                            Y               : Byte;  // index Y
                            PS              : Byte;  // processor status
                            PC              : Word;  // program counter
                            SP              : WORD;  // stack pointer
                          End;
      RegsRec           = tRegsRec;
      RegsPtr           = ^RegsRec;
      tFloppyRec        = Record
                            ImageName       : Array[0..15]  of Char;
                            FullName        : Array[0..127] of Char;
                            ImageHandle     : hImage;
                            Track           : Integer;
                            TrackImage      : LPBYTE;
                            Phase           : Integer;
                            Byte            : Integer;
                            WriteProtected  : Bool;
                            TrackImageData  : Bool;
                            TrackImageDirty : Bool;
                            Spinning        : DWord;
                            WriteLight      : DWord;
                            Nibbles         : Integer
                          End;
      FloppyRec         = tFloppyRec;
      FloppyPtr         = ^FloppyRec;
      tImageInfoRec     = Record
                            Filename       : Array[0..Pred(MAX_PATH)] of Char;
                            Format         : DWord;
                            _File          : tHandle;
                            Offset         : DWord;
                            WriteProtected : Bool;
                            HeaderSize     : DWord;
                            Header         : LPBYTE;
                            ValidTrack     : Array[0..Pred(TRACKS)] of Bool
                          End;
      ImageInfoRec      = tImageInfoRec;
      ImageInfoPtr      = ^ImageInfoRec;
      tJoyInfoRec       = Record
                            Device : Integer;
                            Mode   : Integer
                          End;
      JoyInfoRec        = tJoyInfoRec;
      JoyInfoPtr        = ^JoyInfoRec;
      tSymbolRec        = Record
                            Value : Word;
                            Name  : Array[0..13] of Char
                          End;
      SymbolRec         = tSymbolRec;
      SymbolPtr         = ^SymbolRec;
      BootType          = Function (Ptr                 : ImageInfoPtr  ) : Bool;
      DetectType        = Function (ImagePtr            : LPBYTE;
                                    ImageSize           : DWord         ) : DWord;
      ReadType          = Procedure(Ptr                 : ImageInfoPtr;
                                    Track, QuarterTrack : Integer;
                                    TrackImageBuffer    : LPBYTE;
                                    Nibbles             : LPINT         );
      WriteType         = Procedure(Ptr                 : ImageInfoPtr;
                                    Track, QuarterTrack : Integer;
                                    Trackimage          : LPBYTE;
                                    Nibbles             : Integer       );
      tImangeTypeRec    = Record
                            CreateExts : LPTSTR;
                            RejectExts : LPTSTR;
                            Detect     : DetectType;
                            Boot       : BootType;
                            Read       : ReadType;
                            Write      : WriteType
                          End;
      ImageTypeRec      = tImangeTypeRec;
      ImageTypePtr      = ImageTypeRec;
      tInstRec          = Record
                            Mnemonic : Array[0..3] of Char;
                            AddrMode : Integer
                          End;
      InstRec           = tInstRec;
      InstPtr           = ^InstRec;
      tAddrRec          = Record
                            Format : Array[0..11] of Char;
                            Bytes  : Integer
                          End;
      AddrRec           = tAddrRec;
      AddrPtr           = ^AddrRec;
      tCmdRec           = Record
                            Name  : Array[0..11] of Char;
                            Funct : CmdFunction;
                          End;
      CmdRec            = tCmdRec;
      CmdPtr            = ^CmdRec;
      tArgRec           = Record
                            Str  : Array[0..11] of Char;
                            Val1 : Word;
                            Val2 : Word
                          End;
      ArgRec            = tArgRec;
      ArgPtr            = ^ArgRec;

Function  CommCommand(           ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  CommControl(           ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  CommDipSw(             ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  CommReceive(           ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  CommStatus(            ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    Stdcall; Forward;
Function  CommTransmit(          ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskControlMotor(      ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskControlStepper(    ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskEnable(            ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskReadWrite(         ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskSetLatchValue(     ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskSetReadMode(       ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  DiskSetWriteMode(      ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  JoyReadButton(         ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  JoyReadPosition(       ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  JoyResetPosition(      ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    Stdcall; Forward;
Function  KeybReadData(          ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ): Byte;     StdCall; Forward;
Function  KeybReadFlag(          ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  MemCheckPaging(        ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  MemSetPaging(          ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  NullIo(                ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  SpkrToggle(            ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  VideoCheckMode(        ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  VideoCheckVbl(         ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  VideoSetMode(          ProgramCounter      : Word;
                                 Address             : Byte;
                                 Write               : Byte;
                                 Value               : Byte         ) : Byte;    StdCall; Forward;
Function  ImageOpen(             ImageFilename       : LPTSTR;
                                 ImageHandle         : LPIMAGE;
                                 WriteProtected      : LPBOOL;
                                 CreateIfNecessary   : Bool         ) : Integer;          Forward;
Function  PrgDetect(             ImagePtr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  DoDetect(              ImagePtr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  PoDetect(              ImagePtr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  AplDetect(             Imageptr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  Nib1Detect(            ImagePtr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  Nib2Detect(            ImagePtr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  IIeDetect(             ImagePtr            : LPBYTE;
                                 ImageSize           : DWord        ) : DWord;            Forward;
Function  PrgBoot(               Ptr                 : ImageInfoPtr ) : Bool;             Forward;
Function  AplBoot(               Ptr                 : ImageInfoPtr ) : Bool;             Forward;
Function  CmdBreakpointAdd(      Args                : Integer      ) : Bool;             Forward;
Function  CmdBreakpointClear(    Args                : Integer      ) : Bool;             Forward;
Function  CmdBreakpointDisable(  Args                : Integer      ) : Bool;             Forward;
Function  CmdBreakpointEnable(   Args                : Integer      ) : Bool;             Forward;
Function  CmdSetupBenchmark(     Args                : Integer      ) : Bool;             Forward;
Function  CmdBlackWhite(         Args                : Integer      ) : Bool;             Forward;
Function  CmdColor(              Args                : Integer      ) : Bool;             Forward;
Function  CmdMemoryDump(         Args                : Integer      ) : Bool;             Forward;
Function  CmdExtBenchmark(       Args                : Integer      ) : Bool;             Forward;
Function  CmdGo(                 Args                : Integer      ) : Bool;             Forward;
Function  CmdInput(              Args                : Integer      ) : Bool;             Forward;
Function  CmdInternalCodeDump(   Args                : Integer      ) : Bool;             Forward;
Function  CmdInternalMemoryDump( Args                : Integer      ) : Bool;             Forward;
Function  CmdFeedKey(            Args                : Integer      ) : Bool;             Forward;
Function  CmdCodeDump(           Args                : Integer      ) : Bool;             Forward;
Function  CmdMemoryEnter(        Args                : Integer      ) : Bool;             Forward;
Function  CmdMemoryFill(         Args                : Integer      ) : Bool;             Forward;
Function  CmdOutput(             Args                : Integer      ) : Bool;             Forward;
Function  CmdProfile(            Args                : Integer      ) : Bool;             Forward;
Function  CmdRegisterSet(        Args                : Integer      ) : Bool;             Forward;
Function  CmdFlagSet(            Args                : Integer      ) : Bool;             Forward;
Function  CmdTrace(              Args                : Integer      ) : Bool;             Forward;
Function  CmdTraceFile(          Args                : Integer      ) : Bool;             Forward;
Function  CmdTraceLine(          Args                : Integer      ) : Bool;             Forward;
Function  CmdWatchAdd(           Args                : Integer      ) : Bool;             Forward;
Function  CmdWatchClear(         Args                : Integer      ) : Bool;             Forward;
Function  CmdZap(                Args                : Integer      ) : Bool;             Forward;
Function  CmdViewOutput(         Args                : Integer      ) : Bool;             Forward;
Function  VideoChooseColor(      myColor : COLORREF ): COLORREF;                          Forward;
Function  RegLoadValue(          Section             : LPTSTR;
                                 Key                 : LPTSTR;
                                 PerUser             : Boolean;
                                 Value               : LPDWORD      ) : Bool;             Forward;
Function  RegLoadString(         Section             : LPTSTR;
                                 Key                 : LPTSTR;
                                 PerUser             : Boolean;
                                 Buffer              : LPTSTR;
                                 Chars               : DWord        ) : Bool;             Forward;
Function RegLoadStringLong(      Section             : LPTSTR;
                                 Key                 : LPTSTR;
                                 PerUser             : Boolean;
                                 Buffer              : LPTSTR;
                                 Size                : Word         ) : Bool;             Forward;
Procedure RegSaveString(         Section             : LPTSTR;
                                 Key                 : LPTSTR;
                                 PerUser             : Boolean;
                                 Buffer              : LPTSTR       );                    Forward;
Procedure RegSaveStringLong(     Section             : LPTSTR;
                                 Key                 : LPTSTR;
                                 PerUser             : Boolean;
                                 Buffer              : LPTSTR;
                                 Size                : Word         );                    Forward;
Procedure SetColorBitmap(        DC                  : hDC;
                                 ColorType,
                                 Entry               : Byte;
                                 Color               : COLORREF     );                    Forward;
Function  SpkrSetEmulationType(  Window              : hWnd;
                                 NewType             : DWord        ) : Bool;             Forward;
Function  MemReturnRandomData(   HighBit             : Byte         ) : Byte;             Forward;
Function  DiskIsSpinning                                              : Bool;             Forward;
Function  FrameGetDC                                                  : hDC;              Forward;
Function  ImageBoot(             ImageHandle         : hImage       ) : Bool;             Forward;
Procedure FrameReleaseDC;                                                                 Forward;
Procedure FrameRefreshStatus(    DrawFlags           : Integer      );                    Forward;
Procedure KeybGetCapsStatus(     Status              : LPBOOL       );                    Forward;
Procedure DiskUpdatePosition(    Cycles              : DWord        );                    Forward;
Procedure MemReset;                                                                       Forward;
Procedure MemResetPaging;                                                                 Forward;
Procedure MemSetFastPaging(      _On                 : Boolean      );                    Forward;
Procedure VideoRealizePalette(   DC                  : hDC          );                    Forward;
Procedure SpkrInitialize;                                                                 Forward;
Procedure VideoDisplayLogo;                                                               Forward;
Procedure VideoRedrawScreen;                                                              Forward;
Procedure VideoRefreshScreen;                                                             Forward;
Procedure VideoReinitialize;                                                              Forward;
Procedure VideoResetState;                                                                Forward;
Procedure ImageDestroy;                                                                   Forward;
Procedure MemDestroy;                                                                     Forward;
Procedure SpkrDestroy;                                                                    Forward;
Procedure VideoDestroy;                                                                   Forward;
Procedure VideoBenchmark;                                                                 Forward;
Procedure KeybToggleCapsLock;                                                             Forward;
Procedure RegSaveValue(          Section             : LPTSTR;
                                 Key                 : LPTSTR;
                                 PerUser             : Boolean;
                                 Value               : DWord        );                    Forward;
Procedure KeybQueueKeypress(     Key                 : Integer;
                                 Ascii               : Bool         );                    Forward;
Procedure DoRead(                Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImageBuffer    : LPBYTE;
                                 Nibbles             : LPINT        );                    Forward;
Procedure PoRead(                Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImageBuffer    : LPBYTE;
                                 Nibbles             : LPINT        );                    Forward;
Procedure Nib1Read(              Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImageBuffer    : LPBYTE;
                                 Nibbles             : LPINT        );                    Forward;
Procedure Nib2Read(              Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImageBuffer    : LPBYTE;
                                 Nibbles             : LPINT        );                    Forward;
Procedure IIeRead(               Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImageBuffer    : LPBYTE;
                                 Nibbles             : LPINT        );                    Forward;
Procedure DoWrite(               Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 Trackimage          : LPBYTE;
                                 Nibbles             : Integer      );                    Forward;
Procedure PoWrite(               Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImage          : LPBYTE;
                                 Nibbles             : Integer      );                    Forward;
Procedure Nib1Write(             Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImage          : LPBYTE;
                                 Nibbles             : Integer      );                    Forward;
Procedure Nib2Write(             Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImage          : LPBYTE;
                                 Nibbles             : Integer      );                    Forward;
Procedure IIeWrite(              Ptr                 : ImageInfoPtr;
                                 Track, QuarterTrack : Integer;
                                 TrackImage          : LPBYTE;
                                 Nibbles             : Integer      );                    Forward;
Procedure ImageClose(            ImageHandle         : hImage       );                    Forward;
Procedure ImageReadTrack(        ImageHandle         : hImage;
                                 Track               : Integer;
                                 QuarterTrack        : Integer;
                                 TrackImageBuffer    : LPBYTE;
                                 Nibbles             : LPINT        );                    Forward;
Procedure ImageWriteTrack(       ImageHandle         : hImage;
                                 Track               : Integer;
                                 QuarterTrack        : Integer;
                                 TrackImage          : LPBYTE;
                                 Nibbles             : Integer      );                    Forward;
Function Beep(dwFreq, dwDuration: DWORD): BOOL; stdcall; external kernel32 name 'Beep';

Var   Active            : Bool      = false;
      AfterClose        : Bool      = false;
      AnyUpdates        : Bool      = false;
      Apple2e           : Bool      = true;
      Behind            : Bool      = false;
      Calibrating       : Bool      = false;
      CapsLock          : Bool      = true;
      ColorChanged      : Bool      = false;
      DirectIO          : Bool      = false;
      DiskAccessed      : Bool      = false;
      DisplayPage2      : Bool      = false;
      EnhanceDisk       : Bool      = true;
      FastPaging        : Bool      = false;
      FirstDelay        : Bool      = false;
      FineGrainTiming   : Bool      = true;
      FineGrainLast     : Bool      = true;
      Flash	        : Bool      = false;
      FlashLast         : Bool      = false;
      FloppyMotorOn     : Bool      = false;
      FloppyWriteMode   : Bool      = false;
      FullScreen        : Bool      = false;
      FullSpeed         : Bool      = false;
      GraphicsMode      : Bool      = false;
      H_Scanlines       : Bool      = false;
      HasRefreshed      : Bool      = false;
      HelpQuit          : Bool      = false;
      KeyWaiting        : Bool      = false;
      LastFull          : Bool      = false;
      LastStep          : Bool      = false;
      LastWriteRam      : Bool      = false;
      lFlash            : Bool      = false;
      ModeChanging      : Bool      = false;
      NormalDelays      : Bool      = false;
      PageFlipping      : Bool      = false;
      Painting          : Bool      = false;
      Profiling         : Bool      = false;
      RedrawFull        : Bool      = true;
      ResetTiming       : Bool      = false;
      Restart           : Bool      = false;
      Stepline          : Bool      = false;
      TableGenerated    : Bool      = false;
      UsingBP           : Bool      = false;
      UsingCursor       : Bool      = false;
      UsingMemDump      : Bool      = false;
      UsingWatches      : Bool      = false;
      ViewIngOutput     : Bool      = false;
      ByteSize          : Byte      = 8;
      ControlByte       : Byte      = $1F;
      CommandByte       : Byte      = $00;
      FloppyLatch       : Byte      = 0;
      KeyCode           : Byte      = 0;
      Parity            : Byte      = NOPARITY;
      StopBits          : Byte      = ONESTOPBIT;
      ToggleVal         : Byte      = $50;
      Ahead             : DWord     = 0;
      BufferRate        : DWord     = 0;
      BufferSize        : DWord     = 0;
      BufferUse         : DWord     = 0;
      ClockGran         : Dword     = 0;
      CommInActivity    : DWord     = 0;
      CpuEmType         : DWord     = CPU_COMPILING;
      CumulativeCycles  : DWord     = 0;
      CurrentHertz      : DWord     = 0;
      CycleNum          : DWord     = 0;
      CycleGran         : DWord     = 0;
      CycleShift        : DWord     = 0;
      Dummy             : DWord     = 0;
      EmulMsec          : DWord     = 0;
      ExtBench          : DWord     = 0;
      FineGrainDelay    : DWord     = 1;
      HiResColorType    : Dword     = 0;
      TextColorType     : Dword     = 0;
      Image             : DWord     = 0;
      JoyType           : DWord     = 1;
      KeyboardQueries   : DWord     = 0;
      LastCheck         : DWord     = 0;
      LastCycleNum      : DWord     = 0;
      LastCycles        : DWord     = 0;
      LastDelay         : DWord     = 1;
      LastNormalDelays  : DWord     = 1;
      LastFastPaging    : DWord     = 0;
      LastFlashTime     : DWord     = 0;
      LastID            : DWord     = 0; 
      LastImage         : DWord     = 0;
      LastPageFlip      : DWord     = 0;
      LastRefresh       : DWord     = 0;
      LastReset         : DWord     = 0;
      LastTime          : DWord     = 0;
      LastToggles       : DWord     = 0;
      LastTrimImages    : DWord     = 0;
      LastVal           : DWord     = 0;
      MemMode           : DWord     = MF_BANK2 OR MF_SLOTCXROM OR MF_WRITERAM;
      MicroSeconds      : DWord     = 0;
      MilliSeconds      : DWord     = 0;
      NeedsPrecision    : DWord     = 0;
      NextImage         : DWord     = 0;
      Pages             : DWord     = 0;
      QuietCycles       : DWord     = 0;
      RecvBytes         : DWord     = 0;
      SerialPort        : DWord     = 0;
      SoundEffect       : DWord     = 0;
      SoundType         : DWord     = SOUND_WAVE;
      Speed             : DWord     = 10;
      Toggles           : DWord     = 0;
      TotalDelta        : DWord     = 0;
      TrimNumber        : DWord     = 0;
      VblCounter        : DWord     = 0;
      VideoType         : DWord     = 2;
      VidMode           : DWord     = VF_TEXT;
      WaveOffset        : DWord     = 0;
      ButtonActive      : Integer   = -1;
      ButtonDown        : Integer   = -1;
      ButtonOver        : Integer   = -1;
      ButtonX           : Integer   = cBUTTONX;
      ButtonY           : Integer   = cBUTTONY;
      CharOffs          : Integer   = 0;
      ColorScheme       : Integer   = 0;
      CurrDrive         : Integer   = 0;
      DelayLeft         : Integer   = 0;
      JoyShrX           : Integer   = 8;
      JoyShrY           : Integer   = 8;
      JoySubX           : Integer   = 0;
      JoySubY           : Integer   = 0;
      LastVirtKey       : Integer   = 0;
      LastX             : Integer   = 0;
      LastY             : Integer   = 0;
      xDelay            : Integer   = 0;
      xPos              : Integer   = 127;
      yDelay            : Integer   = 0;
      yPos              : Integer   = 127;
      Mode              : Integer   = MODE_LOGO;
      StepCount         : Integer   = 0;
      StepStart         : Integer   = 0;
      StepUntil         : Integer   = -1;
      SymbolNum         : Integer   = 0;
      ViewPortX         : Integer   = cVIEWPORTX;
      ViewPortY         : Integer   = cVIEWPORTY;
      WavePrep          : Integer   = 0;
      BaudRate          : DWord     = CBR_19200;
      DeviceBitmap      : hBitmap;
      LogoBitmap        : hBitmap;
      SourceBitmap      : hBitmap;
      BtnFaceBrush      : hBrush    = hBrush(0);
      DebugFont         : hFont     = hFont(0);
      SmallFont         : hFont     = hFont(0);
      FrameDC           : hDC       = hDC(0);
      DeviceDC          : hDC       = hDC(0);
      Palette           : hPalette;
      BtnFacePen        : hPen      = hPen(0);
      BtnHighlightPen   : hPen      = hPen(0);
      BtnShadowPen      : hPen      = hPen(0);
      WaveOut           : hWaveOut  = hWaveOut(0);
      FrameWindow       : hWnd      = hWnd(0);
      TooltipWindow     : hWnd      = hWnd(0);
      TraceFile         : pFile     = Nil;
      CommHandle        : tHandle   = INVALID_HANDLE_VALUE;
      Instance          : tInstance = tInstance(0);
      LastPC            : Word      = 0;
      MemoryDump        : Word      = 0;
      TopOffset         : Word      = 0;
//    _Monochrome       : COLORREF  = $FFFFFF;              //white
//    _Monochrome       : COLORREF  = $00FFFF;              //amber
      _Monochrome       : COLORREF  = $00FF00;              //green
      FrameBufferPitch  : LongInt   = 0;
      StepsTaken        : Word      = 0;
      FrameBufferInfo   : LPBITMAPINFO;
      SourceInfo        : LPBITMAPINFO;
      FrameBufferAddr   : LPBYTE    = LPBYTE(0);
      FrameBufferBits   : LPBYTE    = Nil;
      HiresAuxPtr       : LPBYTE    = Nil;
      HiresMainPtr      : LPBYTE    = Nil;
      Mem               : LPBYTE    = NiL;
      MemAux            : LPBYTE    = NiL;
      MemBank           : LPBYTE    = Nil;
      MemDirty          : LPBYTE    = NiL;
      MemImage          : LPBYTE    = NiL;
      MemMain           : LPBYTE    = NiL;
      MemRom            : LPBYTE    = NiL;
      SourceBits        : LPBYTE    = Nil;
      TextAuxPtr        : LPBYTE    = Nil;
      TextMainPtr       : LPBYTE    = Nil;
      VidLastMem        : LPBYTE    = Nil;
      WorkBuffer        : LPBYTE    = Nil;
      ComputerChoices   : LPTSTR    = 'Apple ][+'               +#0+
                                      'Apple //e'               +#0;
      JoystickChoices   : LPTSTR    = 'Disabled'                +#0+
                                      'PC Joystick'             +#0+
                                      'Keyboard (standard)'     +#0+
                                      'Keyboard (centering)'    +#0+
                                      'Mouse'                   +#0;
      SerialChoices     : LPTSTR    = 'None'                    +#0+
                                      'COM1'                    +#0+
                                      'COM2'                    +#0+
                                      'COM3'                    +#0+
                                      'COM4'                    +#0;
      SoundChoices      : LPTSTR    = 'Disabled'                +#0+
                                      'PC Speaker (direct)'     +#0+
                                      'PC Speaker (translated)' +#0+
                                      'Sound Card'              +#0;
      VideoChoices      : LPTSTR    = 'Monochrome'              +#0+
                                      'Color (standard)'        +#0+
                                      'Color (optimized)'       +#0;
      DiscChoices       : LPTSTR    = 'Authentic Speed'         +#0+
                                      'Enhanced Speed'          +#0;
      TextColorChoices  : LPTSTR    = 'Monochrome';
      HiresColorChoices : LPTSTR    = 'Black'#0+
                                      'Dark Blue'#0+
                                      'Dark Green'#0+
                                      'Blue'#0+
                                      'Brown'#0+
                                      'Light Gray'#0+
                                      'Green'#0+
                                      'Aqua'#0+
                                      'Deep Red'#0+
                                      'Magenta'#0+
                                      'Dark Gray'#0+
                                      'Light Blue'#0+
                                      'Orange'#0+
                                      'Pink'#0+
                                      'Yellow'#0+
                                      'White';
      SymbolTable       : SymbolPtr = Nil;
      FrameRect         : tRect     = (Left:0;Top:0;Right:0;Bottom:0);
      Regs              : RegsRec;
      Asciicode         : Array[0..3]                  of Byte           = ($08,$0B,$15,$0A);
      SixBitByte        : Array[0..$7F]                of Byte;
      Breakpoint        : Array[0..Pred(BREAKPOINTS)]  of BpRec;
      CpuExecuteFunc    : Array[0..2]                  of CpuExecuteType = (NiL,NiL,NiL);
      CpuGetCodeFunc    : Array[0..2]                  of CpuGetCodeType = (Nil,Nil,Nil);
      CpuInitFunc       : Array[0..2]                  of CpuInitType    = (NiL,NiL,NiL);
      CpuLibrary        : Array[0..2]                  of tInstance      = (tInstance(0),tInstance(0),tInstance(0));
      ButtonBitmap      : Array[0..Pred(BUTTONS)]      of hBitmap;
      CapsBitmap        : Array[0..1]                  of hBitmap;
      DiskBitmap        : Array[0..2]                  of hBitmap;
      ColorBitmap       : Array[0..1]                  of Array[0..16]  of hBitmap;
      ColorTable        : Array[0..1]                  of Array[0..16]  of COLORREF;
      Floppy            : Array[0..Pred(DRIVES)]       of FloppyRec;
      JoyButton         : Array[0..2]                  of Bool           = (false,false,false);
      KeyDown           : Array[0..10]                 of Bool           = (false,false,false,false,false,false,false,false,false,false,false);
      SetButton         : Array[0..1]                  of Bool           = (false,false);
      LastUpdates       : Array[0..1]                  of Bool           = (false,false);
      ProgDir           : Array[0..Pred(MAX_PATH)]     of Char           = '';
      CellDirty         : Array[0..39]                 of Array[0..31]  of Byte;
      MemShadow         : Array[0..Pred(MAXIMAGES)]    of Array[0..$FF] of LPBYTE;
      MemWrite          : Array[0..Pred(MAXIMAGES)]    of Array[0..$FF] of LPBYTE;
      FrameOffsetTable  : Array[0..383]                of LPBYTE;
      RW_Pages          : Array[0..PRED(MAXEXPAGES)]   of LPBYTE;
      SourceOffsetTable : Array[0..511]                of LPBYTE;
      WaveData          : Array[0..Pred(WAVEBUFFERS)]  of LPBYTE;
      WaveHdr           : Array[0..Pred(WAVEBUFFERS)]  of pWAVEHDR;
      RecvBuffer        : Array[0..8]                  of Byte;
      Sym_Buffer        : Array[0..7]                  of Char           = '';
      CustomColors      : Array[0..15]                 of COLORREF;
      Arg               : Array[0..Pred(MAXARGS)]      of ArgRec;
      HalfToneTable     : Array[0..5]                  of Byte = ( 32,64,96,160,192,224 );
      DiskByte          : Array[0..$3F]                of Byte =
                             ( $96,$97,$9A,$9B,$9D,$9E,$9F,$A6,$A7,$AB,$AC,$AD,$AE,$AF,$B2,$B3,
                               $B4,$B5,$B6,$B7,$B9,$BA,$BB,$BC,$BD,$BE,$BF,$CB,$CD,$CE,$CF,$D3,
                               $D6,$D7,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E5,$E6,$E7,$E9,$EA,$EB,$EC,
                               $ED,$EE,$EF,$F2,$F3,$F4,$F5,$F6,$F7,$F9,$FA,$FB,$FC,$FD,$FE,$FF );
      SectorNumber      : Array[0..2]                  of Array[0..$0F] of Byte =
                            (( $00,$08,$01,$09,$02,$0A,$03,$0B,$04,$0C,$05,$0D,$06,$0E,$07,$0F ),
                             ( $00,$07,$0E,$06,$0D,$05,$0C,$04,$0B,$03,$0A,$02,$09,$01,$08,$0F ),
                             ( $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ));
      Watch             : Array[0..Pred(WATCHES)]      of Integer;
      ButtonLatch       : Array[0..2]                  of DWord          = (0,0,0);
      ImageMode         : Array[0..Pred(MAXIMAGES)]    of DWord;
      LastDelta         : Array[0..1]                  of DWord          = (0,0);
      ProfileData       : Array[0..255]                of DWord;
      CommandString     : Array[0..Pred(COMMANDLINES)] of Array[0..79] of Char;
      tmpBuffer         : Array[0..255]                of Char = '';
      BenchOpcode       : Array[0..Pred(BENCHOPCODES)] of Byte =
                             ( $06,$16,$24,$45,$48,$65,$68,$76,$84,$85,$86,$91,$94,$A4,
                               $A5,$A6,$B1,$B4,$C0,$C4,$C5,$E6,$19,$6D,$8D,$99,$9D,$AD,
                               $B9,$BD,$DD,$ED,$EE );
      KeyValue          : Array[0..8]                  of tPoint =
                            (( X:0;Y:255),(X:127;Y:255),(X:255;Y:255),
                             ( X:0;Y:127),(X:127;Y:127),(X:255;Y:127),
                             ( X:0;Y:0  ),(X:127;Y:0  ),(X:255;Y:0     ));
      Joy_Info          : Array[0..4]                  of JoyInfoRec =
                            (( Device : DEVICE_NONE;     Mode : MODE_NONE      ),
                             ( Device : DEVICE_JOYSTICK; Mode : MODE_STANDARD  ),
                             ( Device : DEVICE_KEYBOARD; Mode : MODE_STANDARD  ),
                             ( Device : DEVICE_KEYBOARD; Mode : MODE_CENTERING ),
                             ( Device : DEVICE_MOUSE;    Mode : MODE_STANDARD  ));
      ImageType         : Array[0..Pred(IMAGETYPES)]   of ImageTypeRec =
                            (( CreateExts : '.prg';
                               RejectExts : '.do;.dsk;.iie;.nib;.po';
                               Detect     : PrgDetect;
                               Boot       : PrgBoot;
                               Read       : Nil;
                               Write      : Nil ),
                             ( CreateExts : '.do;.dsk';
                               RejectExts : '.nib;.iie;.po;.prg';
                               Detect     : DoDetect;
                               Boot       : Nil;
                               Read       : DoRead;
                               Write      : DoWrite ),
                             ( CreateExts : '.po';
                               RejectExts : '.do;.iie;.nib;.prg';
                               Detect     : PoDetect;
                               Boot       : Nil;
                               Read       : PoRead;
                               Write      : PoWrite ),
                             ( CreateExts : '.apl';
                               RejectExts : '.do;.dsk;.iie;.nib;.po';
                               Detect     : AplDetect;
                               Boot       : AplBoot;
                               Read       : Nil;
                               Write      : Nil ),
                              ( CreateExts : '.nib';
                               RejectExts : '.do;.iie;.po;.prg';
                               Detect     : Nib1Detect;
                               Boot       : Nil;
                               Read       : Nib1Read;
                               Write      : Nib1Write ),
                             ( CreateExts : '.nb2';
                               RejectExts : '.do;.iie;.po;.prg';
                               Detect     : Nib2Detect;
                               Boot       : Nil;
                               Read       : Nib2Read;
                               Write      : Nib2Write ),
                             ( CreateExts : '.iie';
                               RejectExts : '.do.;.nib;.po;.prg';
                               Detect     : IIeDetect;
                               Boot       : Nil;
                               Read       : IIeRead;
                               Write      : IIeWrite ));
      IoRead            : Array[0..$FF] of IoFunction =
                            (  KeybReadData,       // $C000
                               KeybReadData,       // $C001
                               KeybReadData,       // $C002
                               KeybReadData,       // $C003
                               KeybReadData,       // $C004
                               KeybReadData,       // $C005
                               KeybReadData,       // $C006
                               KeybReadData,       // $C007
                               KeybReadData,       // $C008
                               KeybReadData,       // $C009
                               KeybReadData,       // $C00A
                               KeybReadData,       // $C00B
                               KeybReadData,       // $C00C
                               KeybReadData,       // $C00D
                               KeybReadData,       // $C00E
                               KeybReadData,       // $C00F
                               KeybReadFlag,       // $C010
                               MemCheckPaging,     // $C011
                               MemCheckPaging,     // $C012
                               MemCheckPaging,     // $C013
                               MemCheckPaging,     // $C014
                               MemCheckPaging,     // $C015
                               MemCheckPaging,     // $C016
                               MemCheckPaging,     // $C017
                               MemCheckPaging,     // $C018
                               VideoCheckVbl,      // $C019
                               VideoCheckMode,     // $C01A
                               VideoCheckMode,     // $C01B
                               MemCheckPaging,     // $C01C
                               MemCheckPaging,     // $C01D
                               VideoCheckMode,     // $C01E
                               VideoCheckMode,     // $C01F
                               NullIo,             // $C020
                               NullIo,             // $C021
                               NullIo,             // $C022
                               NullIo,             // $C023
                               NullIo,             // $C024
                               NullIo,             // $C025
                               NullIo,             // $C026
                               NullIo,             // $C027
                               NullIo,             // $C028
                               NullIo,             // $C029
                               NullIo,             // $C02A
                               NullIo,             // $C02B
                               NullIo,             // $C02C
                               NullIo,             // $C02D
                               NullIo,             // $C02E
                               NullIo,             // $C02F
                               SpkrToggle,         // $C030
                               SpkrToggle,         // $C031
                               SpkrToggle,         // $C032
                               SpkrToggle,         // $C033
                               SpkrToggle,         // $C034
                               SpkrToggle,         // $C035
                               SpkrToggle,         // $C036
                               SpkrToggle,         // $C037
                               SpkrToggle,         // $C038
                               SpkrToggle,         // $C039
                               SpkrToggle,         // $C03A
                               SpkrToggle,         // $C03B
                               SpkrToggle,         // $C03C
                               SpkrToggle,         // $C03D
                               SpkrToggle,         // $C03E
                               SpkrToggle,         // $C03F
                               NullIo,             // $C040
                               NullIo,             // $C041
                               NullIo,             // $C042
                               NullIo,             // $C043
                               NullIo,             // $C044
                               NullIo,             // $C045
                               NullIo,             // $C046
                               NullIo,             // $C047
                               NullIo,             // $C048
                               NullIo,             // $C049
                               NullIo,             // $C04A
                               NullIo,             // $C04B
                               NullIo,             // $C04C
                               NullIo,             // $C04D
                               NullIo,             // $C04E
                               NullIo,             // $C04F
                               VideoSetMode,       // $C050
                               VideoSetMode,       // $C051
                               VideoSetMode,       // $C052
                               VideoSetMode,       // $C053
                               MemSetPaging,       // $C054
                               MemSetPaging,       // $C055
                               MemSetPaging,       // $C056
                               MemSetPaging,       // $C057
                               NullIo,             // $C058
                               NullIo,             // $C059
                               NullIo,             // $C05A
                               NullIo,             // $C05B
                               NullIo,             // $C05C
                               NullIo,             // $C05D
                               VideoSetMode,       // $C05E
                               VideoSetMode,       // $C05F
                               NullIo,             // $C060
                               JoyReadButton,      // $C061
                               JoyReadButton,      // $C062
                               JoyReadButton,      // $C063
                               JoyReadPosition,    // $C064
                               JoyReadPosition,    // $C065
                               NullIo,             // $C066
                               NullIo,             // $C067
                               NullIo,             // $C068
                               NullIo,             // $C069
                               NullIo,             // $C06A
                               NullIo,             // $C06B
                               NullIo,             // $C06C
                               NullIo,             // $C06D
                               NullIo,             // $C06E
                               NullIo,             // $C06F
                               JoyResetPosition,   // $C070
                               NullIo,             // $C071
                               NullIo,             // $C072
                               NullIo,             // $C073
                               NullIo,             // $C074
                               NullIo,             // $C075
                               NullIo,             // $C076
                               NullIo,             // $C077
                               NullIo,             // $C078
                               NullIo,             // $C079
                               NullIo,             // $C07A
                               NullIo,             // $C07B
                               NullIo,             // $C07C
                               NullIo,             // $C07D
                               NullIo,             // $C07E
                               VideoCheckMode,     // $C07F
                               MemSetPaging,       // $C080
                               MemSetPaging,       // $C081
                               MemSetPaging,       // $C082
                               MemSetPaging,       // $C083
                               MemSetPaging,       // $C084
                               MemSetPaging,       // $C085
                               MemSetPaging,       // $C086
                               MemSetPaging,       // $C087
                               MemSetPaging,       // $C088
                               MemSetPaging,       // $C089
                               MemSetPaging,       // $C08A
                               MemSetPaging,       // $C08B
                               MemSetPaging,       // $C08C
                               MemSetPaging,       // $C08D
                               MemSetPaging,       // $C08E
                               MemSetPaging,       // $C08F
                               NullIo,             // $C090
                               NullIo,             // $C091
                               NullIo,             // $C092
                               NullIo,             // $C093
                               NullIo,             // $C094
                               NullIo,             // $C095
                               NullIo,             // $C096
                               NullIo,             // $C097
                               NullIo,             // $C098
                               NullIo,             // $C099
                               NullIo,             // $C09A
                               NullIo,             // $C09B
                               NullIo,             // $C09C
                               NullIo,             // $C09D
                               NullIo,             // $C09E
                               NullIo,             // $C09F
                               NullIo,             // $C0A0
                               CommDipSw,          // $C0A1
                               CommDipSw,          // $C0A2
                               NullIo,             // $C0A3
                               NullIo,             // $C0A4
                               NullIo,             // $C0A5
                               NullIo,             // $C0A6
                               NullIo,             // $C0A7
                               CommReceive,        // $C0A8
                               CommStatus,         // $C0A9
                               CommCommand,        // $C0AA
                               CommControl,        // $C0AB
                               NullIo,             // $C0AC
                               NullIo,             // $C0AD
                               NullIo,             // $C0AE
                               NullIo,             // $C0AF
                               NullIo,             // $C0B0
                               NullIo,             // $C0B1
                               NullIo,             // $C0B2
                               NullIo,             // $C0B3
                               NullIo,             // $C0B4
                               NullIo,             // $C0B5
                               NullIo,             // $C0B6
                               NullIo,             // $C0B7
                               NullIo,             // $C0B8
                               NullIo,             // $C0B9
                               NullIo,             // $C0BA
                               NullIo,             // $C0BB
                               NullIo,             // $C0BC
                               NullIo,             // $C0BD
                               NullIo,             // $C0BE
                               NullIo,             // $C0BF
                               NullIo,             // $C0C0
                               NullIo,             // $C0C1
                               NullIo,             // $C0C2
                               NullIo,             // $C0C3
                               NullIo,             // $C0C4
                               NullIo,             // $C0C5
                               NullIo,             // $C0C6
                               NullIo,             // $C0C7
                               NullIo,             // $C0C8
                               NullIo,             // $C0C9
                               NullIo,             // $C0CA
                               NullIo,             // $C0CB
                               NullIo,             // $C0CC
                               NullIo,             // $C0CD
                               NullIo,             // $C0CE
                               NullIo,             // $C0CF
                               NullIo,             // $C0D0
                               NullIo,             // $C0D1
                               NullIo,             // $C0D2
                               NullIo,             // $C0D3
                               NullIo,             // $C0D4
                               NullIo,             // $C0D5
                               NullIo,             // $C0D6
                               NullIo,             // $C0D7
                               NullIo,             // $C0D8
                               NullIo,             // $C0D9
                               NullIo,             // $C0DA
                               NullIo,             // $C0DB
                               NullIo,             // $C0DC
                               NullIo,             // $C0DD
                               NullIo,             // $C0DE
                               NullIo,             // $C0DF
                               DiskControlStepper, // $C0E0
                               DiskControlStepper, // $C0E1
                               DiskControlStepper, // $C0E2
                               DiskControlStepper, // $C0E3
                               DiskControlStepper, // $C0E4
                               DiskControlStepper, // $C0E5
                               DiskControlStepper, // $C0E6
                               DiskControlStepper, // $C0E7
                               DiskControlMotor,   // $C0E8
                               DiskControlMotor,   // $C0E9
                               DiskEnable,         // $C0EA
                               DiskEnable,         // $C0EB
                               DiskReadWrite,      // $C0EC
                               DiskSetLatchValue,  // $C0ED
                               DiskSetReadMode,    // $C0EE
                               DiskSetWriteMode,   // $C0EF
                               NullIo,             // $C0F0
                               NullIo,             // $C0F1
                               NullIo,             // $C0F2
                               NullIo,             // $C0F3
                               NullIo,             // $C0F4
                               NullIo,             // $C0F5
                               NullIo,             // $C0F6
                               NullIo,             // $C0F7
                               NullIo,             // $C0F8
                               NullIo,             // $C0F9
                               NullIo,             // $C0FA
                               NullIo,             // $C0FB
                               NullIo,             // $C0FC
                               NullIo,             // $C0FD
                               NullIo,             // $C0FE
                               NullIo  );          // $C0FF
      IoWrite           : Array[0..$FF] of IoFunction =
                            (  MemSetPaging,       // $C000
                               MemSetPaging,       // $C001
                               MemSetPaging,       // $C002
                               MemSetPaging,       // $C003
                               MemSetPaging,       // $C004
                               MemSetPaging,       // $C005
                               MemSetPaging,       // $C006
                               MemSetPaging,       // $C007
                               MemSetPaging,       // $C008
                               MemSetPaging,       // $C009
                               MemSetPaging,       // $C00A
                               MemSetPaging,       // $C00B
                               VideoSetMode,       // $C00C
                               VideoSetMode,       // $C00D
                               VideoSetMode,       // $C00E
                               VideoSetMode,       // $C00F
                               KeybReadFlag,       // $C010
                               KeybReadFlag,       // $C011
                               KeybReadFlag,       // $C012
                               KeybReadFlag,       // $C013
                               KeybReadFlag,       // $C014
                               KeybReadFlag,       // $C015
                               KeybReadFlag,       // $C016
                               KeybReadFlag,       // $C017
                               KeybReadFlag,       // $C018
                               KeybReadFlag,       // $C019
                               KeybReadFlag,       // $C01A
                               KeybReadFlag,       // $C01B
                               KeybReadFlag,       // $C01C
                               KeybReadFlag,       // $C01D
                               KeybReadFlag,       // $C01E
                               KeybReadFlag,       // $C01F
                               NullIo,             // $C020
                               NullIo,             // $C021
                               NullIo,             // $C022
                               NullIo,             // $C023
                               NullIo,             // $C024
                               NullIo,             // $C025
                               NullIo,             // $C026
                               NullIo,             // $C027
                               NullIo,             // $C028
                               NullIo,             // $C029
                               NullIo,             // $C02A
                               NullIo,             // $C02B
                               NullIo,             // $C02C
                               NullIo,             // $C02D
                               NullIo,             // $C02E
                               NullIo,             // $C02F
                               SpkrToggle,         // $C030
                               SpkrToggle,         // $C031
                               SpkrToggle,         // $C032
                               SpkrToggle,         // $C033
                               SpkrToggle,         // $C034
                               SpkrToggle,         // $C035
                               SpkrToggle,         // $C036
                               SpkrToggle,         // $C037
                               SpkrToggle,         // $C038
                               SpkrToggle,         // $C039
                               SpkrToggle,         // $C03A
                               SpkrToggle,         // $C03B
                               SpkrToggle,         // $C03C
                               SpkrToggle,         // $C03D
                               SpkrToggle,         // $C03E
                               SpkrToggle,         // $C03F
                               NullIo,             // $C040
                               NullIo,             // $C041
                               NullIo,             // $C042
                               NullIo,             // $C043
                               NullIo,             // $C044
                               NullIo,             // $C045
                               NullIo,             // $C046
                               NullIo,             // $C047
                               NullIo,             // $C048
                               NullIo,             // $C049
                               NullIo,             // $C04A
                               NullIo,             // $C04B
                               NullIo,             // $C04C
                               NullIo,             // $C04D
                               NullIo,             // $C04E
                               NullIo,             // $C04F
                               VideoSetMode,       // $C050
                               VideoSetMode,       // $C051
                               VideoSetMode,       // $C052
                               VideoSetMode,       // $C053
                               MemSetPaging,       // $C054
                               MemSetPaging,       // $C055
                               MemSetPaging,       // $C056
                               MemSetPaging,       // $C057
                               NullIo,             // $C058
                               NullIo,             // $C059
                               NullIo,             // $C05A
                               NullIo,             // $C05B
                               NullIo,             // $C05C
                               NullIo,             // $C05D
                               VideoSetMode,       // $C05E
                               VideoSetMode,       // $C05F
                               NullIo,             // $C060
                               NullIo,             // $C061
                               NullIo,             // $C062
                               NullIo,             // $C063
                               NullIo,             // $C064
                               NullIo,             // $C065
                               NullIo,             // $C066
                               NullIo,             // $C067
                               NullIo,             // $C068
                               NullIo,             // $C069
                               NullIo,             // $C06A
                               NullIo,             // $C06B
                               NullIo,             // $C06C
                               NullIo,             // $C06D
                               NullIo,             // $C06E
                               NullIo,             // $C06F
                               JoyResetPosition,   // $C070
//revised                      NullIo,             // $C071
                               MemSetPaging,       // $C071 - extended memory card set page
                               NullIo,             // $C072
//revise                       NullIo,             // $C073
                               MemSetPaging,       // $C073 - Ramworks III set page
                               NullIo,             // $C074
                               NullIo,             // $C075
                               NullIo,             // $C076
                               NullIo,             // $C077
                               NullIo,             // $C078
                               NullIo,             // $C079
                               NullIo,             // $C07A
                               NullIo,             // $C07B
                               NullIo,             // $C07C
                               NullIo,             // $C07D
                               NullIo,             // $C07E
                               NullIo,             // $C07F
                               MemSetPaging,       // $C080
                               MemSetPaging,       // $C081
                               MemSetPaging,       // $C082
                               MemSetPaging,       // $C083
                               MemSetPaging,       // $C084
                               MemSetPaging,       // $C085
                               MemSetPaging,       // $C086
                               MemSetPaging,       // $C087
                               MemSetPaging,       // $C088
                               MemSetPaging,       // $C089
                               MemSetPaging,       // $C08A
                               MemSetPaging,       // $C08B
                               MemSetPaging,       // $C08C
                               MemSetPaging,       // $C08D
                               MemSetPaging,       // $C08E
                               MemSetPaging,       // $C08F
                               NullIo,             // $C090
                               NullIo,             // $C091
                               NullIo,             // $C092
                               NullIo,             // $C093
                               NullIo,             // $C094
                               NullIo,             // $C095
                               NullIo,             // $C096
                               NullIo,             // $C097
                               NullIo,             // $C098
                               NullIo,             // $C099
                               NullIo,             // $C09A
                               NullIo,             // $C09B
                               NullIo,             // $C09C
                               NullIo,             // $C09D
                               NullIo,             // $C09E
                               NullIo,             // $C09F
                               NullIo,             // $C0A0
                               NullIo,             // $C0A1
                               NullIo,             // $C0A2
                               NullIo,             // $C0A3
                               NullIo,             // $C0A4
                               NullIo,             // $C0A5
                               NullIo,             // $C0A6
                               NullIo,             // $C0A7
                               CommTransmit,       // $C0A8
                               CommStatus,         // $C0A9
                               CommCommand,        // $C0AA
                               CommControl,        // $C0AB
                               NullIo,             // $C0AC
                               NullIo,             // $C0AD
                               NullIo,             // $C0AE
                               NullIo,             // $C0AF
                               NullIo,             // $C0B0
                               NullIo,             // $C0B1
                               NullIo,             // $C0B2
                               NullIo,             // $C0B3
                               NullIo,             // $C0B4
                               NullIo,             // $C0B5
                               NullIo,             // $C0B6
                               NullIo,             // $C0B7
                               NullIo,             // $C0B8
                               NullIo,             // $C0B9
                               NullIo,             // $C0BA
                               NullIo,             // $C0BB
                               NullIo,             // $C0BC
                               NullIo,             // $C0BD
                               NullIo,             // $C0BE
                               NullIo,             // $C0BF
                               NullIo,             // $C0C0
                               NullIo,             // $C0C1
                               NullIo,             // $C0C2
                               NullIo,             // $C0C3
                               NullIo,             // $C0C4
                               NullIo,             // $C0C5
                               NullIo,             // $C0C6
                               NullIo,             // $C0C7
                               NullIo,             // $C0C8
                               NullIo,             // $C0C9
                               NullIo,             // $C0CA
                               NullIo,             // $C0CB
                               NullIo,             // $C0CC
                               NullIo,             // $C0CD
                               NullIo,             // $C0CE
                               NullIo,             // $C0CF
                               NullIo,             // $C0D0
                               NullIo,             // $C0D1
                               NullIo,             // $C0D2
                               NullIo,             // $C0D3
                               NullIo,             // $C0D4
                               NullIo,             // $C0D5
                               NullIo,             // $C0D6
                               NullIo,             // $C0D7
                               NullIo,             // $C0D8
                               NullIo,             // $C0D9
                               NullIo,             // $C0DA
                               NullIo,             // $C0DB
                               NullIo,             // $C0DC
                               NullIo,             // $C0DD
                               NullIo,             // $C0DE
                               NullIo,             // $C0DF
                               DiskControlStepper, // $C0E0
                               DiskControlStepper, // $C0E1
                               DiskControlStepper, // $C0E2
                               DiskControlStepper, // $C0E3
                               DiskControlStepper, // $C0E4
                               DiskControlStepper, // $C0E5
                               DiskControlStepper, // $C0E6
                               DiskControlStepper, // $C0E7
                               DiskControlMotor,   // $C0E8
                               DiskControlMotor,   // $C0E9
                               DiskEnable,         // $C0EA
                               DiskEnable,         // $C0EB
                               DiskReadWrite,      // $C0EC
                               DiskSetLatchValue,  // $C0ED
                               DiskSetReadMode,    // $C0EE
                               DiskSetWriteMode,   // $C0EF
                               NullIo,             // $C0F0
                               NullIo,             // $C0F1
                               NullIo,             // $C0F2
                               NullIo,             // $C0F3
                               NullIo,             // $C0F4
                               NullIo,             // $C0F5
                               NullIo,             // $C0F6
                               NullIo,             // $C0F7
                               NullIo,             // $C0F8
                               NullIo,             // $C0F9
                               NullIo,             // $C0FA
                               NullIo,             // $C0FB
                               NullIo,             // $C0FC
                               NullIo,             // $C0FD
                               NullIo,             // $C0FE
                               NullIo  );          // $C0FF;
      Color             : Array[0..1]   of Array[0..Pred(COLORS)] of COLORREF =
                            (( $800000,$C0C0C0,$00FFFF,$808000,$000080,$800000,$00FFFF,$FFFFFF ),
                             ( $000000,$C0C0C0,$FFFFFF,$000000,$C0C0C0,$808080,$FFFFFF,$FFFFFF ));
      AddressMode       : Array[0..16]  of AddrRec =
                            (( Format : '';          Bytes : 1 ),             // (implied)
                             ( Format : '';          Bytes : 1 ),             // INVALID1
                             ( Format : '';          Bytes : 2 ),             // INVALID2
                             ( Format : '';          Bytes : 3 ),             // INVALID3
                             ( Format : '#$%.2X';    Bytes : 2 ),             // ADDR_IMM
                             ( Format : '%s';        Bytes : 3 ),             // ADDR_ABS
                             ( Format : '%s';        Bytes : 2 ),             // ADDR_ZPG
                             ( Format : '%s,X';      Bytes : 3 ),             // ADDR_ABSX
                             ( Format : '%s,Y';      Bytes : 3 ),             // ADDR_ABSY
                             ( Format : '%s,X';      Bytes : 2 ),             // ADDR_ZPGX
                             ( Format : '%s,Y';      Bytes : 2 ),             // ADDR_ZPGY
                             ( Format : '%s';        Bytes : 2 ),             // ADDR_REL
                             ( Format : '($%.2X,X)'; Bytes : 2 ),             // ADDR_INDX
                             ( Format : '($%.4X,X)'; Bytes : 3 ),             // ADDR_ABSIINDX
                             ( Format : '($%.2X),Y'; Bytes : 2 ),             // ADDR_INDY
                             ( Format : '($%.2X)';   Bytes : 2 ),             // ADDR_IZPG
                             ( Format : '($%.4X)';   Bytes : 3 ));
      Command           : Array[0..Pred(COMMANDS)] of CmdRec =
                            (( Name : 'BA';       Funct : CmdBreakpointAdd     ),
                             ( Name : 'BC';       Funct : CmdBreakpointClear   ),
                             ( Name : 'BD';       Funct : CmdBreakpointDisable ),
                             ( Name : 'BE';       Funct : CmdBreakpointEnable  ),
                             ( Name : 'BENCH';    Funct : CmdSetupBenchmark    ),
                             ( Name : 'BPM';      Funct : CmdBreakpointAdd     ),
                             ( Name : 'BW';       Funct : CmdBlackWhite        ),
                             ( Name : 'COLOR';    Funct : CmdColor             ),
                             ( Name : 'D';        Funct : CmdMemoryDump        ),
                             ( Name : 'EXTBENCH'; Funct : CmdExtBenchmark      ),
                             ( Name : 'GOTO';     Funct : CmdGo                ),
                             ( Name : 'I';        Funct : CmdInput             ),
                             ( Name : 'ICD';      Funct : CmdInternalCodeDump  ),
                             ( Name : 'IMD';      Funct : CmdInternalMemoryDump),
                             ( Name : 'INPUT';    Funct : CmdInput             ),
                             ( Name : 'KEY';      Funct : CmdFeedKey           ),
                             ( Name : 'MC';       Funct : Nil                  ), // CmdMemoryCompare
                             ( Name : 'MD';       Funct : CmdMemoryDump        ),
                             ( Name : 'MDB';      Funct : CmdMemoryDump        ),
                             ( Name : 'MDC';      Funct : CmdCodeDump          ),
                             ( Name : 'ME';       Funct : CmdMemoryEnter       ),
                             ( Name : 'MEB';      Funct : CmdMemoryEnter       ),
                             ( Name : 'MEMORY';   Funct : CmdMemoryDump        ),
                             ( Name : 'MF';       Funct : CmdMemoryFill        ),
                             ( Name : 'MONO';     Funct : CmdBlackWhite        ),
                             ( Name : 'MS';       Funct : Nil                  ), // CmdMemorySearch
                             ( Name : 'O';        Funct : CmdOutput            ),
                             ( Name : 'P';        Funct : Nil                  ), // CmdStep
                             ( Name : 'PROFILE';  Funct : CmdProfile           ),
                             ( Name : 'R';        Funct : CmdRegisterSet       ),
                             ( Name : 'RB';       Funct : CmdFlagSet           ),
                             ( Name : 'RC';       Funct : CmdFlagSet           ),
                             ( Name : 'RD';       Funct : CmdFlagSet           ),
                             ( Name : 'REGISTER'; Funct : CmdRegisterSet       ),
                             ( Name : 'RET';      Funct : Nil                  ), // CmdReturn
                             ( Name : 'RI';       Funct : CmdFlagSet           ),
                             ( Name : 'RN';       Funct : CmdFlagSet           ),
                             ( Name : 'RR';       Funct : CmdFlagSet           ),
                             ( Name : 'RTS';      Funct : Nil                  ), // CmdReturn
                             ( Name : 'RV';       Funct : CmdFlagSet           ),
                             ( Name : 'RZ';       Funct : CmdFlagSet           ),
                             ( Name : 'SB';       Funct : CmdFlagSet           ),
                             ( Name : 'SC';       Funct : CmdFlagSet           ),
                             ( Name : 'SD';       Funct : CmdFlagSet           ),
                             ( Name : 'SI';       Funct : CmdFlagSet           ),
                             ( Name : 'SN';       Funct : CmdFlagSet           ),
                             ( Name : 'SR';       Funct : CmdFlagSet           ),
                             ( Name : 'SV';       Funct : CmdFlagSet           ),
                             ( Name : 'SYM';      Funct : Nil                  ), // CmdSymbol
                             ( Name : 'SZ';       Funct : CmdFlagSet           ),
                             ( Name : 'T';        Funct : CmdTrace             ),
                             ( Name : 'TF';       Funct : CmdTraceFile         ),
                             ( Name : 'TL';       Funct : CmdTraceLine         ),
                             ( Name : 'TRACE';    Funct : CmdTrace             ),
                             ( Name : 'U';        Funct : CmdCodeDump          ),
                             ( Name : 'W';        Funct : CmdWatchAdd          ),
                             ( Name : 'W?';       Funct : CmdWatchAdd          ),
                             ( Name : 'WATCH';    Funct : CmdWatchAdd          ),
                             ( Name : 'WC';       Funct : CmdWatchClear        ),
                             ( Name : 'ZAP';      Funct : CmdZap               ),
                             ( Name : '\\';       Funct : CmdViewOutput        ));
      Instruction       : Array[0..255] of InstRec =
                            (( Mnemonic : 'BRK'; AddrMode : 0             ),  // 00h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_INDX     ),  // 01h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2      ),  // 02h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 03h
                             ( Mnemonic : 'TSB'; AddrMode : ADDR_ZPG      ),  // 04h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_ZPG      ),  // 05h
                             ( Mnemonic : 'ASL'; AddrMode : ADDR_ZPG      ),  // 06h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 07h
                             ( Mnemonic : 'PHP'; AddrMode : 0             ),  // 08h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_IMM      ),  // 09h
                             ( Mnemonic : 'ASL'; AddrMode : 0             ),  // 0Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 0Bh
                             ( Mnemonic : 'TSB'; AddrMode : ADDR_ABS      ),  // 0Ch
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_ABS      ),  // 0Dh
                             ( Mnemonic : 'ASL'; AddrMode : ADDR_ABS      ),  // 0Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 0Fh
                             ( Mnemonic : 'BPL'; AddrMode : ADDR_REL      ),  // 10h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_INDY     ),  // 11h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_IZPG     ),  // 12h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 13h
                             ( Mnemonic : 'TRB'; AddrMode : ADDR_ZPG      ),  // 14h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_ZPGX     ),  // 15h
                             ( Mnemonic : 'ASL'; AddrMode : ADDR_ZPGX     ),  // 16h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 17h
                             ( Mnemonic : 'CLC'; AddrMode : 0             ),  // 18h
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_ABSY     ),  // 19h
                             ( Mnemonic : 'INA'; AddrMode : 0             ),  // 1Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 1Bh
                             ( Mnemonic : 'TRB'; AddrMode : ADDR_ABS      ),  // 1Ch
                             ( Mnemonic : 'ORA'; AddrMode : ADDR_ABSX     ),  // 1Dh
                             ( Mnemonic : 'ASL'; AddrMode : ADDR_ABSX     ),  // 1Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 1Fh
                             ( Mnemonic : 'JSR'; AddrMode : ADDR_ABS      ),  // 20h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_INDX     ),  // 21h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2      ),  // 22h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 23h
                             ( Mnemonic : 'BIT'; AddrMode : ADDR_ZPG      ),  // 24h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_ZPG      ),  // 25h
                             ( Mnemonic : 'ROL'; AddrMode : ADDR_ZPG      ),  // 26h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 27h
                             ( Mnemonic : 'PLP'; AddrMode : 0             ),  // 28h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_IMM      ),  // 29h
                             ( Mnemonic : 'ROL'; AddrMode : 0             ),  // 2Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 2Bh
                             ( Mnemonic : 'BIT'; AddrMode : ADDR_ABS      ),  // 2Ch
                             ( Mnemonic : 'AND'; AddrMode : ADDR_ABS      ),  // 2Dh
                             ( Mnemonic : 'ROL'; AddrMode : ADDR_ABS      ),  // 2Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 2Fh
                             ( Mnemonic : 'BMI'; AddrMode : ADDR_REL      ),  // 30h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_INDY     ),  // 31h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_IZPG     ),  // 32h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1      ),  // 33h
                             ( Mnemonic : 'BIT'; AddrMode : ADDR_ZPGX     ),  // 34h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_ZPGX     ),  // 35h
                             ( Mnemonic : 'ROL'; AddrMode : ADDR_ZPGX),      // 36h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 37h
                             ( Mnemonic : 'SEC'; AddrMode : 0),              // 38h
                             ( Mnemonic : 'AND'; AddrMode : ADDR_ABSY),      // 39h
                             ( Mnemonic : 'DEA'; AddrMode : 0),              // 3Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 3Bh
                             ( Mnemonic : 'BIT'; AddrMode : ADDR_ABSX),      // 3Ch
                             ( Mnemonic : 'AND'; AddrMode : ADDR_ABSX),      // 3Dh
                             ( Mnemonic : 'ROL'; AddrMode : ADDR_ABSX),      // 3Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 3Fh
                             ( Mnemonic : 'RTI'; AddrMode : 0),              // 40h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_INDX),      // 41h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // 42h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 43h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // 44h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_ZPG),       // 45h
                             ( Mnemonic : 'LSR'; AddrMode : ADDR_ZPG),       // 46h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 47h
                             ( Mnemonic : 'PHA'; AddrMode : 0),              // 48h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_IMM),       // 49h
                             ( Mnemonic : 'LSR'; AddrMode : 0),              // 4Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 4Bh
                             ( Mnemonic : 'JMP'; AddrMode : ADDR_ABS),       // 4Ch
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_ABS),       // 4Dh
                             ( Mnemonic : 'LSR'; AddrMode : ADDR_ABS),       // 4Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 4Fh
                             ( Mnemonic : 'BVC'; AddrMode : ADDR_REL),       // 50h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_INDY),      // 51h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_IZPG),      // 52h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 53h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // 54h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_ZPGX),      // 55h
                             ( Mnemonic : 'LSR'; AddrMode : ADDR_ZPGX),      // 56h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 57h
                             ( Mnemonic : 'CLI'; AddrMode : 0),              // 58h
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_ABSY),      // 59h
                             ( Mnemonic : 'PHY'; AddrMode : 0),              // 5Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 5Bh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID3),       // 5Ch
                             ( Mnemonic : 'EOR'; AddrMode : ADDR_ABSX),      // 5Dh
                             ( Mnemonic : 'LSR'; AddrMode : ADDR_ABSX),      // 5Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 5Fh
                             ( Mnemonic : 'RTS'; AddrMode : 0),              // 60h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_INDX),      // 61h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // 62h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 63h
                             ( Mnemonic : 'STZ'; AddrMode : ADDR_ZPG),       // 64h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_ZPG),       // 65h
                             ( Mnemonic : 'ROR'; AddrMode : ADDR_ZPG),       // 66h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 67h
                             ( Mnemonic : 'PLA'; AddrMode : 0),              // 68h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_IMM),       // 69h
                             ( Mnemonic : 'ROR'; AddrMode : 0),              // 6Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 6Bh
                             ( Mnemonic : 'JMP'; AddrMode : ADDR_IABS),      // 6Ch
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_ABS),       // 6Dh
                             ( Mnemonic : 'ROR'; AddrMode : ADDR_ABS),       // 6Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 6Fh
                             ( Mnemonic : 'BVS'; AddrMode : ADDR_REL),       // 70h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_INDY),      // 71h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_IZPG),      // 72h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 73h
                             ( Mnemonic : 'STZ'; AddrMode : ADDR_ZPGX),      // 74h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_ZPGX),      // 75h
                             ( Mnemonic : 'ROR'; AddrMode : ADDR_ZPGX),      // 76h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 77h
                             ( Mnemonic : 'SEI'; AddrMode : 0),              // 78h
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_ABSY),      // 79h
                             ( Mnemonic : 'PLY'; AddrMode : 0),              // 7Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 7Bh
                             ( Mnemonic : 'JMP'; AddrMode : ADDR_ABSIINDX ), // 7Ch
                             ( Mnemonic : 'ADC'; AddrMode : ADDR_ABSX),      // 7Dh
                             ( Mnemonic : 'ROR'; AddrMode : ADDR_ABSX),      // 7Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 7Fh
                             ( Mnemonic : 'BRA'; AddrMode : ADDR_REL),       // 80h
                             ( Mnemonic : 'STA'; AddrMode : ADDR_INDX),      // 81h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // 82h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 83h
                             ( Mnemonic : 'STY'; AddrMode : ADDR_ZPG),       // 84h
                             ( Mnemonic : 'STA'; AddrMode : ADDR_ZPG),       // 85h
                             ( Mnemonic : 'STX'; AddrMode : ADDR_ZPG),       // 86h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 87h
                             ( Mnemonic : 'DEY'; AddrMode : 0),              // 88h
                             ( Mnemonic : 'BIT'; AddrMode : ADDR_IMM),       // 89h
                             ( Mnemonic : 'TXA'; AddrMode : 0),              // 8Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 8Bh
                             ( Mnemonic : 'STY'; AddrMode : ADDR_ABS),       // 8Ch
                             ( Mnemonic : 'STA'; AddrMode : ADDR_ABS),       // 8Dh
                             ( Mnemonic : 'STX'; AddrMode : ADDR_ABS),       // 8Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 8Fh
                             ( Mnemonic : 'BCC'; AddrMode : ADDR_REL),       // 90h
                             ( Mnemonic : 'STA'; AddrMode : ADDR_INDY),      // 91h
                             ( Mnemonic : 'STA'; AddrMode : ADDR_IZPG),      // 92h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 93h
                             ( Mnemonic : 'STY'; AddrMode : ADDR_ZPGX),      // 94h
                             ( Mnemonic : 'STA'; AddrMode : ADDR_ZPGX),      // 95h
                             ( Mnemonic : 'STX'; AddrMode : ADDR_ZPGY),      // 96h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 97h
                             ( Mnemonic : 'TYA'; AddrMode : 0),              // 98h
                             ( Mnemonic : 'STA'; AddrMode : ADDR_ABSY),      // 99h
                             ( Mnemonic : 'TXS'; AddrMode : 0),              // 9Ah
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 9Bh
                             ( Mnemonic : 'STZ'; AddrMode : ADDR_ABS),       // 9Ch
                             ( Mnemonic : 'STA'; AddrMode : ADDR_ABSX),      // 9Dh
                             ( Mnemonic : 'STZ'; AddrMode : ADDR_ABSX),      // 9Eh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // 9Fh
                             ( Mnemonic : 'LDY'; AddrMode : ADDR_IMM),       // A0h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_INDX),      // A1h
                             ( Mnemonic : 'LDX'; AddrMode : ADDR_IMM),       // A2h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // A3h
                             ( Mnemonic : 'LDY'; AddrMode : ADDR_ZPG),       // A4h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_ZPG),       // A5h
                             ( Mnemonic : 'LDX'; AddrMode : ADDR_ZPG),       // A6h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // A7h
                             ( Mnemonic : 'TAY'; AddrMode : 0),              // A8h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_IMM),       // A9h
                             ( Mnemonic : 'TAX'; AddrMode : 0),              // AAh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // ABh
                             ( Mnemonic : 'LDY'; AddrMode : ADDR_ABS),       // ACh
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_ABS),       // ADh
                             ( Mnemonic : 'LDX'; AddrMode : ADDR_ABS),       // AEh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // AFh
                             ( Mnemonic : 'BCS'; AddrMode : ADDR_REL),       // B0h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_INDY),      // B1h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_IZPG),      // B2h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // B3h
                             ( Mnemonic : 'LDY'; AddrMode : ADDR_ZPGX),      // B4h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_ZPGX),      // B5h
                             ( Mnemonic : 'LDX'; AddrMode : ADDR_ZPGY),      // B6h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // B7h
                             ( Mnemonic : 'CLV'; AddrMode : 0),              // B8h
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_ABSY),      // B9h
                             ( Mnemonic : 'TSX'; AddrMode : 0),              // BAh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // BBh
                             ( Mnemonic : 'LDY'; AddrMode : ADDR_ABSX),      // BCh
                             ( Mnemonic : 'LDA'; AddrMode : ADDR_ABSX),      // BDh
                             ( Mnemonic : 'LDX'; AddrMode : ADDR_ABSY),      // BEh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // BFh
                             ( Mnemonic : 'CPY'; AddrMode : ADDR_IMM),       // C0h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_INDX),      // C1h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // C2h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // C3h
                             ( Mnemonic : 'CPY'; AddrMode : ADDR_ZPG),       // C4h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_ZPG),       // C5h
                             ( Mnemonic : 'DEC'; AddrMode : ADDR_ZPG),       // C6h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // C7h
                             ( Mnemonic : 'INY'; AddrMode : 0),              // C8h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_IMM),       // C9h
                             ( Mnemonic : 'DEX'; AddrMode : 0),              // CAh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // CBh
                             ( Mnemonic : 'CPY'; AddrMode : ADDR_ABS),       // CCh
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_ABS),       // CDh
                             ( Mnemonic : 'DEC'; AddrMode : ADDR_ABS),       // CEh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // CFh
                             ( Mnemonic : 'BNE'; AddrMode : ADDR_REL),       // D0h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_INDY),      // D1h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_IZPG),      // D2h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // D3h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // D4h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_ZPGX),      // D5h
                             ( Mnemonic : 'DEC'; AddrMode : ADDR_ZPGX),      // D6h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // D7h
                             ( Mnemonic : 'CLD'; AddrMode : 0),              // D8h
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_ABSY),      // D9h
                             ( Mnemonic : 'PHX'; AddrMode : 0),              // DAh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // DBh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID3),       // DCh
                             ( Mnemonic : 'CMP'; AddrMode : ADDR_ABSX),      // DDh
                             ( Mnemonic : 'DEC'; AddrMode : ADDR_ABSX),      // DEh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // DFh
                             ( Mnemonic : 'CPX'; AddrMode : ADDR_IMM),       // E0h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_INDX),      // E1h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // E2h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // E3h
                             ( Mnemonic : 'CPX'; AddrMode : ADDR_ZPG),       // E4h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_ZPG),       // E5h
                             ( Mnemonic : 'INC'; AddrMode : ADDR_ZPG),       // E6h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // E7h
                             ( Mnemonic : 'INX'; AddrMode : 0),              // E8h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_IMM),       // E9h
                             ( Mnemonic : 'NOP'; AddrMode : 0),              // EAh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // EBh
                             ( Mnemonic : 'CPX'; AddrMode : ADDR_ABS),       // ECh
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_ABS),       // EDh
                             ( Mnemonic : 'INC'; AddrMode : ADDR_ABS),       // EEh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // EFh
                             ( Mnemonic : 'BEQ'; AddrMode : ADDR_REL),       // F0h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_INDY),      // F1h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_IZPG),      // F2h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // F3h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID2),       // F4h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_ZPGX),      // F5h
                             ( Mnemonic : 'INC'; AddrMode : ADDR_ZPGX),      // F6h
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // F7h
                             ( Mnemonic : 'SED'; AddrMode : 0),              // F8h
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_ABSY),      // F9h
                             ( Mnemonic : 'PLX'; AddrMode : 0),              // FAh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1),       // FBh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID3),       // FCh
                             ( Mnemonic : 'SBC'; AddrMode : ADDR_ABSX),      // FDh
                             ( Mnemonic : 'INC'; AddrMode : ADDR_ABSX),      // FEh
                             ( Mnemonic : 'NOP'; AddrMode : INVALID1));      // FFh

Function SW_80STORE : Cardinal;
Begin
  Result := MemMode AND MF_80STORE
End;

Function SW_ALTZP : Cardinal;
Begin
  Result := MemMode AND MF_ALTZP
End;

Function SW_AUXREAD : Cardinal;
Begin
  Result := MemMode AND MF_AUXREAD
End;

Function SW_AUXWRITE : Cardinal;
Begin
  Result := MemMode AND MF_AUXWRITE
End;

Function SW_BANK2 : Cardinal;
Begin
  Result := MemMode AND MF_BANK2
End;

Function SW_HIGHRAM : Cardinal;
Begin
  Result := MemMode AND MF_HIGHRAM
End;

Function mSW_HIRES : Cardinal;
Begin
  Result := MemMode AND MF_HIRES
End;

Function mSW_PAGE2 : Cardinal;
Begin
  Result := MemMode AND MF_PAGE2
End;

Function SW_SLOTC3ROM : Cardinal;
Begin
  Result := MemMode AND MF_SLOTC3ROM
End;

Function SW_SLOTCXROM : Cardinal;
Begin
  Result := MemMode AND MF_SLOTCXROM
End;

Function SW_WRITERAM : Cardinal;
Begin
  Result := MemMode AND MF_WRITERAM
End;

Function SW_80COL : Cardinal;
Begin
  Result := VidMode AND VF_80COL
End;

Function SW_DHIRES : Cardinal;
Begin
  Result := VidMode AND VF_DHIRES
End;

Function SW_HIRES : Cardinal;
Begin
  Result := VidMode AND VF_HIRES
End;

Function SW_MASK2 : Cardinal;
Begin
  Result := VidMode AND VF_MASK2
End;

Function SW_MIXED : Cardinal;
Begin
  Result := VidMode AND VF_MIXED
End;

Function SW_PAGE2 : Cardinal;
Begin
  Result := Vidmode AND VF_PAGE2
End;

Function SW_TEXT : Cardinal;
Begin
  Result := VidMode AND VF_TEXT
End;

{$R APPLEWIN.RES}
{$I AW_COMM.PAS }
{$I AW_CPU.PAS  }
{$I AW_DEBUG    }
{$I AW_DISK.PAS }
{$I AW_JOY.PAS  }
{$I AW_FRAME.PAS}
{$I AW_IMAGE.PAS}
{$I AW_KEYB.PAS }
{$I AW_MEM.PAS  }
{$I AW_REG.PAS  }
{$I AW_SPKR.PAS }
{$I AW_VIDEO.PAS}

Procedure GetProgramDirectory;
Var Loop : Integer;
Begin
  GetModuleFileName(0,ProgDir,MAX_PATH);
  ProgDir[Pred(MAX_PATH)] := #0;
  Loop := StrLen(ProgDir);
  While Ok(Loop) do Begin
    Dec(Loop);
    If (ProgDir[Loop] = '\') or (ProgDir[Loop] = ':') then Begin
      ProgDir[Succ(Loop)] := #0;
      Break
    End
  End
End;

Procedure LoadConfiguration;

  Procedure Load( a : LPTSTR; b : Pointer );
  Begin
    RegLoadValue('Configuration',a,true,b)
  End;

Begin
  LOAD('Computer Emulation',LPDWORD(@Apple2e));
  LOAD('Joystick Emulation'  ,@JoyType);
  LOAD('Sound Emulation'     ,@SoundType);
  LOAD('Serial Port'         ,@SerialPort);
  LOAD('Emulation Speed'     ,@Speed);
  LOAD('Enhance Disk Speed'  ,LPDWORD(@EnhanceDisk));
  LOAD('Video Emulation'     ,@VideoType);
  LOAD('Monochrome Color'    ,@_Monochrome);
  LOAD('Horizontal Scanlines',LPDWORD(@H_Scanlines))
End;

Function LoadCalibrationData : Bool;
Var Version     : Array[0..19] of Char;
    RunningOnOS : DWord;
Begin
  Version := '';
  RunningOnOS := 0;
 If not RegLoadString('','CurrentVersion',false,@Version,20) then Begin
    Result := false;
    Exit
  End;
  If not RegLoadValue('','RunningOnOS',false,@RunningOnOS) then Begin
    Result := false;
    Exit
  End;
  If Ok(StrComp(Version,VERSIONSTRING)) then Begin
    Result := false;
    Exit
  End;
  If RunningOnOS <> GetVersion() then Begin
    Result := false;
    Exit
  End;
  If not RegLoadValue('Calibration','Clock Granularity',false,@ClockGran) then Begin
    Result := false;
    Exit
  End;
  If not RegLoadValue('Calibration','Cycle Granularity',false,@CycleGran) then Begin
    Result := false;
    Exit
  End;
  If not RegLoadValue('Calibration','Precision Timing',false,@FineGrainDelay) then Begin
    Result := false;
    Exit
  End;
  DWORD(Result) := Abs(Ord(Ok(ClockGran) and Ok(CycleGran) and Ok(FineGrainDelay)))
End;

Procedure SaveCalibrationData;
Begin
  RegSaveString('','CurrentVersion',false,VERSIONSTRING);
  RegSaveString('','CurrentVersion',BOOL(DWORD(1)),VERSIONSTRING);
  RegSaveValue ('','RunningOnOS'   ,false,GetVersion());
  RegSaveValue ('','RunningOnOS'   ,BOOL(DWORD(1)),GetVersion());
  RegSaveValue ('Calibration','Clock Granularity',false,ClockGran);
  RegSaveValue ('Calibration','Cycle Granularity',false,CycleGran);
  RegSaveValue ('Calibration','Precision Timing' ,false,FineGrainDelay)
End;

Procedure RegisterExtensions;
Var Command : Array[0..Pred(MAX_PATH)] of Char;
    Icon    : Array[0..Pred(MAX_PATH)] of Char;
Begin
  GetModuleFileName(0,Command,MAX_PATH);
  Command[Pred(MAX_PATH)] := #0;
  sPrintF(Icon,'%s,1',Command);
  StrCat(Command,' %1');
  RegSetValue(HKEY_CLASSES_ROOT,'.bin',                                    REG_SZ,'DiskImage', 10);
  RegSetValue(HKEY_CLASSES_ROOT,'.do' ,                                    REG_SZ,'DiskImage', 10);
  RegSetValue(HKEY_CLASSES_ROOT,'.dsk',                                    REG_SZ,'DiskImage', 10);
  RegSetValue(HKEY_CLASSES_ROOT,'.nib',                                    REG_SZ,'DiskImage', 10);
  RegSetValue(HKEY_CLASSES_ROOT,'.po' ,                                    REG_SZ,'DiskImage', 10);
  RegSetValue(HKEY_CLASSES_ROOT,'DiskImage',                               REG_SZ,'Disk Image',21);
  RegSetValue(HKEY_CLASSES_ROOT,'DiskImage\DefaultIcon',                   REG_SZ,Icon,   Succ(StrLen(Icon)));
  RegSetValue(HKEY_CLASSES_ROOT,'DiskImage\shell\open\command',            REG_SZ,Command,Succ(StrLen(Command)));
  RegSetValue(HKEY_CLASSES_ROOT,'DiskImage\shell\open\ddeexec',            REG_SZ,'%1',          3);
  RegSetValue(HKEY_CLASSES_ROOT,'DiskImage\shell\open\ddeexec\application',REG_SZ,'applewin',    9);
  RegSetValue(HKEY_CLASSES_ROOT,'DiskImage\shell\open\ddeexec\topic',      REG_SZ,'system',      7)
End;

Procedure DetermineClockGranularity;
Var OldTicks : DWord;
    NewTicks : DWord;
    Loop     : Integer;
Begin
  ClockGran := 50;
  OldTicks  := GetTickCount();
  Loop      := 40;
  While Ok(Loop) and (ClockGran >= 20) do Begin
    Dec(Loop);
    Repeat
      NewTicks := GetTickCount()
    Until not (OldTicks >= NewTicks);
    If NewTicks - OldTicks >= 10 then ClockGran := MIN(ClockGran,NewTicks - OldTicks);
    OldTicks := NewTicks
  End;
  CycleGran := ClockGran * 1000
End;

Function DlgProc (Window : HWnd;Msg : UINT;wParam : WPARAM;lParam : LPARAM) : lResult; StdCall;
Var Rect : tRect;
    Size : tSize;
Begin
  If Msg = WM_CREATE then Begin
    GetWindowRect(Window,Rect);
    Size.cx     := Rect.Right - Rect.Left;
    Size.cy     := Rect.Bottom - Rect.Top;
    Rect.Left   := (GetSystemMetrics(SM_CXSCREEN) - Size.cx) Shr 1;
    Rect.Top    := (GetSystemMetrics(SM_CYSCREEN) - Size.cy) Shr 1;
    Rect.Right  := Rect.Left + Size.cx;
    Rect.Bottom := Rect.Top  + Size.cy;
    MoveWindow(Window,Rect.Left,Rect.Top,Rect.Right - Rect.Left,Rect.Bottom - Rect.Top,false);
    ShowWindow(Window,SW_SHOW)
  End;
  Result := DefWindowProc(Window,Msg,wParam,lParam)
End;

Procedure CheckFastPaging;
Begin
  If (Pages >= 10) and Ok(CpuSupportsFastPaging()) then Begin
    LastFastPaging := CumulativeCycles;
    If CpuEmType = CPU_COMPILING then Begin
      LastTrimImages := CumulativeCycles;
      MemSetFastPaging(BOOL(DWORD(1)))
    End
  End
End;

Procedure ContinueExecution;
Var SkippedFineGrain : Bool;
    RanFineGrain     : Bool;
    DiskSpinning     : Bool;
    ScreenUpdated    : Bool;
    SystemIdle       : Bool;
    CurrTime         : DWord;
    CyclesNeeded     : DWord;
    CyclesToRun      : DWord;
    Delta            : DWord;
    ExecutedCycles   : DWord;
    StartCycles      : DWord;
    Loop             : Integer;
    Loop2            : Integer;
    tmpVal           : DWord;
Begin
  // RUN THE CPU, DISK, AND JOYSTICK TIMERS FOR ONE CLOCK TICK'S
  // WORTH OF CYCLES
  SkippedFineGrain := false;
  RanFineGrain     := false;
  Loop := 1 + Abs(Ord(CycleGran >= 20000));
  CyclesToRun := CycleGran Shr DWord(Abs(Ord(CycleGran >= 20000)));
  While Ok(Loop) do Begin
    Dec(Loop);
    CycleNum := 0;
    If (CumulativeCycles - NeedsPrecision > 1500000) and not FineGrainTiming then Begin
      Repeat
        ExecutedCycles := CpuExecute(2000);
        Inc(CycleNum,ExecutedCycles);
        CheckFastPaging();
        DiskUpdatePosition(ExecutedCycles);
        JoyUpdatePosition(ExecutedCycles);
        VideoUpdateVbl(ExecutedCycles,BOOL(DWORD(Abs(Ord(CyclesToRun - CycleNum <= 2000)))))
      Until not (CycleNum < CyclesToRun)
    End Else Begin
      CyclesNeeded := 0;
      Repeat
        StartCycles := CycleNum;
        If SpkrNeedsAccurateCycleCount() then Begin
          Loop2 := 3;
          While Ok(Loop2) do Begin
            Dec(Loop2);
            Inc(CyclesNeeded,33);
            If CycleNum < CyclesNeeded then Inc(CycleNum,CpuExecute(CyclesNeeded - CycleNum))
          End
        End Else Begin
          Inc(CyclesNeeded,100);
          If (CycleNum < CyclesNeeded) then Inc(CycleNum,CpuExecute(CyclesNeeded - CycleNum))
        End;
        CheckFastPaging();
        DiskUpdatePosition(CycleNum - StartCycles);
        JoyUpdatePosition(CycleNum - StartCycles);
        VideoUpdateVbl(CycleNum - StartCycles,Bool(DWORD(Abs(Ord(CyclesToRun - CyclesNeeded < 1000)))));
        If FineGrainTiming and FineGrainLast then If not Calibrating and (SpkrCyclesSinceSound() > 50000) then Begin
           DWORD(SkippedFineGrain) := 1
        End Else Begin
          DWORD(RanFineGrain) := 1;
          Loop := FineGrainDelay;
          While Ok(Loop) do Begin
            Dec(Loop);
            Dummy := Dummy * Dummy
          End
        End
      Until not (CyclesNeeded < CyclesToRun)
    End;
    Inc(CumulativeCycles,CycleNum);
    SpkrUpdate(CycleNum);
    CommUpdate(CycleNum)
  End;
  Inc(EmulMSec,ClockGran);
  If CpuEmType = CPU_FASTPAGING then If not Ok(Pages) and (CumulativeCycles - LastFastPaging > 500000) then Begin
    MemSetFastPaging(false)
  End Else If CumulativeCycles - LastTrimImages > 500000 then Begin
    MemTrimImages();
    LastTrimImages := CumulativeCycles
  End;
  Pages := 0;
  // DETERMINE WHETHER THE SCREEN WAS UPDATED, THE DISK WAS SPINNING,
  // OR THE KEYBOARD I/O PORTS WERE BEING EXCESSIVELY QUERIED THIS
  // CLOCKTICK
  VideoCheckPage(false);
  DiskSpinning  := DiskIsSpinning();
  ScreenUpdated := VideoHasRefreshed();
  DWORD(SystemIdle) := Abs(Ord((KeybGetNumQueries() > ClockGran Shl 2) and not Calibrating and not RanFineGrain));
  DWORD(Fullspeed)  := Abs(Ord(((Speed = SPEED_MAX) or (GetKeyState(VK_SCROLL) < 0)) and not Calibrating));
  If ScreenUpdated then DWORD(PageFlipping) := 3;
  // IF A TWENTIETH OF A SECOND HAS ELAPSED AND THE SCREEN HAS NOT BEEN
  // UPDATED BUT IT APPEARS TO NEED UPDATING, THEN REFRESH IT
  // also refresh the screen if it's flash time
  CurrTime := GetTickCount();
  If CurrTime - LastFlashTime >= 250 then Begin
    Flash := not Flash;
    LastFlashTime := CurrTime;
  End;
  If Mode <> MODE_LOGO then Begin
    If Flash = FlashLast then Begin
      AnyUpdates := AnyUpdates OR ScreenUpdated;
      If (CumulativeCycles - LastCycles) >= 50000 then Begin
        LastCycles := CumulativeCycles;
        If not Ok(AnyUpdates) and not LastUpdates[0] and not LastUpdates[1] and Ok(VideoApparentlyDirty() or (Flash <> FlashLast)) then Begin
          VideoCheckPage(true);
          CurrTime := GetTickCount();
          If Ok(GraphicsMode) or not Ok(SystemIdle) then tmpVal := 100 Else tmpVal := 25;
          If not Ok(Fullspeed) or (CurrTime - LastTime >= tmpVal) then Begin
            VideoRefreshScreen();
            LastTime  := CurrTime;
            FlashLast := Flash
          End;
          DWORD(ScreenUpdated) := 1
        End;
        LastUpdates[1] := LastUpdates[0];
        LastUpdates[0] := AnyUpdates;
        AnyUpdates     := false;
        If Ok(PageFlipping) then Dec(PageFlipping)
      End
    End Else Begin
      VideoRefreshScreen();
      LastTime  := CurrTime;
      FlashLast := Flash
    End
  End;
  // IF WE ARE CURRENTLY CALIBRATING THE SYSTEM THEN ADJUST FINE
  // GRAIN TIMING
  If Ok(Calibrating) then Begin
    If CumulativeCycles - LastCycles >= 100000 then Begin
      LastCycles := CumulativeCycles;
      If FineGrainTiming and FineGrainLast then Begin
        If Abs(Ord(NormalDelays)) + LastNormalDelays <= Abs(Ord(ClockGran <= 25)) then Begin
          If DWORD(Calibrating) < 3 then Begin
            Inc(Calibrating);
            FineGrainDelay := LastDelay;
            DWORD(NormalDelays)   := 1;
            DWORD(ResetTiming)    := 1
          End Else Calibrating := false
        End Else Begin
          LastDelay := FineGrainDelay;
          Case DWORD(Calibrating) of
            1 : Inc(FineGrainDelay,100);
            2 : Inc(FineGrainDelay,10);
            3 : Inc(FineGrainDelay)
          End
        End
      End;
      LastNormalDelays := Abs(Ord(NormalDelays));
      NormalDelays     := false
    End
  End;
  // IF WE ARE NOT CALIBRATING THE SYSTEM, TURN FINE GRAIN TIMING
  // ON OR OFF BASED ON WHETHER THE DISK IS SPINNING, THE SCREEN IS
  // BEING UPDATED, OR THE SYSTEM IS IDLE
  FineGrainLast   := FineGrainTiming;
  FineGrainTiming := Calibrating or (not SystemIdle and not DiskSpinning and not Fullspeed and not PageFlipping and not ScreenUpdated
                                     and SpkrNeedsFineGrainTiming() and not VideoApparentlyDirty());
  // COMPARE THE EMULATOR'S CLOCK TO THE REAL TIME CLOCK
  CurrTime     := GetTickCount();
  If not Fullspeed and (not EnhanceDisk or not DiskSpinning) and not ResetTiming then Begin
    If (Speed = SPEED_NORMAL) or Ok(Calibrating) then Begin
      Inc(MilliSeconds,ClockGran)
    End Else Begin
      Delta := Trunc((ClockGran * 2000.0) / Power(2.0,Speed / 10.0));
      Inc(MilliSeconds,(Delta Div 1000));
      Inc(MicroSeconds,(Delta Mod 1000));
      If MicroSeconds >= 1000 then Begin
        Dec(MicroSeconds,1000);
        Inc(MilliSeconds)
      End
    End;
    // DETERMINE WHETHER WE ARE AHEAD OF OR BEHIND REAL TIME
    If CurrTime > MilliSeconds + 1000 then Begin
      Behind       := false;
      MilliSeconds := CurrTime
    End Else If (CurrTime >= MilliSeconds + 100) and not Ok(Calibrating) then Begin
      DWORD(Behind) := 1
    End Else If MilliSeconds > CurrTime then Begin
      Inc(Ahead,MilliSeconds - CurrTime);
      If CurrTime - LastReset > 500 then Begin
        If Ahead >= 200 then Behind := false;
        Ahead     := 0;
        LastReset := CurrTime
      End
    End;
    // IF WE ARE AHEAD OF REAL TIME, WAIT FOR REAL TIME TO CATCH UP
    If (MilliSeconds - CurrTime > 0) and (MilliSeconds - CurrTime < 200) then Begin
      Inc(NormalDelays);
      If (SkippedFineGrain or not FineGrainTiming) and not Behind then Sleep(1);
      Repeat
        If SystemIdle and not Behind then Sleep(1);
        CurrTime := GetTickCount()
      Until not ((MilliSeconds - CurrTime > 0) and (MilliSeconds - CurrTime < 200))
    End Else If CurrTime - MilliSeconds > 250 then Inc(MilliSeconds,100)
  End Else Begin
    Behind       := Fullspeed;
    MilliSeconds := CurrTime;
    ResetTiming  := false
  End
End;

Procedure PerformCalibration;
Var WndClass  : tWndClass;
    DlgWindow : hWnd;
    Msg       : tMsg;
Begin
  // REGISTER THE WINDOW CLASS OF THE CALIBRATION DIALOG BOX
  FillChar(WndClass,SizeOf(tWndClass),#0);
  WndClass.lpfnWndProc   := @DlgProc;
  WndClass.cbWndExtra    := DLGWINDOWEXTRA;
  WndClass.hInstance     := Instance;
  WndClass.hIcon         := LoadIcon(Instance,'APPLEWIN_ICON');
  WndClass.hCursor       := LoadCursor(0,IDC_WAIT);
  WndClass.hbrBackground := CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
  WndClass.lpszClassName := 'APPLE2CALIBRATION';
  RegisterClass(WndClass);
  // CREATE THE CALIBRATION DIALOG BOX
  DlgWindow := CreateDialog(Instance,'CALIBRATION_DIALOG',hWND(0),NiL);
  // PROCESS MESSAGES UNTIL THE DIALOG BOX IS FULLY DRAWN
  While PeekMessage(Msg,0,0,0,PM_REMOVE) do Begin
    TranslateMessage(Msg);
    DispatchMessage(Msg)
  End;
  // WAIT ONE SECOND FOR DISK ACTIVITY TO STOP
  Sleep(1000);
  // SET UP MEMORY FOR THE CALIBRATION
  FillMemory(Mem,$102,$3E);
  LPBYTE(DWord(Mem) + $102)^ := $4C;
  LPBYTE(DWord(Mem) + $103)^ := $00;
  LPBYTE(DWord(Mem) + $104)^ := $00;
  Regs.PC := 0;
  // PERFORM THE CALIBRATION
  DWORD(Calibrating)    := 1;
  FineGrainDelay := 1;
  While Ok(Calibrating) do ContinueExecution();
  // CLOSE THE DIALOG BOX
  PostMessage(DlgWindow,WM_CLOSE,0,0)
End;

Procedure EnterMessageLoop;
Var Msg : tMsg;
Begin
  While GetMessage(Msg,0,0,0) do Begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
    While (Mode = MODE_RUNNING) or (Mode = MODE_STEPPING) or Calibrating do Begin
      If PeekMessage(Msg,0,0,0,PM_REMOVE) then Begin
        If Msg.Message = WM_QUIT then Exit;
        TranslateMessage(Msg);
        DispatchMessage(Msg)
      End Else If Mode = MODE_STEPPING then Begin
        DebugContinueStepping();
      End Else Begin
         ContinueExecution();
         If Fullspeed then ContinueExecution()
      End
    End
  End;
  While PeekMessage(Msg,0,0,0,PM_REMOVE) do
End;

Function WinMain : Integer;
Begin
  // DO ONE-TIME INITIALIZATION
  Instance := hInstance;
  GdiSetBatchLimit(512);
  GetProgramDirectory();
  RegisterExtensions();
  FrameRegisterClass();
  ImageInitialize();
  DiskInitialize();
  ColorInitialize;
  Repeat
    // DO INITIALIZATION THAT MUST BE REPEATED FOR A RESTART
    Restart := false;
    Mode    := MODE_LOGO;
    LoadConfiguration();
    DebugInitialize();
    JoyInitialize();
    MemInitialize();
    VideoInitialize();
    If not LoadCalibrationData() then Begin
      DetermineClockGranularity();
      PerformCalibration();
      SaveCalibrationData();
      MemDestroy();
      MemInitialize()
    End;
    FrameCreateWindow();
    // ENTER THE MAIN MESSAGE LOOP
    EnterMessageLoop();
  Until not Restart;
  DestroyColorBitmaps;
  Result := 0;
End;

Begin
  CommandString[0] := #0;
  CommandString[1] := ' ';
  CommandString[2] := ' Apple //e Emulator for Windows';
  CommandString[3] := ' ';
  CommandString[4] := ' ';
  WinMain()
End.
