Function RegLoadString( Section : LPTSTR;
                        Key     : LPTSTR;
                        PerUser : Boolean;
                        Buffer  : LPTSTR;
                        Chars   : DWord   ) : Bool;
Var Success     : Boolean;
    FullKeyname : Array[0..255] of Char;
    KeyHandle   : hKey;
    HKEY_ID     : hKey;
    HKEY_TYPE   : DWord;
    HKEY_SIZE   : DWord;
Begin
  Success := false;
  StrFmt(FullKeyname,'Software\AppleWin\CurrentVersion\%s',[Section]);
  If PerUser then HKEY_ID := HKEY_CURRENT_USER
             Else HKEY_ID := HKEY_LOCAL_MACHINE;
  If not Ok(RegOpenKeyEx(HKEY_ID,FullKeyname,0,KEY_READ,KeyHandle)) then Begin
    HKEY_SIZE := Chars;
    Success := not Ok(RegQueryValueEx(KeyHandle,Key,Nil,@HKEY_TYPE,PByte(Buffer),@HKEY_SIZE)) and Ok(HKEY_SIZE);
    RegCloseKey(KeyHandle)
  End;
  DWORD(Result) := Abs(Ord(Success))
End;

Function RegLoadStringLong( Section : LPTSTR;
                            Key     : LPTSTR;
                            PerUser : Boolean;
                            Buffer  : LPTSTR;
                            Size    : Word     ) : Bool;
Var Success     : Boolean;
    FullKeyname : Array[0..255] of Char;
    KeyHandle   : hKey;
    HKEY_ID     : hKey;
    HKEY_TYPE   : DWord;
    HKEY_SIZE   : DWord;
Begin
  Success := false;
  StrFmt(FullKeyname,'Software\AppleWin\CurrentVersion\%s',[Section]);
  If PerUser then HKEY_ID := HKEY_CURRENT_USER
             Else HKEY_ID := HKEY_LOCAL_MACHINE;
  If not Ok(RegOpenKeyEx(HKEY_ID,FullKeyname,0,KEY_READ,KeyHandle)) then Begin
    HKEY_SIZE := Size;
    Success := not Ok(RegQueryValueEx(KeyHandle,Key,Nil,@HKEY_TYPE,PByte(Buffer),@HKEY_SIZE)) and Ok(HKEY_SIZE);
    RegCloseKey(KeyHandle)
  End;
  DWORD(Result) := Abs(Ord(Success))
End;

Function RegLoadValue( Section : LPTSTR;
                       Key     : LPTSTR;
                       PerUser : Boolean;
                       Value   : LPDWORD ) : Bool;
Var Buffer : Array[0..31] of Char;
Begin
  If not Ok(Value) then Begin
    Result := false;
    Exit
  End;
  Buffer := '';
  If not RegLoadString(Section,Key,PerUser,Buffer,32) then Begin
    Result := false;
    Exit
  End;
  Buffer[31] := #0;
  Value^ := DWord(StrToInt(Buffer));
  DWORD(Result) := 1
End;

Procedure RegSaveString( Section : LPTSTR;
                         Key     : LPTSTR;
                         PerUser : Boolean;
                         Buffer  : LPTSTR );
Var FullKeyname : Array[0..255] of Char;
    KeyHandle   : hKey;
    Disposition : DWord;
    HKEY_ID     : hKey;
Begin
  StrFmt(FullKeyname,'Software\AppleWin\CurrentVersion\%s',[Section]);
  If PerUser then HKEY_ID := HKEY_CURRENT_USER Else HKEY_ID := HKEY_LOCAL_MACHINE;
  If not Ok(RegCreateKeyEx(HKEY_ID,FullKeyname,0,Nil,REG_OPTION_NON_VOLATILE,
                           KEY_READ OR KEY_WRITE,Nil,KeyHandle,@Disposition)) then Begin
    RegSetValueEx(KeyHandle,Key,0,REG_SZ,Buffer,Succ(Length(Buffer)));
    RegCloseKey(KeyHandle)
  End
End;

Procedure RegSaveStringLong( Section : LPTSTR;
                             Key     : LPTSTR;
                             PerUser : Boolean;
                             Buffer  : LPTSTR;
                             Size    : Word    );
Var FullKeyname : Array[0..255] of Char;
    KeyHandle   : hKey;
    Disposition : DWord;
    HKEY_ID     : hKey;
Begin
  StrFmt(FullKeyname,'Software\AppleWin\CurrentVersion\%s',[Section]);
  If PerUser then HKEY_ID := HKEY_CURRENT_USER Else HKEY_ID := HKEY_LOCAL_MACHINE;
  If not Ok(RegCreateKeyEx(HKEY_ID,FullKeyname,0,Nil,REG_OPTION_NON_VOLATILE,
                           KEY_READ OR KEY_WRITE,Nil,KeyHandle,@Disposition)) then Begin
    RegSetValueEx(KeyHandle,Key,0,REG_MULTI_SZ,Buffer,Size);
    RegCloseKey(KeyHandle)
  End
End;

Procedure RegSaveValue( Section : LPTSTR;
                        Key     : LPTSTR;
                        PerUser : Boolean;
                        Value   : DWord    );
Var Buffer : Array[0..31] of Char;
Begin
  Buffer := '';
  StrPCopy(Buffer,IntToStr(Value));
  RegSaveString(Section,Key,PerUser,Buffer)
End;
