{ DO logical order  0 1 2 3 4 5 6 7 8 9 A B C D E F
     physical order 0 D B 9 7 5 3 1 E C A 8 6 4 2 F

  PO logical order  0 E D C B A 9 8 7 6 5 4 3 2 1 F
     physical order 0 2 4 6 8 A C E 1 3 5 7 9 B D F }

Function Code62( Sector : Integer ) : LPBYTE;
Var SectorBase : LPBYTE;
    ResultPtr  : LPBYTE;
    Offset     : Byte;
    Value      : Byte;
    Loop       : Integer;
    SavedVal   : Byte;
    SourcePtr  : LPBYTE;

    Procedure AddValue(a : Cardinal);
    Begin
      Value := (Value Shl 2) OR ((a AND $01) Shl 1) OR ((a AND $02) Shr 1)
    End;

Begin
  // CONVERT THE 256 8-BIT BYTES INTO 342 6-BIT BYTES, WHICH WE STORE
  // STARTING AT 4K INTO THE WORK BUFFER.
  SectorBase := LPBYTE(DWord(WorkBuffer) + (Sector Shl 8));
  ResultPtr  := LPBYTE(DWord(WorkBuffer) + $1000);
  Offset     := $AC;
  While Offset <> $02 do Begin
    Value := 0;
    AddValue(LPBYTE(DWord(SectorBase) + Offset)^);  Dec(Offset,$56);
    AddValue(LPBYTE(DWord(SectorBase) + Offset)^);  Dec(Offset,$56);
    AddValue(LPBYTE(DWord(SectorBase) + Offset)^);  Dec(Offset,$53);
    ResultPtr^ := Value Shl 2; Inc(ResultPtr);
  End;
  LPBYTE(DWord(ResultPtr) - 2)^ := LPBYTE(DWord(ResultPtr) - 2)^ AND $3F;
  LPBYTE(DWord(ResultPtr) - 1)^ := LPBYTE(DWord(ResultPtr) - 1)^ AND $3F;
  Loop := 0;
  While Loop < $100 do Begin
    ResultPtr^ := LPBYTE(DWord(SectorBase) + Loop)^;
    Inc(ResultPtr);
    Inc(Loop)
  End;
  // EXCLUSIVE-OR THE ENTIRE DATA BLOCK WITH ITSELF OFFSET BY ONE BYTE,
  // CREATING A 343RD BYTE WHICH IS USED AS A CHECKSUM.  STORE THE NEW
  // BLOCK OF 343 BYTES STARTING AT 5K INTO THE WORK BUFFER.
  SavedVal  := 0;
  SourcePtr := LPBYTE(DWord(WorkBuffer) + $1000);
  ResultPtr := LPBYTE(DWord(WorkBuffer) + $1400);
  Loop      := 342;
  While Ok(Loop) do Begin
    Dec(Loop);
    ResultPtr^ := SavedVal XOR SourcePtr^;
    Inc(ResultPtr);
    SavedVal := SourcePtr^;
    Inc(SourcePtr)
  End;
  ResultPtr^ := SavedVal;
  // USING A LOOKUP TABLE, CONVERT THE 6-BIT BYTES INTO DISK BYTES.  A VALID
  // DISK BYTE IS A BYTE THAT HAS THE HIGH BIT SET, AT LEAST TWO ADJACENT
  // BITS SET (EXCLUDING THE HIGH BIT), AND AT MOST ONE PAIR OF CONSECUTIVE
  // ZERO BITS.  THE CONVERTED BLOCK OF 343 BYTES IS STORED STARTING AT 4K
  // INTO THE WORK BUFFER.
  SourcePtr := LPBYTE(DWord(WorkBuffer) + $1400);
  ResultPtr := LPBYTE(DWord(WorkBuffer) + $1000);
  Loop      := 343;
  While Ok(Loop) do Begin
    Dec(Loop);
    ResultPtr^ := DiskByte[SourcePtr^ Shr 2];
    Inc(ResultPtr);
    Inc(SourcePtr)
  End;
  Result := LPBYTE(DWord(WorkBuffer) + $1000)
End;

Procedure Decode62( ImagePtr : LPBYTE );
Var Loop           : Integer;
    SourcePtr      : LPBYTE;
    ResultPtr      : LPBYTE;
    SavedVal       : Byte;
    LowBitsPtr     : LPBYTE;
    SectorBase     : LPBYTE;
    Offset         : Byte;
Begin
  // IF WE HAVEN'T ALREADY DONE SO, GENERATE A TABLE FOR CONVERTING
  // DISK BYTES BACK INTO 6-BIT BYTES
  If not TableGenerated then Begin
    FillChar(SixBitByte,$80,#0);
    Loop := 0;
    While Loop < $40 do Begin
      SixBitByte[DiskByte[Loop] - $80] := Loop Shl 2;
      Inc(Loop)
    End;
    DWORD(TableGenerated) := 1
  End;
  // USING OUR TABLE, CONVERT THE DISK BYTES BACK INTO 6-BIT BYTES
  SourcePtr := LPBYTE(DWord(WorkBuffer) + $1000);
  ResultPtr := LPBYTE(DWord(WorkBuffer) + $1400);
  Loop      := 343;
  While Ok(Loop) do Begin
    Dec(Loop);
    ResultPtr^ := SixBitByte[SourcePtr^ AND $7F];
    Inc(ResultPtr);
    Inc(SourcePtr)
  End;
  // EXCLUSIVE-OR THE ENTIRE DATA BLOCK WITH ITSELF OFFSET BY ONE BYTE
  // TO UNDO THE EFFECTS OF THE CHECKSUMMING PROCESS
  SavedVal  := 0;
  SourcePtr := LPBYTE(DWord(WorkBuffer) + $1400);
  ResultPtr := LPBYTE(DWord(WorkBuffer) + $1000);
  Loop      := 342;
  While Ok(Loop) do Begin
    Dec(Loop);
    ResultPtr^ := SavedVal XOR SourcePtr^;
    Inc(SourcePtr);
    SavedVal := ResultPtr^;
    Inc(ResultPtr)
  End;
  // CONVERT THE 342 6-BIT BYTES INTO 256 8-BIT BYTES
  LowBitsPtr := LPBYTE(DWord(WorkBuffer) + $1000);
  SectorBase := LPBYTE(DWord(WorkBuffer) + $1056);
  Offset     := $AC;
  While Offset <> $02 do Begin
    If Offset >= $AC then Begin
      LPBYTE(DWord(ImagePtr) + Offset)^ := (LPBYTE(DWord(SectorBase) + Offset)^ AND $FC) OR ((LowBitsPtr^ AND $80) Shr 7)
                                                                                         OR ((LowBitsPtr^ AND $40) Shr 5);
    End;
    Dec(Offset,$56);
    LPBYTE(DWord(ImagePtr) + Offset)^ := (LPBYTE(DWord(SectorBase) + Offset)^ AND $FC) OR ((LowBitsPtr^ AND $20) Shr 5)
                                                                                       OR ((LowBitsPtr^ AND $10) Shr 3);
    Dec(Offset,$56);
    LPBYTE(DWord(ImagePtr) + Offset)^ := (LPBYTE(DWord(SectorBase) + Offset)^ AND $FC) OR ((LowBitsPtr^ AND $08) Shr 3)
                                                                                       OR ((LowBitsPtr^ AND $04) Shr 1);
    Dec(Offset,$53);
    Inc(LowBitsPtr)
  End
End;

Function NibblizeTrack( TrackImageBuffer : LPBYTE;
                        DosOrder         : Bool;
                        Track            : Integer ) : DWord;
Var ImagePtr : LPBYTE;
    Sector   : Byte;
    Loop     : Integer;

    Function CODE44A(a : Cardinal) : Cardinal;
    Begin
      Result := ((a Shr 1) AND $55) OR $AA
    End;

    Function CODE44B(a : Cardinal) : Cardinal;
    Begin
      Result := (a AND $55) OR $AA
    End;

Begin
  FillChar(LPBYTE(DWord(WorkBuffer) + 4096)^,4096,#0);
  ImagePtr := TrackImageBuffer;
  Sector   := 0;
  // WRITE GAP ONE, WHICH CONTAINS 48 SELF-SYNC BYTES
  For Loop := 0 to 47 do Begin
    ImagePtr^ := $FF;
    Inc(ImagePtr)
  End;
  While Sector < 16 do Begin
    // WRITE THE ADDRESS FIELD, WHICH CONTAINS:
    //   - PROLOGUE (D5AA96)
    //   - VOLUME NUMBER ("4 AND 4" ENCODED)
    //   - TRACK NUMBER ("4 AND 4" ENCODED)
    //   - SECTOR NUMBER ("4 AND 4" ENCODED)
    //   - CHECKSUM ("4 AND 4" ENCODED)
    //   - EPILOGUE (DEAAEB)
    ImagePtr^ := $D5;                                     Inc(ImagePtr);
    ImagePtr^ := $AA;                                     Inc(ImagePtr);
    ImagePtr^ := $96;                                     Inc(ImagePtr);
    ImagePtr^ := $FF;                                     Inc(ImagePtr);
    ImagePtr^ := $FE;                                     Inc(ImagePtr);
    ImagePtr^ := CODE44A(BYTE(Track));                    Inc(ImagePtr);
    ImagePtr^ := CODE44B(BYTE(Track));                    Inc(ImagePtr);
    ImagePtr^ := CODE44A(Sector);                         Inc(ImagePtr);
    ImagePtr^ := CODE44B(Sector);                         Inc(ImagePtr);
    ImagePtr^ := CODE44A($FE XOR BYTE(Track) XOR Sector); Inc(ImagePtr);
    ImagePtr^ := CODE44B($FE XOR BYTE(Track) XOR Sector); Inc(ImagePtr);
    ImagePtr^ := $DE;                                     Inc(ImagePtr);
    ImagePtr^ := $AA;                                     Inc(ImagePtr);
    ImagePtr^ := $EB;                                     Inc(ImagePtr);
    // WRITE GAP TWO, WHICH CONTAINS SIX SELF-SYNC BYTES
    For Loop := 0 to 5 do Begin
      ImagePtr^ := $FF;
      Inc(ImagePtr)
    End;
    // WRITE THE DATA FIELD, WHICH CONTAINS:
    //   - PROLOGUE (D5AAAD)
    //   - 343 6-BIT BYTES OF NIBBLIZED DATA, INCLUDING A 6-BIT CHECKSUM
    //   - EPILOGUE (DEAAEB)
    ImagePtr^ := $D5;                                     Inc(ImagePtr);
    ImagePtr^ := $AA;                                     Inc(ImagePtr);
    ImagePtr^ := $AD;                                     Inc(ImagePtr);
    CopyMemory(ImagePtr,Code62(SectorNumber[Abs(Ord(DosOrder))][Sector]),343);
    Inc(ImagePtr,343);
    ImagePtr^ := $DE;                                     Inc(ImagePtr);
    ImagePtr^ := $AA;                                     Inc(ImagePtr);
    ImagePtr^ := $EB;                                     Inc(ImagePtr);
    // WRITE GAP THREE, WHICH CONTAINS 27 SELF-SYNC BYTES
    For Loop := 0 to 26 do Begin
      ImagePtr^ := $FF;
      Inc(ImagePtr)
    End;
    Inc(Sector)
  End;
  Result := DWord(ImagePtr) - DWord(TrackImageBuffer);
End;

Procedure DenibblizeTrack( TrackImage : LPBYTE;
                           DosOrder   : Bool;
                           Nibbles    : Integer );
Var Offset     : Integer;
    PartsLeft  : Integer;
    Sector     : Integer;
    Loop       : Integer;
    ByteNum    : Integer;
    TempOffset : Integer;
    ByteVal    : Array[0..2] of Byte;
Begin
  FillChar(WorkBuffer^,$1000,#0);
  // SEARCH THROUGH THE TRACK IMAGE FOR EACH SECTOR.  FOR EVERY SECTOR
  // WE FIND, COPY THE NIBBLIZED DATA FOR THAT SECTOR INTO THE WORK
  // BUFFER AT OFFSET 4K.  THEN CALL DECODE62() TO DENIBBLIZE THE DATA
  // IN THE BUFFER AND WRITE IT INTO THE FIRST PART OF THE WORK BUFFER
  // OFFSET BY THE SECTOR NUMBER.
  Offset    := 0;
  PartsLeft := 33;
  Sector    := 0;
  While Ok(PartsLeft) do Begin
    Dec(PartsLeft);
    FillChar(ByteVal,3,#0);
    ByteNum := 0;
    Loop    := Nibbles;
    While Ok(Loop) and (ByteNum < 3) do Begin
      Dec(Loop);
      If Ok(ByteNum) then Begin
        ByteVal[ByteNum] := LPBYTE(DWord(TrackImage) + Offset)^;
        Inc(ByteNum)
      End Else If LPBYTE(DWord(TrackImage) + Offset)^ = $D5 then Begin
        ByteNum := 1
      End;
      Inc(Offset);
      If Offset >= Nibbles then Offset := 0
    End;
    If (ByteNum = 3) and (ByteVal[1] = $AA) then Begin
      Loop       := 0;
      TempOffset := Offset;
      While Loop < 384 do Begin
        LPBYTE(DWord(WorkBuffer) + $1000 + Loop)^ := LPBYTE(DWord(TrackImage) + TempOffset)^;
        Inc(Loop);
        Inc(TempOffset);
        If TempOffset >= Nibbles then TempOffset := 0
      End;
      If ByteVal[2] = $96 then Begin
        Sector := ((LPBYTE(DWord(WorkBuffer) + $1004)^ AND $55) Shl 1) OR (LPBYTE(DWord(WorkBuffer) + $1005)^ AND $55)
      End Else If ByteVal[2] = $AD then Begin
        Decode62(LPBYTE(DWord(WorkBuffer) + (SectorNumber[Abs(Ord(DosOrder))][Sector] Shl 8)));
        Sector := 0
      End
    End
  End
End;

Procedure SkewTrack( Track            : Integer;
                     Nibbles          : Integer;
                     TrackImageBuffer : LPBYTE   );
Var SkewBytes : Integer;
Begin
  SkewBytes := (Track * 768) Mod Nibbles;
  CopyMemory(Workbuffer,TrackImageBuffer,Nibbles);
  CopyMemory(TrackImageBuffer,LPBYTE(DWord(WorkBuffer) + SkewBytes),Nibbles - SkewBytes);
  CopyMemory(LPBYTE(DWord(TrackImageBuffer) + Nibbles - SkewBytes),WorkBuffer,SkewBytes)
End;

Procedure IIeConvertSectorOrder( SourceOrder : LPBYTE );
Var Loop  : Integer;
    Loop2 : Integer;
    Found : Byte;
Begin
  Loop := 16;
  While Ok(Loop) do Begin
    Dec(Loop);
    Found := $FF;
    Loop2 := 16;
    While Ok(Loop2) and (Found = $FF) do Begin
      Dec(Loop2);
      If LPBYTE(DWord(SourceOrder) + Loop2)^ = Loop then Found := Loop2
    End;
    If Found = $FF then Found := 0;
    SectorNumber[2][Loop] := Found
  End
End;

Function  PrgDetect(  ImagePtr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Begin
  If LPDWORD(ImagePtr)^ = $214C470A then Result := 2 Else Result := 0
End;

Function  DoDetect(   ImagePtr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Var Loop      : Integer;
    Mismatch  : Bool;
    Val1,Val2 : Word;
Begin
  If ((ImageSize < 143105) or (ImageSize > 143364)) and (ImageSize <> 143403) and (Imagesize <> 143488) then Begin
    Result := 0;
    Exit
  End;
  // CHECK FOR A DOS ORDER IMAGE OF A DOS DISKETTE
  Loop     := 0;
  Mismatch := false;
  While (Loop < 15) and not Mismatch do Begin
    Inc(Loop);
    If LPBYTE(DWord(ImagePtr) + $11002 + (Loop Shl 8))^ <> Pred(Loop) then Mismatch := true
  End;
  If not Mismatch then Begin
    Result := 2;
    Exit
  End;
  // CHECK FOR A DOS ORDER IMAGE OF A PRODOS DISKETTE
  Loop     := 1;
  Mismatch := false;
  While (Loop < 5) and not Mismatch do Begin
    Inc(Loop);
    If Loop = 5 then Val1 := 0 Else Val1 := 6 - Loop;
    If Loop = 2 then Val2 := 0 Else Val2 := 8 - Loop;
    If (LPWORD(DWord(ImagePtr) + (Loop Shl 9) + $100)^ <> Val1) or
       (LPWORD(DWord(ImagePtr) + (Loop Shl 9) + $102)^ <> Val2) then Mismatch := true
  End;
  If not Mismatch then Begin
    Result := 2;
    Exit
  End;
  Result := 1
End;

Function  PoDetect(   ImagePtr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Var Loop      : Integer;
    Mismatch  : Bool;
    Val1,Val2 : Word;
Begin
  If ((ImageSize < 143105) or (ImageSize > 143364)) and (ImageSize <> 143488) then Begin
    Result := 0;
    Exit
  End;
  // CHECK FOR A PRODOS ORDER IMAGE OF A DOS DISKETTE
  Loop     := 4;
  Mismatch := false;
  While (Loop < 13) and not Mismatch do Begin
    Inc(Loop);
    If LPBYTE(DWord(ImagePtr) + $11002 + (Loop Shl 8))^ <> 14 - Loop then Mismatch := true
  End;
  If not Mismatch then Begin
    Result := 2;
    Exit
  End;
  // CHECK FOR A PRODOS ORDER IMAGE OF A PRODOS DISKETTE
  Loop     := 1;
  Mismatch := false;
  While (Loop < 5) and not Mismatch do Begin
    Inc(Loop);
    If Loop = 2 then Val1 := 0 Else Val1 := Pred(Loop);
    If Loop = 5 then Val2 := 0 Else Val2 := Succ(Loop);
    If (LPWORD(DWord(ImagePtr) + (Loop Shl 9)  )^ <> Val1) or
       (LPWORD(DWord(ImagePtr) + (Loop Shl 9) + 2)^ <> Val2) then Mismatch := true
  End;
  If not Mismatch then Begin
    Result := 2;
    Exit
  End;
  Result := 1
End;

Function  AplDetect(  Imageptr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Var Length : DWord;
Begin
  Length := LPWORD(DWord(ImagePtr) + 2)^;
  Result := Ord(((Length + 4) = ImageSize) or ((Length + 4 + ((256 - ((Length + 4) AND 255)) AND 255)) = ImageSize))
End;

Function  Nib1Detect( ImagePtr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Begin
  If ImageSize = 232960 then Result := 2 Else Result := 0
End;

Function  Nib2Detect( ImagePtr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Begin
  If ImageSize = 223440 then Result := 2 Else Result := 0
End;

Function  IIeDetect(  ImagePtr            : LPBYTE;
                      ImageSize           : DWord        ) : DWord;
Begin
  If (StrLComp(LPSTR(ImagePtr),'SIMSYSTEM_IIE',13) <> 0) or (LPBYTE(DWord(ImagePtr) + 13)^ > 3) then Begin
    Result := 0;
    Exit
  End;
  Result := 2
End;

Function  PrgBoot(    Ptr                 : ImageInfoPtr ) : Bool;
Var Address   : Word;
    Length    : Word;
    BytesRead : DWord;
    Loop      : Integer;
Begin
  SetFilePointer(Ptr^._File,5,Nil,FILE_BEGIN);
  Address := 0;
  Length  := 0;
  ReadFile(Ptr^._File,Address,SizeOf(Word),BytesRead,Nil);
  ReadFile(Ptr^._File,Length ,SizeOf(Word),BytesRead,Nil);
  Length := Length Shl 1;
  If (Address + Length <= Address) or (Address >= $C000) or (Address + Pred(Length) >= $C000) then Begin
    Result := false;
    Exit
  End;
  SetFilePointer(Ptr^._File,128,Nil,FILE_BEGIN);
  ReadFile(Ptr^._File,LPBYTE(DWord(Mem) + Address)^,Length,BytesRead,Nil);
  Loop := 192;
  While Ok(Loop) do Begin
    Dec(Loop);
    LPBYTE(DWord(MemDirty) + Loop)^ := $FF
  End;
  Regs.PC := Address;
  DWORD(Result) := 1
End;

Function  AplBoot(    Ptr                 : ImageInfoPtr ) : Bool;
Var Address   : Word;
    Length    : Word;
    BytesRead : DWord;
    Loop      : Integer;
Begin
  SetFilePointer(Ptr^._File,0,Nil,FILE_BEGIN);
  Address := 0;
  Length  := 0;
  ReadFile(Ptr^._File,Address,SizeOf(Word),BytesRead,Nil);
  ReadFile(Ptr^._File,Length ,SizeOf(Word),BytesRead,Nil);
  If (Address + Length <= Address) or (Address >= $C000) or (Address + Pred(Length) >= $C000) then Begin
    Result := false;
    Exit
  End;
  ReadFile(Ptr^._File,LPBYTE(DWord(Mem) + Address)^,Length,BytesRead,Nil);
  Loop := 192;
  While Ok(Loop) do Begin
    Dec(Loop);
    LPBYTE(DWord(MemDirty) + Loop)^ := $FF
  End;
  Regs.PC := Address;
  DWORD(Result) := 1
End;

Procedure DoRead(     Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImageBuffer    : LPBYTE;
                      Nibbles             : LPINT        );
Var BytesRead : DWord;
Begin
  SetFilePointer(Ptr^._File,Ptr^.Offset + (Track Shl 12),Nil,FILE_BEGIN);
  FillChar(WorkBuffer^,4096,#0);
  ReadFile(Ptr^._File,WorkBuffer^,4096,BytesRead,Nil);
  Nibbles^ := NibblizeTrack(TrackImageBuffer,true,Track);
  If not EnhanceDisk then SkewTrack(Track,Nibbles^,TrackImageBuffer)
End;

Procedure PoRead(     Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImageBuffer    : LPBYTE;
                      Nibbles             : LPINT        );
Var BytesRead : DWord;
Begin
  SetFilePointer(Ptr^._File,Ptr^.Offset + (Track Shl 12),Nil,FILE_BEGIN);
  FillChar(WorkBuffer^,4096,#0);
  ReadFile(Ptr^._File,WorkBuffer^,4096,Bytesread,Nil);
  Nibbles^ := NibblizeTrack(TrackImageBuffer,false,Track);
  If not Ok(EnhanceDisk) then SkewTrack(Track,Nibbles^,TrackImageBuffer)
End;

Procedure Nib1Read(   Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImageBuffer    : LPBYTE;
                      Nibbles             : LPINT        );
Begin
  SetFilePointer(Ptr^._File,Ptr^.Offset + Track * cNIBBLES,Nil,FILE_BEGIN);
  ReadFile(Ptr^._File,TrackImageBuffer^,cNIBBLES,LPDWORD(Nibbles)^,Nil)
End;

Procedure Nib2Read(   Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImageBuffer    : LPBYTE;
                      Nibbles             : LPINT        );
Begin
  SetFilePointer(Ptr^._File,Ptr^.Offset + Track * 6384,Nil,FILE_BEGIN);
  ReadFile(Ptr^._File,TrackImageBuffer^,6384,LPDWORD(Nibbles)^,Nil)
End;

Procedure IIeRead(    Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImageBuffer    : LPBYTE;
                      Nibbles             : LPINT        );
Var BytesRead : DWord;
    Offset    : DWord;
Begin
  // IF WE HAVEN'T ALREADY DONE SO, READ THE IMAGE FILE HEADER
  If not Ok(Ptr^.Header) then Begin
    Ptr^.Header := LPBYTE(VirtualAlloc(Nil,88,MEM_COMMIT,PAGE_READWRITE));
    If not Ok(Ptr^.Header) then Begin
      Nibbles^ := 0;
      Exit
    End;
    FillChar(Ptr^.Header^,88,#0);
    SetFilePointer(Ptr^._File,0,Nil,FILE_BEGIN);
    ReadFile(Ptr^._File,Ptr^.Header,88,BytesRead,Nil)
  End;
  // IF THIS IMAGE CONTAINS USER DATA, READ THE TRACK AND NIBBLIZE IT
  If LPBYTE(DWord(Ptr^.Header) + 13)^ <= 2 then Begin
    IIeConvertSectorOrder(LPBYTE(DWord(Ptr^.Header) + 14));
    SetFilePointer(Ptr^._File,(Track Shl 12) + 30,Nil,FILE_BEGIN);
    FillChar(WorkBuffer^,4096,#0);
    ReadFile(Ptr^._File,WorkBuffer^,4096,BytesRead,Nil);
    Nibbles^ := NibblizeTrack(TrackImageBuffer,BOOL(DWORD(2)),Track)
  End Else Begin
  // OTHERWISE, IF THIS IMAGE CONTAINS NIBBLE INFORMATION, READ IT
  // DIRECTLY INTO THE TRACK BUFFER
    Nibbles^ := LPWORD(DWord(Ptr^.Header) + (Track Shl 1) + 14)^;
    Offset := 88;
    While Ok(Track) do Begin
      Dec(Track);
      Inc(Offset,LPWORD(DWord(Ptr^.Header) + (Track Shl 1) + 14)^)
    End;
    SetFilePointer(Ptr^._File,Offset,Nil,FILE_BEGIN);
    FillChar(TrackImageBuffer^,Nibbles^,#0);
    ReadFile(Ptr^._File,TrackImageBuffer^,Nibbles^,BytesRead,Nil)
  End
End;

Procedure DoWrite(    Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      Trackimage          : LPBYTE;
                      Nibbles             : Integer      );
Var BytesWritten : DWord;
Begin
  FillChar(WorkBuffer^,4096,#0);
  DenibblizeTrack(TrackImage,BOOL(DWORD(1)),Nibbles);
  SetFilePointer(Ptr^._File,Ptr^.Offset + (Track Shl 12),Nil,FILE_BEGIN);
  WriteFile(Ptr^._File,WorkBuffer^,4096,BytesWritten,Nil)
End;

Procedure PoWrite(    Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImage          : LPBYTE;
                      Nibbles             : Integer      );
Var BytesWritten : DWord;
Begin
  FillChar(WorkBuffer^,4096,#0);
  DenibblizeTrack(TrackImage,false,Nibbles);
  SetFilePointer(Ptr^._File,Ptr^.Offset + (Track Shl 12),Nil,FILE_BEGIN);
  WriteFile(Ptr^._File,WorkBuffer^,4096,BytesWritten,Nil)
End;

Procedure Nib1Write(  Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImage          : LPBYTE;
                      Nibbles             : Integer      );
Var BytesWritten : DWord;
Begin
  SetFilePointer(Ptr^._File,Ptr^.Offset + Track * cNIBBLES,Nil,FILE_BEGIN);
  WriteFile(Ptr^._File,TrackImage^,Nibbles,BytesWritten,Nil)
End;

Procedure Nib2Write(  Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImage          : LPBYTE;
                      Nibbles             : Integer      );
Var BytesWritten : DWord;
Begin
  SetFilePointer(Ptr^._File,Ptr^.Offset + Track * 6384,Nil,FILE_BEGIN);
  WriteFile(Ptr^._File,TrackImage^,Nibbles,Byteswritten,Nil)
End;

Procedure IIeWrite(   Ptr                 : ImageInfoPtr;
                      Track, QuarterTrack : Integer;
                      TrackImage          : LPBYTE;
                      Nibbles             : Integer      );
Begin
  // note: unimplemented
End;

Procedure ImageInitialize;
Begin
  WorkBuffer := LPBYTE(VirtualAlloc(Nil,$2000,MEM_COMMIT,PAGE_READWRITE))
End;

Procedure ImageClose( ImageHandle : hImage );
Var Ptr   : ImageInfoPtr;
    Track : Integer;
Begin
  Ptr := ImageInfoPtr(ImageHandle);
  If Ptr^._File <> INVALID_HANDLE_VALUE then CloseHandle(Ptr^._File);
  For Track := 0 to Pred(TRACKS) do If not Ok(Ptr^.ValidTrack[Track]) then Begin
    DeleteFile(Ptr^.Filename);
    Break
  End;
  If Ok(Ptr^.Header) then VirtualFree(Ptr^.Header,0,MEM_RELEASE);
  VirtualFree(Ptr,0,MEM_RELEASE)
End;

Function ImageOpen( ImageFilename     : LPTSTR;
                    ImageHandle       : LPIMAGE;
                    WriteProtected    : LPBOOL;
                    CreateIfNecessary : Bool     ) : Integer;
Var _File          : tHandle;
    _Result        : DWord;
    ImageFileExt   : LPTSTR;
    Ext            : Array[0..Pred(MAX_EXT)] of Char;
    Size           : DWord;
    View           : LPBYTE;
    ImagePtr       : LPBYTE;
    Format         : DWord;
    Mapping        : tHandle;
    PossibleFormat : DWord;
    Loop           : Integer;
    Track          : Integer;
Begin
  If not (Ok(ImageFilename) and Ok(ImageHandle) and Ok(WriteProtected) and Ok(Workbuffer)) then Begin
    Result := -1;
    Exit
  End;
  // TRY TO OPEN THE IMAGE FILE
  _File := INVALID_HANDLE_VALUE;
  If not WriteProtected^ then Begin
    _File := CreateFile(ImageFilename,GENERIC_READ OR GENERIC_WRITE,FILE_SHARE_READ OR FILE_SHARE_WRITE,
                        PSecurityAttributes(Nil),OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0)
  End;
  If _File = INVALID_HANDLE_VALUE then Begin
    _File := CreateFile(ImageFilename,GENERIC_READ,FILE_SHARE_READ,
                        PSecurityAttributes(Nil),OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
    If _File <> INVALID_HANDLE_VALUE then DWORD(WriteProtected^) := 1
  End;
  If (_File = INVALID_HANDLE_VALUE) and CreateIfNecessary then Begin
    _File := CreateFile(ImageFilename,GENERIC_READ OR GENERIC_WRITE,FILE_SHARE_READ OR FILE_SHARE_WRITE,
                        PSecurityAttributes(Nil),CREATE_NEW,FILE_ATTRIBUTE_NORMAL,0)
  End;
  // IF WE AREN'T ABLE TO OPEN THE FILE, RETURN
  If _File = INVALID_HANDLE_VALUE then Begin
    Result := 1;
    Exit
  End;
  // DETERMINE THE FILE'S EXTENSION AND CONVERT IT TO LOWERCASE
  ImageFileExt := ImageFilename;
  If Ok(StrRScan(ImageFileExt,'\')) then ImageFileExt := StrRScan(ImageFileExt,'\') + 1;
  If Ok(StrRScan(ImageFileExt,'.')) then ImageFileExt := StrRScan(ImageFileExt,'.');
  StrLCopy(Ext,ImageFileExt,MAX_EXT);
  CharLowerBuff(Ext,StrLen(Ext));
  Size     := GetFileSize(_File,Nil);
  View     := Nil;
  ImagePtr := Nil;
  Format   := $FFFFFFFF;
  If Size > 0 then Begin
    // MAP THE FILE INTO MEMORY FOR USE BY THE DETECTION FUNCTIONS
    Mapping  := CreateFileMapping(_File,PSecurityAttributes(Nil),PAGE_READONLY,0,0,Nil);
    View     := LPBYTE(MapViewOfFile(Mapping,FILE_MAP_READ,0,0,0));
    ImagePtr := View;
    If Ok(ImagePtr) then Begin
      // DETERMINE WHETHER THE FILE HAS A 128-BYTE MACBINARY HEADER
      If (Size > 128) and not Ok(Imageptr^) and (LPBYTE(DWord(ImagePtr) + 1)^ < 120)
                      and not Ok(LPBYTE(DWord(ImagePtr) + LPBYTE(DWord(ImagePtr) + 1)^ + 2)^)
                      and     (LPBYTE(DWord(ImagePtr) + $7A)^ = $81)
                      and     (LPBYTE(DWord(ImagePtr) + $7B)^ = $81) then Begin
        Inc(ImagePtr,128);
        Dec(Size,128)
      End;
      // CALL THE DETECTION FUNCTIONS IN ORDER, LOOKING FOR A MATCH
      PossibleFormat := $FFFFFFFF;
      Loop           := 0;
      While (Loop < IMAGETYPES) and (Format = $FFFFFFFF) do Begin
        If Ok(Ext[0]) and Ok(StrPos(ImageType[Loop].RejectExts,Ext)) then Begin
          Inc(Loop)
        End Else Begin
          _Result := ImageType[Loop].Detect(ImagePtr,Size);
          If _Result = 2 then Begin
            Format := Loop;
          End Else If (_Result = 1) and (PossibleFormat = $FFFFFFFF) then Begin
            PossibleFormat := Loop;
            Inc(Loop)
          End Else Inc(Loop)
        End
      End;
      If Format = $FFFFFFFF then Format := PossibleFormat;
      // CLOSE THE MEMORY MAPPING
      UnmapViewOfFile(View)
    End;
    CloseHandle(Mapping)
  End Else Begin
    // WE CREATE ONLY DOS ORDER (DO) OR 6656-NIBBLE (NIB) FORMAT FILES
    Loop := 1;
    While Loop <= 4 do Begin;
      If Ok(Ext[0]) and Ok(StrPos(ImageType[Loop].CreateExts,Ext)) then Begin
        Format := Loop;
        Break
      End;
      Inc(Loop,3)
    End
  End;
  // IF THE FILE DOES MATCH A KNOWN FORMAT...
  If Format <> $FFFFFFFF then Begin
    // CREATE A RECORD FOR THE FILE, AND RETURN AN IMAGE HANDLE
    ImageHandle^ := hImage(VirtualAlloc(Nil,SizeOf(ImageInfoRec),MEM_COMMIT,PAGE_READWRITE));
    If Ok(ImageHandle^) then Begin
      FillChar(ImageInfoPtr(ImageHandle^)^,SizeOf(ImageInfoRec),#0);
      StrLCopy(ImageInfoPtr(ImageHandle^).Filename,ImageFilename,MAX_PATH);
      ImageInfoPtr(ImageHandle^).Format         := Format;
      ImageInfoPtr(ImageHandle^)._File          := _File;
      ImageInfoPtr(ImageHandle^).Offset         := DWord(ImagePtr) - DWord(View);
      ImageInfoPtr(ImageHandle^).Writeprotected := WriteProtected^;
      For Track := 0 to Pred(TRACKS) do Begin
        ImageInfoPtr(ImageHandle^).ValidTrack[Track] := Bool(Size > 0)
      End;
      Result := 0;
      Exit
    End
  End;
  CloseHandle(_File);
  If not Ok(Size > 0) then DeleteFile(ImageFilename);
  Result := 2
End;

Procedure ImageWriteTrack( ImageHandle  : hImage;
                           Track        : Integer;
                           QuarterTrack : Integer;
                           TrackImage   : LPBYTE;
                           Nibbles      : Integer  );
Var Ptr : ImageInfoPtr;
Begin
  Ptr := ImageInfoPtr(ImageHandle);
  If Ok(@ImageType[Ptr^.Format].Write) and not Ptr^.WriteProtected then Begin
    ImageType[Ptr^.Format].Write(Ptr,Track,QuarterTrack,TrackImage,Nibbles);
    DWORD(Ptr^.ValidTrack[Track]) := 1
  End
End;

Procedure ImageReadTrack( ImageHandle      : hImage;
                          Track            : Integer;
                          QuarterTrack     : Integer;
                          TrackImageBuffer : LPBYTE;
                          Nibbles          : LPINT    );
Var Ptr  : ImageInfoPtr;
    Loop : Integer;
Begin
  Ptr := ImageInfoPtr(ImageHandle);
  If Ok(@ImageType[Ptr^.Format].Read) and Ptr^.ValidTrack[Track] then Begin
    ImageType[Ptr^.Format].Read(Ptr,Track,QuarterTrack,TrackImageBuffer,Nibbles)
  End Else Begin
    For Loop := 0 to Pred(cNIBBLES) do LPBYTE(DWord(TrackImageBuffer) + Loop)^ := BYTE(Rand() AND $FF);
    Nibbles^ := Loop
  End
End;

Function ImageBoot( ImageHandle : hImage ) : Bool;
Var Ptr     : ImageInfoPtr;
    _Result : Bool;
Begin
  Ptr := ImageInfoPtr(ImageHandle);
  _Result := false;
  If Ok(@ImageType[Ptr^.Format].Boot) then _Result := ImageType[Ptr^.Format].Boot(Ptr);
  If Ok(_Result) then DWORD(Ptr^.WriteProtected) := 1;
  Result := _Result
End;

Procedure ImageDestroy;
Begin
  VirtualFree(WorkBuffer,0,MEM_RELEASE);
  Workbuffer := Nil
End;
