{ *********************************************************************** }
{                                                                         }
{ Delphi Runtime Library                                                  }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       MSVCRT interface unit                           }
{*******************************************************}

Unit MSVCRT;

{$WEAKPACKAGEUNIT}

Interface

Uses Windows;

Type LPCHAR = ^Char;
Type tFile  = Record
                _ptr  : ^Char;
                _cnt  : Integer;
                _base : ^Char;
                _flag : Integer;
                _file : Integer;
                _charbuf : Integer;
                _bufsiz : Integer;
                _tmpfname : ^Char;
              End;
     pFile  = ^tFile;

{$EXTERNALSYM fclose}
Function fClose(stream : pFile) : Integer; cdecl;

{$EXTERNALSYM feof}
Function fEOF(stream : pFile) : Integer; cdecl;

{$EXTERNALSYM fgets}
Function fGets(str : LPTSTR; n : Integer; stream : pFile) : PChar; cdecl;

{$EXTERNALSYM fopen}
Function fOpen(Const filename : LPTSTR; Const mode : LPTSTR) : pFile; cdecl;

{$EXTERNALSYM fprintf}
Function fPrintF(stream : pFile; Const format : LPTSTR) : Integer; cdecl; varargs;

{$EXTERNALSYM fscanf}
Function fScanF(stream : pFile; Const format : LPTSTR) : Integer; cdecl; varargs;

{$EXTERNALSYM rand}
Function rand() : Integer; cdecl;

{$EXTERNALSYM strtok}
Function StrTok(strToken : LPTSTR; Const strDelimit : LPTSTR): PChar; cdecl;

{$EXTERNALSYM strtoul}
Function StrToul(Const nPtr : LPTSTR; EndPtr : LPCHAR; Base : Integer): DWord; cdecl;

{$EXTERNALSYM sprintf}
Function sPrintF(buffer : LPTSTR; Const format : LPTSTR) : Integer; cdecl; varargs;

Implementation

Function fClose;   external 'msvcrt.dll' name 'fclose';
Function fEOF;     external 'msvcrt.dll' name 'feof';
Function fGets;    external 'msvcrt.dll' name 'fgets';
Function fOpen;    external 'msvcrt.dll' name 'fopen';
Function fPrintF;  external 'msvcrt.dll' name 'fprintf';
Function fScanF;   external 'msvcrt.dll' name 'fscanf';
Function Rand;     external 'msvcrt.dll' name 'rand';
Function StrTok;   external 'msvcrt.dll' name 'strtok';
Function StrToul;  external 'msvcrt.dll' name 'strtoul';
Function sPrintF;  external 'msvcrt.dll' name 'sprintf';

End.






