Procedure CopySource( DestX,   DestY   : Integer;
                      xSize,   ySize   : Integer;
                      SourceX, SourceY : Integer  ); StdCall;
Var CurrDestPtr   : LPBYTE;
    CurrSourcePtr : LPBYTE;
    BytesLeft     : Integer;
Begin
  CurrDestPtr   := LPBYTE(DWord(FrameOffsetTable [DestY])   + DestX);
  CurrSourcePtr := LPBYTE(DWord(SourceOffsetTable[SourceY]) + SourceX);
  While Ok(ySize) do Begin
    Dec(ySize);
    BytesLeft := xSize;
    While Ok(Bytesleft AND 3) do Begin
      Dec(BytesLeft);
      LPBYTE(DWord(CurrDestPtr) + BytesLeft)^ := LPBYTE(DWord(CurrSourcePtr) + BytesLeft)^
    End;
    While Ok(BytesLeft) do Begin
      Dec(BytesLeft,4);
      LPDWORD(DWord(CurrDestPtr) + BytesLeft)^ := LPDWORD(DWord(CurrSourcePtr) + BytesLeft)^
    End;
    Dec(CurrDestPtr,FrameBufferPitch);
    Dec(CurrSourcePtr,SRCOFFS_TOTAL)
  End
End;

Function VideoCheckMode( ProgramCounter : Word;
                         Address        : Byte;
                         Write          : Byte;
                         Value          : Byte  ) : Byte; StdCall;
Var _Result : Bool;
Begin
  If Address = $7F then Begin
    Result := MemReturnRandomData(Byte(SW_DHIRES <> 0));
    Exit;
  End Else Begin
    _Result := false;
    Case Address of
      $1A : DWORD(_Result) := SW_TEXT;
      $1B : DWORD(_Result) := SW_MIXED;
      $1D : DWORD(_Result) := SW_HIRES;
      $1E : DWORD(_Result) := CharOffs;
      $1F : DWORD(_Result) := SW_80COL;
      $7F : DWORD(_Result) := SW_DHIRES;
    End;
    If Ok(_Result) then Result := KeybGetKeycode() OR $80 Else Result := KeybGetKeycode() OR $00
  End
End;

Function VideoCheckVbl( ProgramCounter : Word;
                        Address        : Byte;
                        Write          : Byte;
                        Value          : Byte  ) : Byte; StdCall;
Begin
  Result := MemReturnRandomData(Byte(VblCounter < 22))
End;

Function VideoSetMode( ProgramCounter : Word;
                       Address        : Byte;
                       Write          : Byte;
                       Value          : Byte  ) : Byte; StdCall;
Var OldPage2         : DWord;
    OldValue         : Integer;
    CurrTime         : DWord;
    FastVideoSlowCPU : Bool;
// Fehler ? unklar: LastTime bereits definiert, mu nochmals global als VidLastTime definiert werden ?    
Begin
  OldPage2 := SW_PAGE2;
  OldValue := CharOffs + Integer(VidMode AND NOT (VF_MASK2 OR VF_PAGE2));
  Case Address of
    $00 : VidMode  := VidMode AND NOT VF_MASK2;
    $01 : VidMode  := VidMode OR VF_MASK2;
    $0C : VidMode  := VidMode AND NOT VF_80COL;
    $0D : VidMode  := VidMode OR VF_80COL;
    $0E : CharOffs := 0;
    $0F : CharOffs := 256;
    $50 : VidMode  := VidMode AND NOT VF_TEXT;
    $51 : VidMode  := VidMode OR VF_TEXT;
    $52 : VidMode  := VidMode AND NOT VF_MIXED;
    $53 : VidMode  := VidMode OR VF_MIXED;
    $54 : VidMode  := VidMode AND NOT VF_PAGE2;
    $55 : VidMode  := VidMode OR VF_PAGE2;
    $56 : VidMode  := VidMode AND NOT VF_HIRES;
    $57 : VidMode  := VidMode OR VF_HIRES;
    $5E : VidMode  := VidMode OR VF_DHIRES;
    $5F : VidMode  := VidMode AND NOT VF_DHIRES
  End;
  If Ok(SW_MASK2) then VidMode := VidMode AND NOT VF_PAGE2;
  If OldValue <> CharOffs + Integer(VidMode AND NOT(VF_MASK2 OR VF_PAGE2)) then Begin
    DWORD(GraphicsMode) := Abs(Ord(not Ok(SW_TEXT)));
    DWORD(RedrawFull)   := 1
  End;
  If FullSpeed and Ok(OldPage2) and not Ok(SW_PAGE2) then Begin
    CurrTime := GetTickCount();
    If CurrTime - LastTime >= 20 then LastTime := CurrTime
                                 Else OldPage2 := SW_PAGE2
  End;
  If OldPage2 <> SW_PAGE2 then Begin
    FastVideoSlowCPU := false;
    If (CpuEmType = CPU_FASTPAGING) and (EmulMsec - LastRefresh >= 20) then DWORD(FastVideoSlowCPU) := 1;
    If (DisplayPage2 and not Ok(SW_PAGE2)) or not Behind or FastVideoSlowCPU then Begin
      DWORD(DisplayPage2) := Abs(Ord(SW_PAGE2 <> 0));
      If not RedrawFull then Begin
        VideoRefreshScreen();
        DWORD(HasRefreshed) := 1;
        LastRefresh  := EmulMsec
      End
    End Else If not Ok(SW_PAGE2) and not RedrawFull and (EmulMsec - LastRefresh >= 20) then Begin
      DisplayPage2 := false;
      VideoRefreshScreen();
      DWORD(HasRefreshed) := 1;
      LastRefresh  := EmulMsec
    End;
    LastPageFlip := EmulMsec
  End;
  If Address = $50 then Result := VideoCheckVbl(0,0,0,0)
                   Else Result := MemReturnRandomData(1)
End;

Procedure CreateFrameOffsetTable( Addr : LPBYTE; Pitch : LongInt );
Var Loop : Integer;
Begin
  If (FrameBufferAddr = Addr) and (FrameBufferPitch = Pitch) then Exit;
  FrameBufferAddr  := Addr;
  FrameBufferPitch := Pitch;
  // CREATE THE OFFSET TABLE FOR EACH SCAN LINE IN THE FRAME BUFFER
  For Loop := 0 to 383 do Begin
    FrameOffsetTable[Loop] := LPBYTE(DWord(FrameBufferAddr) + FrameBufferPitch * ( 383 - Loop))
  End
End;

Function Update40ColCell( x, y, xPixel, yPixel, Offset : Integer ) : Bool;
Var Ch   : Byte;
    Val  : Byte;
    FlCh : Boolean;
    Step : Integer;
    y1   : Integer;
Begin
  Ch := LPBYTE(DWord(TextMainPtr) + Offset)^;
  FlCh := (Ch < $80) and (Ch > $3F);
  If (Ch <> LPBYTE(DWord(VidLastMem) + Offset + $400)^) or RedrawFull or (FlCh and (Flash <> lFlash)) then Begin
    If Flash and FlCh then Val := $40 Else Val := $00;
    If not H_Scanlines then Begin
      CopySource(xPixel,yPixel,14,16,SRCOFFS_40COL + ((ch AND $0F) Shl 4),((Ch + Val) AND $F0) + CharOffs);
    End Else Begin
      Step := 2;
      y1   := 0;
      While y1 < 16 do Begin
        CopySource(xPixel,yPixel + y1,14,1,SRCOFFS_40COL + ((ch AND $0F) Shl 4),(y1 AND $FE) + ((Ch + Val) AND $F0) + CharOffs);
        Inc(y1,Step)
      End
    End;
    DWORD(Result) := 1
  End Else Result := false
End;

Function Update80ColCell( x, y, xPixel, yPixel, Offset : Integer ) : Bool;
Var AuxVal  : Byte;
    MainVal : Byte;
    Step    : Integer;
    y1      : Integer;
Begin
  AuxVal  := LPBYTE(DWord(TextAuxPtr)  + Offset)^;
  MainVal := LPBYTE(DWord(TextMainPtr) + Offset)^;
  If (AuxVal  <> LPBYTE(DWord(VidLastMem) + Offset)^) or (MainVal <> LPBYTE(DWord(VidLastMem) + Offset + $400)^) or RedrawFull then Begin
    If not H_Scanlines then Begin
      CopySource(xPixel,    yPixel,7,16,SRCOFFS_80COL + ((AuxVal  AND 15) Shl 3),((AuxVal  Shr 4) Shl 4) + CharOffs);
      CopySource(xPixel + 7,yPixel,7,16,SRCOFFS_80COL + ((MainVal AND 15) Shl 3),((MainVal Shr 4) Shl 4) + CharOffs)
    End Else Begin
      Step := 2;
      y1   := 0;
      While y1 < 16 do Begin
        CopySource(xPixel,    yPixel + y1,7,1,SRCOFFS_80COL + ((AuxVal  AND 15) Shl 3),(y1 AND $FE) + ((AuxVal  Shr 4) Shl 4) + CharOffs);
        CopySource(xPixel + 7,yPixel + y1,7,1,SRCOFFS_80COL + ((MainVal AND 15) Shl 3),(y1 AND $FE) + ((MainVal Shr 4) Shl 4) + CharOffs);
        Inc(y1,Step)
      End
    End;
    DWORD(Result) := 1
  End Else Result := false
End;

Function UpdateLoResCell( x, y, xPixel, yPixel, Offset : Integer ) : Bool;
Var Val  : Byte;
    Step : Integer;
    y1   : Integer;
Begin
  Val := LPBYTE(DWord(TextMainPtr) + Offset)^;
  If (Val <> LPBYTE(DWord(VidLastMem) + Offset + $400)^) or Redrawfull then Begin
    If not H_Scanlines then Begin
      CopySource(xPixel,yPixel,    14,8,SRCOFFS_LORES + ((x AND 1) Shl 1),(Val AND $0F) Shl 4);
      CopySource(xPixel,yPixel + 8,14,8,SRCOFFS_LORES + ((x AND 1) Shl 1),Val AND $F0)
    End Else Begin
      Step := 2;
      y1   := 0;
      While y1 < 8 do Begin
        CopySource(xPixel,yPixel + y1,    14,1,SRCOFFS_LORES + ((x AND 1) Shl 1),(Val AND $0F) Shl 4);
        CopySource(xPixel,yPixel + y1 + 8,14,1,SRCOFFS_LORES + ((x AND 1) Shl 1),Val AND $F0);
        Inc(y1,Step)
      End
    End;
    DWORD(Result) := 1
  End Else Result := false
End;

Function UpdateHiResCell( x, y, xPixel, yPixel, Offset : Integer ) : Bool;
Var Dirty    : Bool;
    yOffset  : Integer;
    ByteVal1 : Byte;
    ByteVal2 : Byte;
    ByteVal3 : Byte;

    Function COLOFFS : Word;
    Begin
      Result := ((ByteVal1 AND $60) Shl 2) OR ((ByteVal3 AND $03) Shl 5)
    End;

Begin
  Dirty   := false;
  yOffset := 0;
  While yOffset < $2000 do Begin
    If x >  0 then ByteVal1 := LPBYTE(DWord(HiresMainPtr) + Offset + Pred(yOffset))^ Else ByteVal1 := 0;
    ByteVal2 := LPBYTE(DWord(HiresMainPtr) + Offset + yOffset)^;
    If x < 39 then ByteVal3 := LPBYTE(DWord(HiresMainPtr) + Offset + Succ(yOffset))^ Else ByteVal3 := 0;
    If (ByteVal2 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset + $2000)^) or
       ((x >  0) and (ByteVal1 AND $60 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset + $1FFF)^ AND $60)) or
       ((x < 39) and (ByteVal3 AND $03 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset + $2001)^ AND $03)) or
       Redrawfull then Begin
      If not H_Scanlines then Begin
        CopySource(xPixel,yPixel + (yOffset Shr 9),14,2,SRCOFFS_HIRES + COLOFFS + ((x AND 1) Shl 4),Integer(ByteVal2) Shl 1)
      End Else Begin
        CopySource(xPixel,yPixel + (yOffset Shr 9),14,1,SRCOFFS_HIRES + COLOFFS + ((x AND 1) Shl 4),Integer(ByteVal2) Shl 1)
      End;  
      DWORD(Dirty) := 1
    End;
    Inc(yOffset,$400)
  End;
  DWORD(Result) := Abs(Ord(Dirty))
End;

Function UpdateDHiResCell( x, y, xPixel, yPixel, Offset : Integer ) : Bool;
Var Dirty    : Bool;
    yOffset  : Integer;
    ByteVal1 : Byte;
    ByteVal2 : Byte;
    ByteVal3 : Byte;
    ByteVal4 : Byte;
    DWordVal : DWord;
    PIXEL    : Byte;

    Function Color : Word;
    Begin
      Result := (xPixel + PIXEL) AND 3
    End;

    Function Value : Word;
    Begin
      Result := DWordVal Shr (4 + PIXEL - COLOR)
    End;

Begin
  Dirty   := false;
  yOffset := 0;
  While yOffset < $2000 do Begin
    If x >  0 then ByteVal1 := LPBYTE(DWord(HiresMainPtr) + Offset + Pred(yOffset))^ Else ByteVal1 := 0;
    ByteVal2 := LPBYTE(DWord(HiresAuxPtr)  + Offset + yOffset)^;
    ByteVal3 := LPBYTE(DWord(HiresMainPtr) + Offset + yOffset)^;
    If x < 39 then ByteVal4 := LPBYTE(DWord(HiresAuxPtr) + Offset + Succ(yOffset))^ Else ByteVal4 := 0;
    If (ByteVal2 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset)^) or
       (ByteVal3 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset + $2000)^) or
       ((x >  0) and (ByteVal1 AND $70 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset + $1FFF)^ AND $70)) or
       ((x < 39) and (ByteVal4 AND $07 <> LPBYTE(DWord(VidLastMem) + Offset + yOffset +     1)^ AND $07)) or
       RedrawFull then Begin
      DWordVal := (ByteVal1 AND $70) OR ((ByteVal2 AND $7F) Shl 7) OR ((ByteVal3 AND $7F) Shl 14) OR ((ByteVal4 AND $07) Shl 21);
      PIXEL := 0;
      If not H_Scanlines then Begin
        CopySource(xPixel + PIXEL,yPixel + (yOffset Shr 9),7,2,SRCOFFS_DHIRES + 10 * HiByte(VALUE) + COLOR,LoByte(VALUE) Shl 1);
        PIXEL := 7;
        CopySource(xPixel + PIXEL,yPixel + (yOffset Shr 9),7,2,SRCOFFS_DHIRES + 10 * HiByte(VALUE) + COLOR,LoByte(VALUE) Shl 1)
      End Else Begin
        CopySource(xPixel + PIXEL,yPixel + (yOffset Shr 9),7,1,SRCOFFS_DHIRES + 10 * HiByte(VALUE) + COLOR,LoByte(VALUE) Shl 1);
        PIXEL := 7;
        CopySource(xPixel + PIXEL,yPixel + (yOffset Shr 9),7,1,SRCOFFS_DHIRES + 10 * HiByte(VALUE) + COLOR,LoByte(VALUE) Shl 1)
      End;
      DWORD(Dirty) := 1
    End;
    Inc(yOffset,$400)
  End;
  DWORD(Result) := Abs(Ord(Dirty))
End;

Procedure SetLastDrawnImage;
Var Loop : Integer;
Begin
  Move(TextMainPtr^,LPBYTE(DWord(VidLastMem) + $0400)^,$0400);
  If Ok(SW_HIRES)  then Begin
    Move(HiresMainPtr^,LPBYTE(DWord(VidLastMem) + $2000)^,$2000)
  End;
  If Ok(SW_DHIRES) then Begin
    Move(HiresAuxPtr^,VidLastMem^,$2000)
  End Else If Ok(SW_80COL) then Begin
    Move(TextAuxPtr^,VidLastMem^,$0400)
  End;
  For Loop := 0 to 255 do Begin
    LPBYTE(DWord(MemDirty) + Loop)^ := LPBYTE(DWord(MemDirty) + Loop)^ AND NOT 2
  End
End;

Procedure VideoRefreshScreen;
Var Addr           : LPBYTE;
    Pitch          : LongInt;
    FrameDC        : hDC;
    Update         : UpdateType;
    AnyDirty       : Bool;
    Offset         : Integer;
    y,yPixel       : Integer;
    x,xPixel       : Integer;
    RemainingDirty : Bool;
    Start,StartX   : Integer;
    Height         : Integer;
    Loop           : Integer;
Begin
  Addr    := FrameBufferBits;
  Pitch   := 560;
  FrameDC := FrameGetVideoDC(@Addr,@Pitch);
  CreateFrameOffsetTable(Addr,Pitch);
  // CHECK EACH CELL FOR CHANGED BYTES.  REDRAW PIXELS FOR THE CHANGED BYTES
  // IN THE FRAME BUFFER.  MARK CELLS IN WHICH REDRAWING HAS TAKEN PLACE AS
  // DIRTY.
  HiresAuxPtr  := MemGetAuxPtr ($2000 Shl Abs(Ord(DisplayPage2)));
  HiresMainPtr := MemGetMainPtr($2000 Shl Abs(Ord(DisplayPage2)));
  TextAuxPtr   := MemGetAuxPtr ($400  Shl Abs(Ord(DisplayPage2)));
  TextMainPtr  := MemGetMainPtr($400  Shl Abs(Ord(DisplayPage2)));
  FillChar(CellDirty,40 * 32,#0);
  If Ok(SW_TEXT) then Begin
    If Ok(SW_80COL) then Begin
      Update := @Update80ColCell
    End Else Begin
      Update := @Update40ColCell
    End
  End Else Begin
    If Ok(SW_HIRES) then Begin
      If Ok(SW_DHIRES) and Ok(SW_80COL) then Begin
        Update := @UpdateDHiResCell
      End Else Begin
        Update := @UpdateHiResCell
      End
    End Else Begin
      Update := @UpdateLoResCell
    End
  End;
  AnyDirty := false;
  y        := 0;
  yPixel   := 0;
  While y < 20 do Begin
    Offset := ((y AND 7) Shl 7) + ((y Shr 3) * 40);
    x      := 0;
    xPixel := 0;
    While x < 40 do Begin
      CellDirty[x][y] := Abs(Ord(Update(x,y,xPixel,yPixel,Offset + x)));
      AnyDirty := AnyDirty OR Bool(CellDirty[x][y]);
      Inc(x);
      Inc(xPixel,14)
    End;
    Inc(y);
    Inc(yPixel,16)
  End;
  If Ok(SW_MIXED) then If Ok(SW_80COL) then Update := @Update80ColCell
                                       Else Update := @Update40ColCell;
  While y < 24 do Begin
    Offset := ((y AND 7) Shl 7) + ((y Shr 3) * 40);
    x      := 0;
    xPixel := 0;
    While x < 40 do Begin
      CellDirty[x][y] := Abs(Ord(Update(x,y,xPixel,yPixel,Offset + x)));
      AnyDirty := AnyDirty OR Bool(CellDirty[x][y]);
      Inc(x);
      Inc(xPixel,14)
    End;
    Inc(y);
    Inc(yPixel,16)
  End;
  If not Ok(FrameDC) or not AnyDirty then Begin
    FrameReleaseVideoDC();
    SetLastDrawnImage();
    RedrawFull := false;
    Exit
  End;
  // COPY DIRTY CELLS FROM THE DEVICE DEPENDENT BITMAP ONTO THE SCREEN
  // IN LONG HORIZONTAL RECTANGLES
  RemainingDirty := false;
  y              := 0;
  yPixel         := 0;
  While y < 24 do Begin
    Start  := -1;
    StartX := 0;
    x      := 0;
    xPixel := 0;
    While x < 40 do Begin
      If (x = 39) and Ok(CellDirty[x][y]) then If Start >= 0 then Begin
        Inc(xPixel,14);
        CellDirty[x][y] := 0
      End Else DWORD(RemainingDirty) := 1;
      If (Start >= 0) and not Ok(CellDirty[x][y]) then Begin
        If (x - StartX > 1) or ((x = 39) and (xPixel = 560)) then Begin
          Height := 1;
          While (y + Height < 24) and Ok(CellDirty[StartX][y + Height])
                                  and Ok(CellDirty[Pred(x)][y + Height])
                                  and Ok(CellDirty[(StartX + Pred(x)) Shr 1][y + Height]) do Inc(Height);
          BitBlt(FrameDC,Start,yPixel,xPixel - Start,Height Shl 4,DeviceDC,Start,yPixel,SRCCOPY);
          While Ok(Height) do Begin
            Dec(Height);
            Loop := StartX;
            While Loop < x + Abs(Ord(xPixel = 560)) do Begin
              CellDirty[Loop][y + Height] := 0;
              Inc(Loop)
            End
          End;
          Start := -1
        End Else DWORD(RemainingDirty) := 1;
        Start := -1
      End Else If (Start = -1) and Ok(CellDirty[x][y]) and (x < 39) then Begin
        Start  := xPixel;
        StartX := x
      End;
      Inc(x);
      Inc(xPixel,14)
    End;
    Inc(y);
    Inc(yPixel,16)
  End;
  // COPY ANY REMAINING DIRTY CELLS FROM THE DEVICE DEPENDENT BITMAP
  // ONTO THE SCREEN IN VERTICAL RECTANGLES
  If Ok(RemainingDirty) then Begin
    x      := 0;
    xPixel := 0;
    While x < 40 do Begin
      Start  := -1;
      y      := 0;
      yPixel := 0;
      While y < 24 do Begin
        If (y = 23) and Ok(CellDirty[x][y]) then Begin
          If Start = -1 then Start := yPixel;
          Inc(yPixel,16);
          CellDirty[x][y] := 0
        End;
        If (Start >= 0) and not Ok(CellDirty[x][y]) then Begin
          BitBlt(FrameDC,xPixel,Start,14,yPixel - Start,DeviceDC,xPixel,Start,SRCCOPY);
          Start := -1
        End Else If (Start = -1) and Ok(CellDirty[x][y]) then Start := yPixel;
        Inc(y);
        Inc(yPixel,16)
      End;
      Inc(x);
      Inc(xPixel,14)
    End
  End;
  GdiFlush();
  FrameReleaseVideoDC();
  SetLastDrawnImage();
  lFlash     := Flash;
  RedrawFull := false
End;

Procedure VideoRedrawScreen;
Begin
  DWORD(RedrawFull) := 1;
  VideoRefreshScreen()
End;

Procedure SETFRAMECOLOR(i,r,g,b : Byte);
Begin
  FrameBufferInfo^.bmiColors[i].rgbRed   := r;
  FrameBufferInfo^.bmiColors[i].rgbGreen := g;
  FrameBufferInfo^.bmiColors[i].rgbBlue  := b
End;

Procedure CreateIdentityPalette;
Var Window        : hWnd;
    DC            : hDC;
    MemDC         : hDC;
    Colors        : Integer;
    System        : Integer;
    LogoTable     : Array[0..255] of RGBQUAD;
    PalData       : pLOGPALETTE;
    PaletteIndex  : Integer;
    LogoIndex     : Integer;
    HalfToneIndex : Integer;
    OurIndex      : Integer;
    Loop          : Integer;
Begin
  If Ok(Palette) then DeleteObject(Palette);
  // SET SIX FRAME BUFFER TABLE ENTRIES TO OUR COLORS
  SETFRAMECOLOR(DEEP_RED,  $D0,$00,$30);
  SETFRAMECOLOR(LIGHT_BLUE,$60,$A0,$FF);
  SETFRAMECOLOR(BROWN,     $80,$50,$00);
  SETFRAMECOLOR(ORANGE,    $FF,$80,$00);
  SETFRAMECOLOR(PINK,      $FF,$90,$80);
  SETFRAMECOLOR(AQUA,      $40,$FF,$90);
  SETFRAMECOLOR(MONOCHROME,GetRValue(_Monochrome),GetGValue(_Monochrome),GetBValue(_Monochrome));
  // IF WE ARE IN A PALETTIZED VIDEO MODE, CREATE AN IDENTITY PALETTE
  Window := GetDesktopWindow();
  DC     := GetDC(Window);
  Colors := GetDeviceCaps(DC,SIZEPALETTE);
  System := GetDeviceCaps(DC,NUMCOLORS);
  If Ok(GetDeviceCaps(DC,RASTERCAPS) AND RC_PALETTE) and (Colors <= 256) then Begin
    // GET THE PALETTE ENTRIES OF THE LOGO
    FillChar(LogoTable,SizeOf(LogoTable),#0);
    If Ok(LogoBitmap) then Begin
      MemDC := CreateCompatibleDC(DC);
      SelectObject(MemDC,LogoBitmap);
      GetDIBColorTable(MemDC,0,Colors,LogoTable);
      DeleteDC(MemDC)
    End;
    // CREATE A PALETTE ENTRY ARRAY
    PalData := VirtualAlloc(Nil,SizeOf(LOGPALETTE) + 256 * SizeOf(PALETTEENTRY),MEM_COMMIT,PAGE_READWRITE);
    PalData^.palVersion    := $300;
    PalData^.palNumEntries := Colors;
    GetSystemPaletteEntries(DC,0,Colors,PalData^.palPalEntry);
    // FILL IN THE PALETTE ENTRIES
    PaletteIndex  := 0;
    LogoIndex     := 0;
    HalfToneIndex := 0;
    // COPY THE SYSTEM PALETTE ENTRIES AT THE BEGINNING OF THE PALETTE
    For PaletteIndex := 0 to Pred(System Div 2) do PalData^.palPalEntry[PaletteIndex].peFlags := 0;
    // FILL IN THE MIDDLE PORTION OF THE PALETTE WITH OUR OWN COLORS
    For OurIndex := DEEP_RED to MONOCHROME do Begin
      PalData^.palPalEntry[PaletteIndex].peRed   := FrameBufferInfo^.bmiColors[OurIndex].rgbRed;
      PalData^.palPalEntry[PaletteIndex].peGreen := FrameBufferInfo^.bmiColors[OurIndex].rgbGreen;
      PalData^.palPalEntry[PaletteIndex].peBlue  := FrameBufferInfo^.bmiColors[OurIndex].rgbBlue;
      PalData^.palPalEntry[PaletteIndex].peFlags := PC_NOCOLLAPSE;
      Inc(PaletteIndex)
    End;
    For PaletteIndex := 0 to Pred(Colors - System Div 2) do Begin
      // IF THIS PALETTE ENTRY IS NEEDED FOR THE LOGO, COPY IN THE LOGO COLOR
      If Ok(LogoTable[LogoIndex].rgbRed) and Ok(LogoTable[LogoIndex].rgbGreen) and Ok(LogoTable[LogoIndex].rgbBlue) then Begin
        PalData^.palPalEntry[PaletteIndex].peRed   := LogoTable[LogoIndex].rgbRed;
        PalData^.palPalEntry[PaletteIndex].peGreen := LogoTable[LogoIndex].rgbGreen;
        PalData^.palPalEntry[PaletteIndex].peBlue  := LogoTable[LogoIndex].rgbBlue
      End Else Begin
      // OTHERWISE, ADD A HALFTONING COLOR, SO THAT OTHER APPLICATIONS
      // RUNNING IN THE BACKGROUND WILL HAVE SOME REASONABLE COLORS TO USE
        PalData^.palPalEntry[PaletteIndex].peRed   := HalfToneTable[HalfToneIndex        Mod 6];
        PalData^.palPalEntry[PaletteIndex].peGreen := HalfToneTable[HalfToneIndex Div  6 Mod 6];
        PalData^.palPalEntry[PaletteIndex].peBlue  := HalfToneTable[HalfToneIndex Div 36 Mod 6];
        Inc(HalfToneIndex)
      End;
      Inc(LogoIndex);
      PalData^.palPalEntry[PaletteIndex].peFlags := PC_NOCOLLAPSE
    End;
    // COPY THE SYSTEM PALETTE ENTRIES AT THE END OF THE PALETTE
    For PaletteIndex := 0 to Pred(Colors) do PalData^.palPalEntry[PaletteIndex].peFlags := 0;
    // FILL THE FRAME BUFFER TABLE WITH COLORS FROM OUR PALETTE
    For Loop := 0 to Pred(Colors) do Begin
      FrameBufferInfo^.bmiColors[Loop].rgbRed   := PalData^.palPalEntry[Loop].peRed;
      FrameBufferInfo^.bmiColors[Loop].rgbGreen := PalData^.palPalEntry[Loop].peGreen;
      FrameBufferInfo^.bmiColors[Loop].rgbBlue  := PalData^.palPalEntry[Loop].peBlue
    End;
    // CREATE THE PALETTE
    Palette := CreatePalette(PalData^);
    VirtualFree(PalData,0,MEM_RELEASE)
  End Else Begin
  // OTHERWISE, FILL THE FRAME BUFFER TABLE WITH THE STANDARD WINDOWS COLORS
    SETFRAMECOLOR(BLACK,       $00,$00,$00);
    SETFRAMECOLOR(DARK_RED,    $80,$00,$00);
    SETFRAMECOLOR(DARK_GREEN,  $00,$80,$00);
    SETFRAMECOLOR(DARK_YELLOW, $80,$80,$00);
    SETFRAMECOLOR(DARK_BLUE,   $00,$00,$80);
    SETFRAMECOLOR(DARK_MAGENTA,$80,$00,$80);
    SETFRAMECOLOR(DARK_CYAN,   $00,$80,$80);
    SETFRAMECOLOR(LIGHT_GRAY,  $C0,$C0,$C0);
    SETFRAMECOLOR(MONEY_GREEN, $C0,$DC,$C0);
    SETFRAMECOLOR(SKY_BLUE,    $A6,$CA,$F0);
    SETFRAMECOLOR(CREAM,       $FF,$FB,$F0);
    SETFRAMECOLOR(MEDIUM_GRAY, $A0,$A0,$A4);
    SETFRAMECOLOR(DARK_GRAY,   $80,$80,$80);
    SETFRAMECOLOR(RED,         $FF,$00,$00);
    SETFRAMECOLOR(GREEN,       $00,$FF,$00);
    SETFRAMECOLOR(YELLOW,      $FF,$FF,$00);
    SETFRAMECOLOR(BLUE,        $00,$00,$FF);
    SETFRAMECOLOR(MAGENTA,     $FF,$00,$FF);
    SETFRAMECOLOR(CYAN,        $00,$FF,$FF);
    SETFRAMECOLOR(WHITE,       $FF,$FF,$FF);
    Palette := hPalette(0)
  End;
  ReleaseDC(Window,DC)
End;

Procedure DrawTextSource( DC : hDC );
Var MemDC  : hDC;
    Bitmap : hBitmap;
    Brush  : hBrush;
Begin
  MemDC  := CreateCompatibleDC(DC);
  Bitmap := LoadBitmap(Instance,'CHARSET40');
  Brush  := CreateSolidBrush(_Monochrome);
  SelectObject(MemDC,Bitmap);
  SelectObject(DC,Brush);
  BitBlt(DC,SRCOFFS_40COL,0,256,512,MemDC,0,0,MERGECOPY);
  StretchBlt(DC,SRCOFFS_80COL,0,128,512,MemDC,0,0,256,512,MERGECOPY);
  SelectObject(DC,GetStockObject(NULL_BRUSH));
  DeleteObject(Brush);
  DeleteDC(MemDC);
  DeleteObject(Bitmap)
End;

Procedure SETSOURCEPIXEL(x,y : Integer; c : Byte);
Begin
  LPBYTE(DWord(SourceOffsetTable[y]) + x)^ := c
End;

Procedure DrawLoResSource;
Var ColorVal : Array[0..15] of Byte;
    Color    : Integer;
    x,y      : Integer;
Begin
  ColorVal[00] := BLACK;
  ColorVal[01] := DEEP_RED;
  ColorVal[02] := DARK_BLUE;
  ColorVal[03] := MAGENTA;
  ColorVal[04] := DARK_GREEN;
  ColorVal[05] := DARK_GRAY;
  ColorVal[06] := BLUE;
  ColorVal[07] := LIGHT_BLUE;
  ColorVal[08] := BROWN;
  ColorVal[09] := ORANGE;
  ColorVal[10] := LIGHT_GRAY;
  ColorVal[11] := PINK;
  ColorVal[12] := GREEN;
  ColorVal[13] := YELLOW;
  ColorVal[14] := AQUA;
  ColorVal[15] := WHITE;
  For Color := 0 to 15 do For x := 0 to 15 do For y := 0 to 15 do Begin
    SETSOURCEPIXEL(SRCOFFS_LORES + x,(Color Shl 4) + y,ColorVal[Color])
  End
End;

Procedure DrawHiResSource;
Var ColorVal : Array[0..5]  of Byte;
    PixelOn  : Array[0..10] of Bool;
    Column   : Integer;
    ColOffs  : Integer;
    ByteVal  : Byte;
    BitVal   : Integer;
    Pixel    : Integer;
    HiBit    : Integer;
    x,y      : Integer;
    Adj,Odd  : Integer;
    Color    : Integer;
Begin
  ColorVal[0] := MAGENTA;
  ColorVal[1] := BLUE;
  ColorVal[2] := GREEN;
  ColorVal[3] := ORANGE;
  ColorVal[4] := BLACK;
  ColorVal[5] := WHITE;
  For Column := 0 to 15 do Begin
    ColOffs := Column Shl 5;
    For ByteVal := 0 to 255 do Begin
      DWORD(PixelOn[ 0]) := Column AND 4;
      DWORD(PixelOn[ 1]) := Column AND 8;
      DWORD(PixelOn[ 9]) := Column AND 1;
      DWORD(PixelOn[10]) := Column AND 2;
      BitVal := 1;
      For Pixel := 2 to 8 do Begin
        DWORD(PixelOn[Pixel]) := Abs(Ord((ByteVal AND BitVal) <> 0));
        BitVal := BitVal Shl 1
      End;
      HiBit := Abs(Ord((ByteVal AND $80) <> 0));
      x     := 0;
      y     := ByteVal Shl 1;
      While x < 28 do Begin
        Adj := Abs(Ord(x >= 14)) Shl 1;
        Odd := Abs(Ord(x >= 14));
        For Pixel := 2 to 8 do Begin
          Color := 4;
          If PixelOn[Pixel] then Begin
            If PixelOn[Pred(Pixel)] or PixelOn[Succ(Pixel)] then Begin
              Color := 5
            End Else Begin
              Color := ((Odd XOR (Pixel AND 1)) Shl 1) OR HiBit
            End
          End Else If PixelOn[Pred(Pixel)] and PixelOn[Succ(Pixel)] then Begin
            If (VideoType = 1) or not (PixelOn[Pixel - 2] and PixelOn[Pixel + 2]) then
              Color := ((Odd XOR Ord(not Ok(Pixel AND 1))) Shl 1) OR HiBit
          End;
          SETSOURCEPIXEL(SRCOFFS_HIRES + ColOffs + x + adj    ,y    ,ColorVal[Color]);
          SETSOURCEPIXEL(SRCOFFS_HIRES + ColOffs + x + adj + 1,y    ,ColorVal[Color]);
          SETSOURCEPIXEL(SRCOFFS_HIRES + ColOffs + x + adj    ,y + 1,ColorVal[Color]);
          SETSOURCEPIXEL(SRCOFFS_HIRES + ColOffs + x + adj + 1,y + 1,ColorVal[Color]);
          Inc(x,2)
        End
      End
    End
  End
End;

Procedure DrawDHiResSource;
Const OFFSET     =  3;
      SIZE       = 10;
Var   ColorVal   : Array[0..15]         of Byte;
      Color      : Array[0..Pred(SIZE)] of Integer;
      Column     : Integer;
      ColOffs    : Integer;
      ByteVal    : Byte;
      Pattern    : Word;
      Pixel      : Integer;
      PixelColor : Integer;
      Pos        : Integer;
      x,y        : Integer;
Begin
  ColorVal[00] := BLACK;
  ColorVal[01] := DARK_BLUE;
  ColorVal[02] := DARK_GREEN;
  ColorVal[03] := BLUE;
  ColorVal[04] := BROWN;
  ColorVal[05] := LIGHT_GRAY;
  ColorVal[06] := GREEN;
  ColorVal[07] := AQUA;
  ColorVal[08] := DEEP_RED;
  ColorVal[09] := MAGENTA;
  ColorVal[10] := DARK_GRAY;
  ColorVal[11] := LIGHT_BLUE;
  ColorVal[12] := ORANGE;
  ColorVal[13] := PINK;
  ColorVal[14] := YELLOW;
  ColorVal[15] := WHITE;
  For Column := 0 to 255 do Begin
    ColOffs := SIZE * Column;
    For ByteVal := 0 to 255 do Begin
      FillChar(Color,SizeOf(Color),#0);
      Pattern := MAKEWORD(ByteVal,Column);
      For Pixel := 1 to 14 do Begin
        If Ok(Pattern AND (1 Shl Pixel)) then Begin
          PixelColor := 1 Shl ((Pixel - OFFSET) AND 3);
          If (Pixel >=  OFFSET + 2) and (Pixel < SIZE + OFFSET + 2) and Ok(Pattern AND ($7 Shl (Pixel - 4))) then
            Color[Pixel - (OFFSET + 2)] := Color[Pixel - (OFFSET + 2)] OR PixelColor;
          If (Pixel >=  OFFSET + 1) and (Pixel < SIZE + OFFSET + 1) and Ok(Pattern AND ($F Shl (Pixel - 4))) then
            Color[Pixel - (OFFSET + 1)] := Color[Pixel - (OFFSET + 1)] OR PixelColor;
          If (Pixel >=  OFFSET + 0) and (Pixel < SIZE + OFFSET + 0) then
            Color[Pixel - (OFFSET + 0)] := Color[Pixel - (OFFSET + 0)] OR PixelColor;
          If (Pixel >=  OFFSET - 1) and (Pixel < SIZE + OFFSET - 1) and Ok(Pattern AND ($F Shl (Pixel + 1))) then
            Color[Pixel - (OFFSET - 1)] := Color[Pixel - (OFFSET - 1)] OR PixelColor;
          If (Pixel >=  OFFSET - 2) and (Pixel < SIZE + OFFSET - 2) and Ok(Pattern AND ($7 Shl (Pixel + 2))) then
            Color[Pixel - (OFFSET - 2)] := Color[Pixel - (OFFSET - 2)] OR PixelColor
        End
      End;
      If VideoType = 2 then Begin
        For Pixel := 0 to 12 do Begin
          If Pattern AND ($0F Shl Pixel) = $0F Shl Pixel then
            For Pos := Pixel to Pred(Pixel) + 4 do
              If (Pos >= OFFSET) and (Pos < SIZE + OFFSET) then Color[Pos - OFFSET] := 15
        End
      End;
      y := ByteVal Shl 1;
      For x := 0 to Pred(SIZE) do Begin
        SETSOURCEPIXEL(SRCOFFS_DHIRES + ColOffs + x,y    ,ColorVal[Color[x]]);
        SETSOURCEPIXEL(SRCOFFS_DHIRES + ColOffs + x,y + 1,ColorVal[Color[x]])
      End
    End
  End
End;

Procedure DrawMonoTextSource(DC : hDC);
Var MemDC  : hDC;
    Bitmap : hBitmap;
    Brush  : hBrush;
Begin
  MemDC  := CreateCompatibleDC(DC);
  Bitmap := LoadBitmap(Instance,'CHARSET40');
  Brush  := CreateSolidBrush(_Monochrome);
  SelectObject(MemDC,Bitmap);
  SelectObject(DC,Brush);
  BitBlt(DC,SRCOFFS_40COL,0,256,512,MemDC,0,0,MERGECOPY);
  StretchBlt(DC,SRCOFFS_80COL,0,128,512,MemDC,0,0,256,512,MERGECOPY);
  SelectObject(DC,GetStockObject(NULL_BRUSH));
  DeleteObject(Brush);
  DeleteDC(MemDC);
  DeleteObject(Bitmap)
End;

Procedure DrawMonoLoResSource;
Var Color    : Integer;
    X,Y      : Integer;
    ColorVal : Byte;
Begin
  For Color := 0 to 15 do For X := 0 to 15 do For Y := 0 to 15 do Begin
    If Ok(Color Shr (X AND 3) AND 1) then ColorVal := MONOCHROME Else ColorVal := BLACK;
    SETSOURCEPIXEL(SRCOFFS_LORES + X,(Color Shl 4) + Y,ColorVal)
  End
End;

Procedure DrawMonoHiResSource;
Var Column   : Integer;
    X,Y      : Integer;
    Val      : Word;
    ColorVal : Byte;
Begin
  Column := 0;
  While Column < 512 do Begin
    Y := 0;
    While Y < 512 do Begin
      Val := Y Shr 1;
      X := 0;
      While X < 16 do Begin
        If Ok(Val AND 1) then ColorVal := MONOCHROME Else ColorVal := BLACK;
        Val := Val Shr 1;
        SETSOURCEPIXEL(SRCOFFS_HIRES + Column + x    ,Y    ,ColorVal);
        SETSOURCEPIXEL(SRCOFFS_HIRES + Column + x + 1,Y    ,ColorVal);
        SETSOURCEPIXEL(SRCOFFS_HIRES + Column + x    ,Y + 1,ColorVal);
        SETSOURCEPIXEL(SRCOFFS_HIRES + Column + x + 1,Y + 1,ColorVal);
        Inc(X,2)
      End;
      Inc(Y,2)
    End;
    Inc(Column,16)
  End
End;

Procedure DrawMonoDHiResSource;
Var Column   : Integer;
    ColOffs  : Integer;
    ByteVal  : Word;
    Pattern  : Word;
    X,Y      : Integer;
    ColorVal : Byte;
Begin
  For Column := 0 to 255 do Begin
    ColOffs := 10 * Column;
    For ByteVal := 0 to 255 do Begin
      Pattern := MAKEWORD(ByteVal,Column);
      Y       := ByteVal Shl 1;
      For X := 0 to 9 do Begin
        If Ok(Pattern AND (1 Shl (X + 3))) then ColorVal := MONOCHROME Else ColorVal := BLACK;
        SETSOURCEPIXEL(SRCOFFS_DHIRES + ColOffs + X,Y    ,ColorVal);
        SETSOURCEPIXEL(SRCOFFS_DHIRES + ColOffs + X,Y + 1,ColorVal)
      End
    End
  End
End;

Procedure CreateDIBSections;
Var Window   : hWnd;
    DC       : hDC;
    SourceDC : hDC;
    Loop     : Integer;
Begin
  CopyMemory(@SourceInfo^.bmiColors,@FramebufferInfo^.bmiColors,256 * SizeOf(RGBQUAD));
  // CREATE THE DEVICE CONTEXT
  Window  := GetDesktopWindow();
  DC      := GetDC(Window);
  If Ok(DeviceDC) then DeleteDC(DeviceDC);
  DeviceDC := CreateCompatibleDC(DC);
  // CREATE THE FRAME BUFFER DIB SECTION
  If Ok(DeviceBitmap) then DeleteObject(DeviceBitmap);
  DeviceBitmap := CreateDIBSection(DC,FrameBufferInfo^,DIB_RGB_COLORS,Pointer(FrameBufferBits),0,0);
  SelectObject(DeviceDC,DeviceBitmap);
  // CREATE THE SOURCE IMAGE DIB SECTION
  SourceDC := CreateCompatibleDC(DC);
  ReleaseDC(Window,DC);
  If Ok(SourceBitmap) then DeleteObject(SourceBitmap);
  SourceBitmap := CreateDIBSection(SourceDC,SourceInfo^,DIB_RGB_COLORS,Pointer(SourceBits),0,0);
  SelectObject(SourceDC,SourceBitmap);
  // CREATE THE OFFSET TABLE FOR EACH SCAN LINE IN THE SOURCE IMAGE
  For Loop := 0 to 511 do SourceOffsetTable[Loop] := LPBYTE(DWord(SourceBits) + SRCOFFS_TOTAL * (511 - Loop));
  // DRAW THE SOURCE IMAGE INTO THE SOURCE BIT BUFFER
  FillChar(SourceBits^,SRCOFFS_TOTAL * 512,#0);
  If Ok(VideoType) then Begin
    DrawTextSource(SourceDC);
    DrawLoResSource();
    DrawHiResSource();
    DrawDHiResSource()
  End Else Begin
    DrawMonoTextSource(SourceDC);
    DrawMonoLoResSource();
    DrawMonoHiResSource();
    DrawMonoDHiResSource()
  End;
  DeleteDC(SourceDC)
End;

Procedure VideoResetState;
Begin
  CharOffs     := 0;
  DisplayPage2 := false;
  VidMode      := VF_TEXT;
  DWORD(RedrawFull) := 1
End;

Procedure VideoInitialize;
Var Filename : Array[0..Pred(MAX_PATH)] of Char;
    Index    : Integer;
Begin
  // CREATE A BUFFER FOR AN IMAGE OF THE LAST DRAWN MEMORY
  VidLastMem := LPBYTE(VirtualAlloc(Nil,$10000,MEM_COMMIT,PAGE_READWRITE));
  FillChar(VidLastMem^,$10000,#0);
  // LOAD THE LOGO
  StrCopy(Filename,ProgDir);
  StrCat(Filename,'APPLEWIN.BMP');
  LogoBitmap := hBitMap(LoadImage(0,Filename,IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION OR LR_LOADFROMFILE));
  // CREATE A BITMAPINFO STRUCTURE FOR THE FRAME BUFFER
  FrameBufferInfo := LPBITMAPINFO(VirtualAlloc(Nil,SizeOf(BITMAPINFOHEADER) + 256 * SizeOf(RGBQUAD),MEM_COMMIT,PAGE_READWRITE));
  FillChar(FrameBufferInfo^,SizeOf(BITMAPINFOHEADER) + 256 * SizeOf(RGBQUAD),#0);
  FrameBufferInfo^.bmiHeader.biSize     := SizeOf(BITMAPINFOHEADER);
  FrameBufferInfo^.bmiHeader.biWidth    := 560;
  FrameBufferInfo^.bmiHeader.biHeight   := 384;
  FrameBufferInfo^.bmiHeader.biPlanes   := 1;
  FrameBufferInfo^.bmiHeader.biBitCount := 8;
  FrameBufferInfo^.bmiHeader.biClrUsed  := 256;
  // CREATE A BITMAPINFO STRUCTURE FOR THE SOURCE IMAGE
  SourceInfo := LPBITMAPINFO(VirtualAlloc(Nil,SizeOf(BITMAPINFOHEADER) + 256 * SizeOf(RGBQUAD),MEM_COMMIT,PAGE_READWRITE));
  FillChar(SourceInfo^,SizeOf(BITMAPINFOHEADER),#0);
  SourceInfo^.bmiHeader.biSize     := SizeOf(BITMAPINFOHEADER);
  SourceInfo^.bmiHeader.biWidth    := SRCOFFS_TOTAL;
  SourceInfo^.bmiHeader.biHeight   := 512;
  SourceInfo^.bmiHeader.biPlanes   := 1;
  SourceInfo^.bmiHeader.biBitCount := 8;
  SourceInfo^.bmiHeader.biClrUsed  := 256;
  // CREATE AN IDENTITY PALETTE AND FILL IN THE CORRESPONDING COLORS IN
  // THE BITMAPINFO STRUCTURE
  CreateIdentityPalette();
  // PREFILL THE 16 CUSTOM COLORS AND MAKE SURE TO INCLUDE THE CURRENT MONOCHROME COLOR
  For Index := DARK_RED to MONOCHROME do Begin
    CustomColors[Index - DARK_RED] := RGB(FrameBufferInfo^.bmiColors[Index].rgbRed,
                                          FrameBufferInfo^.bmiColors[Index].rgbGreen,
                                          FrameBufferInfo^.bmiColors[Index].rgbBlue)
  End;
  // CREATE THE FRAME BUFFER DIB SECTION AND DEVICE CONTEXT,
  // CREATE THE SOURCE IMAGE DIB SECTION AND DRAW INTO THE SOURCE BIT BUFFER
  CreateDIBSections();
  // RESET THE VIDEO MODE SWITCHES AND THE CHARACTER SET OFFSET
  VideoResetState()
End;

Procedure VideoUpdateVbl( Cycles : DWord; NearRefresh : Bool );
Begin
  If Ok(VblCounter) then Dec(VblCounter,MIN(VblCounter,Cycles Shr 6))
                    Else If not Ok(NearRefresh) then VblCounter := 250
End;

Procedure VideoCheckPage( Force : Boolean );
Begin
  If (DisplayPage2 <> (SW_PAGE2 <> 0)) and (Force or (EmulMSec - LastPageFlip > 500)) then Begin
    DWORD(DisplayPage2) := Abs(Ord(SW_PAGE2 <> 0));
    VideoRefreshScreen();
    DWORD(HasRefreshed) := 1;
    LastPageFlip := EmulMSec
  End
End;

Function VideoHasRefreshed : Bool;
Begin
  Result := HasRefreshed;
  HasRefreshed := false
End;

Function VideoApparentlyDirty : Bool;
Var Address : DWord;
    Length  : DWord;
Begin
  If Ok(SW_MIXED) or RedrawFull then Begin
    DWORD(Result) := 1;
    Exit
  End;
  If Ok(SW_HIRES) and not Ok(SW_TEXT) then Begin
    Address := $20 Shl Abs(Ord(DisplayPage2));
    Length  := $20
  End Else Begin
    Address := $04 Shl Abs(Ord(DisplayPage2));
    Length  := $04
  End;
  While Ok(Length) do Begin
    Dec(Length);
    If Ok(LPBYTE(DWord(MemDirty) + Address)^ AND 2) then Begin
      Inc(Address);
      DWORD(Result) := 1;
      Exit
    End;
    Inc(Address)
  End;
  Result := false
End;

Procedure VideoReinitialize;
Begin
  CreateIdentityPalette();
  CreateDIBSections();
End;

Function VideoChooseColor( myColor : COLORREF ) : COLORREF;
Var CC : tChooseColor;
Begin
  FillChar(CC,SizeOf(tChooseColor),#0);
  CC.lStructSize     := SizeOf(tChooseColor);
  CC.hwndOwner       := FrameWindow;
  CC.rgbResult       := myColor;
  CC.lpCustColors    := @CustomColors;
  CC.Flags           := CC_RGBINIT OR CC_SOLIDCOLOR;
  If Ok(ChooseColor(CC)) then Result := CC.rgbResult Else Result := myColor
End;

Procedure VideoDestroy;
Begin
  // DESTROY BUFFERS
  VirtualFree(FrameBufferInfo,0,MEM_RELEASE);
  VirtualFree(SourceInfo     ,0,MEM_RELEASE);
  VirtualFree(VidLastMem     ,0,MEM_RELEASE);
  FrameBufferInfo := Nil;
  SourceInfo      := Nil;
  VidLastMem      := Nil;
  // DESTROY FRAME BUFFER
  DeleteDC(DeviceDC);
  DeleteObject(DeviceBitmap);
  DeviceDC     := hDC(0);
  DeviceBitmap := hBitmap(0);
  // DESTROY SOURCE IMAGE
  DeleteObject(SourceBitmap);
  SourceBitmap := hBitmap(0);
  // DESTROY LOGO
  If Ok(LogoBitmap) then Begin
    DeleteObject(LogoBitmap);
    LogoBitmap := hBitmap(0)
  End;
  // DESTROY PALETTE
  If Ok(Palette) then Begin
    DeleteObject(Palette);
    Palette := hPalette(0)
  End
End;

Procedure VideoRealizePalette( DC : hDC );
Begin
  If Ok(Palette) then Begin
    SelectPalette(DC,Palette,false);
    RealizePalette(DC)
  End
End;

Procedure VideoDisplayLogo;
Var FrameDC : hDC;
    MemDC   : hDC;
    Brush   : hBrush;
    Font    : hFont;
    sFont   : hFont;

    Procedure DRAWVERSION(x,y : Integer;c : COLORREF);
    Begin
      SetTextColor(FrameDC,c);
      TextOut(FrameDC,540 + x,358 + y,'Version ' + VERSIONSTRING,StrLen('Version ' + VERSIONSTRING))
    End;

    Procedure DRAWPORTED(x,y : Integer;c : COLORREF);
    Begin
      SetTextColor(FrameDC,c);
      TextOut(FrameDC,5   + x,3 + y,'Delphi version ported by:',25);
      TextOut(FrameDC,340 + x,3 + y,'Ingo-Willy Raddatz',18)
    End;

Begin
  FrameDC := FrameGetDC();
  // DRAW THE LOGO
  Brush := CreateSolidBrush(PALETTERGB($70,$30,$E0));
  If Ok(LogoBitmap) then Begin
    MemDC := CreateCompatibleDC(FrameDC);
    SelectObject(MemDC,LogoBitmap);
    BitBlt(FrameDC,0,0,560,384,MemDC,0,0,SRCCOPY);
    DeleteDC(MemDC)
  End Else Begin
    SelectObject(FrameDC,Brush);
    SelectObject(FrameDC,GetStockObject(NULL_PEN));
    Rectangle(FrameDC,0,0,560 + 1,384 + 1)
  End;
  // DRAW THE VERSION NUMBER
  Font := CreateFont(-20,0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
                     VARIABLE_PITCH OR 4 OR FF_SWISS,'Arial');
  sFont := CreateFont(-24,0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
                     VARIABLE_PITCH OR 4 OR FF_SWISS,'Arial');
  SelectObject(FrameDC,Font);
  SetTextAlign(FrameDC,TA_RIGHT OR TA_TOP);
  SetBkMode(FrameDC,TRANSPARENT);
  If GetDeviceCaps(FrameDC,PLANES) * GetDeviceCaps(FrameDC,BITSPIXEL) <= 4 then Begin
    DRAWVERSION( 2, 2,RGB($00,$00,$00));
    DRAWVERSION( 1, 1,RGB($00,$00,$00));
    DRAWVERSION( 0, 0,RGB($FF,$00,$FF));
    SelectObject(FrameDC,sFont);
    SetTextAlign(FrameDC,TA_LEFT OR TA_TOP);
    DRAWPORTED(  2,  2,RGB($00,$00,$00));
    DRAWPORTED(  1,  1,RGB($00,$00,$00));
    DRAWPORTED(  0,  0,RGB($FF,$00,$FF))
  End Else Begin
    DRAWVERSION( 1, 1,PALETTERGB($30,$30,$70));
    DRAWVERSION(-1,-1,PALETTERGB($C0,$70,$E0));
    DRAWVERSION( 0, 0,PALETTERGB($70,$30,$E0));
    SelectObject(FrameDC,sFont);
    SetTextAlign(FrameDC,TA_LEFT OR TA_TOP);
    DRAWPORTED(  1,  1,PALETTERGB($30,$30,$70));
    DRAWPORTED( -1, -1,PALETTERGB($C0,$70,$E0));
    DRAWPORTED(  0,  0,PALETTERGB($70,$30,$E0))
  End;
  FrameReleaseDC();
  DeleteObject(Brush);
  DeleteObject(Font)
End;

Procedure VideoBenchmark;
Var Loop           : Integer;
    Cycles         : Integer;
    LastPC         : Word;
    Mem32          : LPDWORD;
    Error          : Bool;
    TotalTextFps   : DWord;
    MilliSeconds   : DWord;
    Cycle          : DWord;
    TotalHiresFps  : DWord;
    TotalMhz10     : DWord;
    RealisticFps   : DWord;
    ExecutedCycles : DWord;
    OutStr         : Array[0..255] of Char;
Begin
  Sleep(500);
  // PREPARE TWO DIFFERENT FRAME BUFFERS, EACH OF WHICH HAVE HALF OF THE
  // BYTES SET TO 0x14 AND THE OTHER HALF SET TO 0xAA
  Mem32 := LPDWORD(Mem);
  For Loop := 4096 to 6143 do If Ok((Loop AND 1) XOR ((Loop AND $40) Shr 6)) then
    LPDWORD(DWord(@Mem32) + Loop)^ := $14141414 Else LPDWORD(DWord(@Mem32) + Loop)^ := $AAAAAAAA;
  For Loop := 6144 to 8191 do If Ok((Loop AND 1) XOR ((Loop AND $40) Shr 6)) then
    LPDWORD(DWord(@Mem32) + Loop)^ := $AAAAAAAA Else LPDWORD(DWord(@Mem32) + Loop)^ := $14141414;
  // SEE HOW MANY TEXT FRAMES PER SECOND WE CAN PRODUCE WITH NOTHING ELSE
  // GOING ON, CHANGING HALF OF THE BYTES IN THE VIDEO BUFFER EACH FRAME TO
  // SIMULATE THE ACTIVITY OF AN AVERAGE GAME
  TotalTextFps := 0;
  VidMode := VF_TEXT;
  FillMemory(Ptr(DWord(@Mem) + $400),$400,$14);
  VideoRedrawScreen();
  MilliSeconds := GetTickCount();
  While GetTickCount() = MilliSeconds do;
  MilliSeconds := GetTickCount();
  Cycle := 0;
  Repeat
    If Ok(Cycle AND 1) then FillMemory(Ptr(DWord(@Mem) + $400),$400,$14)
                         Else If Ok(Cycle AND 2) then CopyMemory(Ptr(DWord(@Mem) + $400),Ptr(DWord(@Mem) + $4000),$400)
                                                 Else CopyMemory(Ptr(DWord(@Mem) + $400),Ptr(DWord(@Mem) + $6000),$400);
    VideoRefreshScreen();
    If Cycle >= 3 then Cycle := 0 Else Inc(Cycle);
    Inc(TotalTextFps)
  Until not (GetTickCount() - MilliSeconds < 1000);
  // SEE HOW MANY HIRES FRAMES PER SECOND WE CAN PRODUCE WITH NOTHING ELSE
  // GOING ON, CHANGING HALF OF THE BYTES IN THE VIDEO BUFFER EACH FRAME TO
  // SIMULATE THE ACTIVITY OF AN AVERAGE GAME
  TotalHiresFps := 0;
  VidMode := VF_HIRES;
  FillMemory(Ptr(DWord(@mem) + $2000),$2000,$14);
  VideoRedrawScreen();
  MilliSeconds := GetTickCount();
  While GetTickCount() = MilliSeconds do;
  MilliSeconds := GetTickCount();
  Cycle := 0;
  Repeat
    If Ok(Cycle AND 1) then FillMemory(Ptr(DWord(@Mem) + $2000),$2000,$14)
                       Else If Ok(Cycle AND 2) then CopyMemory(Ptr(DWord(@Mem) + $2000),Ptr(DWord(@Mem) + $4000),$2000)
                                               Else CopyMemory(Ptr(DWord(@Mem) + $2000),Ptr(DWord(@Mem) + $6000),$2000);
    VideoRefreshScreen();
    If Cycle >= 3 then Cycle := 0 Else Inc(Cycle);
    Inc(TotalHiresFps)
  Until not (GetTickCount() - MilliSeconds < 1000);
  // DETERMINE HOW MANY 65C02 CLOCK CYCLES WE CAN EMULATE PER SECOND WITH
  // NOTHING ELSE GOING ON
  CpuSetupBenchmark();
  TotalMhz10 := 0;
  MilliSeconds := GetTickCount();
  While GetTickCount() = MilliSeconds do;
  MilliSeconds := GetTickCount();
  Cycle := 0;
  Repeat
    CpuExecute(100000);
    Inc(TotalMhz10)
  Until not (GetTickCount() - MilliSeconds < 1000);
  // IF THE PROGRAM COUNTER IS NOT IN THE EXPECTED RANGE AT THE END OF THE
  // CPU BENCHMARK, REPORT AN ERROR AND OPTIONALLY TRACK IT DOWN
  If (Regs.PC < $300) or (Regs.PC > $400) then If MessageBox(FrameWindow,
                                                             'The emulator has detected a problem while running '+
                                                             'the CPU benchmark.  Would you like to gather more '+
                                                             'information?',
                                                             'Benchmarks',
                                                             MB_ICONQUESTION OR MB_YESNO OR MB_SETFOREGROUND) = IDYES then Begin
    Error  := false;
    LastPC := $300;
    Loop   := 0;
    While (Loop < 10000) and not Ok(Error) do Begin
      CpuSetupBenchmark();
      CpuExecute(loop);
      If (Regs.PC < $300) or (Regs.PC > $400) then Begin
        DWORD(Error) := 1
      End Else Begin
        Lastpc := Regs.PC;
        Inc(Loop)
      End
    End;
    If Ok(Error) then Begin
      OutStr := 'The emulator experienced an error %u clock cycles into the CPU benchmark.  Prior to the error, the '+
                'program counter was at $%04X.  After the error, it had jumped to $%04X.';
      Format(OutStr,[Word(Loop),Word(LastPC),Word(Regs.PC)]);
      MessageBox(FrameWindow,Outstr,'Benchmarks',MB_ICONINFORMATION OR MB_SETFOREGROUND)
    End Else Begin
      MessageBox(FrameWindow,'The emulator was unable to locate the exact '+
                             'point of the error.  This probably means that '+
                             'the problem is external to the emulator, '+
                             'happening asynchronously, such as a problem in '+
                             'a timer interrupt handler.',
                             'Benchmarks',
                 MB_ICONINFORMATION OR MB_SETFOREGROUND)
    End
  End;
  // DO A REALISTIC TEST OF HOW MANY FRAMES PER SECOND WE CAN PRODUCE
  // WITH FULL EMULATION OF THE CPU, JOYSTICK, AND DISK HAPPENING AT
  // THE SAME TIME
  RealisticFps := 0;
  FillMemory(Ptr(DWord(@Mem) + $2000),$2000,$AA);
  VideoRedrawScreen();
  MilliSeconds := GetTickCount();
  While GetTickCount() = MilliSeconds do;
  MilliSeconds := GetTickCount();
  Cycle := 0;
  Repeat
    If RealisticFps < 10 then Begin
      Cycles := 100000;
      While Cycles > 0 do Begin
        ExecutedCycles := CpuExecute(103);
        Dec(Cycles,ExecutedCycles);
        DiskUpdatePosition(ExecutedCycles);
        JoyUpdatePosition(ExecutedCycles);
        VideoUpdateVbl(ExecutedCycles,false)
      End
    End;
    If Ok(Cycle AND 1) then FillMemory(Ptr(DWord(@Mem) + $2000),$2000,$AA)
    Else If Ok(Cycle AND 2) then CopyMemory(Ptr(DWord(@Mem) + $2000),Ptr(DWord(@Mem) + $4000),$2000)
                            Else CopyMemory(Ptr(DWord(@Mem) + $2000),Ptr(DWord(@Mem) + $6000),$2000);
    VideoRefreshScreen();
    If Cycle >= 3 then Cycle := 0 Else Inc(Cycle);
    Inc(RealisticFps)
  Until not (GetTickCount() - MilliSeconds < 1000);
  // DISPLAY THE RESULTS
  VideoDisplayLogo();
  OutStr := 'Pure Video FPS:\t%u hires, %u text'#0+'Pure CPU MHz:\t%u.%u%s)'#0#0+
            'EXPECTED AVERAGE VIDEO GAME)'#0+'PERFORMANCE: %u FPS';
  If Ok(Apple2e) then Format(OutStr,[DWord(TotalHiresFps),DWord(TotalTextFps),DWord(TotalMhz10 Div 10),
                                    DWord(TotalMhz10 Mod 10),LPCTSTR(''),DWord(RealisticFps)])
                 Else Format(OutStr,[DWord(TotalHiresFps),DWord(TotalTextFps),DWord(TotalMhz10 Div 10),
                                    DWord(TotalMhz10 Mod 10),LPCTSTR('6502'),DWord(RealisticFps)]);
  MessageBox(FrameWindow,Outstr,'Benchmarks',MB_ICONINFORMATION OR MB_SETFOREGROUND)
End;


