Procedure CheckJoystick;
Var CurrTime  : DWord;
    Info      : JoyInfo;
Begin
// Fehler ? unklar: LastCheck bereits definiert. Mu es nochmals global als JoyLastCheck definiert werden ?
  CurrTime  := GetTickCount();
  If (CurrTime - LastCheck >= 10) or Ok(JoyButton[0]) or Ok(JoyButton[1]) then Begin
    LastCheck := CurrTime;
    If JoyGetPos(JOYSTICKID1,@Info) = JOYERR_NOERROR then Begin
      If Ok(Info.wButtons AND JOY_BUTTON1) and not Ok(JoyButton[0]) then ButtonLatch[0] := BUTTONTIME;
      If Ok(Info.wButtons AND JOY_BUTTON2) and not Ok(JoyButton[1]) then ButtonLatch[1] := BUTTONTIME;
      If Ok(Info.wButtons AND JOY_BUTTON3) and not Ok(JoyButton[2]) then ButtonLatch[2] := BUTTONTIME;
      DWORD(JoyButton[0]) := Abs(Ord((Info.wButtons AND JOY_BUTTON1) <> 0));
      DWORD(JoyButton[1]) := Abs(Ord((Info.wButtons AND JOY_BUTTON2) <> 0));
      DWORD(JoyButton[2]) := Abs(Ord((Info.wButtons AND JOY_BUTTON3) <> 0));
      xPos := (Info.wXpos - JoySubX) Shr JoyShrX;
      yPos := (Info.wYpos - JoySubY) Shr JoyShrY
    End
  End
End;

Procedure JoyInitialize;
Var Caps   : JOYCAPS;
    xRange : UINT;
    yRange : UINT;
Begin
  If Joy_Info[JoyType].Device = DEVICE_JOYSTICK then Begin
    If JoyGetDevCaps(JOYSTICKID1,@Caps,SizeOf(JOYCAPS)) = JOYERR_NOERROR then Begin
      JoyShrX := 0;
      JoyShrY := 0;
      JoySubX := Integer(Caps.wXmin);
      JoySubY := Integer(Caps.wYmin);
      xRange  := Caps.wXmax - Caps.wXmin;
      yRange  := Caps.wYmax - Caps.wYmin;
      While xRange > 256 do Begin
        xRange := xRange Shr 1;
        Inc(JoyShrX)
      End;
      While yRange > 256 do Begin
        yRange := yRange Shr 1;
        Inc(JoyShrY)
      End
    End Else JoyType := 3
  End
End;

Function JoyReadButton( ProgramCounter : Word;
                        Address        : Byte;
                        Write          : Byte;
                        Value          : Byte  ) : Byte; StdCall;
Var Pressed : Bool;
Begin
  If Joy_Info[JoyType].Device = DEVICE_JOYSTICK then CheckJoystick();
  Pressed := false;
  Case Address of
    $61 : Begin
            DWORD(Pressed) := Abs(Ord(Ok(ButtonLatch[0]) or Ok(JoyButton[0]) or Ok(SetButton[0]) or Ok(KeyDown[9])));
            ButtonLatch[0] := 0
          End;
    $62 : Begin
            DWORD(Pressed) := Abs(Ord(Ok(ButtonLatch[1]) or Ok(JoyButton[1]) or Ok(SetButton[1]) or Ok(KeyDown[10])));
            ButtonLatch[1] := 0
          End;
    $63 : Begin
            DWORD(Pressed) := Abs(Ord(Ok(ButtonLatch[2]) or Ok(JoyButton[2]) or not Ok(GetKeyState(VK_SHIFT) < 0)));
            ButtonLatch[2] := 0
          End
  End;
  Result := MemReturnRandomData(Byte(Pressed))
End;

Function JoyReadPosition( ProgramCounter : Word;
                          Address        : Byte;
                          Write          : Byte;
                          Value          : Byte  ) : Byte; StdCall;
Var Position : Bool;
Begin
  If Ok(Address AND 1) then DWORD(Position) := Abs(Ord(yDelay <> 0)) Else DWORD(Position) := Abs(Ord(xDelay <> 0));
  NeedsPrecision := CumulativeCycles;
  If (LPDWORD(DWord(Mem) + ProgramCounter)^     = $D0C80410) and
     (LPWORD( DWord(Mem) + ProgramCounter + 4)^ =     $88F8) then DelayLeft := 1;
  If Ok(DelayLeft) then Begin
    If Ok(xDelay) then Dec(xDelay);
    If Ok(yDelay) then Dec(yDelay);
    Dec(DelayLeft)
  End;
  Result := MemReturnRandomData(Byte(Position))
End;

Function JoyResetPosition( ProgramCounter : Word;
                           Address        : Byte;
                           Write          : Byte;
                           Value          : Byte  ) : Byte; Stdcall;
Begin
  NeedsPrecision := CumulativeCycles;
  If Joy_Info[JoyType].Device = DEVICE_JOYSTICK then CheckJoystick();
  xDelay     := xPos;
  yDelay     := yPos;
  DelayLeft  := 8;
  DWORD(FirstDelay) := 1;
  Result := MemReturnRandomData(1)
End;

Procedure JoyUpdatePosition( Cycles : DWord );
Begin
  If Ok(FirstDelay) then Begin
    FirstDelay := false
  End Else Begin
    xDelay := MAX(0,xDelay - DelayLeft);
    yDelay := MAX(0,yDelay - DelayLeft)
  End;
  DelayLeft := 8;
  If Ok(ButtonLatch[0]) then Dec(ButtonLatch[0]);
  If Ok(ButtonLatch[1]) then Dec(ButtonLatch[1]);
  If Ok(ButtonLatch[2]) then Dec(ButtonLatch[2])
End;

Procedure JoyReset;
Var Loop : Integer;
Begin
  Loop := 0;
  While Loop < 11 do Begin
    KeyDown[Loop] := false;
    Inc(Loop)
  End
End;

Function JoySetEmulationType( Window  : hWnd;
                              NewType : DWord ) : Bool;
Var  Caps : JOYCAPS;
Begin
  If Joy_Info[NewType].Device = DEVICE_JOYSTICK then Begin
    If JoyGetDevCaps(JOYSTICKID1,@Caps,SizeOf(JOYCAPS)) <> JOYERR_NOERROR then Begin
      MessageBox(Window,
                 'The emulator is unable to read your PC joystick.  '+
                 'Ensure that your game port is configured properly, '+
                 'that the joystick is firmly plugged in, and that '+
                 'you have a joystick driver installed.',
                 'Configuration',
                 MB_ICONEXCLAMATION OR MB_SETFOREGROUND);
      Result := false;
      Exit
    End
  End Else If (Joy_Info[NewType].Device = DEVICE_MOUSE) and (Joy_Info[JoyType].Device <> DEVICE_MOUSE) then Begin
    MessageBox(Window,
               'To begin emulating a joystick with your mouse, move '+
               'the mouse cursor over the emulated screen of a running '+
               'program and click the left mouse button.  During the '+
               'time the mouse is emulating a joystick, you will not '+
               'be able to use it to perform mouse functions, and the '+
               'mouse cursor will not be visible.  To end joystick '+
               'emulation and regain the mouse cursor, click the left '+
               'mouse button while pressing Ctrl.',
               'Configuration',
               MB_ICONINFORMATION OR MB_SETFOREGROUND);
  End;
  JoyType := NewType;
  JoyInitialize();
  JoyReset();
  DWord(Result) := 1
End;

Function JoyProcessKey( VirtKey : Integer; Extended : Bool; Down : Bool; AutoRep : Bool ) : Bool;
Var KeyChange : Bool;
    xKeys     : Integer;
    yKeys     : Integer;
    xTotal    : Integer;
    yTotal    : Integer;
    KeyNum    : Integer;
Begin
  If (Joy_Info[JoyType].Device <> DEVICE_KEYBOARD) and (VirtKey <> VK_MENU) then Begin
    Result := false;
    Exit
  End;
  DWORD(KeyChange) := Abs(Ord(not Extended));
  If VirtKey = VK_MENU then Begin
    DWORD(KeyChange) := 1;
    KeyDown[9 + Abs(Ord(Extended <> false))] := Down;
  End Else If not Ok(Extended) then If (VirtKey >= VK_NUMPAD1) and (VirtKey <= VK_NUMPAD9) then Begin
    KeyDown[VirtKey - VK_NUMPAD1] := Down
  End Else Case VirtKey of
    VK_END     : KeyDown[ 0] := Down;
    VK_DOWN    : KeyDown[ 1] := Down;
    VK_NEXT    : KeyDown[ 2] := Down;
    VK_LEFT    : KeyDown[ 3] := Down;
    VK_CLEAR   : KeyDown[ 4] := Down;
    VK_RIGHT   : KeyDown[ 5] := Down;
    VK_HOME    : KeyDown[ 6] := Down;
    VK_UP      : KeyDown[ 7] := Down;
    VK_PRIOR   : KeyDown[ 8] := Down;
    VK_NUMPAD0 : keyDown[ 9] := Down;
    VK_INSERT  : KeyDown[ 9] := Down;
    VK_DECIMAL : KeyDown[10] := Down;
    VK_DELETE  : KeyDown[10] := Down
    Else         KeyChange := false
  End;
  If Ok(KeyChange) then If (VirtKey = VK_NUMPAD0) or (VirtKey = VK_INSERT) then Begin
    If Ok(Down) then ButtonLatch[0] := BUTTONTIME
  End Else If (VirtKey = VK_DECIMAL) or (VirtKey = VK_DELETE) then Begin
    If Ok(Down) then ButtonLatch[1] := BUTTONTIME
  End Else If (Ok(Down) and not Ok(AutoRep)) or (Joy_Info[JoyType].Mode = MODE_CENTERING) then Begin
    xKeys  := 0;
    yKeys  := 0;
    xTotal := 0;
    yTotal := 0;
    KeyNum := 0;
    While KeyNum < 9 do Begin
      If Ok(Keydown[KeyNum]) then Begin
        If KeyNum Mod 3 <> 1 then Begin
          Inc(xKeys);
          xTotal := xTotal + KeyValue[KeyNum].x
        End;
        If KeyNum Div 3 <> 1 then Begin
          Inc(yKeys);
          yTotal := yTotal + KeyValue[KeyNum].y
        End
      End;
      Inc(KeyNum)
    End;
    If Ok(xKeys) then xPos := xTotal Div xKeys
                 Else xPos := 127;
    If Ok(yKeys) then yPos := yTotal Div yKeys
                 Else yPos := 127
  End;
  Result := KeyChange
End;

Procedure JoySetButton( Number : Integer; Down : Bool );
Begin
  If Number > 1 then Exit;
  SetButton[Number] := Down;
  If Ok(Down) then ButtonLatch[Number] := BUTTONTIME
End;

Function JoyUsingMouse : Bool;
Begin
  DWORD(Result) := Abs(Ord(Joy_Info[JoyType].Device = DEVICE_MOUSE))
End;

Procedure JoySetPosition( xValue, xRange, yValue, yRange : Integer );
Begin
  xPos := (xValue * 255) Div xRange;
  yPos := (yValue * 255) Div yRange
End;


