Procedure CpuDestroy;
Var Loop : Integer;
Begin
  Loop := 3;
  While Ok(Loop) do Begin
    Dec(Loop);
    If Ok(CpuLibrary[Loop]) then FreeLibrary(CpuLibrary[Loop]);
    CpuExecuteFunc[Loop] := NiL;
    CpuGetCodeFunc[Loop] := NiL;
    CpuLibrary[Loop]     := tInstance(0)
  End
End;

Procedure CpuInitialize;
Var Filename : Array[0..Pred(MAX_PATH)] of Char;
    Loop     : Integer;
Begin
  CpuDestroy();
  Regs.A  := 0;
  Regs.X  := 0;
  Regs.Y  := 0;
  Regs.PS := $20;
  Regs.PC := LPWORD(DWord(Mem) + $FFFC)^;
  Regs.SP := $01FF;
  If Ok(Mem) then Begin
    StrCopy(Filename,ProgDir);
    StrCat(Filename,'65C02C.DLL');
    CpuLibrary[CPU_COMPILING] := LoadLibrary(Filename);
    StrCopy(Filename,ProgDir);
    If Ok(Apple2e) then StrCat(Filename,'65C02.DLL') Else StrCat(Filename,'6502.DLL');
    CpuLibrary[CPU_INTERPRETIVE] := LoadLibrary(Filename);
    If not OK(CpuLibrary[CPU_INTERPRETIVE]) then Begin
      StrCopy(Filename,ProgDir);
      StrCat(Filename,'65C02.DLL');
      CpuLibrary[CPU_INTERPRETIVE] := LoadLibrary(Filename)
    End;
    StrCopy(Filename,ProgDir);
    StrCat(Filename,'65C02P.DLL');
    CpuLibrary[CPU_FASTPAGING] := LoadLibrary(Filename);
    If not Ok(CpuLibrary[CPU_COMPILING]) then CpuLibrary[CPU_COMPILING] := CpuLibrary[CPU_INTERPRETIVE];
    Loop := 3;
    While Ok(Loop) do Begin
      Dec(Loop);
      If Ok(CpuLibrary[Loop]) then Begin
        CpuExecuteFunc[Loop] := CpuExecuteType(GetProcAddress(CpuLibrary[Loop],'CpuExecute'));
        CpuGetCodeFunc[Loop] := CpuGetCodeType(GetProcAddress(CpuLibrary[Loop],'CpuGetCode'));
        CpuInitFunc[Loop]    := CpuInitType(GetProcAddress(CpuLibrary[Loop],'CpuInitialize'));
        If Ok(@CpuInitFunc[Loop]) then Begin
          CpuInitFunc[Loop](Mem,@MemShadow[0],@MemWrite[0],Image,LastImage,@Regs,@IoRead,@IoWrite,MemDirty)
        End  
      End
    End
  End
End;

Procedure CpuReinitialize;
Begin
  If Ok(CpuLibrary[CpuEmType]) and Ok(@CpuInitFunc[CpuEmType]) then Begin
    CpuInitFunc[CpuEmType](Mem,@MemShadow[0],@MemWrite[0],Image,LastImage,@Regs,@IoRead,@IoWrite,MemDirty)
  End
End;

Procedure CpuResetCompilerData;
Begin
  If Ok(CpuLibrary[CPU_COMPILING]) and (CpuLibrary[CPU_COMPILING] <> CpuLibrary[CPU_INTERPRETIVE]) then Begin
    FillChar(LPBYTE(DWord(Mem) + $10000)^,$20000,#0)
  End
End;

Function InternalCpuExecute( TotalCycles : DWORD ) : DWORD;
Var Addr   : WORD;
    Temp   : Word;
    Val    : Word;
    FlagC  : Bool;
    FlagN  : Bool;
    FlagV  : Bool;
    FlagZ  : Bool;
    Cycles : DWORD;

  Procedure AF_TO_EF;
  Begin
    DWORD(FlagC) := Regs.PS AND AF_CARRY;
    DWORD(FlagN) := Regs.PS AND AF_SIGN;
    DWORD(FlagV) := Regs.PS AND AF_OVERFLOW;
    DWORD(FlagZ) := Regs.PS AND AF_ZERO
  End;

  Procedure EF_TO_AF;
  Var _FlagC : Byte;
      _FlagN : Byte;
      _FlagV : Byte;
      _FlagZ : Byte;
  Begin
    If Ok(FlagC) then _FlagC := AF_CARRY    Else _FlagC := 0;
    If Ok(FlagN) then _FlagN := AF_SIGN     Else _FlagN := 0;
    If Ok(FlagV) then _FlagV := AF_OVERFLOW Else _FlagV := 0;
    If Ok(FlagZ) then _FlagZ := AF_ZERO     Else _FlagZ := 0;
    Regs.PS := (Regs.PS AND NOT (AF_CARRY OR AF_SIGN OR AF_OVERFLOW OR AF_ZERO))
                             OR _FlagC OR _FlagN OR _FlagV OR _FlagZ
  End;

  Procedure CMOS;
  Begin
    If not Ok(Apple2e) then Inc(Cycles)
  End;

  Function POP : Byte;
  Begin
    If LPWORD(DWord(Mem) + Regs.SP)^ >= $1FF then Regs.SP := $100 Else Inc(Regs.SP);
    Result := LPWORD(DWord(Mem) + Regs.SP)^
  End;

  Procedure PUSH(a : Byte);
  Begin
    LPBYTE(DWord(Mem) + Regs.SP)^ := a;
    Dec(Regs.SP);
    If Regs.SP < $100 then Regs.SP := $1FF;
  End;

  Procedure ABS;
  Begin
    Addr := LPWORD(DWord(Mem) + Regs.PC)^;
    Inc(Regs.PC,2)
  End;

  Procedure ABSIINDX;
  Begin
   Addr := LPWORD(DWord(LPWORD(DWord(Mem) + Regs.PC)^))^ + WORD(Regs.X);
   Inc(Regs.PC,2)
  End;

  Procedure ABSX;
  Begin
    Addr := LPWORD(DWord(Mem) + Regs.PC)^ + Word(Regs.X);
    Inc(Regs.PC,2)
  End;

  Procedure ABSY;
  Begin
    Addr := LPWORD(DWord(Mem) + Regs.PC)^ + Word(Regs.Y);
    Inc(Regs.PC,2)
  End;

  Procedure IABS;
  Begin
    Addr := LPWORD(DWord(Mem) + LPWORD(DWord(Mem) + Regs.PC)^)^;
    Inc(Regs.PC,2)
  End;

  Procedure IMM;
  Begin
    Addr := Regs.PC;
    Inc(Regs.PC)
  End;

  Procedure INDX;
  Begin
    Addr := LPWORD(DWord(Mem) + ((LPBYTE(DWord(Mem) + Regs.PC)^ + Regs.X) AND $FF))^;
    Inc(Regs.PC)
  End;

  Procedure INDY;
  Begin
    Addr := LPWORD(DWord(Mem) + LPBYTE(DWord(Mem) + Regs.PC)^)^ + Word(Regs.Y);
    Inc(Regs.PC)
  End;

  Procedure IZPG;
  Begin
    Addr := LPWORD(DWord(Mem) + LPBYTE(DWord(Mem) + Regs.PC)^)^;
    Inc(Regs.PC)
  End;

  Procedure REL;
  Begin
    Addr := ShortInt(LPBYTE(DWord(Mem) + Regs.PC)^);
    Inc(Regs.PC)
  End;

  Procedure ZPG;
  Begin
    Addr := LPBYTE(DWord(Mem) + Regs.PC)^;
    Inc(Regs.PC)
  End;

  Procedure ZPGX;
  Begin
    Addr := (LPBYTE(DWord(Mem) + Regs.PC)^ + Regs.X) AND $FF;
    Inc(Regs.PC)
  End;

  Procedure ZPGY;
  Begin
    Addr := (LPBYTE(DWord(Mem) + Regs.PC)^ + Regs.Y) AND $FF;
    Inc(Regs.PC)
  End;

  Function READ : Byte;
  Begin
    If Addr AND $FF00 = $C000 then Result := IoRead[Addr AND $FF](Regs.PC,Byte(Addr),0,0)
                              Else Result := LPBYTE(DWord(Mem) + Addr)^
  End;

  Procedure WRITE(a : Byte);
  Var Page : LPBYTE;
  Begin
    LPBYTE(DWord(MemDirty) + (Addr Shr 8))^ := $FF;
    Page := MemWrite[0][Addr Shr 8];
    If Ok(Page) then LPBYTE(DWord(Page) + (Addr AND $FF))^ := a
                Else If Addr AND $FF00 = $C000 then IoWrite[Addr AND $FF](Regs.PC,Byte(Addr),1,a);
  End;

  Procedure SETNZ( a : BYTE );
  Begin
    DWORD(FlagN) := a AND $80;
    DWORD(FlagZ) := not (a AND $FF)
  End;

  Procedure SETZ( a : Byte );
  Begin
    DWORD(FlagZ) := not (a AND $FF)
  End;

  Procedure INVALID1;
  Begin
  End;

  Procedure INVALID2;
  Begin
   If Apple2e then Inc(Regs.PC)
  End;

  Procedure INVALID3;
  Begin
   If Apple2e then Inc(Regs.PC,2)
  End;

  Function TOBCD( a : BYTE ) : BYTE;
  Begin
    Result := (((a Div 10) Mod 10) Shl 4) OR (a Mod 10)
  End;

  Function TOBIN( a : BYTE ) : BYTE;
  Begin
   Result := (a Shr 4) * 10 + (a AND $0F)
  End;

  Procedure ADC;
  Begin
    Temp := READ;
    If Ok(Regs.PS AND AF_DECIMAL) then Begin
      Val    := TOBIN(Regs.A) + TOBIN(Temp) + System.Abs(Ord(FlagC <> false));
      Val := Integer(FlagC <> false);
      DWORD(FlagC) := System.Abs(Ord(Val > 99));
      Regs.A := TOBCD(Val);
      If Apple2e then SETNZ(Regs.A)
    End Else Begin
      Val    := Regs.A + Temp + System.Abs(Ord(FlagC <> false));
      DWORD(FlagC)  := System.Abs(Ord(Val > $FF));
      DWORD(FlagV)  := System.Abs(Ord((Regs.A AND $80 = Temp AND $80) and (Regs.A AND $80 <> Val AND $80)));
      Regs.A := Val AND $FF;
      SETNZ(Regs.A)
    End
  End;

  Procedure ASL;
  Begin
    Val := READ Shl 1;
    DWORD(Flagc) := System.Abs(Ord(Val > $FF));
    SETNZ(Val);
    WRITE(Val)
  End;

  Procedure ASLA;
  Begin
    Val := Regs.a Shl 1;
    DWORD(FlagC) := System.Abs(Ord(Val > $FF));
    SETNZ(Val);
    Regs.A := Byte(Val)
  End;

  Procedure AND_;
  Begin
    Regs.A := Regs.A AND READ;
    SETNZ(Regs.A)
  End;

  Procedure BCC;
  Begin
    If not FlagC then Inc(Regs.PC,Addr)
  End;

  Procedure BCS;
  Begin
    If FlagC then Inc(Regs.PC,Addr)
  End;

  Procedure BEQ;
  Begin
    If FlagZ then Inc(Regs.PC,Addr)
  End;

  Procedure BIT;
  Begin
    Val := READ;
    DWORD(FlagZ) := System.Abs(Ord(not Ok(Regs.A AND Val)));
    DWORD(FlagN) := System.Abs(Ord(Val AND $80));
    DWORD(FlagV) := System.Abs(Ord(Val AND $40))
  End;

  Procedure BITI;
  Begin
    DWORD(FlagZ) := System.Abs(Ord(not Ok(Regs.A AND READ)))
  End;

  Procedure BMI;
  Begin
    If FlagN then Inc(Regs.PC,Addr)
  End;

  Procedure BNE;
  Begin
    If not FlagZ then Inc(Regs.PC,Addr)
  End;

  Procedure BPL;
  Begin
    If not FlagN then Inc(Regs.PC,Addr)
  End;

  Procedure BRA;
  Begin
    Inc(Regs.PC,Addr)
  End;

  Procedure BRK;
  Begin
    PUSH(Regs.PC Shr 8);
    PUSH(Regs.PC AND $FF);
    EF_TO_AF;
    Regs.PS := Regs.PS OR AF_BREAK;
    PUSH(Regs.PS);
    Regs.PS := Regs.PS OR AF_INTERRUPT;
    Regs.PC := LPWORD(DWord(Mem) + $FFFE)^
  End;

  Procedure BVC;
  Begin
    If not Ok(FlagV) then Inc(Regs.PC,Addr)
  End;

  Procedure BVS;
  Begin
    If Ok(FlagV) then Inc(Regs.PC,Addr)
  End;

  Procedure CLC;
  Begin
    FlagC := false
  End;

  Procedure CLD;
  Begin
    Regs.PS := Regs.PS AND NOT AF_DECIMAL
  End;

  Procedure CLI;
  Begin
    Regs.PS := Regs.PS AND NOT AF_INTERRUPT
  End;

  Procedure CLV;
  Begin
    FlagV := false
  End;

  Procedure CMP;
  Begin
    Val   := READ;
    DWORD(FlagC) := System.Abs(Ord(Regs.A >= Val));
    Val   := Regs.A - Val;
    SETNZ(Val)
  End;

  Procedure CPX;
  Begin
    Val   := READ;
    DWORD(FlagC) := System.Abs(Ord(Regs.X >= Val));
    Val   := Regs.X - Val;
    SETNZ(Val)
  End;

  Procedure CPY;
  Begin
    Val   := READ;
    DWORD(FlagC) := System.Abs(Ord(Regs.Y >= Val));
    Val   := Regs.Y - Val;
    SETNZ(Val)
  End;

  Procedure DEA;
  Begin
    Dec(Regs.A);
    SETNZ(Regs.A)
  End;

  Procedure DEC_;
  Begin
    Val := Pred(READ);
    SETNZ(Val);
    WRITE(Val)
  End;

  Procedure DEX;
  Begin
    Dec(Regs.X);
    SETNZ(Regs.X)
  End;

  Procedure DEY;
  Begin
    Dec(Regs.Y);
    SETNZ(Regs.Y)
  End;

  Procedure EOR;
  Begin
    Regs.A := Regs.A XOR READ;
    SETNZ(Regs.A)
  End;

  Procedure INA;
  Begin
    Inc(Regs.A);
    SETNZ(Regs.A)
  End;

  Procedure INC_;
  Begin
    Val := Succ(READ);
    SETNZ(Val);
    WRITE(Val)
  End;

  Procedure INX;
  Begin
    Inc(Regs.X);
    SETNZ(Regs.X)
  End;

  Procedure INY;
  Begin
    Inc(Regs.Y);
    SETNZ(Regs.Y)
  End;

  Procedure JMP;
  Begin
    Regs.PC := Addr
  End;

  Procedure JSR;
  Begin
    Dec(Regs.PC);
    PUSH(Regs.PC Shr 8);
    PUSH(Regs.PC AND $FF);
    Regs.PC := Addr
  End;

  Procedure LDA;
  Begin
    Regs.A := READ;
    SETNZ(Regs.A)
  End;

  Procedure LDX;
  Begin
    Regs.X := READ;
    SETNZ(Regs.X)
  End;

  Procedure LDY;
  Begin
    Regs.Y := READ;
    SETNZ(Regs.Y)
  End;

  Procedure LSR;
  Begin
    Val := READ;
    DWORD(FlagC) := System.Abs(Ord(Ok(Val AND 1)));
    FlagN := false;
    Val := Val Shr 1;
    SETZ(Val);
    WRITE(Val)
  End;

  Procedure LSRA;
  Begin
    DWORD(FlagC) := System.Abs(Ord(Ok(Regs.a AND 1)));
    FlagN := false;
    Regs.A := Regs.A Shr 1;
    SETZ(Regs.A)
  End;

  Procedure NOP;
  Begin
  End;

  Procedure ORA;
  Begin
    Regs.A := Regs.A OR READ;
    SETNZ(Regs.A)
  End;

  Procedure PHA;
  Begin
    PUSH(Regs.A)
  End;

  Procedure PHP;
  Begin
    EF_TO_AF;
    Regs.PS := Regs.PS OR AF_RESERVED;
    PUSH(Regs.PS)
  End;

  Procedure PHX;
  Begin
    PUSH(Regs.X)
  End;

  Procedure PHY;
  Begin
    PUSH(Regs.Y)
  End;

  Procedure PLA;
  Begin
    Regs.A := POP;
    SETNZ(Regs.A)
  End;

  Procedure PLP;
  Begin
    Regs.PS := POP;
    AF_TO_EF
  End;

  Procedure PLX;
  Begin
    Regs.X := POP;
    SETNZ(Regs.X)
  End;

  Procedure PLY;
  Begin
    Regs.Y := POP;
    SETNZ(Regs.Y)
  End;

  Procedure ROL;
  Begin
    Val := (READ Shl 1) OR System.Abs(Ord(FlagC <> false));
    DWORD(FlagC) := System.Abs(Ord(Val > $FF));
    SETNZ(Val);
    WRITE(Val)
  End;

  Procedure ROLA;
  Begin
    Val := (Word(Regs.A) Shl 1) OR System.Abs(Ord(FlagC <> false));
    DWORD(FlagC)  := System.Abs(Ord(Val > $FF));
    Regs.A := Val AND $FF;
    SETNZ(Regs.A)
  End;

  Procedure ROR;
  Begin
    Temp := READ;
    If FlagC then  Val := (Temp Shr 1) OR $80 Else  Val := (Temp Shr 1) OR $00;
    DWORD(FlagC) := System.Abs(Ord(Ok(Temp AND 1)));
    SETNZ(Val);
    WRITE(Val)
  End;

  Procedure RORA;
  Begin
    If FlagC then Val := (WORD(Regs.A) Shr 1) OR $80 Else Val := (WORD(Regs.A) Shr 1) OR $00;
    DWORD(FlagC)  := System.Abs(Ord(Ok(Regs.a AND 1)));
    Regs.A := Val AND $FF;
    SETNZ(Regs.A)
  End;

  Procedure RTI;
  Begin
    Regs.PS := POP;
    AF_TO_EF;
    Regs.PC := POP;
    Regs.PC := Regs.PC OR (Word(POP) Shl 8)
  End;

  Procedure RTS;
  Begin
    Regs.PC := POP;
    Regs.PC := Regs.PC OR (WORD(POP) Shl 8);
    Inc(Regs.PC)
  End;

  Procedure SBC;
  Begin
    Temp := READ;
    If Ok(Regs.PS AND AF_DECIMAL) then Begin
      Val    := TOBIN(Regs.A) - TOBIN(Temp) - System.Abs(Ord(not FlagC));
      DWORD(FlagC) := System.Abs(Ord(Val < $8000));
      Regs.A := TOBCD(Val);
      If Apple2e then SETNZ(Regs.A)
    End Else Begin
      Val    := Regs.A - Temp - System.Abs(Ord(not FlagC));
      DWORD(FlagC) := System.Abs(Ord(Val < $8000));
      DWORD(FlagV) := System.Abs(Ord((Regs.A AND $80 <> Temp AND $80) and (Regs.A AND $80 <> Val AND $80)));
      Regs.A := Val AND $FF;
      SETNZ(Regs.A)
    End
  End;

  Procedure SEC;
  Begin
    FlagC := true
  End;

  Procedure SED;
  Begin
    Regs.PS := Regs.PS OR AF_DECIMAL
  End;

  Procedure SEI;
  Begin
    Regs.PS := Regs.PS OR AF_INTERRUPT
  End;

  Procedure STA;
  Begin
    WRITE(Regs.A)
  End;

  Procedure STX;
  Begin
    WRITE(Regs.X)
  End;

  Procedure STY;
  Begin
    WRITE(Regs.Y)
  End;

  Procedure STZ;
  Begin
    WRITE(0)
  End;

  Procedure TAX;
  Begin
    Regs.X := Regs.A;
    SETNZ(Regs.X)
  End;

  Procedure TAY;
  Begin
    Regs.Y := Regs.A;
    SETNZ(Regs.Y)
  End;

  Procedure TRB;
  Begin
    Val := READ;
    DWORD(FlagZ) := System.Abs(Ord(not Ok(Regs.A AND Val)));
    Val := Val AND NOT Regs.A;
    WRITE(Val)
  End;

  Procedure TSB;
  Begin
    Val := READ;
    DWORD(FlagZ) := System.Abs(Ord(not Ok(Regs.A AND Val)));
    Val := Val OR Regs.A;
    WRITE(Val)
  End;

  Procedure TSX;
  Begin
    Regs.X := Regs.SP AND $FF;
    SETNZ(Regs.X)
  End;

  Procedure TXA;
  Begin
    Regs.A := Regs.X;
    SETNZ(Regs.A)
  End;

  Procedure TXS;
  Begin
    Regs.SP := $100 OR Regs.X
  End;

  Procedure TYA;
  Begin
    Regs.A := Regs.Y;
    SETNZ(Regs.A)
  End;

Begin
  AF_TO_EF;
  Cycles := 0;
  Repeat
    Case LPBYTE(DWord(Mem) + Regs.PC)^ of
      $00 : Begin                 BRK;  Inc(Cycles,7) End;
      $01 : Begin       INDX;     ORA;  Inc(Cycles,6) End;
      $02 : Begin       INVALID2;       Inc(Cycles,2) End;
      $03 : Begin       INVALID1;       Inc(Cycles,1) End;
      $04 : Begin CMOS; ZPG;      TSB;  Inc(Cycles,5) End;
      $05 : Begin       ZPG;      ORA;  Inc(Cycles,3) End;
      $06 : Begin       ZPG;      ASL;  Inc(Cycles,5) End;
      $07 : Begin       INVALID1;       Inc(Cycles,1) End;
      $08 : Begin                 PHP;  Inc(Cycles,3) End;
      $09 : Begin       IMM;      ORA;  Inc(Cycles,2) End;
      $0A : Begin                 ASLA; Inc(Cycles,2) End;
      $0B : Begin       INVALID1;       Inc(Cycles,1) End;
      $0C : Begin CMOS; ABS;      TSB;  Inc(Cycles,6) End;
      $0D : Begin       ABS;      ORA;  Inc(Cycles,4) End;
      $0E : Begin       ABS;      ASL;  Inc(Cycles,6) End;
      $0F : Begin       INVALID1;       Inc(Cycles,1) End;
      $10 : Begin       REL;      BPL;  Inc(Cycles,3) End;
      $11 : Begin       INDY;     ORA;  Inc(Cycles,5) End;
      $12 : Begin CMOS; IZPG;     ORA;  Inc(Cycles,5) End;
      $13 : Begin       INVALID1;       Inc(Cycles,1) End;
      $14 : Begin CMOS; ZPG;      TRB;  Inc(Cycles,5) End;
      $15 : Begin       ZPGX;     ORA;  Inc(Cycles,4) End;
      $16 : Begin       ZPGX;     ASL;  Inc(Cycles,6) End;
      $17 : Begin       INVALID1;       Inc(Cycles,1) End;
      $18 : Begin                 CLC;  Inc(Cycles,2) End;
      $19 : Begin       ABSY;     ORA;  Inc(Cycles,4) End;
      $1A : Begin CMOS;           INA;  Inc(Cycles,2) End;
      $1B : Begin       INVALID1;       Inc(Cycles,1) End;
      $1C : Begin CMOS; ABS;      TRB;  Inc(Cycles,6) End;
      $1D : Begin       ABSX;     ORA;  Inc(Cycles,4) End;
      $1E : Begin       ABSX;     ASL;  Inc(Cycles,6) End;
      $1F : Begin       INVALID1;       Inc(Cycles,1) End;
      $20 : Begin       ABS;      JSR;  Inc(Cycles,6) End;
      $21 : Begin       INDX;     AND_; Inc(Cycles,6) End;
      $22 : Begin       INVALID2;       Inc(Cycles,2) End;
      $23 : Begin       INVALID1;       Inc(Cycles,1) End;
      $24 : Begin       ZPG;      BIT;  Inc(Cycles,3) End;
      $25 : Begin       ZPG;      AND_; Inc(Cycles,3) End;
      $26 : Begin       ZPG;      ROL;  Inc(Cycles,5) End;
      $27 : Begin       INVALID1;       Inc(Cycles,1) End;
      $28 : Begin                 PLP;  Inc(Cycles,4) End;
      $29 : Begin       IMM;      AND_; Inc(Cycles,2) End;
      $2A : Begin                 ROLA; Inc(Cycles,2) End;
      $2B : Begin       INVALID1;       Inc(Cycles,1) End;
      $2C : Begin       ABS;      BIT;  Inc(Cycles,4) End;
      $2D : Begin       ABS;      AND_; Inc(Cycles,2) End;
      $2E : Begin       ABS;      ROL;  Inc(Cycles,6) End;
      $2F : Begin       INVALID1;       Inc(Cycles,1) End;
      $30 : Begin       REL;      BMI;  Inc(Cycles,3) End;
      $31 : Begin       INDY;     AND_; Inc(Cycles,5) End;
      $32 : Begin CMOS; IZPG;     AND_; Inc(Cycles,5) End;
      $33 : Begin       INVALID1;       Inc(Cycles,1) End;
      $34 : Begin CMOS; ZPGX;     BIT;  Inc(Cycles,4) End;
      $35 : Begin       ZPGX;     AND_; Inc(Cycles,4) End;
      $36 : Begin       ZPGX;     ROL;  Inc(Cycles,6) End;
      $37 : Begin       INVALID1;       Inc(Cycles,1) End;
      $38 : Begin                 SEC;  Inc(Cycles,2) End;
      $39 : Begin       ABSY;     AND_; Inc(Cycles,4) End;
      $3A : Begin CMOS;           DEA;  Inc(Cycles,2) End;
      $3B : Begin       INVALID1;       Inc(Cycles,1) End;
      $3C : Begin CMOS; ABSX;     BIT;  Inc(Cycles,4) End;
      $3D : Begin       ABSX;     AND_; Inc(Cycles,4) End;
      $3E : Begin       ABSX;     ROL;  Inc(Cycles,6) End;
      $3F : Begin       INVALID1;       Inc(Cycles,1) End;
      $40 : Begin                 RTI;  Inc(Cycles,6) End;
      $41 : Begin       INDX;     EOR;  Inc(Cycles,6) End;
      $42 : Begin       INVALID2;       Inc(Cycles,2) End;
      $43 : Begin       INVALID1;       Inc(Cycles,1) End;
      $44 : Begin       INVALID2;       Inc(Cycles,3) End;
      $45 : Begin       ZPG;      EOR;  Inc(Cycles,3) End;
      $46 : Begin       ZPG;      LSR;  Inc(Cycles,5) End;
      $47 : Begin       INVALID1;       Inc(Cycles,1) End;
      $48 : Begin                 PHA;  Inc(Cycles,3) End;
      $49 : Begin       IMM;      EOR;  Inc(Cycles,2) End;
      $4A : Begin                 LSRA; Inc(Cycles,2) End;
      $4B : Begin       INVALID1;       Inc(Cycles,1) End;
      $4C : Begin       ABS;      JMP;  Inc(Cycles,3) End;
      $4D : Begin       ABS;      EOR;  Inc(Cycles,4) End;
      $4E : Begin       ABS;      LSR;  Inc(Cycles,6) End;
      $4F : Begin       INVALID1;       Inc(Cycles,1) End;
      $50 : Begin       REL;      BVC;  Inc(Cycles,3) End;
      $51 : Begin       INDY;     EOR;  Inc(Cycles,5) End;
      $52 : Begin;CMOS; IZPG;     EOR;  Inc(Cycles,5) End;
      $53 : Begin       INVALID1;       Inc(Cycles,1) End;
      $54 : Begin       INVALID2;       Inc(Cycles,4) End;
      $55 : Begin       ZPGX;     EOR;  Inc(Cycles,4) End;
      $56 : Begin       ZPGX;     LSR;  Inc(Cycles,6) End;
      $57 : Begin       INVALID1;       Inc(Cycles,1) End;
      $58 : Begin                 CLI;  Inc(Cycles,2) End;
      $59 : Begin       ABSY;     EOR;  Inc(Cycles,4) End;
      $5A : Begin CMOS;           PHY;  Inc(Cycles,3) End;
      $5B : Begin       INVALID1;       Inc(Cycles,1) End;
      $5C : Begin       INVALID3;       Inc(Cycles,8) End;
      $5D : Begin       ABSX;     EOR;  Inc(Cycles,4) End;
      $5E : Begin       ABSX;     LSR;  Inc(Cycles,6) End;
      $5F : Begin       INVALID1;       Inc(Cycles,1) End;
      $60 : Begin                 RTS;  Inc(Cycles,6) End;
      $61 : Begin       INDX;     ADC;  Inc(Cycles,6) End;
      $62 : Begin       INVALID2;       Inc(Cycles,2) End;
      $63 : Begin       INVALID1;       Inc(Cycles,1) End;
      $64 : Begin CMOS; ZPG;      STZ;  Inc(Cycles,3) End;
      $65 : Begin       ZPG;      ADC;  Inc(Cycles,3) End;
      $66 : Begin       ZPG;      ROR;  Inc(Cycles,5) End;
      $67 : Begin       INVALID1;       Inc(Cycles,1) End;
      $68 : Begin                 PLA;  Inc(Cycles,4) End;
      $69 : Begin       IMM;      ADC;  Inc(Cycles,2) End;
      $6A : Begin                 RORA; Inc(Cycles,2) End;
      $6B : Begin       INVALID1;       Inc(Cycles,1) End;
      $6C : Begin       IABS;     JMP;  Inc(Cycles,6) End;
      $6D : Begin       ABS;      ADC;  Inc(Cycles,4) End;
      $6E : Begin       ABS;      ROR;  Inc(Cycles,6) End;
      $6F : Begin       INVALID1;       Inc(Cycles,1) End;
      $70 : Begin       REL;      BVS;  Inc(Cycles,3) End;
      $71 : Begin       INDY;     ADC;  Inc(Cycles,5) End;
      $72 : Begin CMOS; IZPG;     ADC;  Inc(Cycles,5) End;
      $73 : Begin       INVALID1;       Inc(Cycles,1) End;
      $74 : Begin CMOS; ZPGX;     STZ;  Inc(Cycles,4) End;
      $75 : Begin       ZPGX;     ADC;  Inc(Cycles,4) End;
      $76 : Begin       ZPGX;     ROR;  Inc(Cycles,6) End;
      $77 : Begin       INVALID1;       Inc(Cycles,1) End;
      $78 : Begin                 SEI;  Inc(Cycles,2) End;
      $79 : Begin       ABSY;     ADC;  Inc(Cycles,4) End;
      $7A : Begin CMOS;           PLY;  Inc(Cycles,4) End;
      $7B : Begin       INVALID1;       Inc(Cycles,1) End;
      $7C : Begin CMOS; ABSIINDX; JMP;  Inc(Cycles,6) End;
      $7D : Begin       ABSX;     ADC;  Inc(Cycles,4) End;
      $7E : Begin       ABSX;     ROR;  Inc(Cycles,6) End;
      $7F : Begin       INVALID1;       Inc(Cycles,1) End;
      $80 : Begin CMOS; REL;      BRA;  Inc(Cycles,3) End;
      $81 : Begin       INDX;     STA;  Inc(Cycles,6) End;
      $82 : Begin       INVALID2;       Inc(Cycles,2) End;
      $83 : Begin       INVALID1;       Inc(Cycles,1) End;
      $84 : Begin       ZPG;      STY;  Inc(Cycles,3) End;
      $85 : Begin       ZPG;      STA;  Inc(Cycles,3) End;
      $86 : Begin       ZPG;      STX;  Inc(Cycles,3) End;
      $87 : Begin       INVALID1;       Inc(Cycles,1) End;
      $88 : Begin                 DEY;  Inc(Cycles,2) End;
      $89 : Begin CMOS; IMM;      BITI; Inc(Cycles,2) End;
      $8A : Begin                 TXA;  Inc(Cycles,2) End;
      $8B : Begin       INVALID1;       Inc(Cycles,1) End;
      $8C : Begin       ABS;      STY;  Inc(Cycles,4) End;
      $8D : Begin       ABS;      STA;  Inc(Cycles,4) End;
      $8E : Begin       ABS;      STX;  Inc(Cycles,4) End;
      $8F : Begin       INVALID1;       Inc(Cycles,1) End;
      $90 : Begin       REL;      BCC;  Inc(Cycles,3) End;
      $91 : Begin       INDY;     STA;  Inc(Cycles,6) End;
      $92 : Begin CMOS; IZPG;     STA;  Inc(Cycles,5) End;
      $93 : Begin       INVALID1;       Inc(Cycles,1) End;
      $94 : Begin       ZPGX;     STY;  Inc(Cycles,4) End;
      $95 : Begin       ZPGX;     STA;  Inc(Cycles,4) End;
      $96 : Begin       ZPGY;     STX;  Inc(Cycles,4) End;
      $97 : Begin       INVALID1;       Inc(Cycles,1) End;
      $98 : Begin                 TYA;  Inc(Cycles,2) End;
      $99 : Begin       ABSY;     STA;  Inc(Cycles,5) End;
      $9A : Begin                 TXS;  Inc(Cycles,2) End;
      $9B : Begin       INVALID1;       Inc(Cycles,1) End;
      $9C : Begin CMOS; ABS;      STZ;  Inc(Cycles,4) End;
      $9D : Begin       ABSX;     STA;  Inc(Cycles,5) End;
      $9E : Begin CMOS; ABSX;     STZ;  Inc(Cycles,5) End;
      $9F : Begin       INVALID1;       Inc(Cycles,1) End;
      $A0 : Begin       IMM;      LDY;  Inc(Cycles,2) End;
      $A1 : Begin       INDX;     LDA;  Inc(Cycles,6) End;
      $A2 : Begin       IMM;      LDX;  Inc(Cycles,2) End;
      $A3 : Begin       INVALID1;       Inc(Cycles,1) End;
      $A4 : Begin       ZPG;      LDY;  Inc(Cycles,3) End;
      $A5 : Begin       ZPG;      LDA;  Inc(Cycles,3) End;
      $A6 : Begin       ZPG;      LDX;  Inc(Cycles,3) End;
      $A7 : Begin       INVALID1;       Inc(Cycles,1) End;
      $A8 : Begin                 TAY;  Inc(Cycles,2) End;
      $A9 : Begin       IMM;      LDA;  Inc(Cycles,2) End;
      $AA : Begin                 TAX;  Inc(Cycles,2) End;
      $AB : Begin       INVALID1;       Inc(Cycles,1) End;
      $AC : Begin       ABS;      LDY;  Inc(Cycles,4) End;
      $AD : Begin       ABS;      LDA;  Inc(Cycles,4) End;
      $AE : Begin       ABS;      LDX;  Inc(Cycles,4) End;
      $AF : Begin       INVALID1;       Inc(Cycles,1) End;
      $B0 : Begin       REL;      BCS;  Inc(Cycles,3) End;
      $B1 : Begin       INDY;     LDA;  Inc(Cycles,5) End;
      $B2 : Begin CMOS; IZPG;     LDA;  Inc(Cycles,5) End;
      $B3 : Begin       INVALID1;       Inc(Cycles,1) End;
      $B4 : Begin       ZPGX;     LDY;  Inc(Cycles,4) End;
      $B5 : Begin       ZPGX;     LDA;  Inc(Cycles,4) End;
      $B6 : Begin       ZPGY;     LDX;  Inc(Cycles,4) End;
      $B7 : Begin       INVALID1;       Inc(Cycles,1) End;
      $B8 : Begin                 CLV;  Inc(Cycles,2) End;
      $B9 : Begin       ABSY;     LDA;  Inc(Cycles,4) End;
      $BA : Begin                 TSX;  Inc(Cycles,2) End;
      $BB : Begin       INVALID1;       Inc(Cycles,1) End;
      $BC : Begin       ABSX;     LDY;  Inc(Cycles,4) End;
      $BD : Begin       ABSX;     LDA;  Inc(Cycles,4) End;
      $BE : Begin       ABSY;     LDX;  Inc(Cycles,4) End;
      $BF : Begin       INVALID1;       Inc(Cycles,1) End;
      $C0 : Begin       IMM;      CPY;  Inc(Cycles,2) End;
      $C1 : Begin       INDX;     CMP;  Inc(Cycles,6) End;
      $C2 : Begin       INVALID2;       Inc(Cycles,2) End;
      $C3 : Begin       INVALID1;       Inc(Cycles,1) End;
      $C4 : Begin       ZPG;      CPY;  Inc(Cycles,3) End;
      $C5 : Begin       ZPG;      CMP;  Inc(Cycles,3) End;
      $C6 : Begin       ZPG;      DEC_; Inc(Cycles,5) End;
      $C7 : Begin       INVALID1;       Inc(Cycles,1) End;
      $C8 : Begin                 INY;  Inc(Cycles,2) End;
      $C9 : Begin       IMM;      CMP;  Inc(Cycles,2) End;
      $CA : Begin                 DEX;  Inc(Cycles,2) End;
      $CB : Begin       INVALID1;       Inc(Cycles,1) End;
      $CC : Begin       ABS;      CPY;  Inc(Cycles,4) End;
      $CD : Begin       ABS;      CMP;  Inc(Cycles,4) End;
      $CE : Begin       ABS;      DEC_; Inc(Cycles,5) End;
      $CF : Begin       INVALID1;       Inc(Cycles,1) End;
      $D0 : Begin       REL;      BNE;  Inc(Cycles,3) End;
      $D1 : Begin       INDY;     CMP;  Inc(Cycles,5) End;
      $D2 : Begin CMOS; IZPG;     CMP;  Inc(Cycles,5) End;
      $D3 : Begin       INVALID1;       Inc(Cycles,1) End;
      $D4 : Begin       INVALID2;       Inc(Cycles,4) End;
      $D5 : Begin       ZPGX;     CMP;  Inc(Cycles,4) End;
      $D6 : Begin       ZPGX;     DEC_; Inc(Cycles,6) End;
      $D7 : Begin       INVALID1;       Inc(Cycles,1) End;
      $D8 : Begin                 CLD;  Inc(Cycles,2) End;
      $D9 : Begin       ABSY;     CMP;  Inc(Cycles,4) End;
      $DA : Begin CMOS;           PHX;  Inc(Cycles,3) End;
      $DB : Begin       INVALID1;       Inc(Cycles,1) End;
      $DC : Begin       INVALID3;       Inc(Cycles,4) End;
      $DD : Begin       ABSX;     CMP;  Inc(Cycles,4) End;
      $DE : Begin       ABSX;     DEC_; Inc(Cycles,6) End;
      $DF : Begin       INVALID1;       Inc(Cycles,1) End;
      $E0 : Begin       IMM;      CPX;  Inc(Cycles,2) End;
      $E1 : Begin       INDX;     SBC;  Inc(Cycles,6) End;
      $E2 : Begin       INVALID2;       Inc(Cycles,2) End;
      $E3 : Begin       INVALID1;       Inc(Cycles,1) End;
      $E4 : Begin       ZPG;      CPX;  Inc(Cycles,3) End;
      $E5 : Begin       ZPG;      SBC;  Inc(Cycles,3) End;
      $E6 : Begin       ZPG;      INC_; Inc(Cycles,5) End;
      $E7 : Begin       INVALID1;       Inc(Cycles,1) End;
      $E8 : Begin                 INX;  Inc(Cycles,2) End;
      $E9 : Begin       IMM;      SBC;  Inc(Cycles,2) End;
      $EA : Begin                 NOP;  Inc(Cycles,2) End;
      $EB : Begin       INVALID1;       Inc(Cycles,1) End;
      $EC : Begin       ABS;      CPX;  Inc(Cycles,4) End;
      $ED : Begin       ABS;      SBC;  Inc(Cycles,4) End;
      $EE : Begin       ABS;      INC_; Inc(Cycles,6) End;
      $EF : Begin       INVALID1;       Inc(Cycles,1) End;
      $F0 : Begin       REL;      BEQ;  Inc(Cycles,3) End;
      $F1 : Begin       INDY;     SBC;  Inc(Cycles,5) End;
      $F2 : Begin CMOS; IZPG;     SBC;  Inc(Cycles,5) End;
      $F3 : Begin       INVALID1;       Inc(Cycles,1) End;
      $F4 : Begin       INVALID2;       Inc(Cycles,4) End;
      $F5 : Begin       ZPGX;     SBC;  Inc(Cycles,4) End;
      $F6 : Begin       ZPGX;     INC_; Inc(Cycles,6) End;
      $F7 : Begin       INVALID1;       Inc(Cycles,1) End;
      $F8 : Begin                 SED;  Inc(Cycles,2) End;
      $F9 : Begin       ABSY;     SBC;  Inc(Cycles,4) End;
      $FA : Begin CMOS;           PLX;  Inc(Cycles,4) End;
      $FB : Begin       INVALID1;       Inc(Cycles,1) End;
      $FC : Begin       INVALID3;       Inc(Cycles,4) End;
      $FD : Begin       ABSX;     SBC;  Inc(Cycles,4) End;
      $FE : Begin       ABSX;     INC_; Inc(Cycles,6) End;
      $FF : Begin       INVALID1;       Inc(Cycles,1) End
    End;
    Inc(Regs.PC)
  Until not (Cycles < TotalCycles);
  EF_TO_AF;
  Result := Cycles
End;

Function CpuExecute(Cycles : DWord) : Dword;
Var _Result      : DWord;
    CyclesToExec : DWord;
    Page         : Integer;
Begin
  _Result  := 0;
  // IF WE ARE SINGLE STEPPING, USING THE INTERPRETIVE EMULATOR
  If not Ok(Cycles) then Begin
    DWORD(LastStep) := 1;
    If Ok(@CpuExecuteFunc[1]) then _Result := CpuExecuteFunc[1](0)
                              Else _Result := InternalCpuExecute(0)
  End Else Begin
  // OTHERWISE, USE THE CURRENT EMULATOR.  IF WE HAVE BEEN REQUESTED TO
  // EXECUTE MORE THAN 65535 CYCLES, BREAK THE REQUEST INTO MULTIPLE
  // 65535-CYCLE CHUNKS, BECAUSE SOME OF THE EXTERNAL EMULATORS KEEP TRACK
  // OF THE CYCLE COUNT USING ONLY 16 BITS.
    If LastStep then Begin
      CpuResetCompilerData();
      LastStep := false
    End;
    If Cycles <= $FFFF then Begin
      If Ok(@CpuExecuteFunc[CpuEmType]) then _Result := CpuExecuteFunc[CpuEmType](Cycles)
                                        Else _Result := InternalCpuExecute(Cycles)
    End Else Begin
      Repeat
        CyclesToExec := MIN(65535,Cycles);
        If Ok(@CpuExecuteFunc[CpuEmType]) then Inc(_Result,CpuExecuteFunc[CpuEmType](CyclesToExec))
                                          Else Inc(_Result,InternalCpuExecute(CyclesToExec));
        Dec(Cycles,CyclesToExec)
      Until not Ok(Cycles)
    End
  End;
  // IF WE ARE USING THE EXTERNAL 6502 64K EMULATOR, MARK PAGES $40-$BF AS
  // DIRTY, BECAUSE IT DOES NOT KEEP TRACK OF DIRTY PAGES IN THAT RANGE.
  If not Apple2e and Ok(@CpuExeCuteFunc[1]) then Begin
    Page := $C0;
    While Page > $40 do Begin
      Dec(Page);
      LPBYTE(DWord(MemDirty) + Page)^ := $FF
    End
  End;
  Result := _Result
End;

Function CpuSupportsFastPaging : Bool;
Begin
  DWORD(Result) := Abs(Ord(CpuLibrary[CPU_FASTPAGING] <> hInst(0)))
End;

Procedure CpuSetupBenchmark;
Var Addr   : Integer;
    OpCode : Integer;
Begin
  Regs.a  := 0;
  Regs.x  := 0;
  Regs.y  := 0;
  Regs.pc := $300;
  Regs.sp := $1FF;
  // CREATE CODE SEGMENTS CONSISTING OF GROUPS OF COMMONLY-USED OPCODES
  Addr   := $300;
  Opcode := 0;
  Repeat
    LPBYTE(DWord(Mem) + Addr)^ := BenchOpcode[Opcode];
    Inc(Addr);
    LPBYTE(DWord(Mem) + Addr)^ := BenchOpcode[Opcode];
    Inc(Addr);
    If Opcode >= SHORTOPCODES then  Begin
      LPBYTE(DWord(Mem) + Addr)^ := 0;
      Inc(Addr)
    End;
    Inc(OpCode);
    If (OpCode >= BENCHOPCODES) or ((Addr AND $0F) >= $0B) then Begin
      LPBYTE(DWord(Mem)+ Addr)^ := $4C;
      Inc(Addr);
      If OpCode >= BENCHOPCODES then LPBYTE(DWord(Mem)+ Addr)^ := $00
                                Else LPBYTE(DWord(Mem)+ Addr)^ := ((Addr Shr 4) + 1) Shl 4;
      Inc(Addr);
      LPBYTE(DWord(Mem)+ Addr)^ := $03;
      Inc(Addr);
      While Ok(Addr AND $0F) do Inc(Addr)
    End
  Until not (Opcode < BENCHOPCODES)
End;

Procedure CpuGetCode(Address : Word; CodePtr : LPBYTEPTR; CodeLength : LPDWORD);
Begin
  CodePtr^    := Nil;
  CodeLength^ := 0;
  If Ok(@CpuGetCodeFunc[0]) then CpuGetCodeFunc[0](Address,CodePtr,CodeLength)
End;