Procedure UpdateCommState;
Var DCB : tDCB;
Begin
  If CommHandle = INVALID_HANDLE_VALUE then Exit;
  FillChar(DCB,SizeOf(tDCB),#0);
  DCB.DCBLength := SizeOf(tDCB);
  GetCommState(CommHandle,DCB);
  DCB.BaudRate := Baudrate;
  DCB.ByteSize := ByteSize;
  DCB.Parity   := Parity;
  DCB.StopBits := StopBits;
  SetCommState(CommHandle,DCB)
End;

Function CheckComm : Bool;
Var Portname : Array[0..7] of Char;
    ct       : COMMTIMEOUTS;
Begin
  CommInActivity := 0;
  If (CommHandle = INVALID_HANDLE_VALUE) and Ok(SerialPort) then Begin
    WvsPrintF(PortName,'COM%u',LPTSTR(IntToStr(SerialPort)));
    CommHandle := CreateFile(Portname,GENERIC_READ OR GENERIC_WRITE,0,PSecurityAttributes(Nil),OPEN_EXISTING,0,0);
    If CommHandle <> INVALID_HANDLE_VALUE then Begin
      UpdateCommState();
      FillChar(ct,SizeOf(COMMTIMEOUTS),#0);
      ct.ReadIntervalTimeout := MAXDWORD;
      SetCommTimeouts(commhandle,ct)
    End
  End;
  DWORD(Result) := Abs(Ord(CommHandle <> INVALID_HANDLE_VALUE))
End;

Procedure CheckReceive;
Begin
  If Ok(RecvBytes) or (CommHandle = INVALID_HANDLE_VALUE) then Exit;
  ReadFile(CommHandle,RecvBuffer,8,RecvBytes,Nil)
End;

Function CommCommand( ProgramCounter : Word;
                      Address        : Byte;
                      Write          : Byte;
                      Value          : Byte  ) : Byte; StdCall;
Begin
  If not Ok(CheckComm()) then Begin
    Result := 0;
    Exit
  End;
  If Ok(Write) and Ok(Value <> CommandByte) then Begin
    CommandByte := Value;
    // UPDATE THE PARITY
    If Ok(CommandByte AND $20) then Case CommandByte AND $C0 of
      $00 : Parity := ODDPARITY;
      $40 : Parity := EVENPARITY;
      $80 : Parity := MARKPARITY;
      $C0 : Parity := SPACEPARITY;
    End Else Parity := NOPARITY;
    UpdateCommState()
  End;
  Result := CommandByte
End;

Function CommControl( ProgramCounter : Word;
                      Address        : Byte;
                      Write          : Byte;
                      Value          : Byte  ) : Byte; StdCall;
Begin
  If not Ok(CheckComm()) then Begin
    Result := 0;
    Exit
  End;
  If Ok(Write) and (Value <> ControlByte) then Begin
    ControlByte := Value;
    // UPDATE THE BAUD RATE
    Case ControlByte AND $0F of
      $00 : ; // fall through
      $01 : ; // fall through
      $02 : ; // fall through
      $03 : ; // fall through
      $04 : ; // fall through
      $05 : Baudrate := CBR_110;
      $06 : Baudrate := CBR_300;
      $07 : Baudrate := CBR_600;
      $08 : Baudrate := CBR_1200;
      $09 : ; // fall through
      $0A : Baudrate := CBR_2400;
      $0B : ; // fall through
      $0C : Baudrate := CBR_4800;
      $0D : ; // fall through
      $0E : Baudrate := CBR_9600;
      $0F : Baudrate := CBR_19200
    End;
    // UPDATE THE BYTE SIZE
    Case ControlByte AND $60 of
      $00 : ByteSize := 8;
      $20 : ByteSize := 7;
      $40 : ByteSize := 6;
      $60 : ByteSize := 5
    End;
    // UPDATE THE NUMBER OF STOP BITS
    If Ok(ControlByte AND $80) then Begin
      If (ByteSize = 8) and (Parity = NOPARITY) then Begin
        StopBits := ONESTOPBIT
      End Else If (ByteSize = 5) and (Parity = NOPARITY) then Begin
        StopBits := ONE5STOPBITS
      End Else Begin
        StopBits := TWOSTOPBITS
      End
    End Else Begin
      StopBits := ONESTOPBIT
    End;
    UpdateCommState()
  End;
  Result := ControlByte
End;

Function CommDipSw( ProgramCounter : Word;
                    Address        : Byte;
                    Write          : Byte;
                    Value          : Byte  ) : Byte; StdCall;
Begin
  // note: determine what values a real SSC returns
  Result := 0
End;

Function CommReceive( ProgramCounter : Word;
                      Address        : Byte;
                      Write          : Byte;
                      Value          : Byte  ) : Byte; StdCall;
Var _Result : Byte;
Begin
  If not Ok(CheckComm()) then Begin
    Result := 0;
    Exit
  End;
  If not Ok(RecvBytes) then CheckReceive();
  _Result := 0;
  If Ok(RecvBytes) then Begin
    _Result := RecvBuffer[0];
    Dec(RecvBytes);
    If Ok(RecvBytes) then MoveMemory(@RecvBuffer,Pointer(DWord(@RecvBuffer) + 1),RecvBytes)
  End;
  Result := _Result
End;

Function CommStatus( ProgramCounter : Word;
                     Address        : Byte;
                     Write          : Byte;
                     Value          : Byte  ) : Byte; Stdcall;
Var ModemStatus : DWord;
    Val1        : Byte;
    Val2        : Byte;
    Val3        : Byte;
Begin
  If not Ok(CheckComm()) then Begin
    Result := $70;
    Exit
  End;
  If not Ok(RecvBytes) then CheckReceive();
  ModemStatus := 0;
  GetCommModemStatus(CommHandle,ModemStatus);
  If Ok(RecvBytes)                  then Val1 := $08 Else Val1 := $00;
  If Ok(ModemStatus AND MS_RLSD_ON) then Val2 := $00 Else Val2 := $20;
  If Ok(ModemStatus AND MS_DSR_ON)  then Val3 := $00 Else Val3 := $40;
  Result := $10 OR Val1 OR Val2 OR VAL3
End;

Function CommTransmit( ProgramCounter : Word;
                       Address        : Byte;
                       Write          : Byte;
                       Value          : Byte  ) : Byte; StdCall;
Var BytesWritten : DWord;
Begin
  If not Ok(CheckComm()) then Begin
    Result := 0;
    Exit
  End;
  WriteFile(CommHandle,Value,1,BytesWritten,Nil);
  Result := 0
End;

Procedure CloseComm;
Begin
  If CommHandle <> INVALID_HANDLE_VALUE then CloseHandle(CommHandle);
  CommHandle     := INVALID_HANDLE_VALUE;
  CommInActivity := 0
End;

Procedure CommUpdate( TotalCycles : DWord );
Var ModemStatus : DWord;
Begin
  If CommHandle = INVALID_HANDLE_VALUE then Exit;
  Inc(CommInActivity,TotalCycles);
  If CommInActivity > 1000000 then Begin
    If (CommInActivity > 2000000) or (CommInActivity - LastCheck > 99950) then Begin
      ModemStatus := 0;
      GetCommModemStatus(CommHandle,ModemStatus);
      If Ok(ModemStatus AND MS_RLSD_ON) or DiskIsSpinning() then CommInActivity := 0
    End;
    If CommInActivity > 2000000 then CloseComm()
  End
End;

Procedure CommReset;
Begin
  CloseComm();
  Baudrate    := CBR_19200;
  Bytesize    := 8;
  CommandByte := $00;
  ControlByte := $1F;
  Parity      := NOPARITY;
  RecvBytes   := 0;
  StopBits    := ONESTOPBIT
End;

Procedure CommSetSerialPort( Window : hWnd; NewSerialPort : DWord);
Begin
  If CommHandle = INVALID_HANDLE_VALUE then Begin
    SerialPort := NewSerialPort
  End Else Begin
    MessageBox(Window,
               'You cannot change the serial port while it is in use.','Configuration',
               MB_ICONEXCLAMATION OR MB_SETFOREGROUND)
  End
End;

Procedure CommDestroy;
Begin
  If (Baudrate <> CBR_19200) or (ByteSize <> 8) or (Parity <> NOPARITY) or (StopBits <> ONESTOPBIT) then Begin
    CommReset();
    CheckComm()
  End;
  CloseComm()
End;
