Procedure DisplayBenchmarkResults;
Var TotalTime : DWord;
    Buffer    : Array[0..63] of Char;
    Args      : String;
Begin
  TotalTime := GetTickCount() - ExtBench;
  VideoRedrawScreen();
  Args := IntToStr(UINT(TotalTime Div 1000)) + ',' + IntToStr(UINT((TotalTime Div 10) Mod 100));
  WVsPrintF(Buffer,'This benchmark took %u.%02u seconds.',PChar(@Args));
  MessageBox(FrameWindow,Buffer,'Benchmark Results',MB_ICONINFORMATION OR MB_SETFOREGROUND)
End;

Function SpkrToggle( ProgramCounter : Word;
                     Address        : Byte;
                     Write          : Byte;
                     Value          : Byte  ) : Byte; StdCall;
Var Loop  : DWord;
    Max   : DWord;
    Delta : DWord;
Begin
  NeedsPrecision := CumulativeCycles;
  If Ok(ExtBench) then Begin
    DisplayBenchmarkResults();
    ExtBench := 0
  End;
  If Ok(WaveOut) then Begin
    Inc(Toggles);
    Loop := (LastCycleNum Shr CycleShift) + WaveOffset;
    Max  := (CycleNum     Shr CycleShift) + WaveOffset;
    If Max <= Loop then Inc(Max,Succ(Loop));
    If Max > Pred(BufferSize) then Max := Pred(BufferSize);
    While Loop < Max do Begin
      LPBYTE(DWord(WaveData[WavePrep]) + Loop)^ := ToggleVal;
      Inc(Loop)
    End;
    LastCycleNum := CycleNum;
    ToggleVal    := NOT ToggleVal
  End Else If SoundType <> SOUND_NONE then Begin
    // IF WE ARE CURRENTLY PLAYING A SOUND EFFECT OR ARE IN DIRECT
    // EMULATION MODE, TOGGLE THE SPEAKER
    If (SoundEffect > 2) or (SoundType = SOUND_DIRECT) then Begin
      If Ok(DirectIO) then ASM
        PUSH EAX
        IN   AL,$61
        XOR  AL,2
        OUT  $61,AL
        POP  EAX
      End Else Begin
        Beep(37,DWORD(-1));
        Beep(0,0)
      End
    End;
    // SAVE INFORMATION ABOUT THE FREQUENCY OF SPEAKER TOGGLING FOR POSSIBLE
    // LATER USE BY SOUND AVERAGING
    If Ok(LastCycleNum) then Begin
      Inc(Toggles);
      Delta := CycleNum - LastCycleNum;
      // DETERMINE WHETHER WE ARE PLAYING A SOUND EFFECT
      If Ok(DirectIO) and ((Delta < 250) or (Ok(LastDelta[0]) and Ok(LastDelta[1]) and
                           (Delta - LastDelta[0] > 250) and (LastDelta[0] - Delta > 250) and
                           (Delta - LastDelta[1] > 250) and (LastDelta[1] - Delta > 250))) then Begin
        SoundEffect := MIN(35,SoundEffect + 2)
      End;
      LastDelta[1] := LastDelta[0];
      LastDelta[0] := Delta;
      Inc(TotalDelta,Delta)
    End;
    LastCycleNum := CycleNum
  End;
  Result := MemReturnRandomData(1)
End;

Function SpkrNeedsAccurateCycleCount : Bool;
Begin
  DWORD(Result) := Abs(Ord((SoundType = SOUND_WAVE) and (Ok(Toggles) or Ok(WaveOffset))))
End;

Function SpkrCyclesSinceSound : DWord;
Begin
  If Ok(WaveOut) then Result := 1000000 Else Result := QuietCycles
End;

Procedure SubmitWaveBuffer( Size : Integer );
Var Loop : Integer;
Begin
  // IF THIS IS WAVE BUFFER ZERO, THE OVERFLOW BUFFER, THEN IGNORE THE
  // REQUEST TO SUBMIT IT AND SKIP ON TO DETERMINING THE NEXT BUFFER TO USE
  If Ok(WavePrep) then Begin
    // OTHERWISE, BUILD A HEADER AND SUBMIT IT
    FillChar(WaveHdr[WavePrep]^,SizeOf(tWAVEHDR),#0);
    WaveHdr[WavePrep]^.lpData          := LPTSTR(WaveData[WavePrep]);
    WaveHdr[WavePrep]^.dwBufferLength  := Size;
    WaveHdr[WavePrep]^.dwFlags         := 0;
    WaveOutPrepareHeader(WaveOut,WaveHdr[WavePrep],SizeOf(tWAVEHDR));
    WaveOutWrite(WaveOut,WaveHdr[WavePrep],SizeOf(tWAVEHDR))
  End;
  // UNPREPARE ANY COMPLETED BUFFERS, AND FIND A FREE BUFFER TO USE NEXT
  WavePrep := 0;
  For Loop := 0 to Pred(WAVEBUFFERS) do Begin
    If WaveHdr[Loop]^.dwFlags AND (WHDR_DONE OR WHDR_PREPARED) = (WHDR_DONE OR WHDR_PREPARED) then Begin
      WaveOutUnprepareHeader(WaveOut,WaveHdr[Loop],SizeOf(tWAVEHDR));
      WaveHdr[Loop]^.dwFlags := 0
    End;
    If not Ok(WaveHdr[Loop]^.dwFlags AND WHDR_PREPARED) then WavePrep := Loop
  End
End;

Procedure InternalBeep( Frequency, Duration : DWord );
Begin
  If Ok(DirectIO) then If Ok(Duration) then Begin
    Frequency := 1193180 Div Frequency;
    ASM
      PUSH EAX
      MOV  AL,$B6
      OUT  $43,AL
      MOV  EAX,Frequency
      OUT  $42,AL
      MOV  AL,AH
      OUT  $42,AL
      IN   AL,$61
      OR   AL,3
      OUT  $61,AL
      POP  EAX
    End
  End Else Begin
    ASM
      PUSH eax
      IN   AL,$61
      AND  AL,$FC
      OUT  $61,AL
      POP  EAX
    End
  End Else Beep(Frequency,Duration)
End;

Procedure InternalClick;
Begin
  If Ok(DirectIO) then Begin
    ASM
      PUSH EAX
      IN   AL,$61
      XOR  AL,2
      OUT  $61,AL
      POP  EAX
    End
  End Else Begin
    Beep(37,DWord(-1));
    Beep(0,0)
  End
End;

Procedure SpkrUpdate( TotalCycles : DWord );
Var Loop   : Integer;
    Max    : Integer;
    NewVal : DWord;
Begin
  If Ok(WaveOut) then Begin
    // IF AT LEAST ONE TOGGLE WAS MADE DURING THIS CLOCK TICK, OR DURING A
    // PREVIOUS CLOCK TICK WHOSE BUFFER WE ARE SHARING, THEN SUBMIT THE
    // BUFFER TO THE WAVE DEVICE
    If Ok(Toggles) or Ok(WaveOffset) then Begin
      Loop := LastCycleNum Shr CycleShift;
      Max  := TotalCycles  Shr CycleShift;
      If Max + WaveOffset > Pred(BufferSize) then Max := BufferSize - Succ(WaveOffset);
      While Loop < max do Begin
        LPBYTE(DWord(WaveData[WavePrep]) + WaveOffset + Loop)^ := ToggleVal;
        Inc(Loop)
      End;
      If WaveOffset + (Max Shl 1) >= BufferUse then Begin
        SubmitWaveBuffer(WaveOffset + Max);
        Toggles    := 0;
        WaveOffset := 0
      End Else Inc(WaveOffset,Max);
      LastCycleNum := 0
    End Else Begin
    // OTHERWISE, CHECK FOR COMPLETED BUFFERS
      WavePrep := 0;
      SubmitWaveBuffer(0)
    End
  End Else Begin
    // IF WE ARE NOT PLAYING A SOUND EFFECT, PERFORM FREQUENCY AVERAGING
    If (SoundEffect > 2) or (SoundType = SOUND_DIRECT) then Begin
      LastVal := 0;
      If Ok(CurrentHertz) and (SoundEffect > 4) then Begin
        InternalBeep(0,0);
        CurrentHertz := 0
      End
    End Else If Ok(Toggles) and Ok(TotalDelta) then Begin
      NewVal := 1000000 * Toggles Div TotalDelta;
      If Ok(LastVal) and Ok(LastFull) and (NewVal - CurrentHertz > 50) and (CurrentHertz - NewVal > 50) then Begin
        InternalBeep(NewVal,DWord(-1));
        CurrentHertz := NewVal;
        LastToggles  := 0
      End;
      DWORD(LastFull) := Abs(Ord(TotalDelta + ((TotalDelta Div Toggles) Shl 1) >= TotalCycles));
      Inc(LastToggles,Toggles);
      LastVal      := NewVal
    End Else If Ok(CurrentHertz) then Begin
      InternalBeep(0,0);
      CurrentHertz := 0;
      LastFull     := false;
      LastToggles  := 0;
      LastVal      := 0
    End Else If Ok(LastVal) then Begin
      If LastToggles > 4 then CurrentHertz := LastVal
                         Else CurrentHertz := 0;
      If Ok(CurrentHertz) then InternalBeep(LastVal,DWord(-1))
                          Else InternalClick();
      LastFull     := false;
      LastToggles  := 0;
      LastVal      := 0
    End;
    // RESET THE FREQUENCY GATHERING VARIABLES
    LastCycleNum := 0;
    LastDelta[0] := 0;
    LastDelta[1] := 0;
    If Ok(Toggles) then QuietCycles := 0 Else QuietCycles := QuietCycles + TotalCycles;
    Toggles      := 0;
    TotalDelta   := 0;
    If Ok(SoundEffect) then Dec(SoundEffect)
  End
End;

Function SpkrNeedsFineGrainTiming : Bool;
Begin
  DWORD(Result) := Abs(Ord((SoundType = SOUND_DIRECT) or ((SoundType = SOUND_SMART) and Ok(SoundEffect))))
End;

Procedure SpkrDestroy;
Var Loop   : Integer;
    Handle : hGlobal;
Begin
  If Ok(WaveOut) then Begin
    WaveOutReset(WaveOut);
    For Loop := 0 to Pred(WAVEBUFFERS) do
      If Ok(WaveHdr[Loop]^.dwFlags AND WHDR_PREPARED) then Begin
        WaveOutUnprepareHeader(WaveOut,WaveHdr[Loop],SizeOf(WAVEHDR))
      End;
    WaveOutClose(WaveOut);
    WaveOut := hWAVEOUT(0);
    For Loop := 0 to Pred(WAVEBUFFERS) do Begin
      Handle := GlobalHandle(WaveData[Loop]);
      GlobalUnlock(Handle);
      GlobalFree(Handle);
      WaveData[Loop] := Nil;
      Handle := GlobalHandle(WaveHdr[Loop]);
      GlobalUnlock(Handle);
      GlobalFree(Handle);
      WaveHdr[Loop] := Nil
    End
  End Else InternalBeep(0,0)
End;

Function SpkrSetEmulationType( Window : hWnd; NewType : DWord ) : Bool;
Begin
  If SoundType <> SOUND_NONE then SpkrDestroy();
  SoundType := NewType;
  If SoundType <> SOUND_NONE then SpkrInitialize();
  If SoundType <> NewType then Case NewType of
    SOUND_DIRECT : Begin
                     MessageBox(Window,'Direct emulation is not available because the '+
                                       'operating system you are using does not allow '+
                                       'direct control of the speaker.',
                                       'Configuration',
                                MB_ICONEXCLAMATION OR MB_SETFOREGROUND);
                     Result := false;
                     Exit
                   End;
    SOUND_WAVE   : Begin
                     MessageBox(Window,'The emulator is unable to initialize a waveform '+
                                       'output device.  Make sure you have a sound card '+
                                       'and a driver installed and that windows is '+
                                       'correctly configured to use the driver.  Also '+
                                       'ensure that no other program is currently using '+
                                       'the device.',
                                       'Configuration',
                                MB_ICONEXCLAMATION OR MB_SETFOREGROUND);
                     Result := false;
                     Exit
                   End
  End;
  DWORD(Result) := 1
End;

Procedure TestPacketSize;
Var TestBuffer : Array[0..1] of Integer;
    Loop       : Integer;
    StartTime  : DWord;
    CurrTime   : DWord;
Begin
  If not Ok(WavePrep) then Exit;
  // SUBMIT TWO 2048 BYTE WAVE BUFFERS.  THESE SHOULD EACH TAKE 1/16TH
  // OF A SECOND TO COMPLETE.
  Loop := 2;
  While Ok(Loop) do Begin
    Dec(Loop);
    TestBuffer[Loop] := WavePrep;
    FillChar(WaveData[WavePrep]^,BufferSize,#$80);
    SubmitWaveBuffer(2048)
  End;
  // DETERMINE HOW MUCH TIME ELAPSES BEFORE ALL BUFFERS ARE COMPLETE.
  StartTime := TimeGetTime();
  Repeat
    CurrTime := TimeGetTime()
  Until not ((CurrTime - StartTime < 250) and not (Ok(WaveHdr[TestBuffer[0]]^.dwFlags AND WHDR_DONE) and
                                                   Ok(WaveHdr[TestBuffer[1]]^.dwFlags AND WHDR_DONE)));
  // THE BUFFERS SHOULD COMPLETE IN 1/8TH SECOND.  EVEN WITH OVERHEAD,
  // THEY SHOULD COMPLETE IN NO MORE THAN 1/5TH SECOND.  SO IF THEY HAVE
  // NOT COMPLETED IN 1/4TH SECOND, THEN THE AUDIO DRIVER MUST BE IMPOSING AN
  // ARTIFICIAL MINIMUM BUFFER SIZE.  GENERALLY THE MINIMUM SIZE USED IS
  // 1/4TH SECOND, SO WE INCREASE OUR BUFFER SIZE TO 1/4TH SECOND TO
  // COMPENSATE.
  If Currtime - StartTime >= 250 then BufferUse := Min(BufferSize,8192)
End;

Procedure SpkrInitialize;
Var Format : tWAVEFORMATEX;
    Loop   : Integer;
Begin
  // DETERMINE THE DEFAULT BUFFER SIZE
  BufferSize :=  8192;
  BufferRate := 30994;
  CycleShift :=     5;
  // DETERMINE WHETHER A WAVEFORM OUTPUT DEVICE IS AVAILABLE
  If SoundType = SOUND_WAVE then Begin
    If Ok(WaveOutGetNumDevs()) then Begin
      Try
        Format.wFormatTag      := WAVE_FORMAT_PCM;
        Format.nChannels       := 1;
        Format.nSamplesPerSec  := BufferRate;
        Format.nAvgBytesPerSec := BufferRate;
        Format.nBlockAlign     := 1;
        Format.wBitsPerSample  := 8;
        Format.cbSize          := SizeOf(tWAVEFORMATEX);
        If Ok(WaveOutOpen(@WaveOut,WAVE_MAPPER,@Format,0,0,0)) then WaveOut := hWAVEOUT(0)
      Except   // (EXCEPTION_EXECUTE_HANDLER) berprfen
        WaveOut := hWAVEOUT(0)
      End
    End Else WaveOut := hWAVEOUT(0);
    If Ok(WaveOut) then Begin
      Loop := WAVEBUFFERS;
      While Ok(Loop) do Begin
        Dec(Loop);
        WaveData[Loop] := LPBYTE(GlobalLock(GlobalAlloc(GMEM_MOVEABLE,BufferSize)));
        WaveHdr[Loop]  := pWAVEHDR(GlobalLock(GlobalAlloc(GMEM_MOVEABLE,SizeOf(tWAVEHDR))));
        FillChar(WaveData[Loop]^,BufferSize,#0);
        FillChar(WaveHdr[Loop]^,SizeOf(tWAVEHDR),#0)
      End;
      WavePrep  := 0;
      SubmitWaveBuffer(0);
      BufferUse := 0;
      RegLoadValue('Calibration','Wave Packet Size',false,@BufferUse);
      BufferUse := Max(2048,Min(BufferSize,BufferUse));
      RegSaveValue('Calibration','Wave Packet Size',false,BufferUse);
      If BufferUse = 2048 then TestPacketSize()
    End
  End;
  // IF NONE IS, THEN DETERMINE WHETHER WE HAVE DIRECT ACCESS TO THE
  // PC SPEAKER PORT
  If not Ok(WaveOut) then Begin
    If SoundType = SOUND_WAVE then SoundType := SOUND_SMART;
    Try
      ASM
        IN  AL,$61
        XOR AL,2
        OUT $61,AL
        XOR AL,2
        OUT $61,AL
      End;
      DWORD(DirectIO) := 1
    Except // (EXCEPTION_EXECUTE_HANDLER)
      On EPrivilege do DirectIO := false
    End;
    If not DirectIO and (SoundType = SOUND_DIRECT) then SoundType := SOUND_SMART
  End
End;
