Procedure BackMainImage;
Var Loop : Integer;
Begin
  Loop := 0;
  For Loop := 0 to 255 do Begin
    If Ok(MemShadow[0][Loop]) and (Ok(LPBYTE(DWord(MemDirty) + Loop)^ AND 1) or (Loop <= 1)) then Begin
      CopyMemory(MemShadow[0][Loop],LPBYTE(DWord(MemImage) + (Loop Shl 8)),256)
    End;
    LPBYTE(DWord(MemDirty) + Loop)^ := LPBYTE(DWord(MemDirty) + Loop)^ AND NOT 1
  End
End;

Function MemReturnRandomData( HighBit : Byte ) : Byte;
Const RetVal : Array[0..15] of Byte = ($00,$2D,$2D,$30,$30,$32,$32,$34,$35,$39,$43,$43,$43,$60,$7F,$7F);
Var   r      : Byte;
Begin
  r := Byte(Rand()) AND $FF;
  If r <= 170 then Begin
    If Ok(HighBit) then Result := $20 OR $80 Else Result := $20 OR 0
  End Else Begin
    If Ok(HighBit) then Result := RetVal[r AND 15] OR $80
                   Else Result := RetVal[r AND 15] OR 0
  End
End;

Procedure UpdatePaging( Initialize      : Boolean; UpdateWriteOnly : Boolean );
Var OldShadow  : Array[0..255] of LPBYTE;
    Loop       : Integer;
    BankOffset : Integer;
Begin
  // SAVE THE CURRENT PAGING SHADOW TABLE
  If not (Initialize or FastPaging or UpdateWriteOnly) then Begin
    CopyMemory(@OldShadow,@MemShadow[Image],256 * SizeOf(LPBYTE))
  End;
  // UPDATE THE PAGING TABLES BASED ON THE NEW PAGING SWITCH VALUES
  If Initialize then Begin
    For Loop :=   0 to 191 do MemWrite[Image][Loop] := LPBYTE(DWord(Mem) + (Loop Shl 8));
    For Loop := 192 to 207 do MemWrite[Image][Loop] := Nil
  End;
  If not UpdateWriteOnly then For Loop := 0 to 1 do Begin
    If Ok(SW_ALTZP) then MemShadow[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                    Else MemShadow[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8))
  End;
  For Loop := 2 to 191 do Begin
    If Ok(SW_AUXREAD) then MemShadow[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                      Else MemShadow[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8));
    If (SW_AUXREAD <> 0) = (SW_AUXWRITE <> 0) then Begin
      MemWrite[Image][Loop] := LPBYTE(DWord(Mem) + (Loop Shl 8))
    End Else If Ok(SW_AUXWRITE) then MemWrite[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                                Else MemWrite[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8))
  End;
  If not Ok(UpdateWriteOnly) then Begin
    For Loop := 192 to 199 do If Loop = 195 then Begin
      If Ok(SW_SLOTC3ROM) and Ok(SW_SLOTCXROM) then MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + $0300)
                                               Else MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + $1300)
    End Else Begin
      If Ok(SW_SLOTCXROM) then MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + (Loop Shl 8) - $C000)
                          Else MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + (Loop Shl 8) - $B000)
    End;
    For Loop := 200 to 207 do MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + (Loop Shl 8) - $B000)
  End;
  For Loop := 208 to 223 do Begin
    If Ok(SW_BANK2) then BankOffset := 0 Else BankOffset := $1000;
    If Ok(SW_HIGHRAM) then If Ok(SW_ALTZP) then MemShadow[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8) - BankOffset)
                                           Else MemShadow[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8) - BankOffset)
                      Else MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + (Loop Shl 8) - $B000);
    If Ok(SW_WRITERAM) then If Ok(SW_HIGHRAM) then MemWrite[Image][Loop] := LPBYTE(DWord(Mem) + (Loop Shl 8))
                                              Else If Ok(SW_ALTZP) then Begin
                                                MemWrite[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8) - BankOffset)
                                              End Else Begin
                                                MemWrite[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8) - BankOffset)
                                              End
                       Else MemWrite[Image][Loop] := Nil
  End;
  For Loop := 224 to 255 do Begin
    If Ok(SW_HIGHRAM) then If Ok(SW_ALTZP) then MemShadow[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                                           Else MemShadow[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8))
                      Else MemShadow[Image][Loop] := LPBYTE(DWord(MemRom) + (Loop Shl 8) - $B000);
    If Ok(SW_WRITERAM) then If Ok(SW_HIGHRAM) then MemWrite[Image][Loop] := LPBYTE(DWord(Mem) + (Loop Shl 8))
                                              Else If Ok(SW_ALTZP) then Begin
                                                MemWrite[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                                              End Else Begin
                                                MemWrite[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8))
                                              End
                       Else MemWrite[Image][Loop] := Nil
  End;
  If Ok(SW_80STORE) then Begin
    For Loop := 4 to 7 do Begin
      If Ok(mSW_PAGE2) then MemShadow[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                       Else MemShadow[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8));
      MemWrite[Image][Loop] := LPBYTE(DWord(Mem) + (Loop Shl 8))
    End;
    If Ok(mSW_HIRES) then For Loop := 32 to 63 do Begin
      If Ok(mSW_PAGE2) then MemShadow[Image][Loop] := LPBYTE(DWord(MemAux)  + (Loop Shl 8))
                       Else MemShadow[Image][Loop] := LPBYTE(DWord(MemMain) + (Loop Shl 8));
      MemWrite[Image][Loop] := LPBYTE(DWord(Mem) + (Loop Shl 8))
    End
  End;
  // MOVE MEMORY BACK AND FORTH AS NECESSARY BETWEEN THE SHADOW AREAS AND
  // THE MAIN RAM IMAGE TO KEEP BOTH SETS OF MEMORY CONSISTENT WITH THE NEW
  // PAGING SHADOW TABLE
  If not UpdateWriteOnly then Begin
    For Loop := 0 to 255 do If Initialize or (OldShadow[Loop] <> MemShadow[Image][Loop]) then Begin
      If not (Initialize or FastPaging) and (Ok(LPBYTE(DWord(MemDirty) + Loop)^ AND 1) or (Loop <= 1)) then Begin
        LPBYTE(DWord(MemDirty) + Loop)^ := LPBYTE(DWord(MemDirty) + Loop)^ AND NOT 1;
        CopyMemory(OldShadow[Loop],LPBYTE(DWord(Mem) + (Loop Shl 8)),256)
      End;
      CopyMemory(LPBYTE(DWord(Mem) + (Loop Shl 8)),MemShadow[Image][Loop],256)
    End
  End
End;

Procedure UpdateFastPaging;
Var Found     : Boolean;
    ImageNum  : DWord;
Begin
  Found    := false;
  ImageNum := 0;
  Repeat
    If (ImageMode[ImageNum] = MemMode) or ((LastImage >= 3) and
                                          ((ImageMode[ImageNum] AND MF_IMAGEMASK) = (MemMode AND MF_IMAGEMASK))) then Begin
      Found := true
    End Else Inc(ImageNum)
  Until not ((ImageNum <= LastImage) and not Found);
  If Found then Begin
    Image := ImageNum;
    Mem   := LPBYTE(DWord(MemImage) + (Image Shl 16));
    If ImageMode[Image] <> MemMode then Begin
      ImageMode[Image] := MemMode;
      UpdatePaging(false,true)
    End
  End Else Begin
    If Lastimage < Pred(MAXIMAGES) then Begin
      Inc(LastImage);
      ImageNum := LastImage;
      If LastImage >= 3 then VirtualAlloc(LPBYTE(DWord(MemImage) + LastImage * $10000),$10000,MEM_COMMIT,PAGE_READWRITE);
    End Else Begin
      If Nextimage > LastImage then NextImage := 0;
      ImageNum := NextImage;
      Inc(NextImage)
    End;
    Image := ImageNum;
    ImageMode[Image] := MemMode;
    Mem := LPBYTE(DWord(MemImage) + (Image Shl 16));
    UpdatePaging(true,false)
  End;
  CpuReinitialize()
End;

Procedure MemSetFastPaging( _On : Boolean );
Begin
  If FastPaging and ModeChanging then Begin
    ModeChanging := false;
    UpdateFastPaging()
  End Else If not FastPaging then Begin
    BackMainImage();
    If LastImage >= 3 then VirtualFree(LPBYTE(DWord(MemImage) + $30000),(LastImage - 2) Shl 16,MEM_DECOMMIT)
  End;
  DWORD(FastPaging) := Ord(_On);
  Image        := 0;
  Mem          := MemImage;
  LastImage    := 0;
  ImageMode[0] := MemMode;
  If not FastPaging then UpdatePaging(true,false);
  If FastPaging then CpuEmType := CPU_FASTPAGING Else CpuEmType := CPU_COMPILING;
  CpuReinitialize();
  If CpuEmType = CPU_COMPILING then CpuResetCompilerData()
End;

Procedure ResetPaging( Initialize : Boolean );
Begin
  If not Initialize then MemSetFastPaging(false);
  LastWriteRam := false;
  MemMode      := MF_BANK2 OR MF_SLOTCXROM OR MF_WRITERAM;
  UpdatePaging(Initialize,false)
End;

Procedure MemReset;
Begin
  // TURN OFF FAST PAGING IF IT IS CURRENTLY ACTIVE
  MemSetFastPaging(false);
  // INITIALIZE THE PAGING TABLES
  FillChar(MemShadow,MAXIMAGES * 256 * SizeOf(LPBYTE),#0);
  FillChar(MemWrite ,MAXIMAGES * 256 * SizeOf(LPBYTE),#0);
  // INITIALIZE THE RAM IMAGES
  FillChar(LPBYTE(MemAux)^, $10000,#0);
  FillChar(LPBYTE(MemMain)^,$10000,#0);
  // SET UP THE MEMORY IMAGE
  Mem   := MemImage;
  Image := 0;
  // INITIALIZE THE CPU
  CpuInitialize();
  // INITIALIZE PAGING, FILLING IN THE 64K MEMORY IMAGE
  ResetPaging(true);
  Regs.PC := LPWORD(DWord(Mem) + $FFFC)^
End;

Procedure MemInitialize;
Var NewLoc    : LPVOID;
    Filename  : Array[0..Pred(MAX_PATH)] of Char;
    _File     : tHandle;
    BytesRead : DWord;
    n         : Word;
Begin
  // ALLOCATE MEMORY FOR THE APPLE MEMORY IMAGE AND ASSOCIATED DATA
  // STRUCTURES
  //
  // THE MEMIMAGE BUFFER CAN CONTAIN EITHER MULTIPLE MEMORY IMAGES OR
  // ONE MEMORY IMAGE WITH COMPILER DATA
  MemAux   := LPBYTE(VirtualAlloc(NiL,$10000,                        MEM_COMMIT,PAGE_READWRITE));
  MemDirty := LPBYTE(VirtualAlloc(NiL,$100  ,                        MEM_COMMIT,PAGE_READWRITE));
  MemMain  := LPBYTE(VirtualAlloc(NiL,$10000,                        MEM_COMMIT,PAGE_READWRITE));
  MemRom   := LPBYTE(VirtualAlloc(NiL,$5000 ,                        MEM_COMMIT,PAGE_READWRITE));
  MemImage := LPBYTE(VirtualAlloc(NiL,MAX($30000,MAXIMAGES * $10000),MEM_RESERVE,PAGE_NOACCESS));
  If not Ok(MemAux) or not Ok(MemDirty) or not Ok(MemImage) or not Ok(MemMain) or not Ok(MemRom) then Begin
    MessageBox(GetDesktopWindow(),'The emulator was unable to allocate the memory it requires. Further execution is not possible.',
               TITLE,MB_ICONSTOP OR MB_SETFOREGROUND);
    ExitProcess(1)
  End;
  NewLoc := VirtualAlloc(MemImage,$30000,MEM_COMMIT,PAGE_READWRITE);
  If DWord(NewLoc) <> DWord(MemImage) then Begin
    MessageBox(GetDesktopWindow(),'The emulator has detected a bug in your operating '+
                                  'system. While changing the attributes of a memory '+
                                  'object, the operating system also changed its '+
                                  'location.',
               TITLE,MB_ICONEXCLAMATION OR MB_SETFOREGROUND)
  End;
  // Allocate memory for RAMWorks III - up to 8MB
  RW_Pages[0] := MemAux;
  For n := 1 to Pred(MAXEXPAGES) do Begin
    RW_Pages[n] := VirtualAlloc(Nil,$10000,MEM_COMMIT,PAGE_READWRITE);
    If not Ok(RW_Pages[n]) then Break
  End;
  // READ THE APPLE FIRMWARE ROMS INTO THE ROM IMAGE
  StrCopy(Filename,ProgDir);
  If Apple2e then StrCat(Filename,'APPLE2E.ROM') Else StrCat(Filename,'APPLE2.ROM');
  _File := CreateFile(Filename,GENERIC_READ,FILE_SHARE_READ,PSecurityAttributes(Nil),
                               OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL OR FILE_FLAG_SEQUENTIAL_SCAN,0);
  If _File = INVALID_HANDLE_VALUE then Begin
    MessageBox(GetDesktopWindow(),'Unable to open the required firmware ROM data file.',
               TITLE,MB_ICONSTOP OR MB_SETFOREGROUND);
    ExitProcess(1)
  End;
  ReadFile(_File,MemRom^,$5000,BytesRead,Nil);
  CloseHandle(_File);
  // REMOVE A WAIT ROUTINE FROM THE DISK CONTROLLER'S FIRMWARE
  LPBYTE(DWord(MemRom) + $064C)^ := $A9;
  LPBYTE(DWord(MemRom) + $064D)^ := $00;
  LPBYTE(DWord(MemRom) + $064E)^ := $EA;
  MemReset()
End;

Function MemCheckPaging( ProgramCounter : Word;
                         Address        : Byte;
                         Write          : Byte;
                         Value          : Byte  ) : Byte; StdCall;
Var _Result : Bool;
Begin
  _Result := false;
  Case Address of
    $11 : DWORD(_Result) := SW_BANK2;
    $12 : DWORD(_Result) := SW_HIGHRAM;
    $13 : DWORD(_Result) := SW_AUXREAD;
    $14 : DWORD(_Result) := SW_AUXWRITE;
    $15 : DWORD(_Result) := Abs(Ord(not Ok(SW_SLOTCXROM)));
    $16 : DWORD(_Result) := SW_ALTZP;
    $17 : DWORD(_Result) := SW_SLOTC3ROM;
    $18 : DWORD(_Result) := SW_80STORE;
    $1C : DWORD(_Result) := mSW_PAGE2;
    $1D : DWORD(_Result) := mSW_HIRES
  End;
  If Ok(_Result) then Result := KeybGetKeyCode() OR $80 Else Result := KeybGetKeyCode() OR 0
End;

Function MemSetPaging( ProgramCounter : Word;
                       Address        : Byte;
                       Write          : Byte;
                       Value          : Byte  ) : Byte; StdCall;
Var LastMemMode : DWord;
    WriteRam    : Bool;
Begin
  LastMemMode := MemMode;
  // DETERMINE THE NEW MEMORY PAGING MODE.
  If (Address >= $80) and (Address <= $8F) then Begin
    DWORD(WriteRam) := Address AND 1;
    MemMode := MemMode AND NOT (MF_BANK2 OR MF_HIGHRAM OR MF_WRITERAM);
    DWORD(LastWriteRam) := 1; // note: because diags.do doesn't set switches twice!
    If Ok(LastWriteRam) and Ok(WriteRam) then MemMode := MemMode OR MF_WRITERAM;
    If not Ok(Address AND 8) then MemMode := MemMode OR MF_BANK2;
    If (Address AND 2) Shr 1 = Address AND 1 then MemMode := MemMode OR MF_HIGHRAM;
    LastWriteRam := WriteRam
  End Else If Ok(Apple2e) then Case Address of
    $00 : MemMode := MemMode AND NOT MF_80STORE;
    $01 : MemMode := MemMode OR      MF_80STORE;
    $02 : MemMode := MemMode AND NOT MF_AUXREAD;
    $03 : MemMode := MemMode OR      MF_AUXREAD;
    $04 : MemMode := MemMode AND NOT MF_AUXWRITE;
    $05 : MemMode := MemMode OR      MF_AUXWRITE;
    $06 : MemMode := MemMode OR      MF_SLOTCXROM;
    $07 : MemMode := MemMode AND NOT MF_SLOTCXROM;
    $08 : MemMode := MemMode AND NOT MF_ALTZP;
    $09 : MemMode := MemMode OR      MF_ALTZP;
    $0A : MemMode := MemMode AND NOT MF_SLOTC3ROM;
    $0B : MemMode := MemMode OR      MF_SLOTC3ROM;
    $54 : MemMode := MemMode AND NOT MF_PAGE2;
    $55 : MemMode := MemMode OR      MF_PAGE2;
    $56 : MemMode := MemMode AND NOT MF_HIRES;
    $57 : MemMode := MemMode OR      MF_HIRES;
    $71 : If Ok(RW_Pages[Value]) then Begin                  // extended memory aux page number
	    MemAux := RW_Pages[Value];
	    //memmode &= ~MF_RWPMASK;
	    //memmode |= value;
	    If FastPaging then UpdateFastPaging() Else Begin
	      UpdatePaging(false,false);
	      If (CpuEmType = CPU_COMPILING) then CpuResetCompilerData()
	    End
          End;
    $73 : If Ok(RW_Pages[Value]) then Begin                  // Ramworks III set aux page number
	    MemAux := RW_Pages[Value];
	    //memmode &= ~MF_RWPMASK;
	    //memmode |= value;
 	    If FastPaging then UpdateFastPaging() Else Begin
	      UpdatePaging(false,false);
	      If (CpuEmType = CPU_COMPILING) then CpuResetCompilerData()
	    End
          End
  End;
  // IF THE EMULATED PROGRAM HAS JUST UPDATE THE MEMORY WRITE MODE AND IS
  // ABOUT TO UPDATE THE MEMORY READ MODE, HOLD OFF ON ANY PROCESSING UNTIL
  // IT DOES SO.
  If (Address >= 4) and (Address <= 5) and ((LPDWORD(Dword(Mem) + ProgramCounter)^ AND $00FFFEFF) = $00C0028D) then Begin
    DWORD(ModeChanging) := 1;
    If Ok(Write) then Result := 0 Else Result := MemReturnRandomData(1);
    Exit
  End;
  If (Address >= $80) and (Address <= $8F) and (ProgramCounter < $C000) and
     ((( LPDWORD(DWord(Mem) + ProgramCounter)^ AND $00FFFEFF) = $00C0048D) or
      (( LPDWORD(DWord(Mem) + ProgramCounter)^ AND $00FFFEFF) = $00C0028D)) then Begin
    DWORD(ModeChanging) := 1;
    If Ok(Write) then Result := 0 Else Result := MemReturnRandomData(1);
    Exit;
  End;
  // IF THE MEMORY PAGING MODE HAS CHANGED, UPDATE OUR MEMORY IMAGES AND
  // WRITE TABLES.
  If (LastMemMode <> MemMode) or Ok(ModeChanging) then Begin
    ModeChanging := false;
    Inc(Pages);
    // IF FAST PAGING IS ACTIVE, WE KEEP MULTIPLE COMPLETE MEMORY IMAGES
    // AND WRITE TABLES, AND SWITCH BETWEEN THEM.  THE FAST PAGING VERSION
    // OF THE CPU EMULATOR KEEPS ALL OF THE IMAGES COHERENT.
    If FastPaging then UpdateFastPaging()
    // IF FAST PAGING IS NOT ACTIVE THEN WE KEEP ONLY ONE MEMORY IMAGE AND
    // WRITE TABLE, AND UPDATE THEM EVERY TIME PAGING IS CHANGED.
    Else Begin
      UpdatePaging(false,false);
      If CpuEmType = CPU_COMPILING then CpuResetCompilerData()
    End
  End;
  If (Address <= 1) or ((Address >= $54) and (Address <= $57)) then
    VideoSetMode(ProgramCounter,Address,Write,Value);
  If Ok(Write) then Result := 0
               Else If (Address = $54) or (Address = $55) then Begin
                 Result := MemReturnRandomData(Abs(Ord(mSW_PAGE2 <> 0)))
               End Else Result := MemReturnRandomData(1)
End;

Function NullIo( ProgramCounter : Word;
                 Address        : Byte;
                 Write          : Byte;
                 Value          : Byte  ) : Byte; StdCall;
Const RetVal : Array[0..15] of Byte = ($58,$FC,$5B,$FF,$58,$FC,$5B,$FF,$0B,$10,$00,$00,$FF,$FF,$FF,$FF);                 
Var   r      : Byte;
Begin
  If Address AND $F0 = $A0 then Begin
    Result := RetVal[Address AND 15];
    Exit
  End Else If (Address >= $B0) and (Address <= $CF) then Begin
    r := Byte(Rand() AND $FF);
    If r >= $10 then Result := $A0
                Else If r >= 8 then Begin
                 If r > $0C then Result := $FF Else Result := $00
                End Else Result := Address AND $F7;
    Exit
  End Else If (Address AND $F0) = $D0 then Begin
    r := BYTE(Rand() AND $FF);
    If r >= $C0 then Result := $C0
                Else If r >= $80 then Result := $80
                Else If (Address = $D0) or (Address = $DF) then Result := 0
                Else If r >= $40 then Result := $40
                Else If r >= $30 then Result := $90
                Else Result := 0;
    Exit
  End Else Result := MemReturnRandomData(1)
End;

Function MemGetAuxPtr( Offset : Word ) : LPBYTE;
Var BytePtr : LPBYTE;
Begin
  If MemShadow[Image][Offset Shr 8] = LPBYTE(DWord(MemAux) + (Offset AND $FF00)) then Begin
    BytePtr := LPBYTE(DWord(Mem) + Offset)
  End Else Begin
    BytePtr := LPBYTE(DWord(MemAux) + Offset)
  End;
  If ((Ok(SW_PAGE2) and Ok(SW_80STORE)) or Ok(SW_80COL)) and (((Offset AND $FF00 >= $0400) and (Offset AND $FF00 <= 0700)) or
                                                              (Ok(SW_HIRES) and (Offset AND $FF00 >= $2000) and (Offset AND $FF00<= $3F00))) then Begin
    If MemShadow[Image][Offset Shr 8] = LPBYTE(DWord(RW_Pages[0]) + (Offset AND $FF00)) then Begin
      BytePtr := LPBYTE(DWord(Mem) + Offset)
     End Else Begin
      BytePtr := LPBYTE(DWord(RW_Pages[0]) + Offset)
    End
  End;
  Result := BytePtr      
End;

Function MemGetMainPtr( Offset : Word ) : LPBYTE;
Begin
  If MemShadow[Image][Offset Shr 8] = LPBYTE(DWord(MemMain) + (Offset AND $FF00)) then Begin
    Result := LPBYTE(DWord(Mem) + Offset)
  End Else Begin
    Result := LPBYTE(DWord(MemMain) + Offset)
  End  
End;

Procedure MemTrimImages;
Var RealImage  : DWord;
Begin
  If Ok(FastPaging) and (LastImage > 2) then Begin
    If Ok(ModeChanging) then Begin
      ModeChanging := false;
      UpdateFastPaging()
    End;
    If (Image <> TrimNumber) and (Image <> LastImage) and (TrimNumber < LastImage) then Begin
      ImageMode[TrimNumber] := ImageMode[LastImage];
      VirtualFree(Ptr(DWord(MemImage) + (LastImage Shl 16)),$10000,MEM_DECOMMIT);
      Dec(LastImage);
      RealImage := Image;
      Image   := TrimNumber;
      Mem     := Ptr(DWord(MemImage) + (Image Shl 16));
      MemMode := ImageMode[Image];
      UpdatePaging(true,false);
      Image   := RealImage;
      Mem     := Ptr(DWord(MemImage) + (Image Shl 16));
      MemMode := ImageMode[Image];
      CpuReinitialize()
    End;
    Inc(TrimNumber);
    If TrimNumber >= LastImage then TrimNumber := 0
  End
End;

Procedure MemDestroy;
Var n : Word;
Begin
  If FastPaging then MemSetFastPaging(false);
  VirtualFree(MemImage,MAX($30000,$10000 * Succ(LastImage)),MEM_DECOMMIT);
  VirtualFree(MemAux  ,0,MEM_RELEASE);
  VirtualFree(MemDirty,0,MEM_RELEASE);
  VirtualFree(MemImage,0,MEM_RELEASE);
  VirtualFree(MemMain ,0,MEM_RELEASE);
  VirtualFree(MemRom  ,0,MEM_RELEASE);
  For n := 1 to Pred(MAXEXPAGES) do Begin
    If Ok(RW_Pages[n]) then Begin
      VirtualFree(RW_Pages[n],0,MEM_RELEASE);
      RW_Pages[n] := Nil;
    End
  End;
  RW_Pages[0] := Nil;
  MemAux      := NiL;
  MemDirty    := NiL;
  MemImage    := NiL;
  MemMain     := Nil;
  MemRom      := NiL;
  Mem         := NiL;
  FillChar(MemWrite,SizeOf(MemWrite),#0);
  FillChar(MemShadow,SizeOf(MemShadow),#0)
End;

Procedure MemResetPaging;
Begin
  ResetPaging(false)
End;
