Procedure DrawCrosshairs( x,y : Integer );
Var DC          : hDC;
    Loop        : Integer;
    Rect        : tRect;

  Procedure Line(x1,y1,x2,y2 : Integer);
  Begin
    MoveToEx(DC,x1,y1,Nil);
    LineTo(DC,x2,y2)
  End;

Begin
  FrameReleaseDC();
  DC := GetDC(FrameWindow);
  // ERASE THE OLD CROSSHAIRS
  If Ok(LastX) and Ok(LastY) then If Ok(Fullscreen) then Begin
    Loop := 4;
    While Ok(Loop) do Begin
      Dec(Loop);
      Rect.Left   := 0;
      Rect.Top    := 0;
      Rect.Right  := 5;
      Rect.Bottom := 5;
      Case Loop of
        0 : OffsetRect(Rect,LastX - 2,FSVIEWPORTY - 5);
        1 : OffsetRect(Rect,LastX - 2,FSVIEWPORTY + cVIEWPORTCY);
        2 : OffsetRect(Rect,FSVIEWPORTX - 5,LastY - 2);
        3 : OffsetRect(Rect,FSVIEWPORTX + cVIEWPORTCX,LastY - 2)
      End;
      FillRect(DC,Rect,hBrush(GetStockObject(BLACK_BRUSH)))
    End
  End Else Begin
    Loop := 5;
    While Ok(loop) do Begin
      Dec(Loop);
      Case Loop of
        0 : SelectObject(DC,GetStockObject(BLACK_PEN));
        1 : ; // fall through
        2 : SelectObject(DC,BtnShadowPen);
        3 : ; // fall through
        4 : SelectObject(DC,BtnFacePen)
      End;
      LINE(LastX - 2,cVIEWPORTY - Pred(Loop),LastX + 3, cVIEWPORTY - Pred(Loop));
      LINE(cVIEWPORTX - Pred(Loop),LastY - 2,cVIEWPORTX - Pred(Loop),LastY + 3);
      If (Loop = 1) or (Loop = 2) then SelectObject(DC,BtnHighLightPen);
      LINE(LastX - 2,cVIEWPORTY + cVIEWPORTCY + Loop,LastX + 3,cVIEWPORTY + cVIEWPORTCY + Loop);
      LINE(cVIEWPORTX + cVIEWPORTCX + Loop,Lasty - 2,cVIEWPORTX + cVIEWPORTCX + Loop,LastY + 3)
    End
  End;
  // DRAW THE NEW CROSSHAIRS
  If Ok(x) and Ok(y) then Begin
    Loop := 4;
    While Ok(Loop) do Begin
      Dec(Loop);
      If (Loop = 1) or (Loop = 2) then SelectObject(DC,GetStockObject(WHITE_PEN))
                                  Else SelectObject(DC,GetStockObject(BLACK_PEN));
      LINE(x + loop - 2,ViewPortY - 5,x + Loop - 2,ViewPortY);
      LINE(x + Loop - 2,ViewPortY + cVIEWPORTCY + 4,x + Loop - 2,ViewPortY + Pred(cVIEWPORTCY));
      LINE(ViewPortX - 5,y + Loop - 2,ViewPortX,y + Loop - 2);
      LINE(ViewPortX + cVIEWPORTCX + 4,y + Loop - 2,ViewPortX + Pred(cVIEWPORTCX),y + Loop - 2)
    End
  End;
  LastX := x;
  LastY := y;
  ReleaseDC(FrameWindow,DC)
End;

Procedure SetUsingCursor( NewValue : Bool );
Var Rect  : tRect;
    Point : tPoint;
Begin
  If NewValue = UsingCursor then Exit;
  UsingCursor := NewValue;
  If Ok(UsingCursor) then Begin
    SetCapture(FrameWindow);
    Rect.Left   := ViewportX + 2;
    Rect.Top    := ViewportY + 2;
    Rect.Right  := ViewportX + cVIEWPORTCX - 1;
    Rect.Bottom := ViewportY + cVIEWPORTCY - 1;
    ClientToScreen(FrameWindow,Rect.TopLeft);
    ClientToScreen(FrameWindow,Rect.BottomRight);
    ClipCursor(@Rect);
    ShowCursor(false);
    GetCursorPos(Point);
    ScreenToClient(FrameWindow,Point);
    DrawCrosshairs(Point.x,Point.y)
  End Else Begin
    DrawCrosshairs(0,0);
    ShowCursor(true);
    ClipCursor(Nil);
    ReleaseCapture()
  End
End;

Procedure SetNormalMode;
Begin
  Fullscreen := false;
  ButtonX    := cBUTTONX;
  ButtonY    := cBUTTONY;
  ViewportX  := cVIEWPORTX;
  ViewportY  := cVIEWPORTY;
  {DirectDraw^.RestoreDisplayMode();
  DirectDraw^.SetCooperativeLevel(Nil,DDSCL_NORMAL);}
  SetWindowLong(FrameWindow,GWL_STYLE,WS_OVERLAPPED OR WS_CAPTION OR WS_SYSMENU OR WS_MINIMIZEBOX OR WS_VISIBLE);
  SetWindowPos(FrameWindow,0,FrameRect.Left,FrameRect.Top,
               FrameRect.Right - FrameRect.Left,FrameRect.Bottom - FrameRect.Top,SWP_NOZORDER OR SWP_FRAMECHANGED);
  {If Ok(Surface) then Begin
    Surface^.Release();
    Surface := (LPDIRECTDRAWSURFACE)0;
  End;
  DirectDraw^.Release();
  DirectDraw := (LPDIRECTDRAW)0}
End;

Procedure CreateGdiObjects;

  Function LoadButtonBitmap( BitmapName : LPTSTR ) : hBitmap;
  Begin
    Result := LoadImage(Instance,BitmapName,IMAGE_BITMAP,0,0,LR_CREATEDIBSECTION OR
                                                             LR_LOADMAP3DCOLORS  OR
                                                             LR_LOADTRANSPARENT)
  End;

Begin
  FillChar(ButtonBitmap,BUTTONS * SizeOf(hBitmap),#0);
  ButtonBitmap[BTN_HELP   ] := LoadButtonBitmap('HELP_BUTTON');
  ButtonBitmap[BTN_RUN    ] := LoadButtonBitmap('RUN_BUTTON');
  ButtonBitmap[BTN_DRIVE1 ] := LoadButtonBitmap('DRIVE1_BUTTON');
  ButtonBitmap[BTN_DRIVE2 ] := LoadButtonBitmap('DRIVE2_BUTTON');
  ButtonBitmap[BTN_FULLSCR] := LoadButtonBitmap('FULLSCR_BUTTON');
  ButtonBitmap[BTN_COLOR  ] := LoadButtonBitmap('COLOR_BUTTON');
  ButtonBitmap[BTN_DEBUG  ] := LoadButtonBitmap('DEBUG_BUTTON');
  ButtonBitmap[BTN_SETUP  ] := LoadButtonBitmap('SETUP_BUTTON');
  CapsBitmap[0] := LoadButtonBitmap('CAPSOFF_BITMAP');
  CapsBitmap[1] := LoadButtonBitmap('CAPSON_BITMAP');
  DiskBitmap[0] := LoadButtonBitmap('DISKOFF_BITMAP');
  DiskBitmap[1] := LoadButtonBitmap('DISKREAD_BITMAP');
  DiskBitmap[2] := LoadButtonBitmap('DISKWRITE_BITMAP');
  BtnFaceBrush    := CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
  BtnFacePen      := CreatePen(PS_SOLID,1,GetSysColor(COLOR_BTNFACE));
  BtnHighlightPen := CreatePen(PS_SOLID,1,GetSysColor(COLOR_BTNHIGHLIGHT));
  BtnShadowPen    := CreatePen(PS_SOLID,1,GetSysColor(COLOR_BTNSHADOW));
  Smallfont := CreateFont(11,6,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
                          DEFAULT_QUALITY,VARIABLE_PITCH OR FF_SWISS,'Small Fonts')
End;

Procedure Draw3DRect( DC          : hDC;
                      X1,Y1,X2,Y2 : Integer;
                      _Out        : Boolean  );
Var Pt : Array[0..2] of tPoint;
Begin
  SelectObject(DC,GetStockObject(NULL_BRUSH));
  If OK(_Out) then SelectObject(DC,BtnShadowPen) Else SelectObject(DC,BtnHighlightPen);
  Pt[0].X := X1;       Pt[0].Y := Pred(Y2);
  Pt[1].X := Pred(X2); Pt[1].Y := Pred(Y2);
  Pt[2].X := Pred(X2); Pt[2].Y := Y1;
  PolyLine(DC,Pt,3);
  If Ok(_Out) then SelectObject(DC,BtnHighlightPen) Else SelectObject(DC,BtnShadowPen);
  Pt[1].X := X1;       Pt[1].Y := Y1;
  Pt[2].X := X2;       Pt[2].Y := Y1;
  Polyline(DC,Pt,3)
End;

Procedure DrawBitmapRect( DC     : hDC;
                          X,Y    : Integer;
                          Rect   : LPRECT;
                          Bitmap : hBitmap  );
Var MemDC : hDC;
Begin
  MemDC := CreateCompatibleDC(DC);
  SelectObject(MemDC,Bitmap);
  BitBlt(DC,X,Y,Succ(Rect^.Right)  - Rect^.Left,Succ(Rect^.Bottom) - Rect^.Top,MemDC,Rect^.Left,Rect^.Top,SRCCOPY);
  DeleteDC(MemDC)
End;

Procedure DrawButton( PassDC : hDC; Number : Integer );
Var DC   : hDC;
    X,Y  : Integer;
    Loop : Integer;
    Rect   : tRect;
    Offset : Integer;
Begin
  FrameReleaseDC();
  If Ok(PassDC) then DC := PassDC Else DC := GetDC(FrameWindow);
  X  := ButtonX;
  Y  := ButtonY + Number * BUTTONCY;
  If (Number = ButtonDown) then Begin
    Loop := 0;
    While Loop < 3 do Begin
      Inc(Loop);
      Draw3dRect(DC,X + Loop,Y + Loop, X + BUTTONCX,Y + BUTTONCY,false)
    End;
    Rect.Left   :=  0;
    Rect.Top    :=  0;
    Rect.Right  := 39;
    Rect.Bottom := 39;
    DrawBitmapRect(DC,x + 4,y + 4,@Rect,ButtonBitmap[Number])
  End Else Begin
    Draw3dRect(DC,X + 1,Y + 1,X + BUTTONCX,  Y + BUTTONCY,true);
    Draw3dRect(DC,X + 2,Y + 2,X + BUTTONCX-1,Y + BUTTONCY - 1,true);
    Rect.Left   :=  1;
    Rect.Top    :=  1;
    Rect.Right  := 40;
    Rect.Bottom := 40;
    DrawBitmapRect(DC,X + 3,Y + 3,@Rect,ButtonBitmap[Number])
  End;
  If (Number = BTN_DRIVE1) or (Number = BTN_DRIVE2) then Begin
    Offset := Abs(Ord(Number = ButtonDown)) Shl 1;
    Rect.Left   := x + Offset +  3;
    Rect.Top    := y + Offset + 31;
    Rect.Right  := x + Offset + 42;
    Rect.Bottom := y + Offset + 42;
    SelectObject(DC,Smallfont);
    SetTextColor(DC,RGB(0,0,0));
    SetTextAlign(DC,TA_CENTER OR TA_TOP);
    SetBkMode(DC,TRANSPARENT);
    ExtTextOut(DC,X + Offset + 22,Rect.Top,ETO_CLIPPED,@Rect,DiskGetName(Number - BTN_DRIVE1),
               Min(8,StrLen(DiskGetName(Number - BTN_DRIVE1))),Nil)
  End;
  If not Ok(PassDC) then ReleaseDC(FrameWindow,DC)
End;

Procedure ResetMachineState;
Begin
  MemReset();
  DiskBoot();
  VideoResetState();
  CommReset();
  JoyReset()
End;

Procedure DrawStatusArea( PassDC    : hDC;
                          DrawFlags : Integer);
Var DC            : hDC;
    X,Y           : Integer;
    Drive1,Drive2 : Integer;
    Val1,Val2     : Byte;
    Caps          : Bool;
    Rect          : tRect;
    TitleText     : Array[0..39] of Char;
Begin
  FrameReleaseDC();
  If Ok(PassDC) then DC := PassDC Else DC := GetDC(FrameWindow);
  X      := ButtonX;
  Y      := ButtonY + BUTTONS * BUTTONCY + 1;
  Drive1 := 0;
  Drive2 := 0;
  Caps   := false;
  DiskGetLightStatus(@Drive1,@Drive2);
  KeybGetCapsStatus(@Caps);
  If Ok(FullScreen) then Begin
    SelectObject(DC,SmallFont);
    SetBkMode(DC,OPAQUE);
    SetBkColor(DC,RGB(0,0,0));
    SetTextAlign(DC,TA_LEFT OR TA_TOP);
    If Drive1 = 2 then Val1 := 255 Else Val1 := 0;
    If Drive1 = 1 then Val2 := 255 Else Val2 := 0;
    SetTextColor(DC,RGB(Val1,Val2,0));
    TextOut(DC,X + 3,Y + 2,'1',1);
    If Drive2 = 2 then Val1 := 255 Else Val1 := 0;
    If Drive2 = 1 then Val2 := 255 Else Val2 := 0;
    SetTextColor(DC,RGB(Val1,Val2,0));
    TextOut(DC,X + 13,Y + 2,'2',1);
    If Ok(Apple2e) then Begin
      SetTextAlign(DC,TA_RIGHT OR TA_TOP);
      If Ok(Caps) then SetTextColor(DC,RGB(128,128,128)) Else SetTextColor(DC,RGB(0,0,0));
      TextOut(DC,X + BUTTONCX,Y + 2,'Caps',4)
    End;
    SetTextAlign(DC,TA_CENTER OR TA_TOP);
    If (Mode = MODE_PAUSED) or (Mode = MODE_STEPPING) then SetTextColor(DC,RGB(255,255,255))
                                                      Else SetTextColor(DC,RGB(0,0,0));
    If Mode = MODE_PAUSED then TextOut(DC,X + BUTTONCX Div 2,Y + 13,' Paused ',8)
                          Else TextOut(DC,X + BUTTONCX Div 2,Y + 13,'Stepping',8)
  End Else Begin
    If Ok(DrawFlags AND DRAW_BACKGROUND) then Begin
      SelectObject(DC,GetStockObject(NULL_PEN));
      SelectObject(DC,BtnFaceBrush);
      Rectangle(DC,X,Y,X + BUTTONCX + 2,Y + 35);
      Draw3DRect(DC,X + 1,Y + 3,X + BUTTONCX,Y + 31,false);
      SelectObject(DC,SmallFont);
      SetTextAlign(DC,TA_CENTER OR TA_TOP);
      SetTextColor(DC,RGB(0,0,0));
      SetBkMode(DC,TRANSPARENT);
      TextOut(DC,X +  7,Y + 7,'1',1);
      TextOut(DC,X + 25,Y + 7,'2',1)
    End;
    If Ok(DrawFlags AND DRAW_LEDS) then Begin
      Rect.Left   := 0;
      Rect.Top    := 0;
      Rect.Right  := 8;
      Rect.Bottom := 8;
      DrawBitmapRect(DC,X + 12,Y + 8,@Rect,DiskBitmap[Drive1]);
      DrawBitmapRect(DC,X + 30,Y + 8,@Rect,DiskBitmap[Drive2]);
      If Ok(Apple2e) then Begin
        Rect.Left   :=  0;
        Rect.Top    :=  0;
        Rect.Right  := 30;
        Rect.Bottom :=  8;
        DrawBitmapRect(DC,X + 7,Y + 19,@Rect,CapsBitmap[Abs(Ord(Caps <> false))])
      End
    End;
    If Ok(DrawFlags AND DRAW_TITLE) then Begin
      If Ok(Apple2e) then StrCopy(TitleText,TITLE) Else StrCopy(TitleText,'Apple ][+ Emulator');
      Case Mode of
        MODE_PAUSED    : StrCat(TitleText,' [Paused]');
        MODE_STEPPING  : StrCat(TitleText,' [Stepping]')
      End;
      SendMessage(FrameWindow,WM_SETTEXT,0,LPARAM(@TitleText))
    End
  End;
  If not Ok(PassDC) then ReleaseDC(FrameWindow,DC)
End;

Procedure SetFullScreenMode;
Begin
  DWORD(Fullscreen) := 1;
  ButtonOver := -1;
  ButtonX    := FSBUTTONX;
  ButtonY    := FSBUTTONY;
  ViewPortX  := FSVIEWPORTX;
  ViewPortY  := FSVIEWPORTY;
  GetWindowRect(FrameWindow,FrameRect);
  SetWindowLong(FrameWindow,GWL_STYLE,WS_POPUP OR WS_SYSMENU OR WS_VISIBLE);
//  DDSURFACEDESC ddsd;
//  ddsd.dwSize = sizeof(ddsd);
//  ddsd.dwFlags = DDSD_CAPS;
//  ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
//  if (DirectDrawCreate(NULL,&directdraw,NULL) != DD_OK ||
//      directdraw->SetCooperativeLevel(framewindow,DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN) != DD_OK ||
//      directdraw->SetDisplayMode(640,480,8) != DD_OK ||
//      directdraw->CreateSurface(&ddsd,&surface,NULL) != DD_OK) {
//    SetNormalMode();
//    return;
//  }
  InvalidateRect(FrameWindow,Nil,True)
End;

Procedure EnableTrackbar( Window : hWnd; Enable : Bool );
Var Loop : Integer;
Begin
  EnableWindow(GetDlgItem(Window,108),Enable);
  Loop := 120;
  While Loop < 124 do Begin
    Inc(Loop);
    EnableWindow(GetDlgItem(Window,Loop),Enable)
  End
End;

Procedure FillComboBox( Window : hWnd; ControlID : Integer; Choices : LPTSTR; CurrentChoice : Integer);
Var ComboWindow : hWnd;
Begin
  ComboWindow := GetDlgItem(Window,ControlID);
  SendMessage(ComboWindow,CB_RESETCONTENT,0,0);
  While Ok(Choices^) do Begin
    SendMessage(ComboWindow,CB_ADDSTRING,0,LPARAM(Choices));
    Inc(Choices,StrLen(Choices) + 1)
  End;
  SendMessage(ComboWindow,CB_SETCURSEL,CurrentChoice,0)
End;

Function ConfigDlgProc( Window : hWnd; Msg : UINT; wParam : WPARAM; lParam : LPARAM ) : Bool; stdcall;
Var NewCompType    : Bool;
    NewVidType     : DWord;
    NewJoyType     : DWord;
    NewSoundType   : DWord;
    NewSerialPort  : DWord;
    NewDiskType    : Bool;
    NewH_Scanlines : Bool;
    Custom         : Bool;
    pt             : tPoint;
    Ptr            : LPTSTR;
    Rect           : tRect;
    DC             : hDC;
    Bitmap         : hBitmap;
    clrBackground  : COLORREF;
    clrForeground  : COLORREF;
    myColor        : COLORREF;
    lpdis          : pDRAWITEMSTRUCT;
    tm             : TEXTMETRIC;
    n              : Byte;
    x,y            : Integer;
    cx,cy          : Integer;
    Entry          : DWord;

    Procedure SAVE( a : LPTSTR; b : Cardinal );
    Begin
      RegSaveValue('Configuration',a,true,b)
    End;

    Procedure SAVELONG( a : LPTSTR; NamPtr : LPTSTR );
    Var Buffer : Array[0..511] of Char;
        n      : Byte;
        BufPtr : LPTSTR;
    Begin
      FillChar(Buffer,SizeOf(Buffer),#0);
      n := 0;
      BufPtr := Buffer;
      While Ok(NamPtr^) do Begin
        StrFmt(BufPtr,'%s = 0x%.8X',[NamPtr,ColorTable[0,n]]);
        Inc(BufPtr,Succ(StrLen(BufPtr)));
        Inc(NamPtr,Succ(StrLen(NamPtr)));
        Inc(n)
      End;
      RegSaveStringLong('Configuration',a,true,Buffer,SizeOf(Buffer))
    End;

Begin
  Case Msg of
    WM_COMMAND        : Begin
                          Case LoWord(wParam) of
                            IDOK     : Begin
                                         DWord(NewCompType) := DWord(SendDlgItemMessage(Window,101,CB_GETCURSEL,0,0));
                                         NewVidType         := DWord(SendDlgItemMessage(Window,105,CB_GETCURSEL,0,0));
                                         NewJoyType         := DWord(SendDlgItemMessage(Window,102,CB_GETCURSEL,0,0));
                                         NewSoundType       := DWord(SendDlgItemMessage(Window,103,CB_GETCURSEL,0,0));
                                         NewSerialPort      := DWord(SendDlgItemMessage(Window,104,CB_GETCURSEL,0,0));
                                         DWord(NewDiskType) := DWord(SendDlgItemMessage(Window,109,CB_GETCURSEL,0,0));
                                         If NewCompType <> Apple2e then
                                           If MessageBox(Window,'You have changed the emulated computer type.  This change will not take effect '+
                                                                'until the next time you restart the emulator.'#0#0+
                                                                'Would you like to restart the emulator now?','Configuration',
                                                                MB_ICONQUESTION OR MB_YESNO OR MB_SETFOREGROUND) = IDYES then Begin
                                             DWORD(Afterclose) := 2
                                           End;
                                         If NewDiskType <> EnhanceDisk then
                                           If MessageBox(Window,'You have changed the disk speed setting.  This change will not take effect '+
                                                                'until the next time you restart the emulator.'#0#0+
                                                                'Would you like to restart the emulator now?','Configuration',
                                                                MB_ICONQUESTION OR MB_YESNO OR MB_SETFOREGROUND) = IDYES then Begin
                                             DWORD(AfterClose) := 2
                                           End;
                                         If not Ok(JoySetEmulationType(Window,NewJoyType)) then Begin
                                           AfterClose := false;
                                           Result := false;
                                           Exit
                                         End;
                                         If not Ok(SpkrSetEmulationType(Window,NewSoundType)) then Begin
                                           AfterClose := false;
                                           Result := false;
                                           Exit
                                         End;
                                         DWORD(NewH_Scanlines) := IsDlgButtonChecked(Window,150);
                                         If (VideoType <> NewVidType) or (H_Scanlines <> NewH_Scanlines) or ColorChanged then Begin
                                           H_Scanlines := NewH_Scanlines;
                                           VideoType   := NewVidType;
                                           VideoReinitialize();
                                           If (Mode <> MODE_LOGO) and (Mode <> MODE_DEBUG) then VideoRedrawScreen()
                                         End;
                                         CommSetSerialPort(Window,NewSerialPort);
                                         If Ok(IsDlgButtonChecked(Window,106)) then Begin
                                           Speed := SPEED_NORMAL
                                         End Else Begin
                                           Speed := SendDlgItemMessage(Window,108,TBM_GETPOS,0,0)
                                         End;
                                         SAVE('Computer Emulation',   DWORD(Abs(Ord(NewCompType))));
                                         SAVE('Joystick Emulation',   JoyType);
                                         SAVE('Sound Emulation',      SoundType);
                                         SAVE('Serial Port',          SerialPort);
                                         SAVE('Custom Speed',         IsDlgButtonChecked(Window,107));
                                         SAVE('Emulation Speed',      Speed);
                                         SAVE('Video Emulation',      VideoType);
                                         SAVE('Enhance Disk Speed',   DWORD(Abs(Ord(NewDiskType))));
                                         SAVE('Horizontal Scanlines', IsDlgButtonChecked(Window,150));
                                         SAVE('Monochrome Color',     _Monochrome);
                                         SAVELONG('HiRes Colors',     HiresColorChoices);
                                         EndDialog(Window,1);
                                         If AfterClose then PostMessage(FrameWindow,WM_USER + Abs(Ord(AfterClose)),0,0)
                                       End;
                            IDCANCEL : EndDialog(Window,0);
                            106      : Begin
                                         SendDlgItemMessage(Window,108,TBM_SETPOS,1,SPEED_NORMAL);
                                         EnableTrackbar(Window,false)
                                       End;
                            107      : Begin
                                         SetFocus(GetDlgItem(Window,108));
                                         EnableTrackbar(Window,BOOL(DWORD(1)))
                                       End;
                            108      : Begin
                                         CheckRadioButton(Window,106,107,107);
                                         EnableTrackbar(Window,BOOL(DWORD(1)))
                                       End;
                            111      : Begin
                                         DWORD(AfterClose) := 1;
                                         PostMessage(Window,WM_COMMAND,IDOK,GetDlgItem(Window,IDOK))
                                       End;
                            112      : Begin
                                         RegSaveValue('','RunningOnOS',false,0);
                                         If MessageBox(Window,'The emulator has been set to recalibrate '+
                                                              'itself the next time it is started.'#$0A#$0A+
                                                              'Would you like to restart the emulator now?',
                                                              'Configuration',
                                                       MB_ICONQUESTION OR MB_YESNO OR MB_SETFOREGROUND) = IDYES then Begin
                                           DWORD(AfterClose) := 2;
                                           PostMessage(Window,WM_COMMAND,IDOK,GetDlgItem(Window,IDOK))
                                         End
                                       End;
                            160      : Case HiWord(wParam) of
                                         CBN_SETFOCUS  : If LastID <> 160 then Begin
                                                           LastId := 160;
                                                           EnableWindow(GetDlgItem(Window,171),true)
                                                         End;
                                         CBN_KILLFOCUS : If SendDlgItemMessage(Window,171,BM_GETSTATE,0,0) = 0 then Begin
                                                           LastId := 0;
                                                           EnableWindow(GetDlgItem(Window,171),false)
                                                         End
                                       End;
                            161      : Case HiWord(wParam) of
                                         CBN_SETFOCUS  : If LastID <> 161 then Begin
                                                           LastId := 161;
                                                           EnableWindow(GetDlgItem(Window,171),true)
                                                         End;
                                         CBN_KILLFOCUS : If SendDlgItemMessage(Window,171,BM_GETSTATE,0,0) = 0 then Begin
                                                           LastID := 0;
                                                           EnableWindow(GetDlgItem(Window,171),false)
                                                         End
                                       End;
                            171      : Begin
                                         Case LastId of
                                           160 : Begin
                                                   myColor := VideoChooseColor(_MonoChrome);
                                                   If myColor <> _MonoChrome then Begin
                                                     ColorChanged     := true;
                                                     _Monochrome      := myColor;
                                                     ColorTable[0,16] := myColor;
                                                     SetColorBitmap(0,0,16,ColorTable[0,16]);
                                                     SendDlgItemMessage(Window,160,CB_SETITEMDATA,0,17)
                                                   End;
                                                 End;
                                           161 : Begin
                                                   Entry := SendDlgItemMessage(Window,161,CB_GETCURSEL,0,0);
                                                   If Entry <> CB_ERR then Begin
                                                     myColor := VideoChooseColor(ColorTable[0,Entry]);
                                                     If myColor <> ColorTable[0,Entry] then Begin
                                                       ColorChanged        := true;
                                                       ColorTable[0,Entry] := myColor;
                                                       SetColorBitmap(0,0,Entry,ColorTable[0,Entry]);
                                                       SendDlgItemMessage(Window,161,CB_SETITEMDATA,Entry,Succ(Entry))
                                                     End
                                                   End
                                                 End
                                         End;
                                         SetFocus(GetDlgItem(Window,LastID))
                                       End
                          End
                        End;
    WM_DRAWITEM       : Begin
                          lpdis := pDRAWITEMSTRUCT(lParam);
                          If lpdis^.itemID <> -1 then Begin
                            If Ok(lpdis^.itemState AND ODS_SELECTED) then Begin
                              clrForeground := SetTextColor(lpdis^.hDC,GetSysColor(COLOR_HIGHLIGHTTEXT));
                              clrBackground := SetBkColor(lpdis^.hDC,GetSysColor(COLOR_HIGHLIGHT))
                            End Else Begin
                              clrForeground := SetTextColor(lpdis^.hDC,GetSysColor(COLOR_WINDOWTEXT));
                              clrBackground := SetBkColor(lpdis^.hDC,GetSysColor(COLOR_WINDOW))
                            End;
                            GetTextMetrics(lpdis^.hDC,tm);
                            y := (lpdis^.rcItem.bottom + lpdis^.rcItem.top - tm.tmHeight) Div 2;
                            x := LoWord(GetDialogBaseUnits()) Div 4;
                            SendMessage(lpdis^.hwndItem, CB_GETLBTEXT,lpdis^.itemID,DWORD(LPCSTR(@tmpBuffer)));
                            ExtTextOut(lpdis^.hDC,2 * x,y,ETO_CLIPPED OR ETO_OPAQUE, @lpdis^.rcItem,tmpBuffer,StrLen(tmpBuffer),Nil);
                            If lpdis^.itemData > 0 then Begin
                              SetTextColor(lpdis^.hDC, clrForeground);
                              SetBkColor(lpdis^.hDC, clrBackground);
                              DC := CreateCompatibleDC(lpdis^.hDC);
                              If Ok(DC) then Begin
                                Bitmap := ColorBitmap[0,Pred(lpdis^.itemData)];
                                SelectObject(DC,Bitmap);
                                cx := 38;
                                cy := 15;
                                BitBlt(lpdis^.hDC,x +  81,lpdis^.rcItem.top + 1,cx,cy,DC,0,0,SRCAND);
                                Bitmap := ColorBitmap[1,Pred(lpdis^.itemData)];
                                SelectObject(DC,Bitmap);
                                BitBlt(lpdis^.hDC,x + 121,lpdis^.rcItem.top + 1,cx,cy,DC,0,0,SRCAND);
                                DeleteDC(DC)
                              End
                            End
                          End
                        End;
    WM_HSCROLL        : CheckRadioButton(Window,106,107,107);
    WM_INITDIALOG     : Begin
                          FillComboBox(Window,101,ComputerChoices,Abs(Ord(Apple2e)));
                          FillComboBox(Window,105,VideoChoices,VideoType);
                          FillComboBox(Window,102,JoystickChoices,JoyType);
                          FillComboBox(Window,103,SoundChoices,SoundType);
                          FillComboBox(Window,104,SerialChoices,SerialPort);
                          FillComboBox(Window,109,DiscChoices,Abs(Ord(EnhanceDisk)));
                          FillComboBox(Window,160,TextColorChoices,TextColorType);
                          FillComboBox(Window,161,HiresColorChoices,HiResColorType);
                          SendDlgItemMessage(Window,108,TBM_SETRANGE,1,MAKELONG(0,40));
                          SendDlgItemMessage(Window,108,TBM_SETPAGESIZE,0,5);
                          SendDlgItemMessage(Window,108,TBM_SETTICFREQ,10,0);
                          SendDlgItemMessage(Window,108,TBM_SETPOS,1,Speed);
                          DWORD(Custom) := 1;
                          ColorChanged  := false;
                          If Speed = 10 then Begin
                            Custom := false;
                            RegLoadValue('Configuration','Custom Speed',true,@Custom)
                          End;
                          CheckRadioButton(Window,106,107,106 + Abs(Ord(Custom)));
                          If Ok(Custom) then SetFocus(GetDlgItem(Window,108))
                                        Else SetFocus(GetDlgItem(Window,106));
                          EnableTrackbar(Window,Custom);
                          If H_Scanlines then CheckDlgButton(Window,150,BST_CHECKED)
                                         Else CheckDlgButton(Window,150,BST_UNCHECKED);
                          SendDlgItemMessage(Window,160,CB_SETITEMDATA,0,17);
                          For n := 0 to 15 do SendDlgItemMessage(Window,161,CB_SETITEMDATA,n,Succ(n));
                          AfterClose := false
                        End;
    WM_LBUTTONDOWN    : Begin
                          pt.x := LOWORD(lParam);
                          pt.y := HIWORD(lParam);
                          ClientToScreen(Window,pt);
                          GetWindowRect(GetDlgItem(Window,108),Rect);
                          If (pt.x >= Rect.Left) and (pt.x <= Rect.Right) and (pt.y >= Rect.Top) and (pt.y <= Rect.Bottom) then Begin
                            CheckRadioButton(Window,106,107,107);
                            EnableTrackbar(Window,true);
                            SetFocus(GetDlgItem(Window,108));
                            ScreenToClient(GetDlgItem(Window,108),pt);
                            PostMessage(GetDlgItem(Window,108),WM_LBUTTONDOWN,wParam,MAKELONG(pt.x,pt.y))
                          End
                        End;
    WM_MEASUREITEM    : Begin

                        End;
    WM_SYSCOLORCHANGE : SendDlgItemMessage(Window,108,WM_SYSCOLORCHANGE,0,0)
  End;
  Result := false
End;

Procedure ProcessButtonClick( Button : Integer );
Var Filename : Array[0..Pred(MAX_PATH)] of Char;
Begin
  Case Button of
    BTN_HELP     : Begin
                     StrCopy(Filename,Progdir);
                     StrCat(Filename,'APPLEWIN.CHM');
                     // Fehler  HtmlHelp(framewindow,filename,HH_DISPLAY_TOC,0);
                     DWORD(HelpQuit) := 1
                   End;
    BTN_RUN      : Begin
                     If Mode = MODE_LOGO then DiskBoot()
                                         Else If Mode = MODE_RUNNING then ResetMachineState();
                     If (Mode = MODE_DEBUG) or (Mode = MODE_STEPPING) then DebugEnd();
                     Mode := MODE_RUNNING;
                     DrawStatusArea(hDC(0),DRAW_TITLE);
                     VideoRedrawScreen();
                     DWORD(ResetTiming) := 1
                  End;
    BTN_DRIVE1  : Begin
                    DiskSelect(Button - BTN_DRIVE1);
                    If not Ok(Fullscreen) then DrawButton(hDC(0),Button)
                  End;
    BTN_DRIVE2  : Begin
                    DiskSelect(Button - BTN_DRIVE1);
                    If not Ok(Fullscreen) then DrawButton(hDC(0),Button)
                  End;
    BTN_FULLSCR : Begin
                    If Ok(Fullscreen) then SetNormalMode() Else  SetFullScreenMode();
                  End;
    BTN_COLOR   : _MonoChrome := VideoChooseColor(_MonoChrome);
    BTN_DEBUG   : Begin
                    If Mode = MODE_LOGO then ResetMachineState();
                    If Mode = MODE_STEPPING then DebugProcessChar(#$1B)
                                            Else If Mode = MODE_DEBUG then ProcessButtonClick(BTN_RUN)
                                                                      Else Begin
                                                                             DebugBegin()
                                                                           End
                  End;
    BTN_SETUP   : DialogBox(Instance,'CONFIGURATION_DIALOG',FrameWindow,@ConfigDlgProc)
  End
End;

Procedure DeleteGDI_Objects;
Var Loop : Integer;
Begin
  For Loop := 0 to Pred(BUTTONS) do DeleteObject(ButtonBitmap[Loop]);
  For Loop := 0 to 1 do DeleteObject(CapsBitmap[Loop]);
  For Loop := 0 to 2 do DeleteObject(DiskBitmap[Loop]);
  DeleteObject(BtnFaceBrush);
  DeleteObject(BtnFacePen);
  DeleteObject(BtnHighlightPen);
  DeleteObject(BtnShadowPen);
  DeleteObject(Smallfont)
End;

Procedure EraseButton( Number : Integer );
Var Rect : tRect;
Begin
  Rect.Left   := ButtonX;
  Rect.Right  := Rect.left + BUTTONCX;
  Rect.Top    := Buttony + Number * BUTTONCY;
  Rect.Bottom := rect.top+BUTTONCY;
  InvalidateRect(FrameWindow,@Rect,true)
End;

Procedure RelayEvent( _Message : UINT; wParam : WPARAM; _lParam : LPARAM );
Var Msg : tMsg;
Begin
  If Ok(Fullscreen) then Exit;
  Msg.hWnd    := FrameWindow;
  Msg.message := _message;
  Msg.wParam  := wParam;
  Msg.lParam  := _lParam;
  SendMessage(ToolTipWindow,TTM_RELAYEVENT,0,LParam(@Msg))
End;

Procedure DrawFrameWindow;
Var PS   : PAINTSTRUCT;
    DC   : hDC;
    Loop : Integer;
Begin
  FrameReleaseDC();
  If Ok(Painting) then DC := BeginPaint(FrameWindow,PS) Else DC := GetDC(FrameWindow);
  VideoRealizePalette(DC);
  If not Ok(Fullscreen) then Begin
    // DRAW THE 3D BORDER AROUND THE EMULATED SCREEN
    Draw3dRect(DC,cVIEWPORTX - 2,cVIEWPORTY - 2,cVIEWPORTX + cVIEWPORTCX + 2,cVIEWPORTY + cVIEWPORTCY + 2,false);
    Draw3dRect(DC,cVIEWPORTX - 3,cVIEWPORTY - 3,cVIEWPORTX + cVIEWPORTCX + 3,cVIEWPORTY + cVIEWPORTCY + 3,false);
    SelectObject(DC,BtnFacePen);
    Rectangle(DC,cVIEWPORTX - 4,cVIEWPORTY - 4,cVIEWPORTX + cVIEWPORTCX + 4,cVIEWPORTY + cVIEWPORTCY + 4);
    Rectangle(DC,cVIEWPORTX - 5,cVIEWPORTY - 5,cVIEWPORTX + cVIEWPORTCX + 5,cVIEWPORTY + cVIEWPORTCY + 5);
    // DRAW THE TOOLBAR BUTTONS
    Loop := BUTTONS;
    While Ok(Loop) do Begin
      Dec(Loop);
      DrawButton(DC,Loop)
    End
  End;
  // DRAW THE STATUS AREA
  DrawStatusArea(DC,DRAW_BACKGROUND OR DRAW_LEDS);
  If Ok(Painting) then EndPaint(FrameWindow,PS) Else ReleaseDC(FrameWindow,DC);
  // DRAW THE CONTENTS OF THE EMULATED SCREEN
  If Mode = MODE_LOGO then VideoDisplayLogo()
                      Else If Mode = MODE_DEBUG then DebugDisplay(true)
                                                Else VideoRedrawScreen()
End;

Procedure DeleteGdiObjects;
Var Loop : Integer;
Begin
  For Loop := 0 to Pred(BUTTONS) do DeleteObject(ButtonBitmap[Loop]);
  For Loop := 0 to 1 do DeleteObject(CapsBitmap[Loop]);
  For Loop := 0 to 2 do DeleteObject(DiskBitmap[Loop]);
  DeleteObject(BtnFaceBrush);
  DeleteObject(BtnFacePen);
  DeleteObject(BtnHighlightPen);
  DeleteObject(BtnShadowPen);
  DeleteObject(SmallFont)
End;

Function FrameWndProc( Window : hWnd; Msg : UINT; wParam : WParam; lParam : LParam ) : lResult; StdCall;
Var Filename    : LPTSTR;
    Error       : Integer;
    Application : ATOM;
    Topic       : ATOM;
    _Filename   : Array[0..Pred(MAX_PATH)] of Char;
    Point       : tPoint;
    Rect        : tRect;
    AutoRep     : Bool;
    Extended    : Bool;
    X,Y         : Integer;
    NewOver     : Integer;
    NewDown     : Integer;
    OldCursor   : hCursor;
    dRect       : tRect;
Label Q;
Begin
  Case Msg of
    WM_ACTIVATE        : Begin
                           JoyReset();
                           SetUsingCursor(false)
                         End;
    WM_ACTIVATEAPP     : DWORD(Active) := wParam;
    WM_CHAR            : Begin
                           If (Mode = MODE_RUNNING) or (Mode = MODE_LOGO) or ((Mode = MODE_STEPPING)
                                                                          and (Byte(WParam) <> $1B)) then Begin
                             KeybQueueKeypress(Integer(WParam),BOOL(DWORD(1)))
                           End Else If (Mode = MODE_DEBUG) or (Mode = MODE_STEPPING) then DebugProcessChar(Char(WParam))
                         End;
    WM_CLOSE           : Begin
                           If Ok(Fullscreen) then SetNormalMode();
                           If not IsIconic(Window) then GetWindowRect(Window,FrameRect);
                           RegSaveValue('Preferences','Window X-Position',true,FrameRect.Left);
                           RegSaveValue('Preferences','Window Y-Position',true,FrameRect.Top);
                           FrameReleaseDC();
                           SetUsingCursor(false);
                           {If Ok(HelpQuit) then Begin
                             HelpQuit := 0;
                             HtmlHelp(Nil,Nil,HH_CLOSE_ALL,0)
                           End}
                         End;
    WM_CREATE          : Begin
                           FrameWindow := Window;
                           CreateGdiObjects();
                           SpkrInitialize();
                           DragAcceptFiles(Window,true);
                         End;
    WM_DDE_EXECUTE     : Begin
                           Filename := GlobalLock(hGLOBAL(LParam));
                           Error := DiskInsert(0,Filename,false,false);
                           If not Ok(Error) then Begin
                             If not Ok(Fullscreen) then DrawButton(hDC(0),BTN_DRIVE1);
                             SetForegroundWindow(Window);
                             ProcessButtonClick(BTN_RUN)
                           End Else DiskNotifyInvalidImage(Filename,Error);
                           GlobalUnlock(hGLOBAL(lparam))
                         End;
    WM_DDE_INITIATE    : Begin
                           Application := GlobalAddAtom('applewin');
                           Topic       := GlobalAddAtom('system');
                           If (LOWORD(lParam) = Application) and (HIWORD(lParam) = Topic) then Begin
                             SendMessage(hWnd(wParam),WM_DDE_ACK,tWPARAM(Window),MAKELPARAM(Application,Topic))
                           End;
                           GlobalDeleteAtom(Application);
                           GlobalDeleteAtom(Topic)
                         End;
    WM_DESTROY         : Begin
                           DragAcceptFiles(Window,false);
                           DebugDestroy();
                           If not Restart then Begin
                             DiskDestroy();
                             ImageDestroy();
                           End;
                           CommDestroy();
                           CpuDestroy();
                           MemDestroy();
                           SpkrDestroy();
                           VideoDestroy();
                           DeleteGDI_Objects();
                           PostQuitMessage(0)
                         End;
    WM_DISPLAYCHANGE   : VideoReinitialize();
    WM_DROPFILES       : Begin
                           DragQueryFile(HDROP(wParam),0,_Filename,SizeOf(_Filename));
                           DragQueryPoint(HDROP(wParam),Point);
                           Rect.Left   := ButtonX;
                           Rect.Right  := Rect.Left + BUTTONCX + 1;
                           Rect.Top    := ButtonY + BTN_DRIVE2 * BUTTONCY + 1;
                           Rect.Bottom := Rect.Top + BUTTONCY;
                           If Ok(PtInRect(Rect,Point)) then Error := DiskInsert(1,_Filename,false,false)
                                                       Else Error := DiskInsert(0,_Filename,false,false);
                           If not Ok(Error) then Begin
                             If not Ok(Fullscreen) then If Ok(PtInRect(Rect,Point)) then DrawButton(hDC(0),BTN_DRIVE2)
                                                                                    Else DrawButton(hDC(0),BTN_DRIVE1);
                             Rect.Top := ButtonY + BTN_DRIVE1 * BUTTONCY + 1;
                             If not Ok(PtInRect(Rect,Point)) then Begin
                               SetForegroundWindow(Window);
                               ProcessButtonClick(BTN_RUN)
                             End
                           End Else DiskNotifyInvalidImage(_Filename,Error);
                           DragFinish(HDROP(wParam))
                         End;
    WM_KEYDOWN         : Begin
                           If (wParam >= VK_F1) and (wparam <= VK_F8) and (ButtonDown = -1) then Begin
                             SetUsingCursor(false);
                             Buttondown := wParam - VK_F1;
                             If Ok(Fullscreen) and (ButtonOver <> -1) then Begin
                               If (ButtonOver <> ButtonDown) then EraseButton(ButtonOver);
                               ButtonOver := -1
                             End;
                             DrawButton(hDC(0),ButtonDown)
                           End Else If wParam = VK_F9 then Begin
                             Inc(VideoType);
                             If VideoType > 2 then VideoType := 0;
                             VideoReinitialize();
                             If (Mode <> MODE_LOGO) and (Mode <> MODE_DEBUG) then VideoRedrawScreen();
                             RegSaveValue('Configuration','Video Emulation',BOOL(DWORD(1)),VideoType)
                           End Else If wParam = VK_CAPITAL then Begin
                             KeybToggleCapsLock()
                           End Else If wParam = VK_PAUSE then Begin
                             SetUsingCursor(false);
                             Case Mode of
                               MODE_RUNNING  : Mode := MODE_PAUSED;
                               MODE_PAUSED   : Mode := MODE_RUNNING;
                               MODE_STEPPING : DebugProcessChar(#$1B)
                             End;
                             DrawStatusArea(hDC(0),DRAW_TITLE);
                             If (Mode <> MODE_LOGO) and (Mode <> MODE_DEBUG) then VideoRedrawScreen();
                             DWORD(ResetTiming) := 1
                           End Else If (Mode = MODE_RUNNING) or (Mode = MODE_LOGO) or (Mode = MODE_STEPPING) then Begin
                             DWORD(Autorep)  := Abs(Ord((lParam AND $40000000) <> 0));
                             DWORD(Extended) := Abs(Ord((lParam AND $01000000) <> 0));
                             If not Ok(JoyProcessKey(Integer(wParam),Extended,BOOL(DWORD(1)),AutoRep)) and (Mode <> MODE_LOGO) then Begin
                               KeybQueueKeypress(Integer(wParam),false)
                             End
                           End Else If Mode = MODE_DEBUG then DebugProcessCommand(wParam);
                           If wParam = VK_F10 then Begin
                             SetUsingCursor(false);
                             Result := 0;
                             Exit
                           End
                         End;
    WM_KEYUP           : Begin
                           If (wParam >= VK_F1) and (wParam <= VK_F8) and (ButtonDown = Integer(wParam - VK_F1)) then Begin
                             ButtonDown := -1;
                             If Ok(Fullscreen) then EraseButton(wParam - VK_F1)
                                               Else DrawButton(hDC(0),wParam - VK_F1);
                             ProcessButtonClick(wParam - VK_F1)
                           End Else JoyProcessKey(Integer(wParam),BOOL(DWORD(Abs(Ord((lParam AND $01000000) <> 0)))),false,false)
                         End;
    WM_LBUTTONDOWN     : Begin
                           If ButtonDown = -1 then Begin
                             X := LOWORD(lParam);
                             Y := HIWORD(lParam);
                             If (X >= ButtonX) and (y >= ButtonY) and (Y <= ButtonY + BUTTONS * BUTTONCY) then Begin
                               ButtonDown   := (Y - ButtonY - 1) Div BUTTONCY;
                               ButtonActive := ButtonDown;
                               DrawButton(hDC(0),ButtonActive);
                               SetCapture(Window)
                             End Else If Ok(UsingCursor) then If Ok(wParam AND (MK_CONTROL OR MK_SHIFT)) then Begin
                               SetUsingCursor(false)
                             End Else Begin
                               JoySetButton(0,BOOL(DWORD(1)))
                             End Else If (x < ButtonX) and Ok(JoyUsingMouse()) and ((Mode = MODE_RUNNING) or (Mode = MODE_STEPPING)) then Begin
                               SetUsingCursor(BOOL(DWORD(1)))
                             End
                           End;
                           RelayEvent(WM_LBUTTONDOWN,wParam,lParam)
                         End;
    WM_LBUTTONUP       : Begin
                           If ButtonActive <> -1 then Begin
                             ReleaseCapture();
                             If ButtonDown = ButtonActive then Begin
                               ButtonDown := -1;
                               If Fullscreen then EraseButton(ButtonActive)
                                             Else DrawButton(hDC(0),ButtonActive);
                               ProcessButtonClick(ButtonActive)
                             End;
                             ButtonActive := -1
                           End Else If UsingCursor then JoySetButton(0,false);
                           RelayEvent(WM_LBUTTONUP,wParam,lParam)
                         End;
    WM_MOUSEMOVE       : Begin
                           X := LOWORD(lParam);
                           Y := HIWORD(lParam);
                           If (X >= ButtonX) and (X <= ButtonX + BUTTONCX) and (Y >= ButtonY) and (Y <= ButtonY + BUTTONS * BUTTONCY) then Begin
                             NewOver := (Y - ButtonY - 1) Div BUTTONCY
                           End Else Begin
                             NewOver := -1
                           End;
                           If ButtonActive <> -1 then Begin
                             If NewOver = ButtonActive then NewDown := ButtonActive
                                                       Else NewDown := -1;
                             If NewDown <> ButtonDown then Begin
                               ButtonDown := NewDown;
                               DrawButton(hDC(0),ButtonActive)
                             End
                           End Else If Ok(Fullscreen) and (NewOver <> ButtonOver) and (ButtonDown = -1) then Begin
                             If ButtonOver <> -1 then EraseButton(ButtonOver);
                             ButtonOver := NewOver;
                             If ButtonOver <> -1 then DrawButton(hDC(0),ButtonOver)
                           End Else If Ok(UsingCursor) then Begin
                             DrawCrosshairs(X,Y);
                             JoySetPosition(X - ViewportX - 2, cVIEWPORTCX - 4, Y - ViewportY - 2, cVIEWPORTCY - 4)
                           End;
                           RelayEvent(WM_MOUSEMOVE,wParam,lParam)
                         End;
    WM_NOTIFY          : If (PNMTTDispInfo(lParam)^.hdr.hwndFrom = ToolTipWindow) and (PNMTTDispInfo(lParam)^.hdr.code = TVN_GETDISPINFO) then Begin
                           PNMTTDispInfo(lParam)^.lpszText := LPTSTR(DiskGetFullName(PNMTTDispInfo(lparam)^.hdr.idFrom))
                         End;
    WM_PAINT           : Begin
                           If GetUpdateRect(Window,dRect,false) then Begin
                             DWORD(Painting):= 1;
                             DrawFrameWindow();
                             Painting := false
                           End
                         End;
    WM_PALETTECHANGED  : ;
    WM_QUERYNEWPALETTE : DrawFrameWindow();
    WM_RBUTTONDOWN     : ;
    WM_RBUTTONUP       : Begin
                           If UsingCursor then JoySetButton(1,BOOL(DWORD(Abs(Ord(Msg = WM_RBUTTONDOWN)))));
                           RelayEvent(Msg,wParam,lParam)
                         End;
    WM_SYSCOLORCHANGE  : Begin
                           DeleteGdiObjects();
                           CreateGdiObjects()
                         End;
    WM_SYSCOMMAND      : Case wParam AND $FFF0 of
                           SC_KEYMENU  : If Ok(Fullscreen) and Ok(Active) then Begin
                                           Result := 0;
                                           Exit
                                         End;
                           SC_MINIMIZE : GetWindowRect(Window,FrameRect);
                         End;
    WM_SYSKEYDOWN      : Begin
                           PostMessage(Window,WM_KEYDOWN,wParam,lParam);
                           If (wParam = VK_F10) or (wParam = VK_MENU) then Begin
                             Result := 0;
                             Exit
                           End
                         End;
    WM_SYSKEYUP        : PostMessage(Window,WM_KEYUP,wParam,lParam);
    WM_USER + 1        : Begin
                           If Mode <> MODE_LOGO then
                             If MessageBox(Framewindow,'Running the benchmarks will reset the state of '+
                                                       'the emulated machine, causing you to lose any '+
                                                       'unsaved work.'#10#10+
                                                       'Are you sure you want to do this?',
                                                       'Benchmarks',
                                 MB_ICONQUESTION OR MB_YESNO OR MB_SETFOREGROUND) = IDNO then Begin
                             Goto Q
                           End;
                           UpdateWindow(Window);
                           ResetMachineState();
                           Mode := MODE_LOGO;
                           DrawStatusArea(hDC(0),DRAW_TITLE);
                           OldCursor := SetCursor(LoadCursor(0,IDC_WAIT));
                           VideoBenchmark();
                           ResetMachineState();
                           SetCursor(OldCursor)
                         End;
    WM_USER + 2        : Begin
                           If Mode <> MODE_LOGO then
                             If MessageBox(FrameWindow,'Restarting the emulator will reset the state '+
                                                       'of the emulated machine, causing you to lose any '+
                                                       'unsaved work.'#10#10+
                                                       'Are you sure you want to do this?',
                                                       'Configuration',
                                           MB_ICONQUESTION OR MB_YESNO OR MB_SETFOREGROUND) = IDNO then Begin
                             Goto Q
                           End;
                           DWORD(Restart) := 1;
                           PostMessage(Window,WM_CLOSE,0,0)
                         End
  End;
Q:Result := DefWindowProc(Window,Msg,wParam,lParam)
End;

Procedure FrameRegisterClass;
Var WndClass : WNDCLASSEX;
Begin
  FillChar(WndClass,SizeOf(WNDCLASSEX),#0);
  WndClass.cbSize        := SizeOf(WNDCLASSEX);
  WndClass.style         := CS_OWNDC OR CS_BYTEALIGNCLIENT;
  WndClass.lpfnWndProc   := @FrameWndProc;
  WndClass.hInstance     := Instance;
  WndClass.hIcon         := LoadIcon(Instance,'APPLEWIN_ICON');
  WndClass.hCursor       := LoadCursor(0,IDC_ARROW);
  WndClass.hbrBackground := hBrush(GetStockObject(BLACK_BRUSH));
  WndClass.lpszClassName := 'APPLE2FRAME';
  WndClass.hIconSm       := hIcon(LoadImage(Instance,'APPLEWIN_ICON',IMAGE_ICON,16,16,LR_DEFAULTCOLOR));
  RegisterClassEx(WndClass)
End;

Procedure FrameReleaseDC;
Begin
  If Ok(FrameDC) then Begin
    SetViewportOrgEx(FrameDC,0,0,Nil);
    ReleaseDC(FrameWindow,FrameDC);
    FrameDC := hDC(0)
  End
End;

Procedure FrameRefreshStatus( DrawFlags : Integer );
Begin
  DrawStatusArea(hDC(0),DrawFlags)
End;

Function FrameGetDC : hDC;
Begin
  If not Ok(FrameDC) then Begin
    FrameDC := GetDC(FrameWindow);
    SetViewportOrgEx(FrameDC,ViewPortX,ViewPortY,Nil)
  End;
  Result := FrameDC
End;

Function FrameGetVideoDC( Addr : LPBYTE; Pitch : LPLONGINT ) : hDC;
Var Rect : tRect;
Begin
  If FullScreen and Active and not Painting then Begin
    Rect.Left   := FSVIEWPORTX;
    Rect.Top    := FSVIEWPORTY;
    Rect.Right  := FSVIEWPORTX + cVIEWPORTCX;
    Rect.Bottom := FSVIEWPORTY + cVIEWPORTCY;
{    DDSURFACEDESC surfacedesc;
    surfacedesc.dwSize = sizeof(surfacedesc);
    If (surface->Lock(&rect,&surfacedesc,0,NULL) == DDERR_SURFACELOST) then Begin
      surface->Restore();
      surface->Lock(&rect,&surfacedesc,0,NULL);
    End;
    *addr  = (LPBYTE)surfacedesc.lpSurface+(VIEWPORTCY-1)*surfacedesc.lPitch;
    *pitch = -surfacedesc.lPitch;}
    Result := hDC(0)
  End Else Result := FrameGetDC()
End;

Procedure FrameReleaseVideoDC;
Var Rect : tRect;
Begin
  If Ok(FullScreen) and Ok(Active) and not Ok(Painting) then Begin
    // THIS IS CORRECT ACCORDING TO THE DIRECTDRAW DOCS
    Rect.Left   := FSVIEWPORTX;
    Rect.Top    := FSVIEWPORTY;
    Rect.Right  := FSVIEWPORTX + cVIEWPORTCX;
    Rect.Bottom := FSVIEWPORTY + cVIEWPORTCY
    {surface->Unlock(&rect);
    // BUT THIS SEEMS TO BE WORKING
    surface->Unlock(NULL);}
  End
End;

Procedure FrameCreateWindow;
Var Width        : Integer;
    Height       : Integer;
    xPos         : Integer;
    yPos         : Integer;
    TitleText    : String;
    ToolInfo     : tToolInfo;
Begin
  Width  := cVIEWPORTCX + (cVIEWPORTX Shl 1) + BUTTONCX + (GetSystemMetrics(SM_CXBORDER) Shl 1) + 5;
  Height := cVIEWPORTCY + (cVIEWPORTY Shl 1) + GetSystemMetrics(SM_CYBORDER) + GetSystemMetrics(SM_CYCAPTION) + 5;
  xPos := 0;
  If not RegLoadValue('Preferences','Window X-Position',true,@xPos) then Begin
    xPos := (GetSystemMetrics(SM_CXSCREEN) - Width) Shr 1
  End;
  yPos := 0;
  If not RegLoadValue('Preferences','Window Y-Position',true,@yPos) then Begin
    yPos := (GetSystemMetrics(SM_CYSCREEN) - Height) Shr 1
  End;
  If Ok(Apple2e) then TitleText := TITLE Else TitleText := 'Apple ][+ Emulator';
  FrameWindow := CreateWindow('APPLE2FRAME',LPTSTR(TitleText),
                              WS_OVERLAPPED OR WS_CAPTION OR WS_SYSMENU OR WS_MINIMIZEBOX OR WS_VISIBLE,
                              xPos,yPos,Width,Height,HWND_DESKTOP,hMenu(0),Instance,Nil);
  InitCommonControls();
  ToolTipWindow := CreateWindow(TOOLTIPS_CLASS,Nil,TTS_ALWAYSTIP,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
                                FrameWindow,hMenu(0),Instance,Nil);
  ToolInfo.cbSize      := SizeOf(tToolInfo);
  ToolInfo.uFlags      := TTF_CENTERTIP;
  ToolInfo.hwnd        := FrameWindow;
  ToolInfo.hinst       := Instance;
  ToolInfo.lpszText    := LPSTR_TEXTCALLBACK;
  ToolInfo.rect.left   := cBUTTONX;
  ToolInfo.rect.right  := ToolInfo.Rect.Left + Succ(BUTTONCX);
  ToolInfo.uId         := 0;
  ToolInfo.rect.top    := cBUTTONY + BTN_DRIVE1 * Succ(BUTTONCY);
  ToolInfo.rect.bottom := ToolInfo.Rect.Top + BUTTONCY;
  SendMessage(ToolTipWindow,TTM_ADDTOOL,0,lParam(@ToolInfo));
  ToolInfo.uId         := 1;
  ToolInfo.rect.top    := cBUTTONY + BTN_DRIVE2 * Succ(BUTTONCY);
  ToolInfo.rect.bottom := ToolInfo.Rect.Top + BUTTONCY;
  SendMessage(ToolTipWindow,TTM_ADDTOOL,0,lParam(@ToolInfo))
End;

Procedure SetColorBitmap( DC : hDC; ColorType, Entry : Byte; Color : COLORREF );
Var MemDC   : hDC;
    Brush   : hBrush;
    Pen     : hPen;
Begin
  If not Ok(DC) then DC := GetDC(GetActiveWindow());
  If Ok(DC) then Begin
    MemDC := CreateCompatibleDC(DC);
    If not Ok(ColorBitmap[ColorType,Entry]) then Begin
      ColorBitmap[ColorType,Entry] := CreateBitmap(38,15,GetDeviceCaps(MemDC,PLANES),GetDeviceCaps(MemDC,BITSPIXEL),Nil)
    End;
    IF Ok(SelectObject(MemDC,ColorBitmap[ColorType,Entry])) then Begin
      Pen   := CreatePen(PS_SOLID,1,GetSysColor(BLACK_PEN));
      Brush := CreateSolidBrush(ColorTable[ColorType,Entry]);
      SelectObject(MemDC,Pen);
      SelectObject(MemDC,Brush);
      Rectangle(MemDC,0,0,38,15);
      DeleteObject(Brush);
      DeleteObject(Pen);
      DeleteDC(MemDC)
    End
  End
End;

Procedure ColorInitialize;
Var Buffer : Array[0..511] of Char;
    i,n    : Byte;
    CmpPtr : LPTSTR;
    BufPtr : LPTSTR;
Begin
  Buffer := '';
  FillChar(ColorBitmap,SizeOf(ColorBitmap),#0);
  If RegLoadStringLong('Configuration','HiRes Colors',true,Buffer,512) then Begin
    n := 0;
    BufPtr := @Buffer;
    Repeat
      CmpPtr := StrPos(BufPtr,'= 0x') + 2;
      If DWord(CmpPtr) > 4 then Begin
        ColorTable[0,n] := StrToInt(CmpPtr);
        BufPtr          := StrEnd(BufPtr) + 1;
        Inc(n)
      End
    Until CmpPtr <= Pointer(2);
    RegLoadValue('Configuration','Monochrome Color',true,@ColorTable[0,16])
  End Else Begin
    ColorTable[0, 0] := PALETTERGB($00,$00,$00); //BLACK
    ColorTable[0, 1] := PALETTERGB($00,$00,$80); //DARK_BLUE
    ColorTable[0, 2] := PALETTERGB($00,$80,$00); //DARK_GREEN
    ColorTable[0, 3] := PALETTERGB($00,$00,$FF); //BLUE
    ColorTable[0, 4] := PALETTERGB($80,$50,$00); //BROWN
    ColorTable[0, 5] := PALETTERGB($C0,$C0,$C0); //LIGHT_GRAY
    ColorTable[0, 6] := PALETTERGB($00,$FF,$00); //GREEN
    ColorTable[0, 7] := PALETTERGB($40,$FF,$90); //AQUA
    ColorTable[0, 8] := PALETTERGB($D0,$00,$30); //DEEP_RED
    ColorTable[0, 9] := PALETTERGB($FF,$00,$FF); //MAGENTA
    ColorTable[0,10] := PALETTERGB($80,$80,$80); //DARK_GRAY
    ColorTable[0,11] := PALETTERGB($60,$A0,$FF); //LIGHT_BLUE
    ColorTable[0,12] := PALETTERGB($FF,$80,$00); //ORANGE
    ColorTable[0,13] := PALETTERGB($FF,$90,$80); //PINK
    ColorTable[0,14] := PALETTERGB($FF,$FF,$00); //YELLOW
    ColorTable[0,15] := PALETTERGB($FF,$FF,$FF); //WHITE
    ColorTable[0,16] := PALETTERGB($00,$FF,$00); //MONOCHROME
  End;
  ColorTable[1, 0] := PALETTERGB($00,$00,$00); //BLACK
  ColorTable[1, 1] := PALETTERGB($00,$00,$80); //DARK_BLUE
  ColorTable[1, 2] := PALETTERGB($00,$80,$00); //DARK_GREEN
  ColorTable[1, 3] := PALETTERGB($00,$00,$FF); //BLUE
  ColorTable[1, 4] := PALETTERGB($80,$50,$00); //BROWN
  ColorTable[1, 5] := PALETTERGB($C0,$C0,$C0); //LIGHT_GRAY
  ColorTable[1, 6] := PALETTERGB($00,$FF,$00); //GREEN
  ColorTable[1, 7] := PALETTERGB($40,$FF,$90); //AQUA
  ColorTable[1, 8] := PALETTERGB($D0,$00,$30); //DEEP_RED
  ColorTable[1, 9] := PALETTERGB($FF,$00,$FF); //MAGENTA
  ColorTable[1,10] := PALETTERGB($80,$80,$80); //DARK_GRAY
  ColorTable[1,11] := PALETTERGB($60,$A0,$FF); //LIGHT_BLUE
  ColorTable[1,12] := PALETTERGB($FF,$80,$00); //ORANGE
  ColorTable[1,13] := PALETTERGB($FF,$90,$80); //PINK
  ColorTable[1,14] := PALETTERGB($FF,$FF,$00); //YELLOW
  ColorTable[1,15] := PALETTERGB($FF,$FF,$FF); //WHITE
  ColorTable[1,16] := PALETTERGB($00,$FF,$00); //MONOCHROME
  For i := 0 to 1 do For n := 0 to 16 do SetColorBitmap(0,i,n,ColorTable[i,n]);
End;

Procedure DestroyColorBitmaps;
Var i,n : Byte;
Begin
  For i := 0 to 1 do For n := 0 to 16 do If Ok(ColorBitmap[i,n]) then DeleteObject(ColorBitmap[i,n])
End;



