Procedure WriteTrack( Drive : Integer );
Var fPtr : FloppyPtr;
Begin
  fPtr := @Floppy[Drive];
  If fPtr^.Track >= TRACKS then Exit;
  If Ok(fPtr^.TrackImage) and Ok(fPtr^.ImageHandle) then Begin
    ImageWriteTrack(fPtr^.ImageHandle,fPtr^.Track,fPtr^.Phase,fPtr^.TrackImage,fPtr^.Nibbles)
  End;
  fPtr^.TrackImageDirty := false
End;

Procedure RemoveDisk( Drive : Integer );
Var fPtr : FloppyPtr;
Begin
  fPtr := @Floppy[Drive];
  If Ok(fPtr^.ImageHandle) then Begin
    If Ok(fPtr^.TrackImage) and Ok(fPtr^.TrackImageDirty) then WriteTrack(Drive);
    ImageClose(fPtr^.ImageHandle);
    fPtr^.ImageHandle := hImage(0)
  End;
  If Ok(fPtr^.TrackImage) then Begin
    VirtualFree(fPtr^.TrackImage,0,MEM_RELEASE);
    fPtr^.TrackImage     := Nil;
    fPtr^.TrackImageData := false
  End
End;

Procedure GetImageTitle( ImageFilename : LPTSTR;
                         fPtr          : FloppyPtr );
Var ImageTitle : Array[0..127] of Char;
    StartPos   : LPTSTR;
    Dot        : LPTSTR;
    Found      : Boolean;
    Loop       : Integer;
Begin
  StartPos := ImageFilename;
  If Ok(StrRScan(StartPos,'\')) then StartPos := StrRScan(StartPos,'\') + 1;
  StrLCopy(ImageTitle,StartPos,127);
  ImageTitle[127] := #0;
  Found := false;
  Loop  := 0;
  While Ok(ImageTitle[Loop]) and not Found do Begin
    If IsCharLower(ImageTitle[Loop]) then Found := true
                                     else Inc(Loop)
  End;
  If not Found and (Loop > 2) then CharLowerBuff(ImageTitle + 1,StrLen(ImageTitle + 1));
  StrLCopy(fPtr^.Fullname,ImageTitle,127);
  {fPtr^.ImageName[127] := #0; //Imagename ist nur 16 Zeichen definiert}
  fPtr^.ImageName[15] := #0;
  If Ok(ImageTitle[0]) then Begin
    Dot := ImageTitle;
    If Ok(StrRScan(Dot,'.')) then Dot := StrRScan(Dot,'.');
    If Dot > ImageTitle then Dot^ := #0
  End;
  StrLCopy(FPtr^.ImageName,ImageTitle,15);
  fPtr^.ImageName[15] := #0
End;

Function DiskInsert( Drive             : Integer;
                     ImageFilename     : LPTSTR;
                     WriteProtected    : Bool;
                     CreateIfNecessary : Bool     ) : Integer;
Var fPtr  : FloppyPtr;
    Error : Integer;
Begin
  fPtr := @Floppy[Drive];
  If Ok(fPtr^.ImageHandle) then RemoveDisk(Drive);
  FillChar(fPtr^,SizeOf(FloppyRec),#0);
  fPtr^.WriteProtected := WriteProtected;
  Error := ImageOpen(ImageFilename,@fPtr^.ImageHandle,@fPtr^.WriteProtected,CreateIfNecessary);
  If not Ok(Error) then GetImageTitle(ImageFilename,fPtr);
  Result := Error
End;

Procedure DiskInitialize;
Var Loop          : Integer;
    ImageFilename : Array[0..Pred(MAX_PATH)] of Char;
Begin
  Loop := DRIVES;
  While Ok(Loop) do Begin
    Dec(Loop);
    FillChar(Floppy[Loop],SizeOf(FloppyRec),#0)
  End;
  StrCopy(ImageFilename,ProgDir);
  StrCat(ImageFilename,'MASTER.DSK');
  DiskInsert(0,ImageFilename,false,false)
End;

Procedure CheckSpinning;
Var ModeChange : DWord;
Begin
  ModeChange := Abs(Ord(FloppyMotorOn and not Ok(Floppy[CurrDrive].Spinning)));
  If Ok(FloppyMotorOn) then Floppy[CurrDrive].Spinning := 20000;
  If Ok(ModeChange)    then FrameRefreshStatus(DRAW_LEDS)
End;

Procedure DiskGetLightStatus( Drive1,
                              Drive2  : LPINT );
Begin
  If Ok(Floppy[0].Spinning) then If Ok(Floppy[0].WriteLight) then Drive1^ := 2
                                                             Else Drive1^ := 1
                            Else Drive1^ := 0;
  If Ok(Floppy[1].Spinning) then If Ok(Floppy[1].WriteLight) then Drive2^ := 2
                                                             Else Drive2^ := 1
                            Else Drive2^ := 0
End;

Procedure ReadTrack( Drive : Integer );
Var fPtr : FloppyPtr;
Begin
  fPtr := @Floppy[Drive];
  If fptr^.Track >= TRACKS then Begin
    fPtr^.TrackImageData := false;
    Exit
  End;
  If not Ok(fPtr^.TrackImage) then fPtr^.TrackImage := LPBYTE(VirtualAlloc(Nil,$1A00,MEM_COMMIT,PAGE_READWRITE));
  If Ok(fPtr^.TrackImage) and Ok(fPtr^.ImageHandle) then Begin
    ImageReadTrack(fPtr^.ImageHandle,fPtr^.Track,fPtr^.Phase,fPtr^.TrackImage,@fPtr^.Nibbles);
    fPtr^.Byte := 0;
    DWORD(fPtr^.TrackImageData) := Abs(Ord(fptr^.Nibbles <> 0))
  End
End;

Function DiskControlMotor( ProgramCounter : Word;
                           Address        : Byte;
                           Write          : Byte;
                           Value          : Byte  ) : Byte; StdCall;
Begin
  DWORD(FloppyMotorOn) := Address AND 1;
  CheckSpinning();
  Result := MemReturnRandomData(1)
End;

Function DiskControlStepper( ProgramCounter : Word;
                             Address        : Byte;
                             Write          : Byte;
                             Value          : Byte  ) : Byte; StdCall;
Var fPtr      : FloppyPtr;
    Phase     : Integer;
    Direction : Integer;
    NewTrack  : Integer;
Begin
  fPtr := @Floppy[CurrDrive];
  If Ok(Address AND 1) then Begin
    Phase     := (Address Shr 1) AND 3;
    Direction := 0;
    If Phase = Succ(fPtr^.Phase) AND 3 then Direction :=  1;
    If Phase = (fPtr^.Phase + 3) AND 3 then Direction := -1;
    If Ok(Direction) then Begin
      fPtr^.Phase := MAX(0,MIN(79,fPtr^.Phase + Direction));
      If not Ok(fPtr^.Phase AND 1) then Begin
        NewTrack := MIN(Pred(TRACKS),fPtr^.Phase Shr 1);
        If NewTrack <> fPtr^.Track then Begin
          If Ok(fPtr^.TrackImage) and Ok(fPtr^.TrackImageDirty) then WriteTrack(CurrDrive);
          fPtr^.Track          := NewTrack;
          fPtr^.TrackImageData := false
        End
      End
    End
  End;
  If Address = $E0 then Result := $FF Else Result := MemReturnRandomData(1)
End;

Function DiskEnable( ProgramCounter : Word;
                     Address        : Byte;
                     Write          : Byte;
                     Value          : Byte  ) : Byte; StdCall;
Begin
  CurrDrive := Address AND 1;
  Floppy[Ord(not Ok(CurrDrive))].Spinning   := 0;
  Floppy[Ord(not Ok(CurrDrive))].WriteLight := 0;
  CheckSpinning();
  Result := 0
End;

Function DiskReadWrite( ProgramCounter : Word;
                        Address        : Byte;
                        Write          : Byte;
                        Value          : Byte  ) : Byte; StdCall;
Var fPtr    : FloppyPtr;
    _Result : Byte;
Begin
  fPtr := @Floppy[CurrDrive];
  DWORD(DiskAccessed) := 1;
  If not fPtr^.TrackImageData and Ok(fPtr^.ImageHandle) then ReadTrack(CurrDrive);
  If not Ok(fPtr^.TrackImageData) then Begin
    Result := $FF;
    Exit
  End;
  _Result := 0;
  If not Ok(FloppyWriteMode) or not Ok(fPtr^.WriteProtected) then Begin
    If Ok(FloppyWriteMode) then If Ok(FloppyLatch AND $80) then Begin
      LPBYTE(DWord(fPtr^.TrackImage) + fPtr^.Byte)^ := FloppyLatch;
      DWORD(fptr^.TrackImageDirty) := 1
    End Else Begin
      Result := 0;
      Exit
    End Else _Result := LPBYTE(DWord(fPtr^.TrackImage) + fPtr^.Byte)^
  End;
  Inc(fPtr^.Byte);
  If fPtr^.Byte >= fPtr^.Nibbles then fPtr^.Byte := 0;
  Result := _Result
End;

Function DiskSetLatchValue( ProgramCounter : Word;
                            Address        : Byte;
                            Write          : Byte;
                            Value          : Byte  ) : Byte; StdCall;
Begin
  If Ok(Write) then FloppyLatch := Value;
  Result := FloppyLatch
End;

Function DiskSetReadMode( ProgramCounter : Word;
                          Address        : Byte;
                          Write          : Byte;
                          Value          : Byte  ) : Byte; StdCall;
Begin
  FloppyWriteMode := false;
  Result := MemReturnRandomData(BYTE(Floppy[CurrDrive].WriteProtected))
End;

Function DiskSetWriteMode( ProgramCounter : Word;
                           Address        : Byte;
                           Write          : Byte;
                           Value          : Byte  ) : Byte; StdCall;
Var ModeChange : Bool;
Begin
  DWORD(FloppyWriteMode) := 1;
  DWORD(ModeChange) := Abs(Ord(not Ok(Floppy[CurrDrive].WriteLight)));
  Floppy[CurrDrive].WriteLight := 20000;
  If ModeChange then FrameRefreshStatus(DRAW_LEDS);
  Result := MemReturnRandomData(1)
End;

Procedure DiskUpdatePosition( Cycles : DWord );
Var Loop : Integer;
    fPtr : FloppyPtr;
Begin
  Loop := 2;
  While Ok(Loop) do Begin
    Dec(Loop);
    fPtr := @Floppy[Loop];
    If Ok(fPtr^.Spinning) and not Ok(FloppyMotorOn) then Begin
      Dec(fPtr^.Spinning,MIN(fPtr^.Spinning,Cycles Shr 6));
      If not Ok(fPtr^.Spinning) then FrameRefreshStatus(DRAW_LEDS)
    End;
    If Ok(FloppyWriteMode) and (CurrDrive = Loop) and Ok(fPtr^.Spinning) then Begin
      fPtr^.Writelight := 20000
    End Else If Ok(fPtr^.WriteLight) then Begin
      Dec(fPtr^.WriteLight,MIN(fPtr^.WriteLight,Cycles Shr 6));
      If not Ok(fPtr^.WriteLight) then FrameRefreshStatus(DRAW_LEDS)
    End;
    If not Ok(EnhanceDisk) and not Ok(DiskAccessed) and Ok(fPtr^.Spinning) then Begin
      NeedsPrecision := CumulativeCycles;
      Inc(fPtr^.Byte,Cycles Shr 5);
      If fPtr^.Byte >= fPtr^.Nibbles then Dec(fPtr^.Byte,fPtr^.Nibbles)
    End
  End;
  DiskAccessed := false
End;

Function DiskIsSpinning : Bool;
Begin
  Result := FloppyMotorOn
End;

Function DiskGetName( Drive : Integer ) : LPTSTR;
Begin
  Result := Floppy[Drive].ImageName
End;

Procedure DiskBoot;
Begin
  // THIS FUNCTION RELOADS A PROGRAM IMAGE IF ONE IS LOADED IN DRIVE ONE.
  // IF A DISK IMAGE OR NO IMAGE IS LOADED IN DRIVE ONE, IT DOES NOTHING.
  If Ok(Floppy[0].ImageHandle) and Ok(ImageBoot(Floppy[0].ImageHandle)) then FloppyMotorOn := false
End;

Procedure DiskNotifyInvalidImage( ImageFilename : LPCTSTR; Error : Integer );
Var Buffer : Array[0..Pred(MAX_PATH + 128)] of Char;
Begin
  Case Error of
    1 : WVsPrintF(Buffer,'Unable to open the file %s.',ImageFilename);
    2 : WVsPrintF(Buffer,'Unable to use the file %s'#0'because the disk image format is not recognized.',
                  ImageFilename);
    // IGNORE OTHER ERRORS SILENTLY
    Else Exit
  End;
  MessageBox(FrameWindow,Buffer,TITLE,MB_ICONEXCLAMATION OR MB_SETFOREGROUND)
End;

Procedure DiskSelect( Drive : Integer );
Var Directory : Array[0..Pred(MAX_PATH)] of Char;
    Filename  : Array[0..Pred(MAX_PATH)] of Char;
    Title     : Array[0..39] of Char;
    OFN       : tOpenFilename;
    Error     : Integer;
Begin
  Directory := '';
  Filename  := '';
  RegLoadString('Preferences','Starting Directory',true,Directory,MAX_PATH);
  StrCopy(Title,'Select Disk Image For Drive ');
  If Ok(Drive) then StrCat(Title,'2') Else StrCat(Title,'1');
  FillChar(OFN,SizeOf(tOpenFilename),#0);
  OFN.lStructSize     := SizeOf(tOpenFilename);
  OFN.hwndOwner       := FrameWindow;
  OFN.hInstance       := Instance;
  OFN.lpstrFilter     := 'All Images'#0'*.apl;*.bin;*.do;*.dsk;*.iie;*.nib;*.po'#0+
                         'Disk Images (*.bin,*.do,*.dsk,*.iie,*.nib,*.po)'#0'*.bin;*.do;*.dsk;*.iie;*.nib;*.po'#0+
                         'All Files'#0'*.*';
  OFN.lpstrFile       := Filename;
  OFN.nMaxFile        := MAX_PATH;
  OFN.lpstrInitialDir := Directory;
  OFN.Flags           := OFN_PATHMUSTEXIST;
  OFN.lpstrTitle      := Title;
  If GetOpenFileName(OFN) then Begin
    If not Ok(OFN.nFileExtension) or not Ok(Filename[OFN.nFileExtension]) then StrCat(Filename,'.DSK');
    Error := DiskInsert(Drive,Filename,BOOL(DWORD(OFN.Flags AND OFN_READONLY)),true);
    If not Ok(Error) then Begin
      Filename[OFN.nFileOffset] := #0;
      If Ok(StrComp(Directory,Filename)) then Begin
        RegSaveString('Preferences','Starting Directory',true,Filename)
      End
    End Else DiskNotifyInvalidImage(Filename,Error)
  End
End;

Procedure DiskDestroy;
Begin
  RemoveDisk(0);
  RemoveDisk(1)
End;

Function DiskGetFullName( Drive : Integer ) : LPCTSTR;
Begin
  Result := Floppy[Drive].Fullname
End;

Procedure DiskReset;
Begin
  FloppyMotorOn := false
End;


