
/**
 * libemulation
 * Emulation interface
 * (C) 2012 by Marc S. Ressl (mressl@umich.edu)
 * Released under the GPL
 *
 * Defines the emulation interface
 */

#ifndef _EMULATIONINTERFACE_H
#define _EMULATIONINTERFACE_H

#include <string>
#include <vector>

#include "OEComponent.h"

using namespace std;

typedef enum
{
    EMULATION_CONSTRUCT_DISPLAYCANVAS,
    EMULATION_CONSTRUCT_PAPERCANVAS,
    EMULATION_CONSTRUCT_OPENGLCANVAS,
    EMULATION_DESTROY_CANVAS,
    
    EMULATION_UPDATE,
    
    EMULATION_ASSERT_ACTIVITY,
    EMULATION_CLEAR_ACTIVITY,
} EmulationMessage;

typedef enum
{
    EMULATION_WAS_SIGNALED,
} EmulationNotification;

typedef enum
{
    EMULATION_POWERDOWN = 0x81,
    EMULATION_SLEEP,
    EMULATION_WAKEUP,
    EMULATION_CONTEXT,
    EMULATION_MAINMENU,
    EMULATION_APPMENU,
    EMULATION_MENUHELP,
    EMULATION_MENUEXIT,
    EMULATION_MENUSELECT,
    EMULATION_MENURIGHT,
    EMULATION_MENULEFT,
    EMULATION_MENUUP,
    EMULATION_MENUDOWN,
    EMULATION_COLDRESTART,
    EMULATION_WARMRESTART,
    EMULATION_DPADUP,
    EMULATION_DPADDOWN,
    EMULATION_DPADRIGHT,
    EMULATION_DPADLEFT,
    
    EMULATION_DOCK = 0xa0,
    EMULATION_UNDOCK,
    EMULATION_SETUP,
    EMULATION_BREAK,
    EMULATION_DEBUGGERBREAK,
    EMULATION_APPLICATIONBREAK,
    EMULATION_APPLICATIONDEBUGGERBREAK,
    EMULATION_SPEAKERMUTE,
    EMULATION_HIBERNATE,
    
    EMULATION_DISPLAYINVERT = 0xb0,
    EMULATION_DISPLAYINTERNAL,
    EMULATION_DISPLAYEXTERNAL,
    EMULATION_DISPLAYBOTH,
    EMULATION_DISPLAYDUAL,
    EMULATION_DISPLAYTOGGLEINTEXT,
    EMULATION_DISPLAYSWAPPRIMARYSECONDARY,
    EMULATION_DISPLAYLCDAUTOSCALE,
    
    EMULATION_END,
} EmulationEvent;

#endif
