/**
 * libdiskimage
 * Disk Image WOZ
 * (C) 2018 by John K. Morris (jmorris@evolutioninteractive.com)
 * Released under the GPL
 *
 * Accesses WOZ disk images
 */

#include "DIBackingStore.h"
#include "DIDiskStorage.h"

class DIWozDiskStorage : public DIDiskStorage
{
public:
    DIWozDiskStorage();
    ~DIWozDiskStorage();
    
    bool open(DIBackingStore *file);
    void close();
    
    bool isWriteEnabled();
    DIDiskType getDiskType();
    DIInt getTracksPerInch();
    string getFormatLabel();
    DILong getOptimalBitTiming();
    void setOptimalBitTiming(DILong value);
    bool isFluxTrack(DIInt trackIndex);
    
    bool readTrack(DIInt headIndex, DIInt trackIndex, DITrack& track);
    bool writeTrack(DIInt headIndex, DIInt trackIndex, DITrack& track);

private:
    
    DIChar wozVersion;
    DIChar infoVersion;
    bool writeProtected;
    DIChar optimalBitTiming;
    DIInt largestTrack;
    DIInt largestFluxTrack;
    bool hasFluxTracks;

    DIBackingStore *backingStore;
    
    DIData trackMap;
    DIData fluxTrackMap;

    DIInt crc32Image();
};
