
/**
 * libemulation
 * Apple II Interface
 * (C) 2010-2012 by Marc S. Ressl (mressl@umich.edu)
 * Released under the GPL
 *
 * Defines the Apple II interface
 */

#ifndef _APPLEIIINTERFACE_H
#define _APPLEIIINTERFACE_H

#include "CanvasInterface.h"
#include "StorageInterface.h"

#include "CPUInterface.h"
#include "MemoryInterface.h"

#define APPLEII_CLOCKFREQUENCY   (14318180.0F * 65 / 912)

typedef enum
{
    APPLEII_MAP_SLOT = ADDRESSDECODER_END,
    APPLEII_UNMAP_SLOT,
    APPLEII_MAP_CXXX,
    APPLEII_UNMAP_CXXX,
    APPLEII_MAP_INTERNAL,
    APPLEII_UNMAP_INTERNAL,
    APPLEII_ADDRESSDECODER_END,
} AppleIIAddressDecoderMessage;

// Apple IIe memory control
typedef enum
{
    APPLEII_SET_ALTZP = APPLEII_ADDRESSDECODER_END,
    APPLEII_SET_RAMRD,
    APPLEII_SET_RAMWRT,
    APPLEII_SET_80STORE,
    APPLEII_SET_MMUPAGE2,
    APPLEII_SET_MMUHIRES,
    APPLEII_SET_INTCXROM,
    APPLEII_SET_SLOTC3ROM,
    APPLEII_SET_LCBANK1,
    APPLEII_SET_LCRAMRD,
    APPLEII_SET_LCRAMWR,
} AppleIIeAddressDecoderMessage;

// Move this to AppleIIControlBus:
//    APPLEII_ASSERT_DISKMOTORON,
//    APPLEII_CLEAR_DISKMOTORON,

typedef enum
{
    APPLEII_KEYSTROBE_DID_CHANGE,
} AppleIIKeyboardNotification;

typedef enum
{
    APPLEII_REFRESH_VIDEO = CANVAS_END,
    APPLEII_READ_FLOATINGBUS,
    APPLEII_IS_VBL,
    APPLEII_IS_COLORKILLER_ENABLED,
    APPLEII_ASSERT_VIDEOINHIBIT,
    APPLEII_CLEAR_VIDEOINHIBIT,
    APPLEII_IS_VIDEO_INHIBITED,
    APPLEII_IS_MONITOR_CONNECTED,
    APPLEII_VIDEO_END,
    APPLEII_80STORE_DID_CHANGE,
} AppleIIVideoMessage;

typedef enum
{
    APPLEII_VBL_DID_CHANGE = CANVAS_NOTIFICATION_END,
    APPLEII_COLORKILLER_DID_CHANGE,
    APPLEII_VIDEOINHIBIT_DID_CHANGE,
    APPLEII_MONITOR_DID_CHANGE,
    APPLEII_HIRES_DID_CHANGE,
    APPLEII_PAGE2_DID_CHANGE,
} AppleIIVideoNotification;

typedef enum
{
    APPLEII_SET_PDL0,
    APPLEII_SET_PDL1,
    APPLEII_SET_PDL2,
    APPLEII_SET_PDL3,
    APPLEII_SET_PB3,
    APPLEII_SET_PB0,
    APPLEII_SET_PB1,
    APPLEII_SET_PB2,
    APPLEII_GET_AN0,
    APPLEII_GET_AN1,
    APPLEII_GET_AN2,
    APPLEII_GET_AN3,
    APPLEII_SET_GAMEPORT_OBSERVER,
} AppleIIGamePortMessage;

typedef enum
{
    APPLEII_AN0_DID_CHANGE,
    APPLEII_AN1_DID_CHANGE,
    APPLEII_AN2_DID_CHANGE,
    APPLEII_AN3_DID_CHANGE,
    APPLEII_DID_STROBE,
} AppleIIGamePortNotification;

typedef enum
{
    APPLEII_DISABLE_C800,
    APPLEII_IS_C800_ENABLED,
} AppleIISlotControllerMessage;

typedef enum
{
    APPLEII_C800_DID_CHANGE,
} AppleIISlotControllerNotification;

typedef enum
{
    APPLEII_ASSERT_DRIVEENABLE = STORAGE_END,
    APPLEII_CLEAR_DRIVEENABLE,
    APPLEII_SET_PHASECONTROL,
    APPLEII_SENSE_INPUT,
    APPLEII_SKIP_DATA,
} AppleIIDiskDriveMessage;

#endif
