/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Much of a2disk.c was built off Rich Skrenta's 'a2' Apple II emulator's 'disk.c'.
 * I copied the tables and the algorithm, but the code itself is my own rewrite.
 * His code is barely readable.
 */

#include <stdio.h>
#include <string.h>
#include "a2vars.h"

void a2_serial_reset(void)
{
	A2_SERIAL_IN[0]=NULL;
	A2_SERIAL_OUT[0]=NULL;
	A2_SERIAL_IN[1]=NULL;
	A2_SERIAL_OUT[1]=NULL;
}

void a2_read_serial_rom(char * fn)
{
	FILE * f;
	f = fopen(fn, "rb");
	if (f) {
		fread(&A2_PERIPH_ROM[0x100], 1, 0x100, f);
		fclose(f);
	}
	f = fopen(fn, "rb");
	if (f) {
		fread(&A2_PERIPH_ROM[0x200], 1, 0x100, f);
		fclose(f);
	}
}

void a2_read_serial_xrom(char * fn)
{
	FILE * f;
	f = fopen(fn, "rb");
	if (f) {
		fread(&A2_PERIPH_XROM[0x0800], 1, 0x800, f);
		fclose(f);
	}
	f = fopen(fn, "rb");
	if (f) {
		fread(&A2_PERIPH_XROM[0x1000], 1, 0x800, f);
		fclose(f);
	}
}

unsigned char a2_serial_peek(unsigned short a)
{
	int slot = (a & 0x0070);
	int addr = (a & 0x000F);
	switch (addr) {
	
	}
}

void a2_serial_poke(unsigned short a, unsigned char ch)
{
	int slot = (a & 0x0070);
	int addr = (a & 0x000F);
	switch (addr) {
	
	}
}