/*
 * Appleblossom - Portable Open-Source Apple IIe Emulator
 * Copyright (C) 2005 Jonathan Bettencourt (jonrelay)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <time.h>
#include <stdio.h>
#include "a2vars.h"

void a2_read_rtc_input(void)
{
	time_t t;
	struct tm * ti;
	time(&t);
	ti = localtime(&t);
	sprintf((A2_WRAUXRAM?A2_AUX:A2_MAIN)+0x200, "%02d,%02d,%02d,%02d,%02d",
		ti->tm_mon+1,
		ti->tm_wday,
		ti->tm_mday,
		ti->tm_hour,
		ti->tm_min
	);
}

void a2_read_rtc_prodos(void)
{
	time_t t;
	struct tm * ti;
	int pdd, pdt;
	time(&t);
	ti = localtime(&t);
	pdd = ( (ti->tm_mday) | ((ti->tm_mon+1) << 5) | ((ti->tm_year % 100) << 9) );
	pdt = ( (ti->tm_min) | ((ti->tm_hour) << 8) );
	A2_MAIN[0xBF90] = (pdd & 0xFF);
	A2_MAIN[0xBF91] = ((pdd & 0xFF00) >> 8);
	A2_MAIN[0xBF92] = (pdt & 0xFF);
	A2_MAIN[0xBF93] = ((pdt & 0xFF00) >> 8);
}

void a2_rtc_install_driver(void)
{
	unsigned short a = (A2_MAIN[0xBF07] | (A2_MAIN[0xBF08]<<8));
	if ((a & 0xF000) == 0xD000) {
		A2_MAIN[0xBF06] = 0x4C;
		a -= 0xD000;
		A2_BS_RAM[a++] = 0xA9;
		A2_BS_RAM[a++] = 0xCF;
		A2_BS_RAM[a++] = 0x8D;
		A2_BS_RAM[a++] = 0x77;
		A2_BS_RAM[a++] = 0xC0;
		A2_BS_RAM[a++] = 0x60;
	}
}
