	Page	58,132
	Title	DEVICE.ASM	Apple Expansion Slot Devices
;******************************************************************************
;
;   Name:	DEVICE.ASM	Apple Expansion Slot Devices
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all the code for the Apple
;	expansion slot devices.
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Slot_Address		; Expansion slot address routine
	Public	Exp_Slot_Read		; Expansion slot read routine
	Public	Exp_Slot_Write		; Expansion slot write routine
	Public	Exp_Mem_Read		; Expansion memory read routine
	Public	Exp_Mem_Write		; Expansion memory write routine
	Public	Select_Device		; Select device type routine
;
;  External Declarations
;
	Extrn	Error:Near		; Apple emulator error routine	(APPLE)
	Extrn	Exit:Near		; Apple emulator exit routine	(APPLE)
	Extrn	Slot_ID:Word		; Expansion slot name table	 (DATA)
	Extrn	Slot_Init:Word		; Exp. slot initialization table (DATA)
	Extrn	Slot_Ctrl:Word		; Expansion slot control table	 (DATA)
	Extrn	Slot_Read:Word		; Expansion slot read table	 (DATA)
	Extrn	Slot_Write:Word 	; Expansion slot write table	 (DATA)
	Extrn	Mem_Read:Word		; Exp. slot memory read table	 (DATA)
	Extrn	Mem_Write:Word		; Exp. slot memory write table	 (DATA)
	Extrn	Exp_Read:Word		; Expansion memory read table	 (DATA)
	Extrn	Exp_Write:Word		; Expansion memory write table	 (DATA)
	Extrn	Dev_Reset:Word		; Device reset table		 (DATA)
	Extrn	Device_Table:Word	; Device type table		 (DATA)
	Extrn	Current_Slot:Byte	; Current active expansion slot  (DATA)
	Extrn	System_Flag:Byte	; Apple emulator system flag byte(DATA)
	Extrn	Config_Flag:Byte	; Apple configuration flag byte  (DATA)
;
;  LOCAL Equates
;
INIT_FLAG	Equ	01h		; Initialization bit flag
SLOT_MASK	Equ	0Fh		; Expansion slot mask value
ENTRY_OFFSET	Equ	02h		; Starting device entry offset
;
;  Define any include files needed
;
	Include 	Macros.inc	; Include the macro definitions
	Include 	Equates.inc	; Include the equate definitions
	Include 	Strucs.inc	; Include the structure definitions
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
	Subttl	Slot_Address	Expansion Slot Address
	Page	+
;******************************************************************************
;
;	Slot_Address(Slot_Number)
;
;		Logically OR in the hardware page number
;		Calculate the actual slot address
;		Return to the caller
;
;	Registers on Entry:
;
;		AX    - Slot number
;
;	Registers on Exit:
;
;		AX    - Destroyed
;		SI    - Slot address
;
;******************************************************************************
		Even			; Force procedure to even address
Slot_Address	Proc	Near		; Expansion slot address procedure
	or	al,HARDWARE_PAGE	; Logically OR in the hardware page
	xchg	al,ah			; Calculate the actual page address
	mov	si,ax			; Move actual page address to SI
	ret				; Return to the caller
Slot_Address	Endp			; End of the Slot_Address procedure
	Subttl	Exp_Slot_Read	Expansion Slot Read
	Page	+
;******************************************************************************
;
;	Exp_Slot_Read(Effective_Address)
;
;		Isolate the slot number being read
;		Jump to correct routine to handle read
;
;	Registers on Entry:
;
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		AL    - Memory value
;
;******************************************************************************
		Even			; Force procedure to even address
Exp_Slot_Read	Proc	Near		; Expansion slot read procedure
	mov	ax,di			; Get the effective address
	mov	al,ah			; Move MSB of address into AL register
	and	al,SLOT_MASK		; Mask off all but the slot number
	xor	ah,ah			; Convert slot number to full word
	shl	ax,1			; Convert slot number to table index
	mov	bp,ax			; Setup to jump to correct routine
	jmp	cs:[bp + Mem_Read]	; Jump to correct routine to read
	ret				; Return to the caller (Never Executed)
Exp_Slot_Read	Endp			; End of the Exp_Slot_Read procedure
	Subttl	Exp_Slot_Write	Expansion Slot Write
	Page	+
;******************************************************************************
;
;	Exp_Slot_Write(Effective_Address, Value)
;
;		Isolate the slot number being written
;		Jump to correct routine to handle write
;
;	Registers on Entry:
;
;		AL    - Memory value
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Exp_Slot_Write	Proc	Near		; Expansion slot write procedure
	mov	bp,ax			; Save the memory value in BP register
	mov	ax,di			; Get the effective address
	mov	al,ah			; Move MSB of address into AL register
	and	al,SLOT_MASK		; Mask off all but the slot number
	xor	ah,ah			; Convert slot number to full word
	shl	ax,1			; Convert slot number to table index
	xchg	bp,ax			; Setup to jump to correct routine
	jmp	cs:[bp + Mem_Write]	; Jump to correct routine to read
	ret				; Return to the caller
Exp_Slot_Write	Endp			; End of the Exp_Slot_Write procedure
	Subttl	Exp_Mem_Read	Expansion Memory Read
	Page	+
;******************************************************************************
;
;	Exp_Mem_Read(Effective_Address)
;
;		Get the current slot number
;		Jump to correct routine to handle read
;
;	Registers on Entry:
;
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		AL    - Memory value
;
;******************************************************************************
		Even			; Force procedure to even address
Exp_Mem_Read	Proc	Near		; Expansion memory read procedure
	mov	al,cs:[Current_Slot]	; Get the current active slot number
	xor	ah,ah			; Convert slot number to full word
	shl	ax,1			; Convert slot number to table index
	mov	bp,ax			; Setup to jump to correct routine
	jmp	cs:[bp + Exp_Read]	; Jump to correct routine to read
	ret				; Return to the caller (Never Executed)
Exp_Mem_Read	Endp			; End of the Exp_Mem_Read procedure
	Subttl	Exp_Mem_Write	Expansion Memory Write
	Page	+
;******************************************************************************
;
;	Exp_Mem_Write(Effective_Address, Value)
;
;		Get the current slot number
;		Jump to correct routine to handle write
;
;	Registers on Entry:
;
;		AL    - Memory value
;		DS:DI - 65C02 Effective address
;
;	Registers on Exit:
;
;		None
;
;******************************************************************************
		Even			; Force procedure to even address
Exp_Mem_Write	Proc	Near		; Expansion memory write procedure
	mov	bp,ax			; Save memory value in BP register
	mov	al,cs:[Current_Slot]	; Get the current active slot number
	xor	ah,ah			; Convert slot number to full word
	shl	ax,1			; Convert slot number to table index
	xchg	bp,ax			; Setup to jump to correct routine
	jmp	cs:[bp + Exp_Write]	; Jump to correct routine to read
	ret				; Return to the caller (Never Executed)
Exp_Mem_Write	Endp			; End of the Exp_Mem_Write procedure
	Subttl	Select_Device	Select Device Type Routine
	Page	+
;******************************************************************************
;
;	Select_Device(Device_Type, Slot_Number)
;
;		Save the required registers
;		Convert slot number to table index
;		Compute offset into the device table
;		Fill in the slot tables using the device table
;		Call the device initialization routine
;		Set flag indicating this slot has been initialized
;		Restore the required registers
;		Return to the caller
;
;	Registers on Entry:
;
;		BX    - Device type
;		DX    - Current parse offset
;		BP    - Slot number
;		DS:SI - Pointer to configuration data (65C02 RAM segment)
;		ES:DI - Pointer to parameter buffer
;
;	Registers on Exit:
;
;		AX-CX - Destroyed
;		DX    - Updated to next parse offset
;
;******************************************************************************
		Even			; Force procedure to even address
Select_Device	Proc	Near		; Select device type procedure
	Save	si,di,bp		; Save the required registers
	shl	bp,1			; Convert slot number to table index
	mov	ax,Size Device_Entry	; Get device table entry size
	mul	bl			; Compute device table offset
	mov	bx,ax			; Setup to access
	add	bx,ENTRY_OFFSET 	;		  the device table
	mov	ax,cs:[Device_Table.Device_ID + bx]
	mov	cs:[Slot_ID + bp],ax	; Save the device ID string address
	mov	ax,cs:[Device_Table.Device_Init + bx]
	mov	cs:[Slot_Init + bp],ax	; Save device initialization address
	mov	ax,cs:[Device_Table.Device_Ctrl + bx]
	mov	cs:[Slot_Ctrl + bp],ax	; Save the device control address
	mov	ax,cs:[Device_Table.Device_Rd + bx]
	mov	cs:[Slot_Read + bp],ax	; Save the device read address
	mov	ax,cs:[Device_Table.Device_Wrt + bx]
	mov	cs:[Slot_Write + bp],ax ; Save the device write address
	mov	ax,cs:[Device_Table.Device_Mem_Rd + bx]
	mov	cs:[Mem_Read + bp],ax	; Save device memory read address
	mov	ax,cs:[Device_Table.Device_Mem_Wrt + bx]
	mov	cs:[Mem_Write + bp],ax	; Save device memory write address
	mov	ax,cs:[Device_Table.Device_Exp_Rd + bx]
	mov	cs:[Exp_Read + bp],ax	; Save device expansion read address
	mov	ax,cs:[Device_Table.Device_Exp_Wrt + bx]
	mov	cs:[Exp_Write + bp],ax	; Save device expansion write address
	mov	ax,cs:[Device_Table.Device_Reset + bx]
	mov	cs:[Dev_Reset + bp],ax	; Save device reset address
	mov	ax,bp			; Get the actual
	shr	ax,1			;		 slot number value
	call	cs:[Slot_Init + bp]	; Call the slot initialization routine
	mov	al,INIT_FLAG		; Get the initialization bit flag
	mov	cx,bp			; Get the actual
	shr	cx,1			;		 slot number value
	shl	al,cl			; Shift initialization flag into place
	or	cs:[Config_Flag],al	; Indicate this slot as initialized
	Restore si,di,bp		; Restore the required registers
	ret				; Return to the caller
Select_Device	Endp			; End of the Select_Device procedure
;******************************************************************************
;
;	Define the end of the Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the Device module
