/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DiskII
extends Peripheral {
    private static final int[] rom = new int[]{162, 32, 160, 0, 162, 3, 134, 60, 138, 10, 36, 60, 240, 16, 5, 60, 73, 255, 41, 126, 176, 8, 74, 208, 251, 152, 157, 86, 3, 200, 232, 16, 229, 32, 88, 255, 186, 189, 0, 1, 10, 10, 10, 10, 133, 43, 170, 189, 142, 192, 189, 140, 192, 189, 138, 192, 189, 137, 192, 160, 80, 189, 128, 192, 152, 41, 3, 10, 5, 43, 170, 189, 129, 192, 169, 86, 169, 0, 234, 136, 16, 235, 133, 38, 133, 61, 133, 65, 169, 8, 133, 39, 24, 8, 189, 140, 192, 16, 251, 73, 213, 208, 247, 189, 140, 192, 16, 251, 201, 170, 208, 243, 234, 189, 140, 192, 16, 251, 201, 150, 240, 9, 40, 144, 223, 73, 173, 240, 37, 208, 217, 160, 3, 133, 64, 189, 140, 192, 16, 251, 42, 133, 60, 189, 140, 192, 16, 251, 37, 60, 136, 208, 236, 40, 197, 61, 208, 190, 165, 64, 197, 65, 208, 184, 176, 183, 160, 86, 132, 60, 188, 140, 192, 16, 251, 89, 214, 2, 164, 60, 136, 153, 0, 3, 208, 238, 132, 60, 188, 140, 192, 16, 251, 89, 214, 2, 164, 60, 145, 38, 200, 208, 239, 188, 140, 192, 16, 251, 89, 214, 2, 208, 135, 160, 0, 162, 86, 202, 48, 251, 177, 38, 94, 0, 3, 42, 94, 0, 3, 42, 145, 38, 200, 208, 238, 230, 39, 230, 61, 165, 61, 205, 0, 8, 166, 43, 144, 219, 76, 1, 8, 0, 0, 0, 0, 0};
    public static final int DEFAULT_VOLUME = 254;
    private static final int NUM_DRIVES = 2;
    private static final int DOS_NUM_SECTORS = 16;
    private static final int DOS_NUM_TRACKS = 35;
    private static final int DOS_TRACK_BYTES = 4096;
    private static final int RAW_TRACK_BYTES = 6656;
    private static final int STANDARD_2IMG_HEADER_SIZE = 64;
    private static final int STANDARD_PRODOS_BLOCKS = 280;
    private int drive = 0;
    private boolean isMotorOn = false;
    private byte[][][] diskData = new byte[2][35][];
    private boolean[] isWriteProtected = new boolean[2];
    private int currPhysTrack;
    private int currNibble;
    private int[] driveCurrPhysTrack = new int[2];
    private byte[] realTrack;
    private int latchData;
    private boolean writeMode;
    private boolean loadMode;
    private boolean driveSpin;
    private static final int[] gcrEncodingTable = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};
    private int[] gcrSwapBit = new int[]{0, 2, 1, 3};
    private int[] gcrBuffer = new int[256];
    private int[] gcrBuffer2 = new int[86];
    private static final int[] gcrLogicalDos33Sector = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};
    private static final int[] gcrLogicalProdosSector = new int[]{0, 8, 1, 9, 2, 10, 3, 11, 4, 12, 5, 13, 6, 14, 7, 15};
    private byte[] gcrNibbles = new byte[6656];
    private int gcrNibblesPos;
    EmAppleII apple;

    public DiskII(EmAppleII emAppleII) {
        this.apple = emAppleII;
        this.readDisk(0, null, "", false, 254);
        this.readDisk(1, null, "", false, 254);
    }

    public int ioRead(int n) {
        switch (n & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setPhase(n);
                break;
            }
            case 8: {
                this.isMotorOn = false;
                break;
            }
            case 9: {
                this.isMotorOn = true;
                break;
            }
            case 10: {
                this.setDrive(0);
                break;
            }
            case 11: {
                this.setDrive(1);
                break;
            }
            case 12: {
                this.ioLatchC();
                break;
            }
            case 13: {
                this.loadMode = true;
                if (!this.isMotorOn || this.writeMode) break;
                this.latchData &= 0x7F;
                if (!this.isWriteProtected[this.drive]) break;
                this.latchData |= 0x80;
                break;
            }
            case 14: {
                this.writeMode = false;
                break;
            }
            case 15: {
                this.writeMode = true;
            }
        }
        if ((n & 1) == 0) {
            if (this.isMotorOn) {
                return this.latchData;
            }
            this.driveSpin = !this.driveSpin;
            return this.driveSpin ? 126 : 127;
        }
        return this.rand.nextInt(256);
    }

    public void ioWrite(int n, int n2) {
        switch (n & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setPhase(n);
                break;
            }
            case 8: {
                this.isMotorOn = false;
                break;
            }
            case 9: {
                this.isMotorOn = true;
                break;
            }
            case 10: {
                this.setDrive(0);
                break;
            }
            case 11: {
                this.setDrive(1);
                break;
            }
            case 12: {
                this.ioLatchC();
                break;
            }
            case 13: {
                this.loadMode = true;
                break;
            }
            case 14: {
                this.writeMode = false;
                break;
            }
            case 15: {
                this.writeMode = true;
            }
        }
        if (this.isMotorOn && this.writeMode && this.loadMode) {
            this.latchData = n2;
        }
    }

    public int memoryRead(int n) {
        return rom[n & 0xFF];
    }

    public void reset() {
        this.ioRead(8);
    }

    public boolean readDisk(int n, DataInputStream dataInputStream, String string, boolean bl, int n2) {
        try {
            byte[] byArray = new byte[4096];
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = string.toLowerCase();
            if (string2.indexOf(".2mg") != -1 || string2.indexOf(".2img") != -1) {
                int n3;
                byte[] byArray2 = new byte[64];
                dataInputStream.readFully(byArray2, 0, 64);
                int n4 = byArray2[9] << 8 | byArray2[8];
                if (n4 != 64) {
                    return false;
                }
                int n5 = byArray2[15] << 24 | byArray2[14] << 16 | byArray2[13] << 8 | byArray2[12];
                if (n5 == 1) {
                    bl2 = true;
                    n3 = byArray2[23] << 24 | byArray2[22] << 16 | byArray2[21] << 8 | byArray2[20];
                    if (n3 != 280) {
                        return false;
                    }
                } else if (n5 == 2) {
                    bl3 = true;
                } else if (n5 != 0) {
                    return false;
                }
                n3 = byArray2[19] << 24 | byArray2[18] << 16 | byArray2[17] << 8 | byArray2[16];
                if ((n3 & Integer.MIN_VALUE) != 0) {
                    bl = true;
                }
                if ((n3 & 0x100) != 0) {
                    n2 = n3 & 0xFF;
                }
            } else {
                bl2 = string2.indexOf(".po") != -1;
                bl3 = string2.indexOf(".nib") != -1;
            }
            for (int i = 0; i < 35; ++i) {
                this.diskData[n][i] = new byte[6656];
                if (dataInputStream == null) continue;
                if (bl3) {
                    dataInputStream.readFully(this.diskData[n][i], 0, 6656);
                    continue;
                }
                dataInputStream.readFully(byArray, 0, 4096);
                this.trackToNibbles(byArray, this.diskData[n][i], n2, i, !bl2);
            }
            this.realTrack = this.diskData[n][this.currPhysTrack >> 1];
            this.isWriteProtected[n] = bl;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean writeDisk(int n, OutputStream outputStream) {
        return true;
    }

    public boolean isMotorOn() {
        return this.isMotorOn;
    }

    private void ioLatchC() {
        this.loadMode = false;
        if (!this.writeMode) {
            this.latchData = this.realTrack[this.currNibble] & 0xFF;
            if (this.apple.memoryRead(this.apple.PC + 3) == 213 && this.apple.memoryRead(this.apple.PC + 2) == 201 && this.apple.memoryRead(this.apple.PC + 1) == 251 && this.apple.memoryRead(this.apple.PC + 0) == 16 && this.latchData != 213) {
                int n = 416;
                do {
                    ++this.currNibble;
                    if (this.currNibble >= 6656) {
                        this.currNibble = 0;
                    }
                    this.latchData = this.realTrack[this.currNibble] & 0xFF;
                } while (this.latchData != 213 && --n > 0);
            } else if (this.latchData == 127) {
                int n = 416;
                do {
                    ++this.currNibble;
                    if (this.currNibble >= 6656) {
                        this.currNibble = 0;
                    }
                    this.latchData = this.realTrack[this.currNibble] & 0xFF;
                } while (this.latchData == 127 && --n > 0);
            }
        } else {
            this.realTrack[this.currNibble] = (byte)this.latchData;
        }
        ++this.currNibble;
        if (this.currNibble >= 6656) {
            this.currNibble = 0;
        }
    }

    private void setPhase(int n) {
        switch (n & 0xF) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 1: {
                int n2 = this.currPhysTrack & 3;
                if (n2 == 1) {
                    if (this.currPhysTrack > 0) {
                        --this.currPhysTrack;
                    }
                } else if (n2 == 3 && this.currPhysTrack < 69) {
                    ++this.currPhysTrack;
                }
                this.realTrack = this.diskData[this.drive][this.currPhysTrack >> 1];
                break;
            }
            case 3: {
                int n3 = this.currPhysTrack & 3;
                if (n3 == 2) {
                    if (this.currPhysTrack > 0) {
                        --this.currPhysTrack;
                    }
                } else if (n3 == 0 && this.currPhysTrack < 69) {
                    ++this.currPhysTrack;
                }
                this.realTrack = this.diskData[this.drive][this.currPhysTrack >> 1];
                break;
            }
            case 5: {
                int n4 = this.currPhysTrack & 3;
                if (n4 == 3) {
                    if (this.currPhysTrack > 0) {
                        --this.currPhysTrack;
                    }
                } else if (n4 == 1 && this.currPhysTrack < 69) {
                    ++this.currPhysTrack;
                }
                this.realTrack = this.diskData[this.drive][this.currPhysTrack >> 1];
                break;
            }
            case 7: {
                int n5 = this.currPhysTrack & 3;
                if (n5 == 0) {
                    if (this.currPhysTrack > 0) {
                        --this.currPhysTrack;
                    }
                } else if (n5 == 2 && this.currPhysTrack < 69) {
                    ++this.currPhysTrack;
                }
                this.realTrack = this.diskData[this.drive][this.currPhysTrack >> 1];
            }
        }
    }

    private void setDrive(int n) {
        this.driveCurrPhysTrack[this.drive] = this.currPhysTrack;
        this.drive = n;
        this.currPhysTrack = this.driveCurrPhysTrack[this.drive];
        this.realTrack = this.diskData[this.drive][this.currPhysTrack >> 1];
    }

    private final void gcrWriteNibble(int n) {
        this.gcrNibbles[this.gcrNibblesPos] = (byte)n;
        ++this.gcrNibblesPos;
    }

    private final void writeNibbles(int n, int n2) {
        while (n2 > 0) {
            --n2;
            this.gcrWriteNibble(n);
        }
    }

    private final void writeSync(int n) {
        this.writeNibbles(255, n);
    }

    private final void encode44(int n) {
        this.gcrWriteNibble(n >> 1 | 0xAA);
        this.gcrWriteNibble(n | 0xAA);
    }

    private void encode62(byte[] byArray, int n) {
        int n2;
        this.gcrBuffer2[0] = this.gcrSwapBit[byArray[n + 1] & 3];
        this.gcrBuffer2[1] = this.gcrSwapBit[byArray[n] & 3];
        int n3 = 2;
        for (n2 = 255; n2 >= 0; --n2) {
            this.gcrBuffer2[n3] = this.gcrBuffer2[n3] << 2 | this.gcrSwapBit[byArray[n + n2] & 3];
            this.gcrBuffer[n2] = (byArray[n + n2] & 0xFF) >> 2;
            n3 = n3 == 85 ? 0 : n3 + 1;
        }
        n2 = 0;
        while (n2 < 86) {
            int n4 = n2++;
            this.gcrBuffer2[n4] = this.gcrBuffer2[n4] & 0x3F;
        }
    }

    private final void writeAddressField(int n, int n2, int n3) {
        this.gcrWriteNibble(213);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(150);
        this.encode44(n);
        this.encode44(n2);
        this.encode44(n3);
        this.encode44(n ^ n2 ^ n3);
        this.gcrWriteNibble(222);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(235);
    }

    private void writeDataField() {
        int n;
        int n2;
        int n3 = 0;
        this.gcrWriteNibble(213);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(173);
        for (n2 = 85; n2 >= 0; --n2) {
            n = n3 ^ this.gcrBuffer2[n2];
            this.gcrWriteNibble(gcrEncodingTable[n]);
            n3 = this.gcrBuffer2[n2];
        }
        for (n2 = 0; n2 < 256; ++n2) {
            n = n3 ^ this.gcrBuffer[n2];
            this.gcrWriteNibble(gcrEncodingTable[n]);
            n3 = this.gcrBuffer[n2];
        }
        this.gcrWriteNibble(gcrEncodingTable[n3]);
        this.gcrWriteNibble(222);
        this.gcrWriteNibble(170);
        this.gcrWriteNibble(235);
    }

    private void trackToNibbles(byte[] byArray, byte[] byArray2, int n, int n2, boolean bl) {
        this.gcrNibbles = byArray2;
        this.gcrNibblesPos = 0;
        int[] nArray = bl ? gcrLogicalDos33Sector : gcrLogicalProdosSector;
        for (int i = 0; i < 16; ++i) {
            this.encode62(byArray, nArray[i] << 8);
            this.writeSync(12);
            this.writeAddressField(n, n2, i);
            this.writeSync(8);
            this.writeDataField();
        }
        this.writeNibbles(127, 6656 - this.gcrNibblesPos);
    }
}

