/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class AppleSpeaker
implements Runnable {
    private EmAppleII apple;
    private long refreshInterval;
    private static final int SPEAKER_BITS = 16;
    private static final int SPEAKER_SAMPLERATE = 44100;
    private static final int SPEAKER_CHANNELS = 1;
    private static final int SPEAKER_SAMPLESIZE = 2;
    private static final boolean SPEAKER_SIGNED = true;
    private static final boolean SPEAKER_BIGENDIAN = false;
    private int clock;
    private int clockNextFlip;
    private int clockEnd;
    private boolean isFlipsBufferEmpty = true;
    private SourceDataLine line;
    private int bufferSize;
    private byte[] buffer;
    private int speakerVolume;
    private int speakerFlipsPointer;
    private int speakerFlipState;
    private int[] speakerFlipStateToVolume = new int[2];
    private int speakerClocksPerSample;
    private boolean isPaused = true;
    private Thread thread;

    public AppleSpeaker(EmAppleII emAppleII) {
        this.apple = emAppleII;
        this.setVolume(4);
    }

    private void setRefreshRate(int n) {
        if ((float)n <= 0.0f) {
            return;
        }
        this.refreshInterval = (int)(1000.0 / (double)n);
        this.speakerClocksPerSample = (int)((float)this.apple.getCpuSpeed() * 1000.0f / 44100.0f);
    }

    public void setVolume(int n) {
        if (n < 0 || n > 7) {
            return;
        }
        this.speakerVolume = n;
        int n2 = 1 << n + 8;
        this.speakerFlipStateToVolume[0] = -n2;
        this.speakerFlipStateToVolume[1] = n2;
    }

    public int getVolume() {
        return this.speakerVolume;
    }

    public void setPaused(boolean bl) {
        if (this.isPaused == bl) {
            return;
        }
        this.isPaused = bl;
        if (this.isPaused) {
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.line != null) {
                this.line.stop();
                this.line.close();
            }
        } else {
            this.setRefreshRate(this.apple.getRefreshRate());
            AudioFormat audioFormat = new AudioFormat(44100.0f, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.bufferSize = this.line.getBufferSize();
                this.buffer = new byte[this.bufferSize];
                this.line.open(audioFormat);
                this.line.start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
    }

    public void run() {
        try {
            while (!this.isPaused) {
                long l = System.currentTimeMillis();
                this.refreshSpeaker();
                long l2 = System.currentTimeMillis() - l;
                if (l2 >= this.refreshInterval) continue;
                Thread.sleep(this.refreshInterval - l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void refreshSpeaker() {
        int n;
        this.clockEnd = this.apple.clock;
        if (this.line == null) {
            return;
        }
        while ((n = this.fillBuffer()) > 0) {
            this.line.write(this.buffer, 0, n);
        }
    }

    private int fillBuffer() {
        int n = this.speakerFlipStateToVolume[this.speakerFlipState];
        int n2 = this.clockEnd - this.speakerClocksPerSample;
        int n3 = 0;
        this.initNextFlip();
        while (n3 < this.bufferSize && n2 != this.clock && (n2 - this.clock & Integer.MAX_VALUE) <= 0x3FFFFFFF) {
            while ((this.clockNextFlip - this.clock & Integer.MAX_VALUE) < this.speakerClocksPerSample) {
                this.getNextFlip();
                this.speakerFlipState ^= 1;
                n = this.speakerFlipStateToVolume[this.speakerFlipState];
            }
            this.buffer[n3] = (byte)(n & 0xFF);
            this.buffer[n3 + 1] = (byte)(n >> 8);
            n3 += 2;
            this.clock += this.speakerClocksPerSample;
        }
        return n3;
    }

    private void initNextFlip() {
        if (this.isFlipsBufferEmpty) {
            this.isFlipsBufferEmpty = false;
            this.getNextFlip();
        }
    }

    private void getNextFlip() {
        if (this.speakerFlipsPointer == this.apple.speakerFlipsPointer) {
            this.clockNextFlip = this.clock + 0x3FFFFFFF;
            this.isFlipsBufferEmpty = true;
        } else {
            this.clockNextFlip = this.apple.speakerFlips[this.speakerFlipsPointer];
            this.speakerFlipsPointer = this.speakerFlipsPointer + 1 & 0xFFF;
        }
    }
}

