/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import javax.imageio.ImageIO;

public class AppleDisplay
implements Runnable {
    private Applet applet;
    private EmAppleII apple;
    public static final int COLORMODE_GREEN = 0;
    public static final int COLORMODE_COLOR = 1;
    private int colorMode;
    private boolean isGlare;
    private boolean isStatMode;
    private int refreshRate;
    private long refreshInterval;
    private long refreshDelayCumulative;
    private long refreshDelayPerSecond;
    private long refreshCycle;
    private boolean isPrecalcRequested = true;
    private boolean isRefreshRequested = true;
    private boolean[] graphicsDirty = new boolean[192];
    private int graphicsMode;
    private static final int DISPLAY_CHAR_SIZE_X = 7;
    private static final int DISPLAY_CHAR_SIZE_Y = 8;
    private static final int DISPLAY_CHAR_COUNT_X = 80;
    private static final int DISPLAY_CHAR_COUNT_Y = 24;
    private static final int DISPLAY_SIZE_X = 560;
    private static final int DISPLAY_SIZE_Y = 192;
    private BufferedImage displayImage;
    private int[] displayImageBuffer;
    private BufferedImage displayImagePaused;
    private BufferedImage displayImageGlare;
    private float displayScale;
    private int displayScaledSizeX;
    private int displayScaledSizeY;
    private int[] displayPalette;
    private static final int[] displayPaletteGreen = new int[]{0, 935694, 266756, 0x166E16, 1001999, 0x115411, 801548, 2072095, 1203218, 1804827, 0x22AB22, 2405668, 1738522, 3007277, 2473253, 0x32FF32};
    private static final int[] displayPaletteColor = new int[]{0, 0xDD0033, 153, 0xDD22DD, 30498, 0x555555, 0x2222FF, 0x66AAFF, 0x885500, 0xFF6600, 0xAAAAAA, 0xFF9988, 0x11DD00, 0xFFFF00, 0x44FF99, 0xFFFFFF};
    private final int CHARSET_CHAR_SIZE_X = 8;
    private final int CHARSET_CHAR_SIZE_Y = 8;
    private final int CHARSET_SIZE_X = 2048;
    private final int CHARSET_SIZE_Y = 8;
    private static final int CHARMAP_NORMAL = 0;
    private static final int CHARMAP_FLASH = 1;
    private static final int CHARMAP_ALT = 2;
    private int[] charSet = new int[16384];
    private int[] charMap;
    private int[][] charMaps = new int[3][256];
    private long charMapFlashCycle = 0L;
    private boolean isCharMapFlash = false;
    private int[][] charMapLookup = new int[][]{{192, 160, 64, 32, 64, 32, 64, 96}, {192, 160, 192, 160, 64, 32, 64, 96}, {192, 160, 0, 224, 64, 32, 64, 96}};
    private static final int[] textLineAddress = new int[]{0, 128, 256, 384, 512, 640, 768, 896, 40, 168, 296, 424, 552, 680, 808, 936, 80, 208, 336, 464, 592, 720, 848, 976};
    private int[] hiresEvenOddToWord = new int[512];
    private int[] hiresWord = new int[8];
    private int[] hiresWordNext = new int[8];
    private int[] hiresLookup = new int[256];
    private static final int[] hiresLookupColor = new int[]{0, 273, 8738, 9011, 17472, 17745, 26210, 26483, 34816, 35089, 43554, 43827, 52288, 52561, 61026, 61299, 4096, 4369, 12834, 13107, 21568, 21841, 30306, 30579, 38912, 39185, 47650, 47923, 56384, 56657, 65122, 65395, 0, 273, 8738, 9011, 17472, 17745, 26210, 26483, 34816, 35089, 43554, 43827, 52288, 52561, 61026, 61299, 4096, 4369, 12834, 13107, 21568, 21841, 30306, 30579, 38912, 39185, 47650, 47923, 56384, 56657, 65122, 65395, 4, 277, 8742, 9015, 17476, 17749, 26214, 26487, 34820, 35093, 43558, 43831, 52292, 52565, 61030, 61303, 4100, 4373, 12838, 13111, 21572, 21845, 30310, 30583, 38916, 39189, 47654, 47927, 56388, 56661, 65126, 65399, 4, 277, 8742, 9015, 17476, 17749, 26214, 26487, 34820, 35093, 43558, 43831, 52292, 52565, 61030, 61303, 4100, 4373, 12838, 13111, 21572, 21845, 30310, 30583, 38916, 39189, 47654, 47927, 56388, 56661, 65126, 65399, 136, 409, 8874, 9147, 17608, 17881, 26346, 26619, 34952, 35225, 43690, 43963, 52424, 52697, 61162, 61435, 4232, 4505, 12970, 13243, 21704, 21977, 30442, 30715, 39048, 39321, 47786, 48059, 56520, 56793, 65258, 65531, 136, 409, 8874, 9147, 17608, 17881, 26346, 26619, 34952, 35225, 43690, 43963, 52424, 52697, 61162, 61435, 4232, 4505, 12970, 13243, 21704, 21977, 30442, 30715, 39048, 39321, 47786, 48059, 56520, 56793, 65258, 65531, 140, 413, 8878, 9151, 17612, 17885, 26350, 26623, 34956, 35229, 43694, 43967, 52428, 52701, 61166, 61439, 4236, 4509, 12974, 13247, 21708, 21981, 30446, 30719, 39052, 39325, 47790, 48063, 56524, 56797, 65262, 65535, 140, 413, 8878, 9151, 17612, 17885, 26350, 26623, 34956, 35229, 43694, 43967, 52428, 52701, 61166, 61439, 4236, 4509, 12974, 13247, 21708, 21981, 30446, 30719, 39052, 39325, 47790, 48063, 56524, 56797, 65262, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 4369, 32, 51, 1024, 1285, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 8738, 51, 1024, 1285, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 13107, 1024, 1285, 1632, 1911, 61440, 36873, 41120, 45243, 65280, 56589, 65520, 65535, 0, 1, 32, 51, 17476, 1285, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 21845, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 26214, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 30583, 32768, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 4095, 34952, 36873, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 1911, 32768, 39321, 41120, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 1911, 32768, 36873, 43690, 45243, 52224, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 1911, 32768, 36873, 41120, 48059, 52224, 56589, 61152, 65535, 0, 15, 32, 255, 1024, 1285, 1632, 4095, 32768, 36873, 41120, 45243, 52428, 56589, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56797, 61152, 65535, 0, 1, 32, 51, 1024, 1285, 1632, 1911, 32768, 36873, 41120, 45243, 52224, 56589, 61166, 65535, 0, 15, 240, 255, 3840, 3855, 4080, 4095, 61440, 61455, 61680, 61695, 65280, 65295, 65520, 65535};
    private int[] doubleHiresPalette;
    private static final int[] doubleHiresPaletteColor = new int[]{0, 153, 30498, 0x2222FF, 0x885500, 0xAAAAAA, 0x11DD00, 0x44FF99, 0xDD0033, 0xDD22DD, 0x555555, 0x66AAFF, 0xFF6600, 0xFF9988, 0xFFFF00, 0xFFFFFF};
    private boolean isPaused = true;
    private Thread thread;
    private String threadError = null;

    public AppleDisplay(Applet applet, EmAppleII emAppleII) {
        this.applet = applet;
        this.apple = emAppleII;
        this.displayImage = new BufferedImage(560, 192, 1);
        this.displayImageBuffer = ((DataBufferInt)this.displayImage.getRaster().getDataBuffer()).getData();
        try {
            this.displayImageGlare = ImageIO.read(this.getClass().getResourceAsStream("/Resources/Glare.png"));
            this.displayImagePaused = ImageIO.read(this.getClass().getResourceAsStream("/Resources/Paused.png"));
        }
        catch (IOException iOException) {
            this.threadError = iOException.toString();
        }
        this.precalcCharMaps();
        this.precalcHiresEvenEddToWord();
        this.setScale(1.0f);
        this.setRefreshRate(10);
        this.setColorMode(0);
        this.setGlare(false);
        this.setStatMode(false);
    }

    public void setScale(float f) {
        if (f <= 0.0f) {
            return;
        }
        this.displayScale = f;
        this.isPrecalcRequested = true;
    }

    public float getScale() {
        return this.displayScale;
    }

    public void setRefreshRate(int n) {
        if ((float)n <= 0.0f) {
            return;
        }
        this.refreshRate = n;
        this.refreshInterval = (int)(1000.0 / (double)n);
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setColorMode(int n) {
        this.colorMode = n;
        this.isPrecalcRequested = true;
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setPaused(boolean bl) {
        if (this.isPaused == bl) {
            return;
        }
        this.isPaused = bl;
        if (this.isPaused) {
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.applet.repaint();
        } else {
            this.isRefreshRequested = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public boolean getPaused() {
        return this.isPaused;
    }

    public void setGlare(boolean bl) {
        this.isGlare = bl;
        this.isRefreshRequested = true;
    }

    public boolean getGlare() {
        return this.isGlare;
    }

    public void setStatMode(boolean bl) {
        this.isStatMode = bl;
        this.isRefreshRequested = true;
    }

    public boolean getStatMode() {
        return this.isStatMode;
    }

    public String getStatInfo() {
        String string = "";
        long l = this.refreshDelayPerSecond > 1000L ? (long)(this.refreshRate * 1000) / this.refreshDelayPerSecond : (long)this.refreshRate;
        string = string + " FPS=" + l + " [" + this.refreshDelayPerSecond + " ms/s]\n";
        string = string + " GM=" + this.graphicsMode + "\n";
        if (this.threadError != null) {
            string = string.concat(this.threadError + "\n");
        }
        return string;
    }

    public void paint(Graphics graphics) {
        if (this.displayImage != null) {
            graphics.drawImage(this.displayImage, 0, 0, this.displayScaledSizeX, this.displayScaledSizeY, 0, 0, 560, 192, this.applet);
        }
        if (this.isStatMode) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, 256, 128);
            this.drawStatInfo(graphics);
        }
        if (this.displayImagePaused != null && this.isPaused) {
            graphics.drawImage(this.displayImagePaused, 0, 0, this.displayScaledSizeX, this.displayScaledSizeY, 0, 0, 560, 192, this.applet);
        }
        if (this.isGlare && this.displayImageGlare != null) {
            graphics.drawImage(this.displayImageGlare, 0, 0, this.displayScaledSizeX, this.displayScaledSizeY, 0, 0, 560, 192, this.applet);
        }
    }

    public void run() {
        try {
            while (!this.isPaused) {
                long l = System.currentTimeMillis();
                this.refreshDisplay();
                long l2 = System.currentTimeMillis() - l;
                this.refreshDelayCumulative += l2;
                ++this.refreshCycle;
                if (this.refreshCycle >= (long)this.refreshRate) {
                    this.refreshDelayPerSecond = this.refreshDelayCumulative;
                    this.refreshCycle = 0L;
                    this.refreshDelayCumulative = 0L;
                }
                if (l2 >= this.refreshInterval) continue;
                Thread.sleep(this.refreshInterval - l2);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void drawStatInfo(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        String string = this.apple.getStatInfo() + "\n" + this.getStatInfo();
        String[] stringArray = string.split("\n");
        int n = 16;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            graphics.drawString(string2, 0, n);
            n += 16;
        }
    }

    private void refreshDisplay() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.isPrecalcRequested) {
            this.isPrecalcRequested = false;
            this.precalcDisplay();
            this.graphicsMode = -1;
        }
        if (this.graphicsMode != this.apple.graphicsMode) {
            this.graphicsMode = this.apple.graphicsMode;
            bl = true;
            bl3 = true;
        }
        if (this.charMapFlashCycle <= 0L) {
            this.charMapFlashCycle = this.refreshRate / 4 - 1;
            this.isCharMapFlash = !this.isCharMapFlash;
            bl = true;
        } else {
            --this.charMapFlashCycle;
        }
        boolean bl5 = (this.graphicsMode & 3) != 0;
        boolean bl6 = (this.graphicsMode & 9) == 0;
        boolean bl7 = (this.graphicsMode & 9) == 8;
        boolean bl8 = (this.graphicsMode & 3) == 2;
        boolean bl9 = (this.graphicsMode & 0x14) == 4;
        boolean bl10 = (this.graphicsMode & 0x40) != 0;
        boolean bl11 = (this.graphicsMode & 0x20) == 32;
        boolean bl12 = (this.graphicsMode & 0xA0) == 160;
        int n2 = bl9 ? 2048 : 1024;
        int n3 = n = bl9 ? 16384 : 8192;
        if (bl) {
            if (bl10) {
                this.setCharMap(2);
            } else if (this.isCharMapFlash) {
                this.setCharMap(1);
            } else {
                this.setCharMap(0);
            }
            bl2 = true;
            this.isRefreshRequested = true;
        }
        if (bl2) {
            if (bl5 || bl6) {
                this.setTextBufferDirty(n2);
            }
            if (bl3 && bl7) {
                this.setHiresBufferDirty(n);
            }
            bl4 = true;
        } else {
            if ((bl5 || bl6) && this.isTextBufferDirty(n2)) {
                bl4 = true;
            }
            if (bl7 && this.isHiresBufferDirty(n)) {
                bl4 = true;
            }
        }
        if (bl4) {
            if (bl5) {
                if (bl11) {
                    this.renderDoubleText(n2, bl8);
                } else {
                    this.renderText(n2, bl8);
                }
            }
            if (bl7) {
                if (bl12) {
                    this.renderDoubleHires(n, bl8);
                } else {
                    this.renderHires(n, bl8);
                }
            } else if (bl6) {
                if (bl12) {
                    this.renderDoubleLores(n2, bl8);
                } else {
                    this.renderLores(n2, bl8);
                }
            }
            this.isRefreshRequested = true;
        }
        if (this.isRefreshRequested) {
            this.isRefreshRequested = false;
            this.applet.repaint();
        }
    }

    private void setTextBufferDirty(int n) {
        int n2 = n >> 7;
        int n3 = n2 + 8;
        for (int i = n2; i < n3; ++i) {
            this.graphicsDirty[i] = true;
            this.apple.graphicsDirty[i] = false;
        }
    }

    private void setHiresBufferDirty(int n) {
        int n2 = n >> 7;
        int n3 = n2 + 8;
        for (int i = n2; i < n3; ++i) {
            this.graphicsDirty[i] = true;
            this.apple.graphicsDirty[i + 0] = false;
            this.apple.graphicsDirty[i + 8] = false;
            this.apple.graphicsDirty[i + 16] = false;
            this.apple.graphicsDirty[i + 24] = false;
            this.apple.graphicsDirty[i + 32] = false;
            this.apple.graphicsDirty[i + 40] = false;
            this.apple.graphicsDirty[i + 48] = false;
            this.apple.graphicsDirty[i + 56] = false;
        }
    }

    private boolean isTextBufferDirty(int n) {
        boolean bl = false;
        int n2 = n >> 7;
        int n3 = n2 + 8;
        for (int i = n2; i < n3; ++i) {
            this.graphicsDirty[i] = this.apple.graphicsDirty[i];
            this.apple.graphicsDirty[i] = false;
            if (!this.graphicsDirty[i]) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isHiresBufferDirty(int n) {
        boolean bl = false;
        int n2 = n >> 7;
        int n3 = n2 + 8;
        for (int i = n2; i < n3; ++i) {
            this.graphicsDirty[i] = this.apple.graphicsDirty[i + 0] || this.apple.graphicsDirty[i + 8] || this.apple.graphicsDirty[i + 16] || this.apple.graphicsDirty[i + 24] || this.apple.graphicsDirty[i + 32] || this.apple.graphicsDirty[i + 40] || this.apple.graphicsDirty[i + 48] || this.apple.graphicsDirty[i + 56];
            this.apple.graphicsDirty[i + 0] = false;
            this.apple.graphicsDirty[i + 8] = false;
            this.apple.graphicsDirty[i + 16] = false;
            this.apple.graphicsDirty[i + 24] = false;
            this.apple.graphicsDirty[i + 32] = false;
            this.apple.graphicsDirty[i + 40] = false;
            this.apple.graphicsDirty[i + 48] = false;
            this.apple.graphicsDirty[i + 56] = false;
            if (!this.graphicsDirty[i]) continue;
            bl = true;
        }
        return bl;
    }

    private void precalcDisplay() {
        this.displayScaledSizeX = (int)(560.0f * this.displayScale / 2.0f);
        this.displayScaledSizeY = (int)(192.0f * this.displayScale);
        this.setDisplayPalette();
        this.loadCharSet();
        this.precalcHiresLookup();
    }

    private void loadCharSet() {
        int n = 0;
        try {
            BufferedImage bufferedImage = ImageIO.read(this.getClass().getResourceAsStream("/Resources/Character Set.png"));
            bufferedImage.getRGB(0, 0, 1024, 8, this.charSet, 0, 2048);
        }
        catch (IOException iOException) {
            this.threadError = iOException.toString();
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 1024; ++j) {
                this.charSet[n + 1024 + j] = this.charSet[n + j] ^ 0xFFFFFF;
            }
            n += 2048;
        }
        n = 0;
        while (n < 16384) {
            int n2 = n++;
            this.charSet[n2] = this.charSet[n2] & (this.displayPalette[15] | 0xFF000000);
        }
    }

    private void precalcCharMaps() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.charMaps[i][j] = this.charMapLookup[i][j >> 5] + (j & 0x1F);
            }
        }
    }

    private void setCharMap(int n) {
        this.charMap = this.charMaps[n];
    }

    private void setDisplayPalette() {
        this.displayPalette = this.colorMode == 1 ? displayPaletteColor : displayPaletteGreen;
        this.doubleHiresPalette = this.colorMode == 1 ? doubleHiresPaletteColor : displayPaletteGreen;
    }

    private void precalcHiresEvenEddToWord() {
        for (int i = 0; i < 512; ++i) {
            this.hiresEvenOddToWord[i] = (i & 1) << 0 | (i & 1) << 1 | (i & 2) << 1 | (i & 2) << 2 | (i & 4) << 2 | (i & 4) << 3 | (i & 8) << 3 | (i & 8) << 4 | (i & 0x10) << 4 | (i & 0x10) << 5 | (i & 0x20) << 5 | (i & 0x20) << 6 | (i & 0x40) << 6 | (i & 0x40) << 7;
            if ((i & 0x80) == 0) continue;
            int n = i;
            this.hiresEvenOddToWord[n] = this.hiresEvenOddToWord[n] << 1;
            int n2 = i;
            this.hiresEvenOddToWord[n2] = this.hiresEvenOddToWord[n2] | (i & 0x100) >> 8;
        }
    }

    private void precalcHiresLookup() {
        if (this.colorMode == 1) {
            for (int i = 0; i < 256; ++i) {
                this.hiresLookup[i] = hiresLookupColor[i << 6 & 0xFF | i >> 2];
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                this.hiresLookup[i] = ((i & 4) != 0 ? 15 : 0) | ((i & 8) != 0 ? 240 : 0) | ((i & 0x10) != 0 ? 3840 : 0) | ((i & 0x20) != 0 ? 61440 : 0);
            }
        }
    }

    private final void renderTextScanLine(int n, int n2) {
        int n3 = this.charSet[n2];
        this.displayImageBuffer[n + 1] = n3;
        this.displayImageBuffer[n + 0] = n3;
        int n4 = this.charSet[n2 + 1];
        this.displayImageBuffer[n + 3] = n4;
        this.displayImageBuffer[n + 2] = n4;
        int n5 = this.charSet[n2 + 2];
        this.displayImageBuffer[n + 5] = n5;
        this.displayImageBuffer[n + 4] = n5;
        int n6 = this.charSet[n2 + 3];
        this.displayImageBuffer[n + 7] = n6;
        this.displayImageBuffer[n + 6] = n6;
        int n7 = this.charSet[n2 + 4];
        this.displayImageBuffer[n + 9] = n7;
        this.displayImageBuffer[n + 8] = n7;
        int n8 = this.charSet[n2 + 5];
        this.displayImageBuffer[n + 11] = n8;
        this.displayImageBuffer[n + 10] = n8;
        int n9 = this.charSet[n2 + 6];
        this.displayImageBuffer[n + 13] = n9;
        this.displayImageBuffer[n + 12] = n9;
    }

    private final void renderTextCharacter(int n, int n2) {
        this.renderTextScanLine(n, n2);
        this.renderTextScanLine(n += 560, n2 += 2048);
        this.renderTextScanLine(n += 560, n2 += 2048);
        this.renderTextScanLine(n += 560, n2 += 2048);
        this.renderTextScanLine(n += 560, n2 += 2048);
        this.renderTextScanLine(n += 560, n2 += 2048);
        this.renderTextScanLine(n += 560, n2 += 2048);
        this.renderTextScanLine(n += 560, n2 += 2048);
    }

    private void renderText(int n, boolean bl) {
        int n2 = bl ? 20 : 0;
        int n3 = n2 * 8 * 560;
        for (int i = n2; i < 24; ++i) {
            int n4 = n + textLineAddress[i];
            if (this.graphicsDirty[n4 >> 7]) {
                int n5 = n4 + 40;
                for (int j = n4; j < n5; ++j) {
                    this.renderTextCharacter(n3, this.charMap[this.apple.mem[j] & 0xFF] << 3);
                    n3 += 14;
                }
                n3 += 3920;
                continue;
            }
            n3 += 4480;
        }
    }

    private final void renderDoubleTextScanLine(int n, int n2) {
        this.displayImageBuffer[n + 0] = this.charSet[n2];
        this.displayImageBuffer[n + 1] = this.charSet[n2 + 1];
        this.displayImageBuffer[n + 2] = this.charSet[n2 + 2];
        this.displayImageBuffer[n + 3] = this.charSet[n2 + 3];
        this.displayImageBuffer[n + 4] = this.charSet[n2 + 4];
        this.displayImageBuffer[n + 5] = this.charSet[n2 + 5];
        this.displayImageBuffer[n + 6] = this.charSet[n2 + 6];
    }

    private final void renderDoubleTextCharacter(int n, int n2) {
        this.renderDoubleTextScanLine(n, n2);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
        this.renderDoubleTextScanLine(n += 560, n2 += 2048);
    }

    private void renderDoubleText(int n, boolean bl) {
        int n2 = bl ? 20 : 0;
        int n3 = n2 * 8 * 560;
        for (int i = n2; i < 24; ++i) {
            int n4 = n + textLineAddress[i];
            if (this.graphicsDirty[n4 >> 7]) {
                int n5 = n4 + 40;
                for (int j = n4; j < n5; ++j) {
                    this.renderDoubleTextCharacter(n3, this.charMap[this.apple.mem[j + 65536] & 0xFF] << 3);
                    this.renderDoubleTextCharacter(n3 += 7, this.charMap[this.apple.mem[j + 0] & 0xFF] << 3);
                    n3 += 7;
                }
                n3 += 3920;
                continue;
            }
            n3 += 4480;
        }
    }

    private final void renderLoresScanLine(int n, int n2) {
        this.displayImageBuffer[n + 0] = n2;
        this.displayImageBuffer[n + 1] = n2;
        this.displayImageBuffer[n + 2] = n2;
        this.displayImageBuffer[n + 3] = n2;
        this.displayImageBuffer[n + 4] = n2;
        this.displayImageBuffer[n + 5] = n2;
        this.displayImageBuffer[n + 6] = n2;
    }

    private final void renderLoresBlock(int n, int n2, int n3) {
        this.renderLoresScanLine(n, n2);
        this.renderLoresScanLine(n += 560, n2);
        this.renderLoresScanLine(n += 560, n2);
        this.renderLoresScanLine(n += 560, n2);
        this.renderLoresScanLine(n += 560, n3);
        this.renderLoresScanLine(n += 560, n3);
        this.renderLoresScanLine(n += 560, n3);
        this.renderLoresScanLine(n += 560, n3);
    }

    private void renderLores(int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + textLineAddress[i];
            if (this.graphicsDirty[n4 >> 7]) {
                int n5 = n4 + 40;
                for (int j = n4; j < n5; ++j) {
                    this.renderLoresBlock(n3, this.displayPalette[this.apple.mem[j] & 0xF], this.displayPalette[(this.apple.mem[j] & 0xF0) >> 4]);
                    this.renderLoresBlock(n3 += 7, this.displayPalette[this.apple.mem[j] & 0xF], this.displayPalette[(this.apple.mem[j] & 0xF0) >> 4]);
                    n3 += 7;
                }
                n3 += 3920;
                continue;
            }
            n3 += 4480;
        }
    }

    private void renderDoubleLores(int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + textLineAddress[i];
            if (this.graphicsDirty[n4 >> 7]) {
                int n5 = n4 + 40;
                for (int j = n4; j < n5; ++j) {
                    this.renderLoresBlock(n3, this.displayPalette[this.apple.mem[j + 65536] & 0xF], this.displayPalette[(this.apple.mem[j + 65536] & 0xF0) >> 4]);
                    this.renderLoresBlock(n3 += 7, this.displayPalette[this.apple.mem[j] & 0xF], this.displayPalette[(this.apple.mem[j] & 0xF0) >> 4]);
                    n3 += 7;
                }
                n3 += 3920;
                continue;
            }
            n3 += 4480;
        }
    }

    private final void renderHiresWord(int n, int n2) {
        this.displayImageBuffer[n + 0] = this.displayPalette[n2 >> 0 & 0xF];
        this.displayImageBuffer[n + 1] = this.displayPalette[n2 >> 4 & 0xF];
        this.displayImageBuffer[n + 2] = this.displayPalette[n2 >> 8 & 0xF];
        this.displayImageBuffer[n + 3] = this.displayPalette[n2 >> 12 & 0xF];
    }

    private final void renderHiresScanLine(int n, int n2) {
        this.renderHiresWord(n + 0, this.hiresLookup[n2 >> 0 & 0xFF]);
        this.renderHiresWord(n + 4, this.hiresLookup[n2 >> 4 & 0xFF]);
        this.renderHiresWord(n + 8, this.hiresLookup[n2 >> 8 & 0xFF]);
        this.renderHiresWord(n + 12, this.hiresLookup[n2 >> 12 & 0xFF]);
        this.renderHiresWord(n + 16, this.hiresLookup[n2 >> 16 & 0xFF]);
        this.renderHiresWord(n + 20, this.hiresLookup[n2 >> 20 & 0xFF]);
        this.renderHiresWord(n + 24, this.hiresLookup[n2 >> 24 & 0xFF]);
    }

    private final void renderHiresBlock(int n) {
        this.renderHiresScanLine(n, this.hiresWord[0]);
        this.renderHiresScanLine(n += 560, this.hiresWord[1]);
        this.renderHiresScanLine(n += 560, this.hiresWord[2]);
        this.renderHiresScanLine(n += 560, this.hiresWord[3]);
        this.renderHiresScanLine(n += 560, this.hiresWord[4]);
        this.renderHiresScanLine(n += 560, this.hiresWord[5]);
        this.renderHiresScanLine(n += 560, this.hiresWord[6]);
        this.renderHiresScanLine(n += 560, this.hiresWord[7]);
    }

    private final void resetHiresWords() {
        this.hiresWord[0] = 0;
        this.hiresWord[1] = 0;
        this.hiresWord[2] = 0;
        this.hiresWord[3] = 0;
        this.hiresWord[4] = 0;
        this.hiresWord[5] = 0;
        this.hiresWord[6] = 0;
        this.hiresWord[7] = 0;
    }

    private final void bufferHiresWords() {
        this.hiresWord[0] = this.hiresWordNext[0];
        this.hiresWord[1] = this.hiresWordNext[1];
        this.hiresWord[2] = this.hiresWordNext[2];
        this.hiresWord[3] = this.hiresWordNext[3];
        this.hiresWord[4] = this.hiresWordNext[4];
        this.hiresWord[5] = this.hiresWordNext[5];
        this.hiresWord[6] = this.hiresWordNext[6];
        this.hiresWord[7] = this.hiresWordNext[7];
    }

    private final void calcNextHiresWord(int n, int n2, int n3) {
        this.hiresWordNext[n] = this.hiresWord[n] >> 28;
        int n4 = n;
        this.hiresWordNext[n4] = this.hiresWordNext[n4] | this.hiresEvenOddToWord[n2 & 0xFF | (this.hiresWordNext[n] & 2) << 7] << 2;
        int n5 = n;
        this.hiresWordNext[n5] = this.hiresWordNext[n5] | this.hiresEvenOddToWord[n3 & 0xFF | (this.hiresWordNext[n] & 0x8000) >> 7] << 16;
        int n6 = n;
        this.hiresWord[n6] = this.hiresWord[n6] | this.hiresWordNext[n] << 28;
    }

    private final void calcNextHiresWords(int n) {
        this.calcNextHiresWord(0, this.apple.mem[n + 0], this.apple.mem[n + 1]);
        this.calcNextHiresWord(1, this.apple.mem[n + 1024], this.apple.mem[n + 1025]);
        this.calcNextHiresWord(2, this.apple.mem[n + 2048], this.apple.mem[n + 2049]);
        this.calcNextHiresWord(3, this.apple.mem[n + 3072], this.apple.mem[n + 3073]);
        this.calcNextHiresWord(4, this.apple.mem[n + 4096], this.apple.mem[n + 4097]);
        this.calcNextHiresWord(5, this.apple.mem[n + 5120], this.apple.mem[n + 5121]);
        this.calcNextHiresWord(6, this.apple.mem[n + 6144], this.apple.mem[n + 6145]);
        this.calcNextHiresWord(7, this.apple.mem[n + 7168], this.apple.mem[n + 7169]);
    }

    private void renderHires(int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + textLineAddress[i];
            if (this.graphicsDirty[n4 >> 7]) {
                int n5 = n4 + 40;
                this.resetHiresWords();
                this.calcNextHiresWords(n4);
                for (int j = n4 + 2; j < n5; j += 2) {
                    this.bufferHiresWords();
                    this.calcNextHiresWords(j);
                    this.renderHiresBlock(n3);
                    n3 += 28;
                }
                this.bufferHiresWords();
                this.renderHiresBlock(n3);
                n3 += 28;
                n3 += 3920;
                continue;
            }
            n3 += 4480;
        }
    }

    private final void renderDoubleHiresWord(int n, int n2) {
        this.displayImageBuffer[n + 0] = this.doubleHiresPalette[n2 >> 0 & 0xF];
        this.displayImageBuffer[n + 1] = this.doubleHiresPalette[n2 >> 4 & 0xF];
        this.displayImageBuffer[n + 2] = this.doubleHiresPalette[n2 >> 8 & 0xF];
        this.displayImageBuffer[n + 3] = this.doubleHiresPalette[n2 >> 12 & 0xF];
    }

    private final void renderDoubleHiresScanLine(int n, int n2) {
        this.renderDoubleHiresWord(n + 0, this.hiresLookup[n2 >> 0 & 0xFF]);
        this.renderDoubleHiresWord(n + 4, this.hiresLookup[n2 >> 4 & 0xFF]);
        this.renderDoubleHiresWord(n + 8, this.hiresLookup[n2 >> 8 & 0xFF]);
        this.renderDoubleHiresWord(n + 12, this.hiresLookup[n2 >> 12 & 0xFF]);
        this.renderDoubleHiresWord(n + 16, this.hiresLookup[n2 >> 16 & 0xFF]);
        this.renderDoubleHiresWord(n + 20, this.hiresLookup[n2 >> 20 & 0xFF]);
        this.renderDoubleHiresWord(n + 24, this.hiresLookup[n2 >> 24 & 0xFF]);
    }

    private final void renderDoubleHiresBlock(int n) {
        this.renderDoubleHiresScanLine(n, this.hiresWord[0]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[1]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[2]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[3]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[4]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[5]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[6]);
        this.renderDoubleHiresScanLine(n += 560, this.hiresWord[7]);
    }

    private final void calcNextDoubleHiresWord(int n, int n2, int n3, int n4, int n5) {
        this.hiresWordNext[n] = (n2 & 0x7F) << 2 | (n3 & 0x7F) << 9 | (n4 & 0x7F) << 16 | (n5 & 0x7F) << 23 | this.hiresWord[n] >> 28;
        int n6 = n;
        this.hiresWord[n6] = this.hiresWord[n6] | this.hiresWordNext[n] << 28;
    }

    private final void calcNextDoubleHiresWords(int n) {
        this.calcNextDoubleHiresWord(0, this.apple.mem[n + 65536], this.apple.mem[n + 0], this.apple.mem[n + 65537], this.apple.mem[n + 1]);
        this.calcNextDoubleHiresWord(1, this.apple.mem[n + 66560], this.apple.mem[n + 1024], this.apple.mem[n + 66561], this.apple.mem[n + 1025]);
        this.calcNextDoubleHiresWord(2, this.apple.mem[n + 67584], this.apple.mem[n + 2048], this.apple.mem[n + 67585], this.apple.mem[n + 2049]);
        this.calcNextDoubleHiresWord(3, this.apple.mem[n + 68608], this.apple.mem[n + 3072], this.apple.mem[n + 68609], this.apple.mem[n + 3073]);
        this.calcNextDoubleHiresWord(4, this.apple.mem[n + 69632], this.apple.mem[n + 4096], this.apple.mem[n + 69633], this.apple.mem[n + 4097]);
        this.calcNextDoubleHiresWord(5, this.apple.mem[n + 70656], this.apple.mem[n + 5120], this.apple.mem[n + 70657], this.apple.mem[n + 5121]);
        this.calcNextDoubleHiresWord(6, this.apple.mem[n + 71680], this.apple.mem[n + 6144], this.apple.mem[n + 71681], this.apple.mem[n + 6145]);
        this.calcNextDoubleHiresWord(7, this.apple.mem[n + 72704], this.apple.mem[n + 7168], this.apple.mem[n + 72705], this.apple.mem[n + 7169]);
    }

    private void renderDoubleHires(int n, boolean bl) {
        int n2 = bl ? 20 : 24;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + textLineAddress[i];
            if (this.graphicsDirty[n4 >> 7]) {
                int n5 = n4 + 40;
                this.resetHiresWords();
                this.calcNextDoubleHiresWords(n4);
                for (int j = n4 + 2; j < n5; j += 2) {
                    this.bufferHiresWords();
                    this.calcNextDoubleHiresWords(j);
                    this.renderDoubleHiresBlock(n3);
                    n3 += 28;
                }
                this.bufferHiresWords();
                this.renderDoubleHiresBlock(n3);
                n3 += 28;
                n3 += 3920;
                continue;
            }
            n3 += 4480;
        }
    }
}

