/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AppleIIGo
extends Applet
implements KeyListener,
ComponentListener,
MouseListener,
MouseMotionListener {
    final String version = "1.0.6";
    final String versionString = "AppleIIGo Version 1.0.6";
    private EmAppleII apple;
    private AppleDisplay display;
    private DiskII disk;
    private boolean isCpuPaused;
    private boolean isCpuDebugEnabled;
    private boolean keyboardUppercaseOnly;
    private boolean isPaddleInverted;
    private String[] diskDriveResource = new String[2];
    private boolean diskWritable;
    private String[][] diskImageNames = new String[][]{new String[0], new String[0]};
    private int[] diskImageNumber = new int[]{0, 0};

    private void debug(String string) {
    }

    private String getAppletParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    public void init() {
        this.debug("init()");
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.getAppletParameter("displayFocusOnStart", "true").equals("true")) {
            this.addComponentListener(this);
        }
        this.apple = new EmAppleII();
        this.loadRom(this.getAppletParameter("cpuRom", ""));
        this.apple.setCpuSpeed(new Integer(this.getAppletParameter("cpuSpeed", "1000")));
        this.isCpuPaused = this.getAppletParameter("cpuPaused", "false").equals("true");
        this.isCpuDebugEnabled = this.getAppletParameter("cpuDebugEnabled", "false").equals("true");
        this.apple.setStepMode(this.getAppletParameter("cpuStepMode", "false").equals("true"));
        this.keyboardUppercaseOnly = this.getAppletParameter("keyboardUppercaseOnly", "true").equals("true");
        this.display = new AppleDisplay(this, this.apple);
        this.display.setScale(new Float(this.getAppletParameter("displayScale", "1")).floatValue());
        this.display.setRefreshRate(new Integer(this.getAppletParameter("displayRefreshRate", "10")));
        this.display.setColorMode(new Integer(this.getAppletParameter("displayColorMode", "0")));
        this.display.setStatMode(this.getAppletParameter("displayStatMode", "false").equals("true"));
        this.display.setGlare(this.getAppletParameter("displayGlare", "false").equals("true"));
        this.apple.speaker = new AppleSpeaker(this.apple);
        this.apple.speaker.setVolume(new Integer(this.getAppletParameter("speakerVolume", "6")));
        this.disk = new DiskII(this.apple);
        this.apple.setPeripheral(this.disk, 6);
        this.diskWritable = this.getAppletParameter("diskWritable", "false").equals("true");
        this.diskImageNames[0] = this.getAppletParameter("diskDrive1", "").split("[|]");
        this.diskImageNumber[0] = 0;
        this.diskImageNames[1] = this.getAppletParameter("diskDrive2", "").split("[|]");
        this.diskImageNumber[1] = 0;
        this.mountDisk(0, this.diskImageNames[0][this.diskImageNumber[0]]);
        this.mountDisk(1, this.diskImageNames[1][this.diskImageNumber[1]]);
        if (!this.isCpuPaused) {
            this.resume();
        }
    }

    public void start() {
        this.debug("AppleIIGo Version 1.0.6");
        this.debug("start()");
    }

    public void stop() {
        this.debug("stop()");
    }

    public void destroy() {
        this.debug("destroy()");
        this.unmountDisk(0);
        this.unmountDisk(1);
    }

    public void focus() {
        this.debug("focus()");
        this.requestFocus();
    }

    public void pause() {
        this.debug("pause()");
        this.isCpuPaused = true;
        this.apple.setPaused(true);
        this.display.setPaused(true);
        this.apple.speaker.setPaused(true);
    }

    public void resume() {
        this.debug("resume()");
        this.isCpuPaused = false;
        this.apple.speaker.setPaused(false);
        this.display.setPaused(false);
        this.apple.setPaused(false);
    }

    public void restart() {
        this.debug("restart()");
        this.apple.restart();
    }

    public void reset() {
        this.debug("reset()");
        this.apple.reset();
    }

    public void setSpeed(int n) {
        this.debug("setSpeed(" + n + ")");
        try {
            this.pause();
            this.wait(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.apple.setCpuSpeed(n);
        this.resume();
    }

    public void cycleDisk(int n) {
        this.debug("cycleDisk(" + n + ")");
        if (this.diskImageNames[n].length > 1) {
            int n2 = n;
            int n3 = this.diskImageNumber[n2] + 1;
            this.diskImageNumber[n2] = n3;
            this.diskImageNumber[n] = n3 % this.diskImageNames[n].length;
            this.mountDisk(n, this.diskImageNames[n][this.diskImageNumber[n]]);
        }
    }

    private DataInputStream openInputStream(String string) {
        return this.openInputStream(string, null);
    }

    private DataInputStream openInputStream(String string, StringBuffer stringBuffer) {
        InputStream inputStream = null;
        if (stringBuffer != null) {
            stringBuffer.setLength(0);
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(92);
            int n3 = Math.max(n, n2);
            stringBuffer.append(string.substring(n3 > 0 ? n3 : 0));
        }
        try {
            URL uRL = new URL(this.getCodeBase(), string);
            this.debug("resource: " + uRL.toString());
            inputStream = uRL.openStream();
            if (string.toLowerCase().endsWith(".gz")) {
                inputStream = new GZIPInputStream(inputStream);
            } else if (string.toLowerCase().endsWith(".zip")) {
                inputStream = new ZipInputStream(inputStream);
                ZipEntry zipEntry = ((ZipInputStream)inputStream).getNextEntry();
                if (stringBuffer != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append(zipEntry.getName());
                }
            }
        }
        catch (Exception exception) {
            this.debug("Exeption: " + exception.getLocalizedMessage());
        }
        if (inputStream == null) {
            this.debug("failed");
            return null;
        }
        this.debug("ok");
        return new DataInputStream(inputStream);
    }

    private OutputStream openOutputStream(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            if (!string.substring(0, 6).equals("http://")) {
                fileOutputStream = new FileOutputStream(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileOutputStream;
    }

    public boolean loadRom(String string) {
        this.debug("loadRom(resource: " + string + ")");
        boolean bl = false;
        try {
            DataInputStream dataInputStream = this.openInputStream(string);
            bl = this.apple.loadRom(dataInputStream);
            dataInputStream.close();
        }
        catch (Exception exception) {
            this.debug("Exeption: " + exception.getLocalizedMessage());
        }
        return bl;
    }

    public boolean mountDisk(int n, String string) {
        this.debug("mountDisk(drive: " + n + ", resource: " + string + ")");
        boolean bl = false;
        if (n < 0 || n > 1) {
            return bl;
        }
        try {
            this.unmountDisk(n);
            this.diskDriveResource[n] = string;
            StringBuffer stringBuffer = new StringBuffer();
            DataInputStream dataInputStream = this.openInputStream(string, stringBuffer);
            bl = this.disk.readDisk(n, dataInputStream, stringBuffer.toString(), false);
            dataInputStream.close();
            this.showStatus("Drive " + (n + 1) + ": " + string);
        }
        catch (Exception exception) {
            this.debug("Exeption: " + exception.getLocalizedMessage());
        }
        return bl;
    }

    public void unmountDisk(int n) {
        this.debug("unmountDisk(drive: " + n + ")");
        if (n < 0 || n > 2) {
            return;
        }
        if (!this.diskWritable) {
            return;
        }
        try {
            OutputStream outputStream = this.openOutputStream(this.diskDriveResource[n]);
            this.disk.writeDisk(n, outputStream);
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColorMode(int n) {
        this.debug("setColorMode(value: " + n + ")");
        this.display.setColorMode(n);
    }

    public boolean getDiskActivity() {
        return !this.isCpuPaused && this.disk.isMotorOn();
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyChar();
        if (n == 10) {
            this.apple.setKeyLatch(13);
        } else if (n < 128) {
            if (this.keyboardUppercaseOnly && n >= 97 && n <= 122) {
                n -= 32;
            }
            this.apple.setKeyLatch(n);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 157: {
                this.apple.paddle.setButton(1, true);
                break;
            }
            case 18: {
                if (keyEvent.getKeyLocation() == 2) {
                    this.apple.paddle.setButton(0, true);
                    break;
                }
                if (keyEvent.getKeyLocation() != 3) break;
                this.apple.paddle.setButton(1, true);
                break;
            }
            case 8: 
            case 37: {
                if (keyEvent.getKeyLocation() == 4) {
                    this.handleKeypadLeft();
                    break;
                }
                this.apple.setKeyLatch(8);
                break;
            }
            case 39: {
                if (keyEvent.getKeyLocation() == 4) {
                    this.handleKeypadRight();
                    break;
                }
                this.apple.setKeyLatch(21);
                break;
            }
            case 38: {
                if (keyEvent.isControlDown()) {
                    this.apple.speaker.setVolume(this.apple.speaker.getVolume() + 1);
                    break;
                }
                if (keyEvent.getKeyLocation() == 4) {
                    this.handleKeypadUp();
                    break;
                }
                this.apple.setKeyLatch(11);
                break;
            }
            case 40: {
                if (keyEvent.isControlDown()) {
                    this.apple.speaker.setVolume(this.apple.speaker.getVolume() - 1);
                    break;
                }
                if (keyEvent.getKeyLocation() == 4) {
                    this.handleKeypadDown();
                    break;
                }
                this.apple.setKeyLatch(10);
                break;
            }
            case 27: {
                this.apple.setKeyLatch(27);
                break;
            }
            case 127: {
                this.apple.setKeyLatch(127);
                break;
            }
            case 36: {
                if (keyEvent.isControlDown()) {
                    this.restart();
                    break;
                }
                this.apple.paddle.setButton(0, true);
                break;
            }
            case 35: {
                this.apple.paddle.setButton(1, true);
                break;
            }
            case 112: {
                this.showStatus("AppleIIGo Version 1.0.6");
                break;
            }
            case 114: {
                this.cycleDisk(0);
                break;
            }
            case 115: {
                this.cycleDisk(1);
                break;
            }
            case 116: {
                if (!this.isCpuDebugEnabled) break;
                this.display.setStatMode(!this.display.getStatMode());
                break;
            }
            case 117: {
                if (!this.isCpuDebugEnabled) break;
                this.apple.setStepMode(!this.apple.getStepMode());
                break;
            }
            case 118: {
                if (!this.isCpuDebugEnabled) break;
                this.apple.setStepMode(this.apple.getStepMode());
                this.apple.stepInstructions(1);
                break;
            }
            case 119: {
                if (!this.isCpuDebugEnabled) break;
                this.apple.setStepMode(this.apple.getStepMode());
                this.apple.stepInstructions(128);
                break;
            }
            case 3: 
            case 123: {
                if (!keyEvent.isControlDown()) break;
                this.reset();
                break;
            }
            case 226: {
                this.handleKeypadLeft();
                break;
            }
            case 227: {
                this.handleKeypadRight();
                break;
            }
            case 224: {
                this.handleKeypadUp();
                break;
            }
            case 225: {
                this.handleKeypadDown();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 157: {
                this.apple.paddle.setButton(1, false);
                break;
            }
            case 18: {
                if (keyEvent.getKeyLocation() == 2) {
                    this.apple.paddle.setButton(0, false);
                    break;
                }
                if (keyEvent.getKeyLocation() != 3) break;
                this.apple.paddle.setButton(1, false);
                break;
            }
            case 37: 
            case 39: {
                if (keyEvent.getKeyLocation() != 4) break;
            }
            case 226: 
            case 227: {
                if (this.isPaddleInverted) {
                    this.apple.paddle.setPaddlePos(1, 127);
                    break;
                }
                this.apple.paddle.setPaddlePos(0, 127);
                break;
            }
            case 38: 
            case 40: {
                if (keyEvent.getKeyLocation() != 4) break;
            }
            case 224: 
            case 225: {
                if (this.isPaddleInverted) {
                    this.apple.paddle.setPaddlePos(0, 127);
                    break;
                }
                this.apple.paddle.setPaddlePos(1, 127);
                break;
            }
            case 36: {
                if (!keyEvent.isControlDown()) {
                    this.apple.paddle.setButton(0, false);
                }
            }
            case 35: {
                this.apple.paddle.setButton(1, false);
            }
        }
    }

    private void handleKeypadLeft() {
        if (this.isPaddleInverted) {
            this.apple.paddle.setPaddlePos(1, 255);
        } else {
            this.apple.paddle.setPaddlePos(0, 0);
        }
    }

    private void handleKeypadRight() {
        if (this.isPaddleInverted) {
            this.apple.paddle.setPaddlePos(1, 0);
        } else {
            this.apple.paddle.setPaddlePos(0, 255);
        }
    }

    private void handleKeypadUp() {
        if (this.isPaddleInverted) {
            this.apple.paddle.setPaddlePos(0, 255);
        } else {
            this.apple.paddle.setPaddlePos(1, 0);
        }
    }

    private void handleKeypadDown() {
        if (this.isPaddleInverted) {
            this.apple.paddle.setPaddlePos(0, 0);
        } else {
            this.apple.paddle.setPaddlePos(1, 255);
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.debug("componentShown()");
        this.removeComponentListener(this);
        this.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.getAppletContext().showDocument(new URL("javascript:flipMouseOver();"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        try {
            this.getAppletContext().showDocument(new URL("javascript:flipMouseOut();"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            this.apple.paddle.setButton(0, true);
        }
        if ((n & 4) != 0) {
            this.apple.paddle.setButton(1, true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            this.apple.paddle.setButton(0, false);
        }
        if ((n & 4) != 0) {
            this.apple.paddle.setButton(1, false);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        float f = this.display.getScale();
        if (this.isPaddleInverted) {
            this.apple.paddle.setPaddlePos(0, (int)(255.0f - (float)(mouseEvent.getY() * 256) / (192.0f * f)));
            this.apple.paddle.setPaddlePos(1, (int)(255.0f - (float)(mouseEvent.getX() * 256) / (280.0f * f)));
        } else {
            this.apple.paddle.setPaddlePos(0, (int)((float)(mouseEvent.getX() * 256) / (280.0f * f)));
            this.apple.paddle.setPaddlePos(1, (int)((float)(mouseEvent.getY() * 256) / (192.0f * f)));
        }
    }

    public void paint(Graphics graphics) {
        this.display.paint(graphics);
    }

    public void update(Graphics graphics) {
        this.display.paint(graphics);
    }
}

