/*
 *  Apple II emulator 6502 & undocumented instructions table
 *
 *  The routines in this file were moved from the apple2.S file,
 *  originally by Alexander Jean-Claude Bottema.
 *
 *  $Id: undocumented.h,v 1.3 1998/08/23 17:12:55 chernabog Exp $
 *
 *  MODIFICATION HISTORY
 *   v0.5 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Feb 1998.
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *     This code has nothing to do with my employer, GTE Internetworking,
 *     BBN Technologies.  It was written completely on my own time and on
 *     my own machine.
 *
 */

#ifndef __ASSEMBLY__
#define table_undoc(nme,fmt,ins,val,args) \
	{ nme, fmt, val, args },
#else
#define table_undoc(nme,fmt,ins,val,args) \
	.long		ins

	.align 4
table_6502_undoc_opcodes:
#endif
table_undoc("BRK", "BRK",		op_BRK,			0x00, 0)
table_undoc("ORA", "ORA ($%02X,X)",	op_ORA_ind_x,		0x01, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x02, 0)
table_undoc("LORX", "LORX $%02X",	op_LOR_ind_x,		0x03, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x04, 0)
table_undoc("ORA", "ORA $%02X",		op_ORA_zpage,		0x05, 1)
table_undoc("ASL", "ASL $%02X",		op_ASL_zpage,		0x06, 1)
table_undoc("LORZ", "LORZ $%02X",	op_LOR_zpage,		0x07, 1)
table_undoc("PHP", "PHP",		op_PHP,			0x08, 0)
table_undoc("ORA", "ORA #$%02X",	op_ORA_imm,		0x09, 1)
table_undoc("ASL", "ASL",		op_ASL_acc,		0x0A, 0)
table_undoc("ANA_", "ANA_ #$%02X",	op_ANA_imm,		0x0B, 1)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0x0C, 0)
table_undoc("ORA", "ORA $%02X%02X",	op_ORA_abs,		0x0D, 2)
table_undoc("ASL", "ASL $%02X%02X",	op_ASL_abs,		0x0E, 2)
table_undoc("LORa", "LORa $%02X%02X",	op_LOR_abs,		0x0F, 2)
table_undoc("BPL", "BPL $%04X (_$%02X)",op_BPL,			0x10, 3)
table_undoc("ORA", "ORA ($%02X),Y",	op_ORA_ind_y,		0x11, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x12, 0)
table_undoc("LORY", "LORY $%02X",	op_LOR_ind_y,		0x13, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x14, 0)
table_undoc("ORA", "ORA $%02X,X",	op_ORA_zpage_x,		0x15, 1)
table_undoc("ASL", "ASL $%02X,X",	op_ASL_zpage_x,		0x16, 1)
table_undoc("LORZX", "LORZX $%02X",	op_LOR_zpage_x,		0x17, 1)
table_undoc("CLC", "CLC",		op_CLC,			0x18, 0)
table_undoc("ORA", "ORA $%02X%02X,Y",	op_ORA_abs_y,		0x19, 2)
table_undoc("NOP_", "NOP_",		op_NOP,			0x1A, 0)
table_undoc("LORy", "LORy $%02X%02X",	op_LOR_abs_y,		0x1B, 2)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0x1C, 0)
table_undoc("ORA", "ORA $%02X%02X,X",	op_ORA_abs_x,		0x1D, 2)
table_undoc("ASL", "ASL $%02X%02X,X",	op_ASL_abs_x,		0x1E, 2)
table_undoc("LORx", "LORx $%02X%02X",	op_LOR_abs_x,		0x1F, 2)
table_undoc("JSR", "JSR %02X%02X",	op_JSR,			0x20, 2)
table_undoc("AND", "AND ($%02X,X)",	op_AND_ind_x,		0x21, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x22, 0)
table_undoc("LANX", "LANX $%02X",	op_LAN_ind_x,		0x23, 1)
table_undoc("BIT", "BIT $%02X",		op_BIT_zpage,		0x24, 1)
table_undoc("AND", "AND $%02X",		op_AND_zpage,		0x25, 1)
table_undoc("ROL", "ROL $%02X",		op_ROL_zpage,		0x26, 1)
table_undoc("LANZ", "LANZ $%02X",	op_LAN_zpage,		0x27, 1)
table_undoc("PLP", "PLP",		op_PLP,			0x28, 0)
table_undoc("AND", "AND #$%02X",	op_AND_imm,		0x29, 1)
table_undoc("ROL", "ROL",		op_ROL_acc,		0x2A, 0)
table_undoc("ANB_", "ANB_ #$%02X",	op_ANB_imm,		0x2B, 1)
table_undoc("BIT", "BIT $%02X%02X",	op_BIT_abs,		0x2C, 2)
table_undoc("AND", "AND $%02X%02X",	op_AND_abs,		0x2D, 2)
table_undoc("ROL", "ROL $%02X%02X",	op_ROL_abs,		0x2E, 2)
table_undoc("LANa", "LANa $%02X%02X",	op_LAN_abs,		0x2F, 2)
table_undoc("BMI", "BMI $%04X (_$%02X)",op_BMI,			0x30, 3)
table_undoc("AND", "AND ($%02X),Y",	op_AND_ind_y,		0x31, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x32, 0)
table_undoc("LANY", "LANY $%02X",	op_LAN_ind_y,		0x33, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x34, 0)
table_undoc("AND", "AND $%02X,X",	op_AND_zpage_x,		0x35, 1)
table_undoc("ROL", "ROL $%02X,X",	op_ROL_zpage_x,		0x36, 1)
table_undoc("LANZX", "LANZX $%02X",	op_LAN_zpage_x,		0x37, 1)
table_undoc("SEC", "SEC",		op_SEC,			0x38, 0)
table_undoc("AND", "AND $%02X%02X,Y",	op_AND_abs_y,		0x39, 2)
table_undoc("NOP_", "NOP_",		op_NOP,			0x3A, 0)
table_undoc("LANy", "LANy $%02X%02X",	op_LAN_abs_y,		0x3B, 2)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0x3C, 0)
table_undoc("AND", "AND $%02X%02X,X",	op_AND_abs_x,		0x3D, 2)
table_undoc("ROL", "ROL $%02X%02X,X",	op_ROL_abs_x,		0x3E, 2)
table_undoc("LANx", "LANx $%02X%02X",	op_LAN_abs_x,		0x3F, 2)
table_undoc("RTI", "RTI",		op_RTI,			0x40, 0)
table_undoc("EOR", "EOR ($%02X,X)",	op_EOR_ind_x,		0x41, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x42, 0)
table_undoc("REOX", "REOX $%02X",	op_REO_ind_x,		0x43, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x44, 0)
table_undoc("EOR", "EOR $%02X",		op_EOR_zpage,		0x45, 1)
table_undoc("LSR", "LSR $%02X",		op_LSR_zpage,		0x46, 1)
table_undoc("REOZ", "REOZ $%02X",	op_REO_zpage,		0x47, 1)
table_undoc("PHA", "PHA",		op_PHA,			0x48, 0)
table_undoc("EOR", "EOR #$%02X",	op_EOR_imm,		0x49, 1)
table_undoc("LSR", "LSR",		op_LSR_acc,		0x4A, 0)
table_undoc("RAM_", "RAM_ #$%02X",	op_RAM_imm,		0x4B, 1)
table_undoc("JMP", "JMP %02X%02X",	op_JMP_abs,		0x4C, 2)
table_undoc("EOR", "EOR %02X%02X",	op_EOR_abs,		0x4D, 2)
table_undoc("LSR", "LSR %02X%02X",	op_LSR_abs,		0x4E, 2)
table_undoc("REOa", "REOa %02X%02X",	op_REO_abs,		0x4F, 2)
table_undoc("BVC", "BVC $%04X (_$%02X)",op_BVC,			0x50, 3)
table_undoc("EOR", "EOR ($%02X),Y",	op_EOR_ind_y,		0x51, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x52, 0)
table_undoc("REOY", "REOY $%02X",	op_REO_ind_y,		0x53, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x54, 0)
table_undoc("EOR", "EOR $%02X,X",	op_EOR_zpage_x,		0x55, 1)
table_undoc("LSR", "LSR $%02X,X",	op_LSR_zpage_x,		0x56, 1)
table_undoc("REOZX", "REOZX $%02X",	op_REO_zpage_x,		0x57, 1)
table_undoc("CLI", "CLI",		op_CLI,			0x58, 0)
table_undoc("EOR", "EOR $%02X%02X,Y",	op_EOR_abs_y,		0x59, 2)
table_undoc("NOP_", "NOP_",		op_NOP,			0x5A, 0)
table_undoc("REOy", "REOy $%02X%02X",	op_REO_abs_y,		0x5B, 2)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0x5C, 0)
table_undoc("EOR", "EOR $%02X%02X,X",	op_EOR_abs_x,		0x5D, 2)
table_undoc("LSR", "LSR $%02X%02X,X",	op_LSR_abs_x,		0x5E, 2)
table_undoc("REOx", "REOx $%02X%02X",	op_REO_abs_x,		0x5F, 2)
table_undoc("RTS", "RTS",		op_RTS,			0x60, 0)
table_undoc("ADC", "ADC ($%02X,X)",	op_ADC_ind_x,		0x61, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x62, 0)
table_undoc("RADX", "RADX $%02X",	op_RAD_ind_x,		0x63, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x64, 0)
table_undoc("ADC", "ADC $%02X",		op_ADC_zpage,		0x65, 1)
table_undoc("ROR", "ROR $%02X",		op_ROR_zpage,		0x66, 1)
table_undoc("RADZ", "RADZ $%02X",	op_RAD_zpage,		0x67, 1)
table_undoc("PLA", "PLA",		op_PLA,			0x68, 0)
table_undoc("ADC", "ADC #$%02X",	op_ADC_imm,		0x69, 1)
table_undoc("ROR", "ROR",		op_ROR_acc,		0x6A, 0)
table_undoc("RBM_", "RBM_ #$%02X",	op_RBM_imm,		0x6B, 1)
table_undoc("JMP", "JMP ($%02X%02X)",	op_JMP_ind,		0x6C, 2)
table_undoc("ADC", "ADC $%02X%02X",	op_ADC_abs,		0x6D, 2)
table_undoc("ROR", "ROR $%02X%02X",	op_ROR_abs,		0x6E, 2)
table_undoc("RADa", "RADa $%02X%02X",	op_RAD_abs,		0x6F, 2)
table_undoc("BVS", "BVS $%04X (_$%02X)",op_BVS,			0x70, 3)
table_undoc("ADC", "ADC ($%02X),Y",	op_ADC_ind_y,		0x71, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x72, 0)
table_undoc("RADY", "RADY $%02X",	op_RAD_ind_y,		0x73, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x74, 0)
table_undoc("ADC", "ADC $%02X,X",	op_ADC_zpage_x,		0x75, 1)
table_undoc("ROR", "ROR $%02X,X",	op_ROR_zpage_x,		0x76, 1)
table_undoc("RADZX", "RADZX $%02X",	op_RAD_zpage_x,		0x77, 1)
table_undoc("SEI", "SEI",		op_SEI,			0x78, 0)
table_undoc("ADC", "ADC $%02X%02X,Y",	op_ADC_abs_y,		0x79, 2)
table_undoc("NOP_", "NOP_",		op_NOP,			0x7A, 0)
table_undoc("RADy", "RADy $%02X%02X",	op_RAD_abs_y,		0x7B, 2)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0x7C, 0)
table_undoc("ADC", "ADC $%02X%02X,X",	op_ADC_abs_x,		0x7D, 2)
table_undoc("ROR", "ROR $%02X%02X,X",	op_ROR_abs_x,		0x7E, 2)
table_undoc("RADx", "RADx $%02X%02X",	op_RAD_abs_x,		0x7F, 2)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x80, 0)
table_undoc("STA", "STA ($%02X,X)",	op_STA_ind_x,		0x81, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x82, 0)
table_undoc("AAXX", "AAXX $%02X",	op_AAX_ind_x,		0x83, 1)
table_undoc("STY", "STY $%02X",		op_STY_zpage,		0x84, 1)
table_undoc("STA", "STA $%02X",		op_STA_zpage,		0x85, 1)
table_undoc("STX", "STX $%02X",		op_STX_zpage,		0x86, 1)
table_undoc("AAXZ", "AAXZ $%02X",	op_AAX_zpage,		0x87, 1)
table_undoc("DEY", "DEY",		op_DEY,			0x88, 0)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0x89, 0)
table_undoc("TXA", "TXA",		op_TXA,			0x8A, 0)
table_undoc("XMA_", "XMA_ $%02X",	op_XMA_imm,		0x8B, 1)
table_undoc("STY", "STY $%02X%02X",	op_STY_abs,		0x8C, 2)
table_undoc("STA", "STA $%02X%02X",	op_STA_abs,		0x8D, 2)
table_undoc("STX", "STX $%02X%02X",	op_STX_abs,		0x8E, 2)
table_undoc("AAXa", "AAXa $%02X%02X",	op_AAX_abs,		0x8F, 2)
table_undoc("BCC", "BCC $%04X (_$%02X)",op_BCC,			0x90, 3)
table_undoc("STA", "STA ($%02X),Y",	op_STA_ind_y,		0x91, 1)
table_undoc("HANG", "HANG",		op_HANG,		0x92, 0)
table_undoc("AAXY", "AAXY $%02X",	op_AAX_ind_y,		0x93, 1)
table_undoc("STY", "STY $%02X,X",	op_STY_zpage_x,		0x94, 1)
table_undoc("STA", "STA $%02X,X",	op_STA_zpage_x,		0x95, 1)
table_undoc("STX", "STX $%02X,Y",	op_STX_zpage_y,		0x96, 1)
table_undoc("AAXZY", "AAXZY $%02X",	op_AAX_zpage_y,		0x97, 1)
table_undoc("TYA", "TYA",		op_TYA,			0x98, 0)
table_undoc("STA", "STA $%02X%02X,Y",	op_STA_abs_y,		0x99, 2)
table_undoc("TXS", "TXS",		op_TXS,			0x9A, 0)
table_undoc("AXSa", "AXSa $%02X%02X",	op_AXS_abs_y,		0x9B, 2)
table_undoc("TEYx", "TEYx $%02X%02X",	op_TEY_abs_x,		0x9C, 2)
table_undoc("STA", "STA $%02X%02X,X",	op_STA_abs_x,		0x9D, 2)
table_undoc("TEXy", "TEXy $%02X%02X",	op_TEX_abs_y,		0x9E, 2)
table_undoc("TEAy", "TEAy $%02X%02X",	op_TEA_abs_y,		0x9F, 2)
table_undoc("LDY", "LDY #$%02X",	op_LDY_imm,		0xA0, 1)
table_undoc("LDA", "LDA ($%02X,X)",	op_LDA_ind_x,		0xA1, 1)
table_undoc("LDX", "LDX #$%02X",	op_LDX_imm,		0xA2, 1)
table_undoc("LAXX", "LAXX $%02X",	op_LAX_ind_x,		0xA3, 1)
table_undoc("LDY", "LDY $%02X",		op_LDY_zpage,		0xA4, 1)
table_undoc("LDA", "LDA $%02X",		op_LDA_zpage,		0xA5, 1)
table_undoc("LDX", "LDX $%02X",		op_LDX_zpage,		0xA6, 1)
table_undoc("LAXZ", "LAXZ $%02X",	op_LAX_zpage,		0xA7, 1)
table_undoc("TAY", "TAY",		op_TAY,			0xA8, 0)
table_undoc("LDA", "LDA #$%02X",	op_LDA_imm,		0xA9, 1)
table_undoc("TAX", "TAX",		op_TAX,			0xAA, 0)
table_undoc("AMA_", "AMA_ #$%02X",	op_AMA_imm,		0xAB, 1)
table_undoc("LDY", "LDY $%02X%02X",	op_LDY_abs,		0xAC, 2)
table_undoc("LDA", "LDA $%02X%02X",	op_LDA_abs,		0xAD, 2)
table_undoc("LDX", "LDX $%02X%02X",	op_LDX_abs,		0xAE, 2)
table_undoc("LAXa", "LAXa $%02X%02X",	op_LAX_abs,		0xAF, 2)
table_undoc("BCS", "BCS $%04X (_$%02X)",op_BCS,			0xB0, 3)
table_undoc("LDA", "LDA ($%02X),Y",	op_LDA_ind_y,		0xB1, 1)
table_undoc("HANG", "HANG",		op_HANG,		0xB2, 0)
table_undoc("LAXY", "LAXY $%02X",	op_LAX_ind_y,		0xB3, 1)
table_undoc("LDY", "LDY $%02X,X",	op_LDY_zpage_x,		0xB4, 1)
table_undoc("LDA", "LDA $%02X,X",	op_LDA_zpage_x,		0xB5, 1)
table_undoc("LDX", "LDX $%02X,Y",	op_LDX_zpage_y,		0xB6, 1)
table_undoc("LAXZY", "LAXZY $%02X",	op_LAX_zpage_y,		0xB7, 1)
table_undoc("CLV", "CLV",		op_CLV,			0xB8, 0)
table_undoc("LDA", "LDA $%02X%02X,Y",	op_LDA_abs_y,		0xB9, 2)
table_undoc("TSX", "TSX",		op_TSX,			0xBA, 0)
table_undoc("LASy", "LASy $%02X%02X",	op_LAS_abs_y,		0xBB, 2)
table_undoc("LDY", "LDY $%02X%02X,X",	op_LDY_abs_x,		0xBC, 2)
table_undoc("LDA", "LDA $%02X%02X,X",	op_LDA_abs_x,		0xBD, 2)
table_undoc("LDX", "LDX $%02X%02X,Y",	op_LDX_abs_y,		0xBE, 2)
table_undoc("LAXy", "LAXy $%02X%02X",	op_LAX_abs_y,		0xBF, 2)
table_undoc("CPY", "CPY #$%02X",	op_CPY_imm,		0xC0, 1)
table_undoc("CMP", "CMP ($%02X,X)",	op_CMP_ind_x,		0xC1, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0xC2, 0)
table_undoc("DCPX", "DCPX $%02X",	op_DCP_ind_x,		0xC3, 1)
table_undoc("CPY", "CPY $%02X",		op_CPY_zpage,		0xC4, 1)
table_undoc("CMP", "CMP $%02X",		op_CMP_zpage,		0xC5, 1)
table_undoc("DEC", "DEC $%02X",		op_DEC_zpage,		0xC6, 1)
table_undoc("DCPZ", "DCPZ $%02X",	op_DCP_zpage,		0xC7, 1)
table_undoc("INY", "INY",		op_INY,			0xC8, 0)
table_undoc("CMP", "CMP #$%02X",	op_CMP_imm,		0xC9, 1)
table_undoc("DEX", "DEX",		op_DEX,			0xCA, 0)
table_undoc("AXM_", "AXM_ #$%02X",	op_AXM_imm,		0xCB, 1)
table_undoc("CPY", "CPY $%02X%02X",	op_CPY_abs,		0xCC, 2)
table_undoc("CMP", "CMP $%02X%02X",	op_CMP_abs,		0xCD, 2)
table_undoc("DEC", "DEC $%02X%02X",	op_DEC_abs,		0xCE, 2)
table_undoc("DCPa", "DCPa $%02X%02X",	op_DCP_abs,		0xCF, 2)
table_undoc("BNE", "BNE $%04X (_$%02X)",op_BNE,			0xD0, 3)
table_undoc("CMP", "CMP ($%02X),Y",	op_CMP_ind_y,		0xD1, 1)
table_undoc("HANG", "HANG",		op_HANG,		0xD2, 0)
table_undoc("DCPY", "DCPY $%02X",	op_DCP_ind_y,		0xD3, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0xD4, 0)
table_undoc("CMP", "CMP $%02X,X",	op_CMP_zpage_x,		0xD5, 1)
table_undoc("DEC", "DEC $%02X,X",	op_DEC_zpage_x,		0xD6, 1)
table_undoc("DCPZX", "DCPZX $%02X",	op_DCP_zpage_x,		0xD7, 1)
table_undoc("CLD", "CLD",		op_CLD,			0xD8, 0)
table_undoc("CMP", "CMP $%02X%02X,Y",	op_CMP_abs_y,		0xD9, 2)
table_undoc("NOP_", "NOP_",		op_NOP,			0xDA, 0)
table_undoc("DCPy", "DCPy $%02X%02X",	op_DCP_abs_y,		0xDB, 2)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0xDC, 0)
table_undoc("CMP", "CMP $%02X%02X,X",	op_CMP_abs_x,		0xDD, 2)
table_undoc("DEC", "DEC $%02X%02X,X",	op_DEC_abs_x,		0xDE, 2)
table_undoc("DCPx", "DCPx $%02X%02X",	op_DCP_abs_x,		0xDF, 2)
table_undoc("CPX", "CPX #$%02X",	op_CPX_imm,		0xE0, 1)
table_undoc("SBC", "SBC ($%02X,X)",	op_SBC_ind_x,		0xE1, 0)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0xE2, 0)
table_undoc("ISBx", "ISBx $%02X",	op_ISB_ind_x,		0xE3, 1)
table_undoc("CPX", "CPX $%02X",		op_CPX_zpage,		0xE4, 1)
table_undoc("SBC", "SBC $%02X",		op_SBC_zpage,		0xE5, 1)
table_undoc("INC", "INC $%02X",		op_INC_zpage,		0xE6, 1)
table_undoc("ISBZ", "ISBZ $%02X",	op_ISB_zpage,		0xE7, 1)
table_undoc("INX", "INX",		op_INX,			0xE8, 0)
table_undoc("SBC", "SBC #$%02X",	op_SBC_imm,		0xE9, 1)
table_undoc("NOP", "NOP",		op_NOP,			0xEA, 0)
table_undoc("ZBC_", "ZBC_ #$%02X",	op_ZBC_imm,		0xEB, 1)
table_undoc("CPX", "CPX $%02X%02X",	op_CPX_abs,		0xEC, 2)
table_undoc("SBC", "SBC $%02X%02X",	op_SBC_abs,		0xED, 2)
table_undoc("INC", "INC $%02X%02X",	op_INC_abs,		0xEE, 2)
table_undoc("ISBa", "ISBa $%02X%02X",	op_ISB_abs,		0xEF, 2)
table_undoc("BEQ", "BEQ $%04X (_$%02X)",op_BEQ,			0xF0, 3)
table_undoc("SBC", "SBC ($%02X),Y",	op_SBC_ind_y,		0xF1, 1)
table_undoc("HANG", "HANG",		op_HANG,		0xF2, 0)
table_undoc("ISBY", "ISBY $%02X",	op_ISB_ind_y,		0xF3, 1)
table_undoc("NOP2", "NOP2",		op_NOP_2,		0xF4, 0)
table_undoc("SBC", "SBC $%02X,X",	op_SBC_zpage_x,		0xF5, 1)
table_undoc("INC", "INC $%02X,X",	op_INC_zpage_x,		0xF6, 1)
table_undoc("ISBZX", "ISBZX $%02X",	op_ISB_zpage_x,		0xF7, 1)
table_undoc("SED", "SED",		op_SED,			0xF8, 0)
table_undoc("SBC", "SBC $%02X%02X,Y",	op_SBC_abs_y,		0xF9, 2)
table_undoc("NOP_", "NOP_",		op_NOP,			0xFA, 0)
table_undoc("ISBy", "ISBy $%02X%02X",	op_ISB_abs_y,		0xFB, 2)
table_undoc("NOP3", "NOP3",		op_NOP_3,		0xFC, 0)
table_undoc("SBC", "SBC $%02X%02X,X",	op_SBC_abs_x,		0xFD, 2)
table_undoc("INC", "INC $%02X%02X,X",	op_INC_abs_x,		0xFE, 2)
table_undoc("ISBx", "ISBx $%02X%02X",	op_ISB_abs_x,		0xFF, 2)


#ifdef __ASSEMBLY__

   /* ----------------------------------------------------------------------
       Undocumented 6502 (Illegal instructions)
      ---------------------------------------------------------------------- */

ENTRY(assign_6502_undoc_table)
		pushl	%edi
		pushl	%eax
		movl	$0, %edi
	1:	movl	SYMBOL_NAME(table_6502_undoc_opcodes)(,%edi,4), %eax
		movl	%eax, SYMBOL_NAME(table_opcodes)(,%edi,4)
		incl	%edi
		cmpl	$0x100, %edi
		jl	1b
		popl	%eax
		popl	%edi
		ret

   /* ----------------------------------
       HANG instruction
      ---------------------------------- */

op_HANG:
		decw	PC_Reg
		Continue

   /* ----------------------------------
       NOP_2 instruction
      ---------------------------------- */

op_NOP_2:
		incw	PC_Reg
		Continue

   /* ----------------------------------
       NOP_3 instruction
      ---------------------------------- */

op_NOP_3:
		addw	$2, PC_Reg
		Continue

   /* ----------------------------------
       AAX instructions
      ---------------------------------- */

op_AAX_abs:
		GetAbs
		DoAAX
		Continue

op_AAX_zpage:
		GetZPage
		DoAAX
		Continue

op_AAX_zpage_y:
		GetZPage_Y
		DoAAX
		Continue

op_AAX_ind_x:
		GetIndZPage_X
		DoAAX
		Continue

op_AAX_ind_y:
		GetIndZPage_Y
		DoAAX
		Continue

   /* ----------------------------------
       AMA instruction
      ---------------------------------- */

op_AMA_imm:
		GetImm
		DoAMA
		Continue

   /* ----------------------------------
       ANA instruction
      ---------------------------------- */

op_ANA_imm:
		GetImm
		DoANA(Continue)

   /* ----------------------------------
       ANB instruction
      ---------------------------------- */

op_ANB_imm:
		GetImm
		DoANB(Continue)

   /* ----------------------------------
       AXM instruction
      ---------------------------------- */

op_AXM_imm:
		GetImm
		DoAXM
		Continue

   /* ----------------------------------
       AXS instruction
      ---------------------------------- */

op_AXS_abs_y:
		GetAbs_Y
		DoAXS
		Continue

   /* ----------------------------------
       DCP instructions
      ---------------------------------- */

op_DCP_zpage:
		GetZPage
		DoDCP
		Continue

op_DCP_zpage_x:
		GetZPage_X
		DoDCP
		Continue

op_DCP_abs:
		GetAbs
		DoDCP
		Continue

op_DCP_abs_x:
		GetAbs_X
		DoDCP
		Continue

op_DCP_abs_y:
		GetAbs_Y
		DoDCP
		Continue

op_DCP_ind_x:
		GetIndZPage_X
		DoDCP
		Continue

op_DCP_ind_y:
		GetIndZPage_Y
		DoDCP
		Continue

   /* ----------------------------------
       ISB instructions
      ---------------------------------- */

op_ISB_dec:
		DoISB_d
		Continue

op_ISB_zpage:
		GetZPage
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue

op_ISB_zpage_x:
		GetZPage_X
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue


op_ISB_abs:
		GetAbs
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue

op_ISB_abs_x:
		GetAbs_X
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue

op_ISB_abs_y:
		GetAbs_Y
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue

op_ISB_ind_x:
		GetIndZPage_X
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue

op_ISB_ind_y:
		GetIndZPage_Y
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ISB_dec		# Yes, jump to decimal version
		DoISB_b
		Continue

   /* ----------------------------------
       LAN instructions
      ---------------------------------- */

op_LAN_zpage:
		GetZPage
		DoLAN(Continue)

op_LAN_zpage_x:
		GetZPage_X
		DoLAN(Continue)

op_LAN_abs:
		GetAbs
		DoLAN(Continue)

op_LAN_abs_x:
		GetAbs_X
		DoLAN(Continue)

op_LAN_abs_y:
		GetAbs_Y
		DoLAN(Continue)

op_LAN_ind_x:
		GetIndZPage_X
		DoLAN(Continue)

op_LAN_ind_y:
		GetIndZPage_Y
		DoLAN(Continue)

   /* ----------------------------------
       LAS instruction
      ---------------------------------- */

op_LAS_abs_y:
		GetAbs_Y
		DoLAS
		Continue

   /* ----------------------------------
       LAX instructions
      ---------------------------------- */

op_LAX_zpage:
		GetZPage
		DoLAX
		Continue

op_LAX_zpage_y:
		GetZPage_Y
		DoLAX
		Continue

op_LAX_abs:
		GetAbs
		DoLAX
		Continue

op_LAX_abs_y:
		GetAbs_Y
		DoLAX
		Continue

op_LAX_ind_x:
		GetIndZPage_X
		DoLAX
		Continue

op_LAX_ind_y:
		GetIndZPage_Y
		DoLAX
		Continue

   /* ----------------------------------
       LOR instructions
      ---------------------------------- */

op_LOR_zpage:
		GetZPage
		DoLOR
		Continue

op_LOR_zpage_x:
		GetZPage_X
		DoLOR
		Continue

op_LOR_abs:
		GetAbs
		DoLOR
		Continue

op_LOR_abs_x:
		GetAbs_X
		DoLOR
		Continue

op_LOR_abs_y:
		GetAbs_Y
		DoLOR
		Continue

op_LOR_ind_x:
		GetIndZPage_X
		DoLOR
		Continue

op_LOR_ind_y:
		GetIndZPage_Y
		DoLOR
		Continue

   /* ----------------------------------
       RAD instructions
      ---------------------------------- */

op_RAD_dec:
		DoRAD_d
		Continue

op_RAD_zpage:
		GetZPage
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue

op_RAD_zpage_x:
		GetZPage_X
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue


op_RAD_abs:
		GetAbs
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue

op_RAD_abs_x:
		GetAbs_X
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue

op_RAD_abs_y:
		GetAbs_Y
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue

op_RAD_ind_x:
		GetIndZPage_X
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue

op_RAD_ind_y:
		GetIndZPage_Y
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_RAD_dec		# Yes, jump to decimal version
		DoRAD_b
		Continue

   /* ----------------------------------
       RAM instruction
      ---------------------------------- */

op_RAM_imm:
		GetImm
		DoRAM
		Continue

   /* ----------------------------------
       RBM instruction
      ---------------------------------- */

op_RBM_imm:
		GetImm
		DoRBM
		Continue

   /* ----------------------------------
       REO instructions
      ---------------------------------- */

op_REO_zpage:
		GetZPage
		DoREO
		Continue

op_REO_zpage_x:
		GetZPage_X
		DoREO
		Continue

op_REO_abs:
		GetAbs
		DoREO
		Continue

op_REO_abs_x:
		GetAbs_X
		DoREO
		Continue

op_REO_abs_y:
		GetAbs_Y
		DoREO
		Continue

op_REO_ind_x:
		GetIndZPage_X
		DoREO
		Continue

op_REO_ind_y:
		GetIndZPage_Y
		DoREO
		Continue

   /* ----------------------------------
       ZBC instruction
      ---------------------------------- */

op_ZBC_imm:
		GetImm
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ZBC_dec		# Yes, jump to decimal version
		DoZBC_b
		Continue
op_ZBC_dec:
		DoZBC_d
		Continue

   /* ----------------------------------
       TEA instruction
      ---------------------------------- */

op_TEA_abs_y:
		GetAbs_Y
		DoTEA
		Continue

   /* ----------------------------------
       TEX instruction
      ---------------------------------- */

op_TEX_abs_y:
		GetAbs_Y
		DoTEX
		Continue

   /* ----------------------------------
       TEY instruction
      ---------------------------------- */

op_TEY_abs_x:
		GetAbs_X
		DoTEY
		Continue

   /* ----------------------------------
       XMA instruction
      ---------------------------------- */

op_XMA_imm:
		GetImm
		DoXMA
		Continue

#endif	/* __ASSEMBLY__ */
