/*
 *  Apple II emulator by Alexander Jean-Claude Bottema (C) 1994
 *
 *  $Id: keys.h,v 1.6 1998/08/25 03:00:01 chernabog Exp $
 *
 *  MODIFICATION HISTORY
 *   v0.3 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Jan 1997.
 *   v0.4 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Jun 1997.
 *   v0.5 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Feb 1998.
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *     This code has nothing to do with my employer, GTE Internetworking,
 *     BBN Technologies.  It was written completely on my own time and on
 *     my own machine.
 *
 */

#ifndef A2_KEYS_H
#define A2_KEYS_H

#define SCODE_L_CTRL	29
#define SCODE_R_CTRL 	97
#define SCODE_L_SHIFT	42
#define SCODE_R_SHIFT	54
#define SCODE_CAPS	58
#define SCODE_J_U	72
#define SCODE_J_D	80
#define SCODE_J_L	75
#define SCODE_J_R	77
#define SCODE_J_C	76

#define kF1	128
#define kF2	129
#define kF3	130
#define kF4	131
#define kF5	132
#define	kF6	133
#define kF7	134
#define kF8	135
#define kF9	136
#define kF10	137
#define kF11	138
#define kF12	139
#define kPRNT	140
#define RST	kPRNT

#define J_U	141
#define J_D	142
#define J_L	143
#define J_R	144
#define JUL	145
#define JUR	146
#define JDL	147
#define JDR	148

#define kDELETE	149
#define JB0	kDELETE
#define kEND	150
#define JB1	kEND
#define kPGDN	151
#define JB2	kPGDN

#define S_D	152
#define S_I	153
#define J_C	154
#define kPAUSE	155
#define BOT     kPAUSE

#define kLEFT	157
#define kRIGHT	158
#define kUP	159
#define kDOWN	160

#define kESC	161
#define kPGUP	162
#define kHOME	163


#define	 TIMER_DELAY		30000L

typedef enum {JOY_OFF, JOY_KYBD, JOY_DIGITAL, JOY_PCJOY} joystick_mode;

short	joy_mode/* = JOY_KYBD*/;
short	joy_step/* = 2*/;
short	joy_center_x/* = 127*/;	/* unsigned char range */
short	joy_center_y/* = 127*/;
short	joy_range/* = 256*/;
short	half_joy_range/* = 128*/;

void c_read_raw_key(int scancode, int pressed);
void c_periodic_update();
void c_set_rubout_key(int ascii);

#endif
