/*
 *  Apple II emulator by Alexander Jean-Claude Bottema (C) 1994
 *
 *  $Id: disk.h,v 1.2 1998/08/23 17:12:52 chernabog Exp $
 *
 *  Disk image routines.  Common code moved here from disk.c.
 *
 *  MODIFICATION HISTORY
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *     This code has nothing to do with my employer, GTE Internetworking,
 *     BBN Technologies.  It was written completely on my own time and on
 *     my own machine.
 *
 */

#ifndef A2_DISK_H
unsigned char	file_name_6[2][1024]/* = { "", "" }*/;
int		compressed_6[2];	/* If diskette in Drive A/B was compressed   */
int		nibblized_6[2];		/* If diskette in Drive A/B is .nib	     */
int		protected_6[2];		/* Drive A/B is protected		     */
int		motor_6;		/* Motor on/off (slot 6) 	       	     */
int		drive_6;		/* Current drive (slot 6)		     */
int		ddrw_6;			/* Data direction (read or write)	     */
int		disk_byte_6;		/* Disk byte (slot 6)			     */
int		volume_6;		/* Disk volume				     */
int		checksum_6;		/* Disk checksum			     */
int		phase_6[2];		/* Drive A/B current phase (0-69)	     */
int		phase_change_6[2];	/* Drive A/B phase changed?		     */
int		sector_6[2];		/* Drive A/B current sector		     */
long		file_size_6[2];		/* Drive A/B file size			     */

void		c_init_6();
int		c_new_diskette_6(int, char*, int, int, int);
void		c_eject_6(int);

void		disk_read_nop(),
		disk_read_phase(),
		disk_read_motor_off(),
		disk_read_motor_on(),
		disk_read_select_a(),
		disk_read_select_b(),
		disk_read_byte(),
		disk_read_latch(),
		disk_write_latch(),
		disk_read_prepare_in(),
		disk_read_prepare_out();

#define A2_DISK_H
#endif
