/*
 *  Apple //e, //c 65c02 instruction table
 *
 *  by Aaron Culliney - chernabog@baldmountain.bbn.com - (C) 1998
 *
 *  $Id: 65c02.h,v 1.3 1998/08/23 17:12:49 chernabog Exp $
 *
 *  MODIFICATION HISTORY
 *   v0.5 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Feb 1998.
 *   v0.6 by Aaron Culliney <chernabog@baldmountain.bbn.com>, Aug 1998.
 *	This code has nothing to do with my employer, GTE Internetworking,
 *	BBN Technologies.  It was written completely on my own time and on
 *	my own machine.
 *
 */

#ifndef __ASSEMBLY__
#define table_65c02(nme,fmt,ins,val,args) \
	{ nme, fmt, val, args },
#else
#define table_65c02(nme,fmt,ins,val,args) \
	.long		ins

	.align 4
table_65c02_opcodes:
#endif
table_65c02("BRK", "BRK", op_BRK,			0x00, 0) /* 6502 */
table_65c02("ORA", "ORA ($%02X,X)", op_ORA_ind_x,	0x01, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x02, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x03, 0) /* 6502 */
table_65c02("TSB", "xTSB $%02X", op_TSB_zpage,		0x04, 1) /* 65c02 */
table_65c02("ORA", "ORA $%02X", op_ORA_zpage,		0x05, 1) /* 6502 */
table_65c02("ASL", "ASL $%02X", op_ASL_zpage,		0x06, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x07, 0) /* 6502 */
table_65c02("PHP", "PHP", op_PHP,			0x08, 0) /* 6502 */
table_65c02("ORA", "ORA #$%02X", op_ORA_imm,		0x09, 1) /* 6502 */
table_65c02("ASL", "ASL", op_ASL_acc,			0x0A, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x0B, 0) /* 6502 */
table_65c02("TSB", "xTSB $%02X%02X", op_TSB_abs,	0x0C, 2) /* 65c02 */
table_65c02("ORA", "ORA $%02X%02X", op_ORA_abs,		0x0D, 2) /* 6502 */
table_65c02("ASL", "ASL $%02X%02X", op_ASL_abs,		0x0E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x0F, 0) /* 6502 */
table_65c02("BPL", "BPL $%04X (_$%02X)", op_BPL,	0x10, 3) /* 6502 */
table_65c02("ORA", "ORA ($%02X),Y", op_ORA_ind_y, 	0x11, 1) /* 6502 */
table_65c02("ORA", "xORA $%02X", op_ORA_ind_zpage,	0x12, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x13, 0) /* 6502 */
table_65c02("TRB", "xTRB $%02X", op_TRB_zpage,		0x14, 1) /* 65c02 */
table_65c02("ORA", "ORA $%02X,X", op_ORA_zpage_x,	0x15, 1) /* 6502 */
table_65c02("ASL", "ASL $%02X,X", op_ASL_zpage_x, 	0x16, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x17, 0) /* 6502 */
table_65c02("CLC", "CLC", op_CLC,			0x18, 0) /* 6502 */
table_65c02("ORA", "ORA $%02X%02X,Y", op_ORA_abs_y, 	0x19, 2) /* 6502 */
table_65c02("INA", "xINA", op_INA,			0x1A, 0) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x1B, 0) /* 6502 */
table_65c02("TRB", "xTRB $%02X%02X", op_TRB_abs,	0x1C, 2) /* 65c02 */
table_65c02("ORA", "ORA $%02X%02X,X", op_ORA_abs_x, 	0x1D, 2) /* 6502 */
table_65c02("ASL", "ASL $%02X%02X,X", op_ASL_abs_x, 	0x1E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x1F, 0) /* 6502 */
table_65c02("JSR", "JSR %02X%02X", op_JSR, 		0x20, 2) /* 6502 */
table_65c02("AND", "AND ($%02X,X)", op_AND_ind_x, 	0x21, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x22, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x23, 0) /* 6502 */
table_65c02("BIT", "BIT $%02X", op_BIT_zpage,		0x24, 1) /* 6502 */
table_65c02("AND", "AND $%02X", op_AND_zpage,		0x25, 1) /* 6502 */
table_65c02("ROL", "ROL $%02X", op_ROL_zpage,		0x26, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x27, 0) /* 6502 */
table_65c02("PLP", "PLP", op_PLP_65c02,			0x28, 0) /* diff */
table_65c02("AND", "AND #$%02X", op_AND_imm,		0x29, 1) /* 6502 */
table_65c02("ROL", "ROL", op_ROL_acc,			0x2A, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x2B, 0) /* 6502 */
table_65c02("BIT", "BIT $%02X%02X", op_BIT_abs,		0x2C, 2) /* 6502 */
table_65c02("AND", "AND $%02X%02X", op_AND_abs,		0x2D, 2) /* 6502 */
table_65c02("ROL", "ROL $%02X%02X", op_ROL_abs,		0x2E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x2F, 0) /* 6502 */
table_65c02("BMI", "BMI $%04X (_$%02X)", op_BMI,	0x30, 3) /* 6502 */
table_65c02("AND", "AND ($%02X),Y", op_AND_ind_y, 	0x31, 1) /* 6502 */
table_65c02("AND", "xAND ($%02X)", op_AND_ind_zpage,	0x32, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x33, 0) /* 6502 */
table_65c02("BIT", "xBIT $%02X,X", op_BIT_zpage_x, 	0x34, 1) /* 65c02 */
table_65c02("AND", "AND $%02X,X", op_AND_zpage_x, 	0x35, 1) /* 6502 */
table_65c02("ROL", "ROL $%02X,X", op_ROL_zpage_x, 	0x36, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x37, 0) /* 6502 */
table_65c02("SEC", "SEC", op_SEC,			0x38, 0) /* 6502 */
table_65c02("AND", "AND $%02X%02X,Y", op_AND_abs_y, 	0x39, 2) /* 6502 */
table_65c02("DEA", "xDEA", op_DEA,			0x3A, 0) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x3B, 0) /* 6502 */
table_65c02("BIT", "xBIT $%02X%02X,X", op_BIT_abs_x, 	0x3C, 2) /* 65c02 */
table_65c02("AND", "AND $%02X%02X,X", op_AND_abs_x, 	0x3D, 2) /* 6502 */
table_65c02("ROL", "ROL $%02X%02X,X", op_ROL_abs_x, 	0x3E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x3F, 0) /* 6502 */
table_65c02("RTI", "RTI", op_RTI_65c02,			0x40, 0) /* diff */
table_65c02("EOR", "EOR ($%02X,X)", op_EOR_ind_x, 	0x41, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x42, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x43, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x44, 0) /* 6502 */
table_65c02("EOR", "EOR $%02X", op_EOR_zpage,		0x45, 1) /* 6502 */
table_65c02("LSR", "LSR $%02X", op_LSR_zpage,		0x46, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x47, 0) /* 6502 */
table_65c02("PHA", "PHA", op_PHA,			0x48, 0) /* 6502 */
table_65c02("EOR", "EOR #$%02X", op_EOR_imm,		0x49, 1) /* 6502 */
table_65c02("LSR", "LSR", op_LSR_acc,			0x4A, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x4B, 0) /* 6502 */
table_65c02("JMP", "JMP %02X%02X", op_JMP_abs,		0x4C, 2) /* 6502 */
table_65c02("EOR", "EOR %02X%02X", op_EOR_abs,		0x4D, 2) /* 6502 */
table_65c02("LSR", "LSR %02X%02X", op_LSR_abs,		0x4E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x4F, 0) /* 6502 */
table_65c02("BVC", "BVC $%04X (_$%02X)", op_BVC, 	0x50, 3) /* 6502 */
table_65c02("EOR", "EOR ($%02X),Y", op_EOR_ind_y, 	0x51, 1) /* 6502 */
table_65c02("EOR", "xEOR ($%02X)", op_EOR_ind_zpage,	0x52, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x53, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x54, 0) /* 6502 */
table_65c02("EOR", "EOR $%02X,X", op_EOR_zpage_x, 	0x55, 1) /* 6502 */
table_65c02("LSR", "LSR $%02X,X", op_LSR_zpage_x, 	0x56, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x57, 0) /* 6502 */
table_65c02("CLI", "CLI", op_CLI_65c02,			0x58, 0) /* diff */
table_65c02("EOR", "EOR $%02X%02X,Y", op_EOR_abs_y, 	0x59, 2) /* 6502 */
table_65c02("PHY", "xPHY", op_PHY,			0x5A, 0) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x5B, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x5C, 0) /* 6502 */
table_65c02("EOR", "EOR $%02X%02X,X", op_EOR_abs_x, 	0x5D, 2) /* 6502 */
table_65c02("LSR", "LSR $%02X%02X,X", op_LSR_abs_x, 	0x5E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x5F, 0) /* 6502 */
table_65c02("RTS", "RTS", op_RTS,			0x60, 0) /* 6502 */
table_65c02("ADC", "ADC ($%02X,X)", op_ADC_ind_x, 	0x61, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x62, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x63, 0) /* 6502 */
table_65c02("STZ", "xSTZ $%02X", op_STZ_zpage,		0x64, 1) /* 65c02 */
table_65c02("ADC", "ADC $%02X", op_ADC_zpage,		0x65, 1) /* 6502 */
table_65c02("ROR", "ROR $%02X", op_ROR_zpage,		0x66, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x67, 0) /* 6502 */
table_65c02("PLA", "PLA", op_PLA,			0x68, 0) /* 6502 */
table_65c02("ADC", "ADC #$%02X", op_ADC_imm,		0x69, 1) /* 6502 */
table_65c02("ROR", "ROR", op_ROR_acc,			0x6A, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x6B, 0) /* 6502 */
table_65c02("JMP", "JMP ($%02X%02X)", op_JMP_ind_65c02,	0x6C, 2) /* diff */
table_65c02("ADC", "ADC $%02X%02X", op_ADC_abs,		0x6D, 2) /* 6502 */
table_65c02("ROR", "ROR $%02X%02X", op_ROR_abs,		0x6E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x6F, 0) /* 6502 */
table_65c02("BVS", "BVS $%04X (_$%02X)", op_BVS, 	0x70, 3) /* 6502 */
table_65c02("ADC", "ADC ($%02X),Y", op_ADC_ind_y, 	0x71, 1) /* 6502 */
table_65c02("ADC", "xADC ($%02X)", op_ADC_ind_zpage,	0x72, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x73, 0) /* 6502 */
table_65c02("STZ", "xSTZ $02X,X", op_STZ_zpage_x, 	0x74, 1) /* 65c02 */
table_65c02("ADC", "ADC $%02X,X", op_ADC_zpage_x, 	0x75, 1) /* 6502 */
table_65c02("ROR", "ROR $%02X,X", op_ROR_zpage_x, 	0x76, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x77, 0) /* 6502 */
table_65c02("SEI", "SEI", op_SEI,			0x78, 0) /* 6502 */
table_65c02("ADC", "ADC $%02X%02X,Y", op_ADC_abs_y, 	0x79, 2) /* 6502 */
table_65c02("PLY", "xPLY", op_PLY,			0x7A, 0) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x7B, 0) /* 6502 */
table_65c02("JMP", "xJMP ($%02X%02X),X",op_JMP_abs_ind_x,0x7C,2) /* 65c02 */
table_65c02("ADC", "ADC $%02X%02X,X", op_ADC_abs_x, 	0x7D, 2) /* 6502 */
table_65c02("ROR", "ROR $%02X%02X,X", op_ROR_abs_x, 	0x7E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x7F, 0) /* 6502 */
table_65c02("BRA", "xBRA $%04X (_$%02X)", op_BRA,	0x80, 3) /* 65c02 */
table_65c02("STA", "STA ($%02X,X)", op_STA_ind_x, 	0x81, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x82, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x83, 0) /* 6502 */
table_65c02("STY", "STY $%02X", op_STY_zpage,		0x84, 1) /* 6502 */
table_65c02("STA", "STA $%02X", op_STA_zpage,		0x85, 1) /* 6502 */
table_65c02("STX", "STX $%02X", op_STX_zpage,		0x86, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x87, 0) /* 6502 */
table_65c02("DEY", "DEY", op_DEY,			0x88, 0) /* 6502 */
table_65c02("BIT", "xBIT #$%02X", op_BIT_imm,		0x89, 1) /* 65c02 */
table_65c02("TXA", "TXA", op_TXA,			0x8A, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x8B, 0) /* 6502 */
table_65c02("STY", "STY $%02X%02X", op_STY_abs,		0x8C, 2) /* 6502 */
table_65c02("STA", "STA $%02X%02X", op_STA_abs,		0x8D, 2) /* 6502 */
table_65c02("STX", "STX $%02X%02X", op_STX_abs,		0x8E, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x8F, 0) /* 6502 */
table_65c02("BCC", "BCC $%04X (_$%02X)", op_BCC, 	0x90, 3) /* 6502 */
table_65c02("STA", "STA ($%02X),Y", op_STA_ind_y, 	0x91, 1) /* 6502 */
table_65c02("STA", "xSTA ($%02X)", op_STA_ind_zpage,	0x92, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x93, 0) /* 6502 */
table_65c02("STY", "STY $%02X,X", op_STY_zpage_x, 	0x94, 1) /* 6502 */
table_65c02("STA", "STA $%02X,X", op_STA_zpage_x, 	0x95, 1) /* 6502 */
table_65c02("STX", "STX $%02X,Y", op_STX_zpage_y, 	0x96, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x97, 0) /* 6502 */
table_65c02("TYA", "TYA", op_TYA,			0x98, 0) /* 6502 */
table_65c02("STA", "STA $%02X%02X,Y", op_STA_abs_y, 	0x99, 2) /* 6502 */
table_65c02("TXS", "TXS", op_TXS,			0x9A, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0x9B, 0) /* 6502 */
table_65c02("STZ", "xSTZ $%02X%02X", op_STZ_abs,	0x9C, 2) /* 65c02 */
table_65c02("STA", "STA $%02X%02X,X", op_STA_abs_x, 	0x9D, 2) /* 6502 */
table_65c02("STZ", "xSTZ $%02X%02X,X", op_STZ_abs_x, 	0x9E, 2) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0x9F, 0) /* 6502 */
table_65c02("LDY", "LDY #$%02X", op_LDY_imm,		0xA0, 1) /* 6502 */
table_65c02("LDA", "LDA ($%02X,X)", op_LDA_ind_x, 	0xA1, 1) /* 6502 */
table_65c02("LDX", "LDX #$%02X", op_LDX_imm,		0xA2, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xA3, 0) /* 6502 */
table_65c02("LDY", "LDY $%02X", op_LDY_zpage,		0xA4, 1) /* 6502 */
table_65c02("LDA", "LDA $%02X", op_LDA_zpage,		0xA5, 1) /* 6502 */
table_65c02("LDX", "LDX $%02X", op_LDX_zpage,		0xA6, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xA7, 0) /* 6502 */
table_65c02("TAY", "TAY", op_TAY,			0xA8, 0) /* 6502 */
table_65c02("LDA", "LDA #$%02X", op_LDA_imm,		0xA9, 1) /* 6502 */
table_65c02("TAX", "TAX", op_TAX,			0xAA, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xAB, 0) /* 6502 */
table_65c02("LDY", "LDY $%02X%02X", op_LDY_abs,		0xAC, 2) /* 6502 */
table_65c02("LDA", "LDA $%02X%02X", op_LDA_abs,		0xAD, 2) /* 6502 */
table_65c02("LDX", "LDX $%02X%02X", op_LDX_abs,		0xAE, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xAF, 0) /* 6502 */
table_65c02("BCS", "BCS $%04X (_$%02X)", op_BCS,	0xB0, 3) /* 6502 */
table_65c02("LDA", "LDA ($%02X),Y", op_LDA_ind_y, 	0xB1, 1) /* 6502 */
table_65c02("LDA", "xLDA ($%02X)", op_LDA_ind_zpage,	0xB2, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0xB3, 0) /* 6502 */
table_65c02("LDY", "LDY $%02X,X", op_LDY_zpage_x, 	0xB4, 1) /* 6502 */
table_65c02("LDA", "LDA $%02X,X", op_LDA_zpage_x, 	0xB5, 1) /* 6502 */
table_65c02("LDX", "LDX $%02X,Y", op_LDX_zpage_y, 	0xB6, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xB7, 0) /* 6502 */
table_65c02("CLV", "CLV", op_CLV,			0xB8, 0) /* 6502 */
table_65c02("LDA", "LDA $%02X%02X,Y", op_LDA_abs_y, 	0xB9, 2) /* 6502 */
table_65c02("TSX", "TSX", op_TSX,			0xBA, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xBB, 0) /* 6502 */
table_65c02("LDY", "LDY $%02X%02X,X", op_LDY_abs_x, 	0xBC, 2) /* 6502 */
table_65c02("LDA", "LDA $%02X%02X,X", op_LDA_abs_x, 	0xBD, 2) /* 6502 */
table_65c02("LDX", "LDX $%02X%02X,Y", op_LDX_abs_y, 	0xBE, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xBF, 0) /* 6502 */
table_65c02("CPY", "CPY #$%02X", op_CPY_imm,		0xC0, 1) /* 6502 */
table_65c02("CMP", "CMP ($%02X,X)", op_CMP_ind_x, 	0xC1, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xC2, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xC3, 0) /* 6502 */
table_65c02("CPY", "CPY $%02X", op_CPY_zpage,		0xC4, 1) /* 6502 */
table_65c02("CMP", "CMP $%02X", op_CMP_zpage,		0xC5, 1) /* 6502 */
table_65c02("DEC", "DEC $%02X", op_DEC_zpage,		0xC6, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xC7, 0) /* 6502 */
table_65c02("INY", "INY", op_INY,			0xC8, 0) /* 6502 */
table_65c02("CMP", "CMP #$%02X", op_CMP_imm,		0xC9, 1) /* 6502 */
table_65c02("DEX", "DEX", op_DEX,			0xCA, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xCB, 0) /* 6502 */
table_65c02("CPY", "CPY $%02X%02X", op_CPY_abs,		0xCC, 2) /* 6502 */
table_65c02("CMP", "CMP $%02X%02X", op_CMP_abs,		0xCD, 2) /* 6502 */
table_65c02("DEC", "DEC $%02X%02X", op_DEC_abs,		0xCE, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xCF, 0) /* 6502 */
table_65c02("BNE", "BNE $%04X (_$%02X)", op_BNE,	0xD0, 3) /* 6502 */
table_65c02("CMP", "CMP ($%02X),Y", op_CMP_ind_y, 	0xD1, 1) /* 6502 */
table_65c02("CMP", "xCMP ($%02X)", op_CMP_ind_zpage,	0xD2, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0xD3, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xD4, 0) /* 6502 */
table_65c02("CMP", "CMP $%02X,X", op_CMP_zpage_x, 	0xD5, 1) /* 6502 */
table_65c02("DEC", "DEC $%02X,X", op_DEC_zpage_x, 	0xD6, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xD7, 0) /* 6502 */
table_65c02("CLD", "CLD", op_CLD,			0xD8, 0) /* 6502 */
table_65c02("CMP", "CMP $%02X%02X,Y", op_CMP_abs_y, 	0xD9, 2) /* 6502 */
table_65c02("PHX", "xPHX", op_PHX,			0xDA, 0) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0xDB, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xDC, 0) /* 6502 */
table_65c02("CMP", "CMP $%02X%02X,X", op_CMP_abs_x, 	0xDD, 2) /* 6502 */
table_65c02("DEC", "DEC $%02X%02X,X", op_DEC_abs_x, 	0xDE, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xDF, 0) /* 6502 */
table_65c02("CPX", "CPX #$%02X", op_CPX_imm,		0xE0, 1) /* 6502 */
table_65c02("SBC", "SBC ($%02X,X)", op_SBC_ind_x, 	0xE1, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xE2, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xE3, 0) /* 6502 */
table_65c02("CPX", "CPX $%02X", op_CPX_zpage,		0xE4, 1) /* 6502 */
table_65c02("SBC", "SBC $%02X", op_SBC_zpage,		0xE5, 1) /* 6502 */
table_65c02("INC", "INC $%02X", op_INC_zpage,		0xE6, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xE7, 0) /* 6502 */
table_65c02("INX", "INX", op_INX,			0xE8, 0) /* 6502 */
table_65c02("SBC", "SBC #$%02X", op_SBC_imm,		0xE9, 1) /* 6502 */
table_65c02("NOP", "NOP", op_NOP,			0xEA, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xEB, 0) /* 6502 */
table_65c02("CPX", "CPX $%02X%02X", op_CPX_abs,		0xEC, 2) /* 6502 */
table_65c02("SBC", "SBC $%02X%02X", op_SBC_abs,		0xED, 2) /* 6502 */
table_65c02("INC", "INC $%02X%02X", op_INC_abs,		0xEE, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xEF, 0) /* 6502 */
table_65c02("BEQ", "BEQ $%04X (_$%02X)", op_BEQ, 	0xF0, 3) /* 6502 */
table_65c02("SBC", "SBC ($%02X),Y", op_SBC_ind_y, 	0xF1, 1) /* 6502 */
table_65c02("SBC", "xSBC ($%02X)", op_SBC_ind_zpage,	0xF2, 1) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0xF3, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xF4, 0) /* 6502 */
table_65c02("SBC", "SBC $%02X,X", op_SBC_zpage_x, 	0xF5, 1) /* 6502 */
table_65c02("INC", "INC $%02X,X", op_INC_zpage_x, 	0xF6, 1) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xF7, 0) /* 6502 */
table_65c02("SED", "SED", op_SED,			0xF8, 0) /* 6502 */
table_65c02("SBC", "SBC $%02X%02X,Y", op_SBC_abs_y, 	0xF9, 2) /* 6502 */
table_65c02("PLX", "xPLX", op_PLX,			0xFA, 0) /* 65c02 */
table_65c02("???", "???", op_UNK_65c02,			0xFB, 0) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xFC, 0) /* 6502 */
table_65c02("SBC", "SBC $%02X%02X,X", op_SBC_abs_x, 	0xFD, 2) /* 6502 */
table_65c02("INC", "INC $%02X%02X,X", op_INC_abs_x, 	0xFE, 2) /* 6502 */
table_65c02("???", "???", op_UNK_65c02,			0xFF, 0) /* 6502 */


#ifdef __ASSEMBLY__

   /* ----------------------------------------------------------------------
       65c02 routines and instructions
      ---------------------------------------------------------------------- */

ENTRY(assign_65c02_table)
		pushl	%edi
		pushl	%eax
		movl	$0, %edi
	1:	movl	SYMBOL_NAME(table_65c02_opcodes)(,%edi,4), %eax
		movl	%eax, SYMBOL_NAME(table_opcodes)(,%edi,4)
		incl	%edi
		cmpl	$0x100, %edi
		jl	1b
		popl	%eax
		popl	%edi
		ret

   /* ----------------------------------
       ADC instruction
      ---------------------------------- */

op_ADC_ind_zpage:		# 72
		GetIndZPage
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_ADC_ind_zpage_dec	# Yes, jump to decimal version
		DoADC_b
		Continue
op_ADC_ind_zpage_dec:
		DoADC_d
		Continue

   /* ----------------------------------
       AND instruction
      ---------------------------------- */

op_AND_ind_zpage:		# 32
		GetIndZPage
		DoAND
		Continue

   /* ----------------------------------
       BIT instructions
      ---------------------------------- */

op_BIT_zpage_x:			# 34
		GetIndZPage
		DoBIT
		Continue

op_BIT_abs_x:			# 3C
		GetAbs_X
		DoBIT
		Continue

op_BIT_imm:			# 89
		GetImm

		andb	Z_Flag_Not, F_Reg
		call	read_memory
		testb	%al, A_Reg
		FlagZ
		Continue

   /* ----------------------------------
       BRA instruction
      ---------------------------------- */

op_BRA:				# 80
		GetFromPC_B
		cbw
		addw	%ax, PC_Reg
		Continue

   /* ----------------------------------
       CMP instruction
      ---------------------------------- */

op_CMP_ind_zpage:		# D2
		GetIndZPage
		DoCMP
		Continue

   /* ----------------------------------
       CLI instruction
      ---------------------------------- */

op_CLI_65c02:			# 58
		btr	I_Flag_Bit, FF_Reg
		Continue

   /* ----------------------------------
       DEA instruction
      ---------------------------------- */

op_DEA:				# 3A
		decb	A_Reg
		FlagNZ
		Continue

   /* ----------------------------------
       EOR instruction
      ---------------------------------- */

op_EOR_ind_zpage:		# 52
		GetIndZPage
		DoEOR
		Continue

   /* ----------------------------------
       INA instruction
      ---------------------------------- */

op_INA:				# 1A
		incb	A_Reg
		FlagNZ
		Continue

   /* ----------------------------------
       JMP instructions
      ---------------------------------- */

op_JMP_ind_65c02:		# 6C - different from 6502
		xorl	%eax, %eax
		GetFromMem_B(PC_Reg_E)
		xchgb	%al, %ah
		incw	PC_Reg
		GetFromMem_B(PC_Reg_E)
		xchgb	%al, %ah
		GetFromMem_W(%eax)
		movw	%ax, PC_Reg
		Continue

op_JMP_abs_ind_x:		# 7C
		GetFromPC_W
		movw	%ax, EffectiveAddr
		movzbl	X_Reg, %eax
		addw	%ax, EffectiveAddr
		GetFromMem_W(EffectiveAddr_E)
		movw	%ax, PC_Reg
		Continue

   /* ----------------------------------
       LDA instruction
      ---------------------------------- */

op_LDA_ind_zpage:		# B2
		GetIndZPage
		DoLDA
		Continue

   /* ----------------------------------
       ORA instruction
      ---------------------------------- */

op_ORA_ind_zpage:		# 12
		GetIndZPage
		DoORA
		Continue

   /* ----------------------------------
       PHX instruction
      ---------------------------------- */

op_PHX:				# DA
		Push(X_Reg)
		Continue

   /* ----------------------------------
       PHY instruction
      ---------------------------------- */

op_PHY:				# 5A
		Push(Y_Reg)
		Continue

   /* ----------------------------------
       PLP instruction
      ---------------------------------- */

op_PLP_65c02:			# 28
		Pop(%al)
		btr	X_Flag_Bit, %eax
		xorb	%ah, %ah
		movb	SYMBOL_NAME(table_decode_flags)(,%eax,1), F_Reg
		bts	B_Flag_Bit, FF_Reg
		Continue

   /* ----------------------------------
       PLX instruction
      ---------------------------------- */

op_PLX:				# FA
		Pop(X_Reg)
		orb X_Reg, X_Reg
		FlagNZ
		Continue

   /* ----------------------------------
       PLY instruction
      ---------------------------------- */

op_PLY:				# 7A
		Pop(Y_Reg)
		orb Y_Reg, Y_Reg
		FlagNZ
		Continue

   /* ----------------------------------
       RTI instruction
      ---------------------------------- */
op_RTI_65c02:			# 40
		Pop(%al)
		btr	X_Flag_Bit, %eax
		xorb	%ah, %ah
		movb	SYMBOL_NAME(table_decode_flags)(,%eax,1), %al
		movb	%al, F_Reg
		Pop(%al)
		Pop(%ah)
		movw	%ax, PC_Reg
		bts	B_Flag_Bit, FF_Reg
		Continue

   /* ----------------------------------
       STA instruction
      ---------------------------------- */

op_STA_ind_zpage:		# 92
		GetIndZPage
		DoSTA
		Continue

   /* ----------------------------------
       SBC instruction
      ---------------------------------- */

op_SBC_ind_zpage:		# F2
		GetIndZPage
		bt	D_Flag_Bit, FF_Reg	# Decimal mode?
		jc	op_SBC_ind_zpage_dec	# Yes, jump to decimal version
		DoSBC_b
		Continue
op_SBC_ind_zpage_dec:
		DoSBC_d
		Continue

   /* ----------------------------------
       STZ instructions
      ---------------------------------- */

op_STZ_zpage:			# 64
		GetZPage
		DoSTZ
		Continue

op_STZ_zpage_x:			# 74
		GetZPage_X
		Continue

op_STZ_abs:			# 9C
		GetAbs
		DoSTZ
		Continue

op_STZ_abs_x:			# 9E
		GetAbs_X
		DoSTZ
		Continue

   /* ----------------------------------
       TRB instructions
      ---------------------------------- */

op_TRB_abs:			# 1C
		GetAbs
		DoTRB
		Continue

op_TRB_zpage:			# 14
		GetZPage
		DoTRB
		Continue

   /* ----------------------------------
       TSB instructions
      ---------------------------------- */

op_TSB_abs:			# 0C
		GetAbs
		DoTSB
		Continue

op_TSB_zpage:			# 04
		GetZPage
		DoTSB
		Continue


   /* ----------------------------------
       ??? instruction - 65c02
      ---------------------------------- */
op_UNK_65c02:
		Continue

#endif	/* __ASSEMBLY__ */
