
/*
 *main.c -- Globals and emulation setup for Apple ][ Emulator
 *
 * Modified 4/20/1990 Randy Frank  randy@tessa.iaf.uiowa.edu
 *
 *    Patched curses calls to work on sysV box (SGI)
 *    Added Dos 3.3 emulation and further ProDOS enhancements
 *    Added 65c02 emulation and fixed ADC, SBC, PLP, and RTI instructs
 *    Added RESET and booting calls to the debugger
 *    Added support for PR# commands
 *    Restructured memory a bit so //e emulation will be easier
 *    Cmd line -s to keep the emulator quiet else beeps are emulated
 *    Added //e emulation including extended 80col video card
 *    Enhancement of the ctrl-A break to allow for oa sa debugger and ^A
 *    Added some dumb protection against core dumps due to file i/o
 *    Added emulation of paddles (although they are not used currently)
 *    Made Apple//e emulation the default
 *
 *    New version:  This is a breakaway from the UNIX/plain version
 *	            Curses support has been removed in favor of GL.
 *		    New version runs under SGI GL and IBM RS/6000 GL.
 *
 *    Added graphic fonts (both pri and alt)
 *    Added full button, joystick, and arrowkey support
 *    Added B/W HIRES graphics to the emulation
 *    Added LORES graphics
 *
 *    Known bugs:  
 *         debugger does not disassemble 65c02
 *         debugger does not disassemble branch instructions correctly
 *	   the emulation of the 16k ram card is not quite correct 
 *		only one hit of the softswitch will enable write access
 *	   the page2 softswitch does not serve dual modes   (ie separate
 *		display page and DHGR page enable switches are not avail
 *		thus DHGR page flipped graphics will not work)
 *	   the drive emulations do not work for some apps but this may be
 *		poor coding on the apps part. (I havn't tested this fully)
 *	   the max timing constant for paddle emulation is a little high.
 *		I don't plan to change it because it is tuned for true
 *		timing of PREAD and the error is because I don't correct
 *		cycle timing for branching and page crossing.
 *	   TEXT page flipping is not supported. 
 *         when visual softswitches change the display does not automatically
 *         update in the new mode.  The program assumes the next thing the
 *         software will do is redraw the screen.  (Note: 2 exceptions: 1
 *         40/80column switch and HRG page flipping)
 *	   
 *
 */

#include "apple.h"

#define REF_DELAY 2000

main (argc,argv)

int	argc;
char	*argv [];

{
  short int byte;
  int loadCD;   /* load the file CDROM to 0xc100-0xffff ROM */
  int i, addr;                  /* Loop iterators */
  int refdelay = REF_DELAY;
  FILE *fp;
  char *D0FILE = "CDROM",
  
  BeepNoise = 1;
  loadCD = 1;
  /* Interpret args: 'invokename [-t] [-s] ' */
  for (i = 1;   i <= argc-1;   i++)
  {
    if (!strcmp (argv [i],"-t"))
      DebugSingle = 1;
    else
     if (!strcmp (argv [i],"-s"))
         BeepNoise = 0;  
     else
	{
	  (void)fprintf (stderr,"Usage: %s [-t] [-s] \n",
		   argv [0]);
	  exit (1);
	}
  }
  
  /* Print banner message: */
  (void)fprintf (stderr,"%s: Apple //e Emulation - v2.0\n",
	   argv [0]);
  
/*  (void)initscr(); */

  /*--------------------------------------------------*\
    Load the 'ROM' with the appropriate 6502 code:
  \*--------------------------------------------------*/ 
  if (loadCD == 1) 
    {
/* start in apple //e mode */
      D0FILE = "CDROM";
      if ((fp = fopen (D0FILE, "r")) == NULL) 
	{
		MegaShutDown();
		exit(1);
	};
      for (addr = 0xc100; addr <= 0xffff; addr++)
        Rom [addr - 0xc000] = fgetc (fp);
      (void)fclose(fp);
/* patch the rom to prevent it from booting slot 7 */
      if (Rom [0xfab5 - 0xc000] == 0xc8) Rom [0xfab5 - 0xc000] = 0xc1;
    } 
  /*--------------------------------------------------*\
    load prodos at $2000
  \*--------------------------------------------------*/
  if ((fp = fopen ("PRODOS", "r")) == NULL)
	{
		MegaShutDown();
		exit(1);
	};
  addr = 0x2000;
  while ((byte = fgetc (fp)) != EOF)
    MegaPutMem(addr++ , byte) ;
  (void)fclose (fp);
  
  /* Make sure banner message is seen: */
  sleep (1);
  
  /* Initialize the emulation: */
  init_graphics();
  MegaStartUp ();
  CPUReset ();
  paddle0 = 0.5 , paddle1 = 0.5 ;
  /*--------------------------------------------------*\
    Run it until user wants to quit:
  \*--------------------------------------------------*/
  while (!MegaQuitDetect)
  {
    CPUExecute ();
    if (!(--refdelay)) {
	do_event();
	refdelay = 75; 
	}
/*    if (!(--refdelay))
    {
      refdelay = REF_DELAY;
      byte = GetC000((ADDR)(0xC000));  
    } */
    if (MegaQuitDetect || DebugSingle || DebugTrace)
      Debugger();
  }
  
  /* Exit cleanly: */
  MegaShutDown ();
  exit (0);
}



