	/* --------------------------------------------------------------------
	    Routine	: disk_read_nop (C0E0, C0E2, C0E4, C0E6)
	   ----------------------------------------------------------------- */

		.globl _disk_read_nop
		.align 4
_disk_read_nop:
		movzwl	%di, %eax
		andb	$0x6, %al
		shrb	$1, %al		/* AL = phase value */
		xorb	%al, %al	/* @@@ Debug */
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_phase (C0E1, C0E3, C0E5, C0E7)
	   ----------------------------------------------------------------- */

		.globl _disk_read_phase
		.align 4
_disk_read_phase:
		pushl	%ebx
		pushl	%ecx
		movzwl	%di, %eax
		andb	$0x6, %al
		shrb	$1, %al		/* AL = current phase value */
		movl	_drive_6, %ecx  /* ECX = drive number */
		movl	_track_6(,%ecx,4), %ebx
		andl	$0x3, %ebx
		subb	%bl, %al
		jns	disk_read_phase_over
		addb	$0x4, %al
disk_read_phase_over:
		cmpb	$0x1, %al
		jne	disk_read_phase_over1
		incl	_track_6(,%ecx,4)
		jmp	disk_read_phase_exit
disk_read_phase_over1:
		cmpb	$0x3, %al
		jne	disk_read_phase_exit
		decl	_track_6(,%ecx,4)
		jns	disk_read_phase_exit
		movl	$0, _track_6(,%ecx,4)
disk_read_phase_exit:
		popl	%ecx
		popl	%ebx
		xorb	%al, %al	/* @@@ Debug */
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_motor_off (C0E8)
	   ----------------------------------------------------------------- */

		.globl _disk_read_motor_off
		.align 4
_disk_read_motor_off:
		movl	$1, _motor_6
		movl	_drive_6, %eax
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_motor_on (C0E9)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_motor_on
		.align 4
_disk_read_motor_on:
		movl	$0, _motor_6
		movl	_drive_6, %eax
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_select_a (C0EA)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_select_a
		.align 4
_disk_read_select_a:
		movl	$0, %eax
		movl	%eax, _drive_6
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_select_b (C0EB)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_select_b
		.align 4
_disk_read_select_b:
		movl	$1, %eax
		movl	%eax, _drive_6
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_byte (C0EC)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_byte
		.align 4
_disk_read_byte:
		cmpl	$0, _ddrw_6
		jne	disk_read_write_byte
		pushl	%ebx
		pushl	%ecx
		pushl	%edx
		pushl	%esi
		pushl	%edi
		call	_c_read_byte_6
		popl	%edi
		popl	%esi
		popl	%edx
		popl	%ecx
		popl	%ebx
		andl	$0xff, %eax
		ret
disk_read_write_byte:
		pusha
		call	_c_write_byte_6
		popa
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_latch (C0ED)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_latch
		.align 4
_disk_read_latch:
		movl	_drive_6, %eax
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_prepare_in (C0EE)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_prepare_in
		.align 4
_disk_read_prepare_in:
		movl	$0, _ddrw_6
		pushl	%ecx
		movl	_drive_6, %ecx
		cmpl	$1, _protected_6(,%ecx,4)
		je	disk_read_prepare_protected
		movl	$0, %eax
		popl	%ecx
		ret
disk_read_prepare_protected:
		movl	$0x80, %eax
		popl	%ecx
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_read_prepare_out (C0EF)
	   ----------------------------------------------------------------- */		

		.globl _disk_read_prepare_out
		.align 4
_disk_read_prepare_out:
		movl	$1, _ddrw_6
		movl	_drive_6, %eax
		ret

	/* --------------------------------------------------------------------
	    Routine	: disk_write_latch (C0ED)
	   ----------------------------------------------------------------- */		

		.globl _disk_write_latch
		.align 4
_disk_write_latch:
		andl	$0xff, %eax
		movl	%eax, _disk_byte_6
		ret


