;       APEX BYTE I/O TO DISK FILES HANDLER

;NOTE: THIS HANDLER ASSUMES THAT THE BUFFERS START ON
;A PAGE BOUNDARY AND ARE AN INTEGRAL NUMBER OF PAGES LONG.

;DEFINE THE DEVICE NUMBER WE WANT THIS TO BE:
        .DEF    DEVNO=3         ;BY CONVENTION IT SHOULD BE 3

;DEFINE THE PLACE IN MEMORY WE WANT THIS HANDLER TO GO:
        .DEF    HIAD=$AD00      ;REALLY HERE
        .DEF    LOAD=$lD00      ;BUT LOADS HERE

;EXTERNALS WE CARE ABOUT SEE SYSTEM PAGE DEFINITION:
        .DEF    KREAD=$BFE2     ;READ DISK BLOCKS
        .DEF    KWRITE=$BFE5    ;WRITE DISK BLOCKS
        .DEF    FSCAN=$BFDC     ;LOOKUP A FILE

;LOCATIONS IN PROGRAM AREA THAT SPECIFY THE BUFFERS WE MUST USE
        .DEF    INBUFE=$BF3C    ;INPUT BUFFER
        .DEF    INBUFD=$BF3A
        .DEF    OTBUFE=$BF38    ;OUTPUT BUFFER
        .DEF    OTBUFD=$BF36

;LOCATIONS IN THE SYSTEM AREA THAT CARRY READ/WRITE PARAMETERS
        .DEF    UNIT=$BF68      ;UNIT TO DO XFER TO/FROM
        .DEF    BLKNO=$BF69     ;BLOCK NUMBER TO START XFER
        .DEF    NBLKS=$BF6B     ;NUMBER OF BLOCKS TO XFER
        .DEF    FADDR=$BF6C     ;MEMORY ADDRESS TO XFER TO/FROM
        .DEF    ENDBLK=$BF6E    ;LAST BLOCK OF FOUND FILE

;LOCATIONS IN THE SYSTEM AREA THAT SPECIFY THE INPUT FILE
        .DEF    INLBLK=$BF78    ;FIRST BLOCK
        .DEF    INHBLK=$BF7A    ;LAST BLOCK
        .DEF    INFLG=$BF7C     ;STATUS
        .DEF    INDEV=$BF7E     ;UNIT IT IS ON

;LOCATIONS IN THE SYSTEM AREA THAT SPECIFY THE OUTPUT FILE

        .DEF    OTLBLK=$BF70    ;FIRST BLOCK
        .DEF    OTHBLK=$BF72    ;MAXIMUM BLOCK WE CAN USE
        .DEF    OTFLG=$BF74     ;STATUS
        .DEF    OTDEV=$BF76     ;UNIT IT IS ON

;WHERE THE DEVICE HANDLER TABLE IS SO WE CAN PATCH INTO IT:

        .DEF    DEVTAB=$BFC0

;A PLACE IF PAGE ZERO WE CAN USE FOR A POINTER
        .DEF    PNTR1=0
        .LOC    HIAD,LOAD

;ENTRY POINTS:
BYTEIO: JMP     OPENIN          ;OPEN FOR INPUT
        JMP     OPENOT          ;OPEN FOR OUTPUT
        JMP     GETBYT          ;INPUT A BYTE
        JMP     PUTBYT          ;OUTPUT A BYTE
        JMP     CLOSE           ;CLOSE
        JMP     SCAN            ;OPEN AN INPUT FILE BY NAME

; BASIC GET A BYTE ROUTINE:
GETBYT: LDA     INFLG           ;DO WE HAVE INPUT OPEN?
        CMP#    $55
        BEQ     GETB1           ;IF SO, CONTINUE
GETB0:  SEC                     ;ELSE RETURN, FAILED
        RTS
GETB1:  LDA     INBHI           ;FORM INBHI-INPNT
        SUB     INPNT           ;TO SEE IF POINTER
        LDA     INBHI+1         ;IS STILL INSIDE THE
        SBC     INPNT+1         ;INPUT BUFFER
        BGE     GETB2           ;OK IF INPNT<=INBHI
        JSR     RMORE           ;ELSE READ MORE IN
        BCS     GETB0           ;BARF IF TROUBLE
GETB2:  LDY#    0               ;GET THE BYTE
        DMOV    INPNT,PNTR1     ;MOVE POINTER TO PAGE ZERO
        LDA@Y   PNTR1           ;VIA INPNT
        DINC    INPNT           ;AND BUMP POINTER
        CLC                     ;ALL IS WELL
        RTS

;READ ANOTHER BUFFER FULL IN

RMORE:  LDA     LIBLK           ;FORM INSIZ:=LIBLK-FIBLK
        SUB     FIBLK           ;TO SEE HOW MUCH OF THE FILE
        STA     INSIZ           ;IS LEFT
        LDA     LIBLK+1
        SBC     FIBLK+1
        STA     INSIZ+1
        BCS     RMOR1           ;IS FILE USED UP?
RMOR0:  SEC                     ;BARF EXIT
        RTS
RMOR1:  LDA     INSIZ+1         ;WILL IT FIT IN BUFFER?
        BNE     RMOR2           ;NO, >256 BLOCKS
        LDA     INSIZ
        CMP     INBSIZ
        BLT     RMOR3           ;YES, IT FITS
;IF FILE IS >= BUFFER:
RMOR2:  MOV     INBLO+1,FADDR+1 ;SETUP WHOLE BUFFER
        MOV     INBSIZ,NOBLK    ;FULL SIZE TANSFER
        JMP     RMOR4           ;ENTER COMMON CODE
;IF FILE IS < BUFFER:
RMOR3:  LDA     INBHI+1         ;COMPUTE WHERE TO PUT IT
        SUB     INSIZ
        STA     FADDR+1
        MOV     INSIZ,NOBLK     ;SIZE OF FILE-1
        INC     NOBLK           ;+l=NO BLKS TO XFER
;COMMON CODE
RMOR4:  MOV#    0,FADDR         ;MUST BE ON A PAGE
        DMOV    FIBLK,BLKNO     ;SETUP BLKNO
        DMOV    FADDR,INPNT     ;RESET POINTERS
        LDA     NOBLK           ;ADJUST NEXT BLOCK
        DADM    FIBLK
        MOV     NOBLK,NBLKS     ;GO GET IT

        MOV     INUNIT,UNIT
        JSR     KREAD
        RTS                     ;RETURN WITH CORRECT CARRY


;OPEN INPUT FILE:

OPENIN: LDA     INFLG           ;DO WE HAVE ONE?
        BNE     OPIN1           ;NON ZERO IF OK
        SEC                     ;ERROR, NO FILE TO OPEN
        RTS
OPIN1:  DMOV    INLBLK,FIBLK    ;SETUP FIBLK
        DMOV    INHBLK,LIBLK    ;AND LIBLK
        DMOV    INBUFE,INBHI    ;LOCAL COPY
        DMOV    INBUFD,INBLO
        LDA     INBHI+1         ;COMPUTE INBSIZ
        SUB     INBLO+1
        INCA
        STA     INBSIZ
        MOV     INDEV,INUNIT    ;MAKE LOCAL COPY OF UNIT
OPIN2:  MOV#    $FF,INPNT+1     ;FLAG IT EMPTY
        MOV#    $55,INFLG       ;FLAG IT OPEN
        CLC
        RTS

;OUTPUT A BYTE:

PUTBYT: STA     DATA            ;SAVE THE BYTE
        LDA     OTFLG           ;IS IT OPEN?
        CMP#    $55
        BEQ     PUTB1           ;WILL BE $55 IF IT IS
PUTB0:  SEC
        RTS
PUTB1:  LDA     OTBHI           ;FORM OTBHI-OTPNT
        SUB     OTPNT           ;TO SEE IF THE POINTER IS
        LDA     OTBHI+1         ;STILL WITHIN THE
        SBC     OTPNT+1         ;OUTPUT BUFFER
        BGE     PUTB2           ;OK IF OTPNT<=OTBHI
        JSR     WMORE           ;ELSE WRITE BUF OUT
        BCS     PUTB0           ;BARF IF TROUBLE
PUTB2:  LDY#    0               ;STORE THE BYTE
        DMOV    OTPNT,PNTR1     ;MOVE POINTER TO PAGE ZERO
        LDA     DATA
        STA@Y   PNTR1           ;VIA OTPNT
        DINC    OTPNT           ;AND BUMP POINTER
        CLC                     ;ALL IS WELL
        RTS

;WRITE OUT A BUFFER

WMORE:  LDA     OTPNT+1         ;COMPUTE OTSIZ
        SUB     OTBLO+1         ;TO SEE HOW MANY BLOCKS
        STA     OTSIZ           ;WE NEED TO WRITE OUT
        LDA     OTPNT
        BEQ     WMOR1
        INC     OTSIZ           ;ADJUST FOR PARTIAL BLOCK
WMOR1:  DMOV    FOBLK,BLKNO     ;SETUP BLKNO
        LDA     OTBLO+1
        STA     FADDR+1
        STA     OTPNT+1         ;AND POINTER
        LDA#    0
        STA     FADDR           ;MUST BE ON A PAGE
        STA     OTPNT
        LDA     OTSIZ           ;UPDATE TO NEXT OUT BLOCK
        DADM    FOBLK
        LDA     LOBLK           ;DOES THIS FIT IN THE EMPTY?
        SUB     FOBLK
        LDA     LOBLK+1
        SBC     FOBLK+1
        BGE     WMOR3           ;IF FOBLK <= LOBLK
        SEC                     ;ATTEMPT TO WRITE TOO FAR
        RTS                     ;DOES NOT FIT
WMOR3:  MOV     OTSIZ,NBLKS     ;FITS, SO WRITE IT
        MOV     OTDEV,UNIT
        JSR     KWRITE
        RTS                     ;RETURN WITH STATUS

;OPEN OUTPUT FILE:
OPENOT: LDA     OTFLG           ;DO WE HAVE ONE?
        CMP#    $1              ;IF IT WAS NEW
        BEQ     OPOT1           ;THEN FINE
        CMP#    $55             ;IF IT WAS NOT CLOSED
        BEQ     OPOT1           ;THEN FINE
        SEC                     ;ELSE BAD
        RTS
OPOT1:  DMOV    OTLBLK,FOBLK    ;SETUP FOBLK
        LDA     OTHBLK          ;AND LOBLK
        INCA
        STA     LOBLK
        LDA     OTHBLK+1
        ADC#    0
        STA     LOBLK+1
        DMOV    OTBUFE,OTBHI    ;LOCAL COPY
        DMOV    OTBUFD,OTBLO    ;IN CASE USER PROGRAM BOMBS US
        LDA     OTBHI+1         ;COMPUTE OTBSIZ
        SUB     OTBLO+1
        INCA
        STA     OTBSIZ
        LDA     OTBLO+1         ;FLAG BUFFER EMPTY
        STA     OTPNT+1
        MOV#    0,OTPNT
        MOV#    $55,OTFLG       ;FLAG IT OPEN
        CLC
        RTS

;CLOSE THE OUT FILE

CLOSE:  LDA     OTFLG           ;WAS IT OPEN?
        CMP#    $55
        BEQ     CLOS1           ;WAS OPEN, SO GO CLOSE IT
        CLC                     ;IT WAS ALREADY CLOSED
        RTS                     ;SO WE JUST IGNORE
CLOS1:  LDA#    $1A             ;STASH AN EOF, IN CASE
        JSR     PUTBYT
        LDA     OTPNT           ;DO WE HAVE TO WRITE ANY?
        BNE     CLOS3           ;HAS CONTENT
        LDA     OTPNT+1
        CMP     OTBLO+1
        BEQ     CLOS2           ;NO CONTENT, ALL DONE
CLOS3:  JSR     WMORE           ;ELSE WRITE OUT FINAL BLOCKS
        BCC     CLOS2           ;CHECK FOR ERRORS
        RTS
CLOS2:  LDA     FOBLK           ;UPDATE LAST BLOCK
        SUB#    1               ;IN SYSTEM PAGE
        STA     OTHBLK          ;SO APEX WILL KNOW HOW
        LDA     FOBLK+1         ;TO UPDATE THE DIRECTORY
        SBC#    0
        STA     OTHBLK+1
        LDA#    $FF             ;MARK IT CLOSED
        STA     OTFLG
        CLC
        RTS                     ;RETURN WITH CARRY FLAG CLEAR

;THIS ROUTINE USES THE SYSTEM RESIDENT "FSCAN" TO OPEN
;AN INPUT FILE BY NAME. THE NAME IS PASSED BY ADDRESS IN
;THE AC AND Y REGISTERS. THE FILE WILL BE LOOKED FOR
;ON THE UNIT IN THE SYSTEM AREA PARAMETER "UNIT".
;NOTE THAT THE FILE OPENED IN THIS WAY LEAVES THE INPUT
;FILE BLOCK IN THE SYSTEM AREA UNAFFECTED. THUS IF ANOTHER
;CALL IS MADE TO "OPENIN" IT WILL RE-OPEN THE ORIGINAL FILE.
;REFER TO THE COMMENTS ON FSCAN FOR FURTHER DETAILS.

SCAN:   JSR     FSCAN
        BCS     BADSCN          ;FILE NOT FOUND
        DMOV    BLKNO,FIBLK     ;MOVE STARTING BLOCK
        DMOV    ENDBLK,LIBLK    ;AND ENDING BLOCK
        MOV     UNIT,INUNIT     ;ALSO SAVE NEW UNIT
        JMP     OPIN2           ;GO JOIN EXISTING CODE
BADSCN: SEC
        RTS

;THE RAM LOCS THAT THESE ROUTINES NEED

FIBLK:  .WORD   0               ;NEXT BLOCK OF INPUT FILE
LIBLK:  .WORD   0               ;LAST BLOCK OF THE INPUT FILE
INSIZ:  .WORD   0               ;REMAINING INPUT FILE SIZE-1
INPNT:  .WORD   0               ;INPUT BUFFER POINTER
INBHI:  .WORD   0               ;LOCAL COPY START OF BUF
INBLO:  .WORD   0               ;LOCAL COPY, END OF BUF
INBSIZ: .BYTE   0               ;INPUT BUFFER SIZE IN PAGES
INUNIT: .BYTE   0               ;LOCAL COPY OF INPUT UNIT

FOBLK:  .WORD   0               ;NEXT BLOCK OF OUT FILE
LOBLK:  .WORD   0               ;MAX+1 BLOCK OF OUT FILE
OTSIZ:  .BYTE   0               ;SIZE FOR THIS WRITE
OTPNT:  .WORD   0               ;OUTPUT BUFFER POINTER
OTBSIZ: .BYTE   0               ;OUTPUT BUFFER SIZE IN PAGES
OTBHI:  .WORD   0               ;LOCAL COPY, START OF BUF
OTBLO:  .WORD   0               ;LOCAL COPY, END OF BUF

DATA:   .BYTE   0               ;TEMPORARY TO SAVE DATA BYTE
NOBLK:  .BYTE   0               ;TEMP=NO OF BLOCKS IN XFER

;PS: THE LOCAL COPY STUFF IS TO SAVE US FROM LOADERS AND LINKED
;FILE READERS WHICH COULD CHANGE THINGS IN THE SYSTEM PAGE
;ON THE FLY.

;NOW HOOK THE HANDLER INTO THE DEVICE HANDLER TABLE:
        .LOC    DEVTAB+DEVNO+DEVNO
        .WORD   BYTEIO

        .PAGE
        .END
