;               A P E X  V1.0
;          **** RESIDENT CODE ****

;SYSTEM CONFIGURATION DEFINITIONS
        .DEF    SWPSIZ=$40      ;DISK SWAP SIZE (16K)
        .DEF    SWPLOC=$6000    ;MEMORY APEX WILL SWAP
        .DEF    DIRBLK=9        ;DIRECTORY BEGINS HERE
        .DEF    MAXFL=48        ;MAX LEGAL NUMBER OF FILES
        .DEF    COMPAG=$B700    ;COMMUNICATIONS PAGE
        .DEF    INPBUF=$A000    ;SCRATCH BUFFER

;DEFINITIONS OF APPLE ROM ADDRESSES:
        .DEF MONITR=$FF59       ;ROM MONITOR "RESET" ENTRY

;SOME PAGE ZERO POINTERS FOR ANYBODY TO USE:
        .DEF    PNTR1=0
        .DEF    PNTR2=2
        .DEF    PNTR3=4

;SOME HARDWARE LOCATIONS IN THE APPLE
        .DEF    ASPEAK=$C030    ;THE SPEAKER


;WHERE THIS MODULE GOES:
        .DEF    HIAD=$B000      ;ACTUALLY GOES HERE
        .DEF    LOAD=$2000      ;BUT IT LOADS HERE
        .DEF    BIAS=HIAD-LOAD

        .PAGE
;       APEX BASIC SYSTEM FUNCTIONS
;       ***************************

        .DEF HERE=$B000
        .LOC    HERE,HERE-BIAS

;"RELOAD" THE APEX SYSTEM FROM THE SYSTEM UNIT
;THAT IS, LOAD THE WHOLE THING NO MATTER WHAT

RELOAD: MOV#    $FF,EXECUT      ;EXEC MODE OFF
        LDA#    $FC             ;INDICATE A RELOAD
REL1:   STA     SYSENF          ;SAVE THE INDICATOR
        CLD                     ;SECURITY
        SEI                     ;EQUALLY
        LDX#    $FF             ;RESET STACK POINTER
        TXS
        MOV     SYSDEV,UNIT     ;TRANSFER FROM SYSTEM UNIT
        DMOV#   SYSFIL,PNTR3    ;POINT TO SYSTEM FILE NAME
        JSR     FSCANR          ;GO FIND THE EXEC CODE. 
        BCS     BARF            ;HEY, NONE HERE!
        DMOV    BLKNO,SYSBLK    ;FOUND, SO FORM THIS BLOCK
        JMP     BOOT            ;WE GO DO A SYSTEM RELOAD

SYSFIL: .ASCII  "SYSTEM  SYS"   ;EXEC FILE NAME
SWPFIL: .ASCII  "SCRATCH SYS"   ;SWAP SPACE FILE NAME

BARF:   MOV#    0,SYSDEV        ;IF TROUBLE, GO BACK TO UNIT 0
        LDA#    <SERMES         ;SAY WE HAD A BAD SYSTEM UNIT
        LDX#    >SERMES
        JMP     HRDERR          ;ITS A HARD ERROR

SERMES: .BYTE   %15
        .BYTE   %12
        .ASCII  "NOT A SYSTEM DISK-"
        .ASCII  "REBOOT ON 0?"
        .BYTE   %15
        .BYTE   %12
        .BYTE   0

;LINK TO THE SCAN FUNCTION:
FSCANR: DPSH    INBUFD          ;SAVE THE INPUT BUFFER SPEC
        DMOV#   INPBUF,INBUFD   ;SET IT UP OUT WAY
        JSR     FSCAN1          ;GO FIND THE FILE
        DPOP    INBUFD          ;AND RESTORE HIS BUFFER SPEC
        RTS

;REENTER THE APEX EXEC, RELOAD IF NECCESSARY

RENTER: LDA#    $FD             ;INDICATE  NON-VALID  SWAP  AREA
ENTER:  STA     SYSENF          ;SAVE REENTRY STATUS
        CLD                     ;FOR SECURITY
        SEI
        LDX#    $FF             ;COS IT MUST NOT BE LOW!
        TXS
        LDA     SYBOMB          ;CHECK RESIDENCY FLAG
        BEQ     TRYSWP          ;=0 IF USER DID NOT BOMB APEX
ENTR2:  CMP#    $55             ;=$55 IF THE PROGRAM IS APEX
        BNE     BOOT            ;NEITHER, SO RELOAD APEX
        JMP     VSTART          ;IS APEX, SO JUST RESTART IT
TRYSWP: JSR     MOVMEM          ;SWAP BACK SYSTEM PAGE
        LDA     SYBOMB          ;CHECK THE NEW RESIDENCY FLAG
        BNE     ENTR2           ;IF WE CAN, REPEAT THE ABOVE
;RESET AND BOOT:
BOOT:   JSR     KRESTD          ;RESET DISK DRIVES
        JSR     OPCON           ;RESET CONSOLE
;CONTINUE WITH BOOT
        MOV     SYSDEV,UNIT     ;BOOT IN FROM THE DEFAULT UNIT
        DMOV    SYSBLK,BLKNO    ;SETUP BLOCK NUMBER

;"RUN" THE MEMORY IMAGE WHICH BEGINS AT 'BLKNO'

RUN:    JSR     GETR            ;GET IT
        MOV#    0,RERUNF        ;NOT RUN YET
        JMP     VSTART          ;AND ENTER AT IT'S STARTING ADDR

;"GET" THE MEMORY IMAGE WHICH BEGINS AT 'BLKNO'

GET:    JSR     GETR            ;GET IT
        JMP     MONITR          ;BUT DON'T START IT

;THIS ROUTINE READS IN THE MEMORY IMAGE AT 'BLKNO'

GETR:   JSR     SET1            ;SET UP FOR COMMUNICATION AREA
        JSR     READUS          ;READ IT
        JSR     MOVMEM          ;MOVE ABOUT
        JSR     SET3            ;SET UP FOR MAIN MEMORY
        JSR     READUS          ;READ IT
        RTS

;THIS ROUTINE WRITES THE CURRENT IMAGE BEGINNING AT 'BLKNO'

SAVE:   JSR     SET1            ;SET UP FOR COMMUNICATION AREA
        JSR     MOVMEM          ;SHUFFLE MEMORY
        JSR     WRITUS          ;WRITE IT
        JSR     MOVMEM          ;SHUFFLE BACK
        JSR     SET3            ;SET UP FOR MAIN MEMORY
        JSR     WRITUS          ;WRITE IT
        RTS

;THIS ROUTINE PACKS THE PROGRAM SPECIFIC AREAS OF PAGES $0 & $BF
;INTO THE "COMMUNICATIONS" PAGE. ACTUALLY IT SWAPS THEM

MOVMEM: DMOV#   SYSPAG,PNTR1    ;FIRST DO LOW PART
        DMOV#   COMPAG,PNTR2    ;OF PAGE $BF
        LDY#    0               ;FROM LOCATION 0
        LDX#    $50             ;FOR $50 BYTES
        JSR     MOVSWP          ;DO THE SHUFFLE
        MOV#    0,PNTR1+1       ;THEN HIGH PART
        LDX#    256-$50         ;OF PAGE ZERO
MOVSWP: LDA@Y   PNTR1           ;\
        PHA                     ; :
        LDA@Y   PNTR2           ; : EXCHANGE THE BYTES
        STA@Y   PNTR1           ; :
        PLA                     ; :
        STA@Y   PNTR2           ;/
        INY                     ;POINT TO NEXT ONE
        DEX                     ;COUNT THIS ONE
        BNE     MOVSWP          ;CONTINUE IF NOT DONE
        RTS

;READ IN APEX EXEC BUT WRITE OUT CURRENT IMAGE FIRST.

SAVER:  MOV     SYSDEV,UNIT     ;GET SYSTEM UNIT NUMBER
        DMOV#   SWPFIL,PNTR3    ;POINT TO SCRATCH FILE NAME
        JSR     FSCANR          ;GO LOOK FOR IT
        BCC     NOBARF          ;DID WE FIND IT?
        JMP     BARF            ;HEY, WE DONT HAVE ONE!
NOBARF: DMOV    BLKNO,SWPBLK    ;SAVE BLOCK NUMBER FOR LATER
        DMOV#   SWPLOC,DSKMEM   ;SETUP SWAP PLACE
        MOV#    SWPSIZ,DSKSIZ   ;SETUP LENGTH
        JSR     SAVE            ;SAVE IT
        LDA#    $FE             ;INDICATE VALID SCRATCH AREA
        JMP     REL1            ;THEN BOOT IN THE EXEC

;SAVE CURRENT IMAGE THAT IS WRITTEN IN SCRATCH AREA

SAVESC: LDA     UNIT
        PHA                     ;REMEMBER UNIT NUMBER
        DPSH    BLKNO           ;REMEMBER PLACE TO SAVE IT
        MOV     SYSDEV,UNIT     ;SETUP POINTERS TO SCRATCH AREA
        DMOV    SWPBLK,BLKNO
        JSR     GETR            ;GET THE IMAGE INTO MEMORY
        DPOP    BLKNO           ;GET PLACE TO PUT IT BACK AGAIN
        PLA
        STA     UNIT            ;REMEMBER UNIT
        MOV     PROSIZ,DSKSIZ   ;SETUP THE PROGRAM SIZE
        DMOV    USRMEM,DSKMEM   ;SET ADDRESS OF PROGRAM
        JSR     SAVE            ;SAVE IT
        LDA#    $FF             ;INDICATE WE SAVED AN IMAGE
        JMP     ENTER           ;AND ENTER THE EXEC

;HERE TO SAVE THE PROGRAM CURRENTLY IN MEMORY

SAVEA:  DMOV    USRMEM,DSKMEM   ;SET THE ADDRESS UP
        MOV     PROSIZ,DSKSIZ   ;SET THE SIZE UP
        JSR     SAVE            ;DO IT
        LDA#    $F0             ;INDICATE WE DID IT
        JMP     ENTER           ;AND ENTER THE EXEC

;ROUTINE TO SETUP TO TRANSFER COMMUNICATION AREA

SET1:   DMOV#   COMPAG,FADDR    ;SETUP ADDR
        MOV#    1,NBLKS         ;ONLY ONE BLOCK
        RTS                     ;AND RETURN

;ROUTINE TO SETUP TO TRANSFER MAIN MEMORY SEGMENT

SET3:   DINC    BLKNO           ;POINT TO NEXT BLOCK ON UNIT
        DMOV    DSKMEM,FADDR    ;SETUP INITIAL ADDR POINTER
        MOV     DSKSIZ,NBLKS    ;GET SIZE OF TRANSFER
        RTS                     ;AND RETURN

;ROUTINE TO READ SEQUENTIAL LOGICAL BLOCKS FROM UNIT.

READUS: JSR     KREAD           ;READ THE BLOCKS
        BCS     WRITER          ;BRANCH IF HARD ERROR
        RTS                     ;RETURN IF NO ERRORS

;ROUTINE TO WRITE SEQUENTIAL BLOCKS TO UNIT.

WRITUS: JSR     KWRITE          ;WRITE THE BLOCK
        BCS     WRITER          ;BRANCH IF HARD ERROR
        RTS                     ;RETURN IF NO ERRORS

WRITER: LDA#    <DERMES         ;POINT TO ERROR MESSAGE
        LDX#    >DERMES         ;AND FALL CEASAR

;HERE WITH A,X POINTING TO APPROPRIATE ERROR MESSAGE.
;ISSUE THE ERROR MESSAGE ON CONSOLE UNIT AND EXIT
;DIRECTLY TO THE SYSTEM MONITOR.

HRDERR: STA     PNTR1           ;SAVE ADDR OF MESSAGE
        STX     PNTR1+1         ;INTO A SCRATCH POINTER
        JSR     OPCON           ;RESET CONSOLE OUTPUT SIDE
        LDY#    0               ;POINT TO FIRST CHAR OF MESSAGE
        STY     LTEMP
HMLOOP: LDY     LTEMP           ;GET POINTER TO NEXT CHAR
        LDA@Y   PNTR1           ;GET CHAR
        BEQ     HMDONE          ;BRANCH IF END OF MESSAGE
        JSR     CONOUT          ;OUTPUT TO CONSOLE
        INC     LTEMP           ;POINT TO NEXT CHAR
        BNE     HMLOOP          ;AND OUTPUT IT
HMDONE: JSR     CONIN           ;WAIT FOR A KEY STRIKE
        JMP     RELOAD          ;AND TRY A RELOAD

LTEMP:  .BYTE   0

DERMES: .BYTE   %15             ;ADVANCE A LINE
        .BYTE   %12
        .ASCII "DISK ERROR-"
        .ASCII "RETURN TO RESET"
        .BYTE   %15
        .BYTE   %12
        .BYTE   0

;CODE TO LOOK UP A FILE IN THE DIRECTORY. THIS ROUTINE TAKES A
;POINTER TO A FILE NAME BY ADDRESS IN A,Y. THE NAME MUST BE 11
;CHARATERS LONG FILLED WITH BLANKS. NO FUZZY FILE NAMES PLEASE.
;THE FILE NAMES ARE 11 BYTES EACH (8-NAME,3-EXT). THE STATUS
;ARRAY OF ONE BYTE PER FILE BEGINS AT +528. STATUS=0 IF NULL,
;<128 IF CLOSED, >127 IF TENTATIVE THE FIRST BLOCK ARRAY BEGINS
;AT +576, TWO BYTES PER FILE. THE LAST BLOCK ARRAY BEGINS AT
;+672-

        .DEF    STATUS=528      ;OFFSET TO STATUS ARRAY
        .DEF    FIRBLK=576      ;OFFSET TO FIRST BLOCK ARRAY
        .DEF    LASBLK=672      ;OFFSET TO LAST BLOCK ARRAY
;

FSCAN:  STA     PNTR3           ;POINTER TO NAME
        STY     PNTR3+1
FSCAN1: DMOV    INBUFD,FADDR    ;READ DIRECTORY
        DMOV#   DIRBLK,BLKNO    ;INTO INPUT BUFFER
        MOV#    3,NBLKS         ;WE ONLY NEED THREE BLOCKS
        JSR     KREAD
;SO WE SCAN THROUGH THE FILE NAMES LOOKING FOR THE NAME
;BUT IGNORING FILES WHOSE STATUS IS NOT >0.
        DMOV    INBUFD,PNTR1    ;SETUP NAME POINTER
        LDA     INBUFD          ;\
        ADD#    <STATUS         ; \
        STA     PNTR2           ;  SETUP POINTER
        LDA     INBUFD+1        ;  TO THE STATUS ARRAY
        ADC#    >STATUS         ; /
        STA     PNTR2+1         ;/
        MOV#    MAXFL,FILENO    ;RESET FILE COUNTER
        LDX#    0               ;COUNT FILES
NEXT:   LDY#    0
        LDA@Y   PNTR2           ;IS STATUS>O
        BEQ     TRYNXT          ;NOT VALID IF 0
        BMI     TRYNXT          ;OR IF <0
TSTLP:  LDA@Y   PNTR1           ;DOES THE NAME MATCH?
        CMP@Y   PNTR3
        BNE     TRYNXT          ;IF NOT TRY NEXT FILE
        CPY#    10
        BEQ     MATCH           ;WHEN WE HAVE A MATCH
        INY
        JMP     TSTLP
TRYNXT: INX                     ;COUNT IT
        LDA     PNTR1
        ADD#    11              ;BUMP THE NAME POINTER
        STA     PNTR1           ;BY THE SIZE OF ONE NAME
        BCC     NOBMP
        INC     PNTR1+1
NOBMP:  DINC    PNTR2           ;BUMP THE STATUS POINTER
        DEC     FILENO          ;SEE IF WE HAVE CHECKED ALL FILE
        BEQ     FAILED          ;IF SO THEN WE HAVE FAILED
        JMP     NEXT            ;LOOP BACK FOR NEXT CHECK
FAILED: SEC                     ;SHOW WE FAILED
        RTS
;IF WE SUCCEED WE COME HERE
MATCH:  LDA     INBUFD          ;\
        ADD#    <FIRBLK         ; \
        STA     PNTR1           ;  MAKE A POINTER TO THE
        LDA     INBUFD+1        ;  FIRST BLOCK ARRAY
        ADC#    >FIRBLK         ; /
        STA     PNTR1+1         ;/
        LDA     INBUFD          ;\
        ADD#    <LASBLK         ; \
        STA     PNTR2           ;  AND A POINTER TO THE LAST
        LDA     INBUFD+1        ;  BLOCK ARRAY
        ADC#    >LASBLK         ; /
        STA     PNTR2+1         ;/
        TXA                     ;PULL OUT THE BLOCK NUMBERS
        ASLA                    ;USING TWICE THE FILE NUMBER
        TAY
        LDA@Y   PNTR1           ;FIRST BLOCK
        STA     BLKNO           ;SAVE FILE FIRST BLOCK
        LDA@Y   PNTR2           ;LAST BLOCK
        STA     ENDBLK          ;SAVE FILE LIMIT BLOCK
        INY
        LDA@Y   PNTR1           ;DITTO HIGH BYTES
        STA     BLKNO+1         ;SAVED IN THE
        LDA@Y   PNTR2           ;AUXILLIARY LOCATION
        STA     ENDBLK+1
        CLC
        RTS

FILENO: .BYTE   0               ;LOCAL TEMPORARY

;FOR LOCAL USE, WE DEFINE THESE CONSOLE I/O FUNCTIONS

OPCON:  LDX#    0               ;CONSOLE IS DEVICE 0
        STX     NOWDEV
        JSR     KHAND           ;OPEN FOR INPUT
        LDX#    3
        JMP     KHAND           ;OPEN FOR OUTPUT

CONOUT: LDX#    0
        STX     NOWDEV
        LDX#    9
        JMP     KHAND           ;OUTPUT TO CONSOLE

CONIN:  LDX#    0
        STX     NOWDEV
        LDX#    6
        JMP KHAND               ;INPUT FROM CONSOLE

;NOW SOME JUNK FOR A NULL DEVICE:
NULDEV: JMP     PUNT
        JMP     PUNT
        JMP     PUNT
        JMP     PUNT
PUNT:   LDA#    $1A             ;GIVE EOF INCASE IT WAS INPUT
        CLC
        RTS

;ROUTINE TO DISPATCH TO A PARTICULAR FUNCTION AND DEVICE
;THE DEVICE IT WILL USE IS IN THE SYSTEM GLOBAL "NOWDEV".
;THE FUNCTION CODE =(DEVICE HANDLER ENTRY OFFSET) IS IN THE
;X REGISTER. ARGUMENTS, IF ANY ARE TRANSFERED IN THE AC & Y.

HANDY:  PHA                     ;SAVE ARGUMENTS IF ANY
        TYA
        PHA
        LDA     NOWDEV          ;AND THE DEVICE NUMBER
        CMP#    8               ;NO MORE THAN 8 DEVICES!
        BLT     HANDOK          ;CONTINUE IF ITS OK
        PLA                     ;REPAIR STACK
        PLA
        SEC                     ;BAD DEVICE NUMBER
        RTS                     ;EXIT, CANT DO IT
HANDOK: ASLA                    ;DEVICE NUMBER TIMES 2
        TAY                     ;WILL BE INDEX INTO TABLE
        TXA                     ;FUNCTION CODE= OFFSET
        CLC
        ADCY    DEVTAB          ;COMPUTE THE ADDRESS
        STA     HANDV+1         ;OF THE ROUTINE
        LDA#    0               ;THAT DOES THE JOB
        ADCY    DEVTAB+1
        STA     HANDV+2
        PLA                     ;GET ARGUMENTS BACK
        TAY                     ;INTO Y REGISTER
        PLA                     ;AND ACCUMULATOR
HANDV:  JMP     .               ;AND DISPATCH TO IT

        .PAGE
;DISK DRIVER. USES RWTS WHICH MUST RESIDE AT $B800

;USEFUL DEFINITIONS
        .DEF    RWTS=$BD00      ;ENTRY POINT OF "RWTS"

;COMMANDS TO RWTS
        .DEF    NULL=0          ;"NULL" COMMAND
        .DEF    READ0=1         ;"READ" DATA COMMAND
        .DEF    WRITE=2         ;"WRITE" DATA COMMAND

;ERROR CODES THAT MAY BE RETURNED BY THIS ROUTINE
        .DEF    BADINF=1        ;BAD INFORMATION WAS PASSED
        .DEF    WRTPRT=$10      ;DISKETTE WRITE PROTECTED
        .DEF    VOLMMT=$20      ;VOLUME MISMATCH ERROR
        .DEF    DRVERR=$40      ;STRANGE DRIVE ERROR
        .DEF    RDERR=$80       ;READ ERROR

;ROUTINE TO READ SEQUENTIAL BLOCKS FROM DISK.

ADEVRB: JSR     SETUP           ;SETUP GOODIES
        BCS     RDBRET          ;BRANCH IF ERROR DURING SETUP
RDBNXT: LDA#    READ0           ;INDICATE THAT WE ARE READING
        JSR     DOIO            ;DO THE I-0
        BCS     RDBRET          ;BRANCH IF ERROR
        JSR     INCADR          ;ADVANCE POINTERS
        DEC     ANBLKS          ;MORE BLOCKS TO READ?
        BNE     RDBNXT          ;BRANCH IF YES
RESTD:  CLC                     ;NO, THEN INDICATE SUCCESS
RDBRET: RTS                     ;RETURN TO CALLER

;ROUTINE TO WRITE SEQUENTIAL BLOCKS TO DISK.

DEVWOB: JSR     SETUP           ;SETUP GOODIES
        BCS     WRBRET          ;BRANCH IF ERROR DURING SETUP
WRBNXT: LDA#    WRITE           ;INDICATE WE WANT TO WRITE
        JSR     DOIO            ;PERFORM THE I-0
        BCS     WRBRET          ;BRANCH IF ERROR
        JSR     INCADR          ;ADVANCE POINTERS
        DEC     ANBLKS          ;MORE BLOCKS TO WRITE?
        BNE     WRBNXT          ;BRANCH IF YES
        CLC                     ;NO, INDICATE SUCCESS
WRBRET: RTS                     ;RETURN TO CALLER

;ROUTINE TO CALL "RWTS" SUBROUTINE.

DOIO:   STA     IBCMD           ;SAVE COMMAND IN IOB
        DMOV    AFADR,IBADDR    ;COPY CURRENT ADDRESS INTO IOB
        JSR     TICKO           ;MAKE "TICKING" NOISES
        LDA#    >IOB            ;GET ADDR OF IOB
        LDY#    <IOB
        JSR     RWTS            ;CALL "RWTS" TO DO THE WORK
        PHP                     ;SAVE PROCESSOR STATUS
        MOV#    NULL,IBCMD      ;ZAP COMMAND
        DMOV    IOBSLT,IBPSLT   ;MOVE CURRENT SLOT AND DRIVE
        LDA     IBSTAT          ;GET STATUS CODE IN CASE ERROR
        PLP                     ;RESTORE PROCESSOR STATUS
DOIORT: RTS                     ;AND RETURN TO CALLER

;ROUTINE TO ADVANCE POINTERS IN MEMORY AND ON DISK.


INCADR: INC     AFADR+1         ;ADVANCE MEMORY ADDRESS
        INC     IBSECT          ;BUMP TO NEXT SECTOR NUMBER
        LDA     IBSECT
        LDX     UNIT
        CMPX    NUMSEC          ;DID WE OVERFLOW TO NEXT TRACK?
        BCC     INCRET          ;BRANCH IF NOT
        LDA#    0               ;YES, THEN SET TO SECTOR ZERO
        STA     IBSECT
        INC     IBTRK           ;ON NEXT TRACK
INCRET: RTS                     ;AND RETURN TO CALLER

;SUBROUTINE TO TOGGLE THE SPEAKER IN ORDER TO MAKE A TICKING
;NOISE BECAUSE THE DISK-II IS TOO QUIET.

TICKO:  STA     ASPEAK          ;TOGGLE SPEAKER PORT
        RTS                     ;AND RETURN

;ROUTINE TO SETUP THINGS PRIOR TO DOING I-0.

SETUP:  JSR     VALDRV          ;IS THIS A PERMITTED UNIT?
        BCS     SETERR          ;NO, ERROR
        DMOV    NBLKS,ANBLKS    ;LOCAL COPY OF NUMBER OF BLKS
        DMOV    FADDR,AFADR     ;LOCAL COPY OF BASE ADDRESS
        LDX     UNIT            ;GET UNIT NUMBER
        LDAX    DEVSLT          ;CONVERT TO SLOT NUMBER OF CONTR
        BEQ     SETERR          ;BRANCH IF ERROR, BUM INFO
        PHA
        AND#    $F0
        STA     IOBSLT          ;SAVE FOR "RWTS" ROUTINE
        PLA
        AND#    $0F
        STA     IOBDRV          ;SAVE FOR "RWTS" ROUTINE
        MOV#    0,IBTRK         ;SET TRACK NUMBER TO ZERO
        MOV     BLKNO,IBSECT    ;GET LOW ORDER BLOCK NUMBER
        MOV     BLKNO+1,TEMP    ;STORE HIGH ORDER BLOCK
NEXTRY: LDA     TEMP            ;GET HIGH ORDER
        BNE     NOTTRK          ;CAN'T BE DONE IF NON-ZERO
        LDA     IBSECT          ;GET REMAINDER
        CMPX    NUMSEC          ;LESS THAN A TRACK YET?
        BCC     GOTIT           ;BRANCH IF YES, THEN WE HAVE IT
NOTTRK: LDA     IBSECT          ;NO, SO SUBTRACT ONE TRACK SIZE
        SEC
        SBCX    NUMSEC
        STA     IBSECT
        LDA     TEMP
        SBC#    0
        STA     TEMP
        INC     IBTRK           ;AND ADVANCE TO NEXT TRACK
        JMP     NEXTRY          ;AND CONTINUE
GOTIT:  RTS                     ;YES, THEN ALL OK

SETERR: LDA#    BADINF          ;INDICATE BAD INFO
        SEC                     ;INDICATE FAILURE
        RTS                     ;AND RETURN

VALDRV: LDA#    1               ;AC WILL BE MASK
        LDX     UNIT            ;GET UNIT NUMBER
        BEQ     VALD1           ;SKIP SHIFT IF UNIT ZERO
VALD2:  ASLA                    ;ELSE SHIFT THE BIT UP
        DEX
        BNE     VALD2
VALD1:  AND     DEVMSK          ;COMPARE TO PERMIT BYTE
        BNE     VALD3           ;#0 MEANS THE UNIT IS OK
        SEC                     ;ELSE INVALID
        RTS
VALD3:  CLC
        RTS

ANBLKS: .BYTE   0               ;HOLDS NUMBER OF BLOCKS
AFADR:  .WORD   0               ;BASE ADDR OF TRANSFER
TEMP:   .WORD   0               ;GENERAL PURPOSE TEMPORARY

;THESE TABLES ARE INDEXED BY UNIT NUMBER

;ENTRIES TO DEVSLT ARE: SLOT*$10+DRIVE
DEVSLT: .BYTE   $61             ;UNIT 0 = SLOT 6 DRIVE 1
        .BYTE   $62             ;UNIT 1 = SLOT 6 DRIVE 2
        .BYTE   $51             ;UNIT 2 = SLOT 5 DRIVE 1
        .BYTE   $52             ;UNIT 3 = SLOT 5 DRIVE 2
        .BYTE   $71             ;UNIT 4 = SLOT 7 DRIVE 1
        .BYTE   $72             ;UNIT 5 = SLOT 7 DRIVE 2
        .BYTE   $73             ;UNIT 6 = SLOT 7 DRIVE 3
        .BYTE   $74             ;UNIT 7 = SLOT 7 DRIVE 4

;NUMBER OF SECTORS PER TRACK
NUMSEC: .BYTE   13              ;ORIGINAL APPLE FORMAT USES
        .BYTE   13              ;13 PER TRACK FOR DISK ][.
        .BYTE   13
        .BYTE   13
        .BYTE   26              ;8" USES 26 PER PSUEDO TRACK
        .BYTE   26              ;WHEN ITS A SORRENTO VALLEY
        .BYTE   26              ;CONTROLLER
        .BYTE   26

;THIS IS THE I-0 CONTROL BLOCK FOR "RWTS" SUBROUTINE.

IOB:    .BYTE   1               ;TYPE OF IOB (ALWAYS A 1)
IOBSLT: .BYTE   0               ;HOLDS SLOT NUMBER OF DISK CONTR
IOBDRV: .BYTE   0               ;HOLDS DRIVE NUMBER OF UNIT
        .BYTE   0               ;VOLUME NUMBER (0 MATCHES ALL)
IBTRK:  .BYTE   0               ;HOLDS TRACK NUMBER
IBSECT: .BYTE   0               ;HOLDS SECTOR NUMBER
        .WORD   DEVT            ;POINTER TO DISK CHARACTER
IBADDR: .WORD   0               ;POINTER TO WHERE DATA IS
        .BYTE   0               ;UNUSED
        .BYTE   0               ;UNUSED
IBCMD:  .BYTE   0               ;HOLDS COMMAND CODE
IBSTAT: .BYTE   0               ;ERROR CODE IF CARRY IS SET
IBVOL:  .BYTE   0               ;VOLUME NUMBER FOUND
IBPSLT: .BYTE   $60             ;SLOT NUMBER OF PREVIOUS ACCESS
IBPDRV: .BYTE   1               ;DRIVE OF PREVIOUS ACCESS
DEVT:   .BYTE   0               ;DISK TYPE (0 FOR DISK-II)
        .BYTE   1               ;NUMBER OF PHASES (=1)
        .WORD   $D8EF           ;TIME COUNT ($D8EF FOR DISK-II)

        .PAGE
;               ***SYSTEM PAGE MODULE FOR APEX***

;       ***PROGRAM SPECIFIC AREA***

;THE FIRST $50 LOCATIONS OF THIS PAGE ARE SAVED WITH THE
;USER PROGRAM IN PLACE OF THE FIRST $50 LOCATIONS IN PAGE 0
        .DEF    HERE=$BF00
        .LOC    HERE,HERE-BIAS

        .DEF    SYSPAG=.

;PROGRAM START AND EXIT VECTORS:
VRSTRT: JMP     .               ;PROGRAM RESTART VECTOR
VSTART: JMP     .               ;PROGRAM START VECTOR
VEXIT:  JMP     KRENTR          ;PROGRAM NORMAL EXIT ADDRESS
VERROR: JMP     KRELOD          ;PROGRAM ERROR EXIT ADDRESS
VABORT: JMP     KSAVER          ;USER ABORT EXIT ADDRESS

;INTERNAL USE BY APEX:
        .BYTE   0               ;SPARE
DSKMEM: .WORD   0               ;BASE ADDR OF MEMORY SEGMENT ON DISK
DSKSIZ: .BYTE   0               ;SIZE OF IMAGE ON THE DISK
        .WORD   0               ;SPARE

;PROGRAM MEMORY PARAMETERS:
USRMEM: .WORD   0               ;BASE ADDR OF USER PROGRAM
PROSIZ: .BYTE   0               ;USER PROGRAM SIZE IN PAGES

;(LEAVE SPACE HERE FOR MORE USER PROGRAM SEGMENTS)

        .DEF    HERE=SYSPAG+$20
        .LOC    HERE,HERE-BIAS

RERUNF: .BYTE   0               ;RERUN FLAG
DEXTO:  .ASCII  "TMP"           ;DEFAULT EXTENSION FOR OUTPUT FILES
DEXTI:  .ASCII  "TMP"           ;DEFAULT EXTENSION FOR INPUT FILES
DEFAUL: .BYTE   0               ;SINGLE BIT DEFAULT FLAGS
SYBOMB: .BYTE   $FF             ;$FF IF PROG BOMBS SYSTEM
USRTOP: .BYTE   $B0             ;LAST PAGE+1 FOR USER PROGRAM
        .BYTE   0               ;SPARE
        .WORD   0               ;SPARE
        .WORD   0               ;SPARE

;I2L PARAMETERS:
I2LFLG: .BYTE   0               ;$FF IF PROGRAM USES SYSTEM I2L
I2LBAS: .WORD   0               ;START OF PSEUDO CODE FOR SYSTEM I2L
I2LHEP: .WORD   0               ;START OF HEAP FOR SYSTEM I2L
        .WORD   0               ;SPARE

;I/0 BUFFERS: (MAY NEED TO BE INTEGRAL PAGES! SEE HANDLER)
OTBUFD: .WORD   $6300           ;BASE OF OUTPUT BUFFER TO USE
OTBUFE: .WORD   $63FF           ;END OF OUTPUT BUFFER
INBUFD: .WORD   $6000           ;BASE OF INPUT BUFFER TO USE
INBUFE: .WORD   $62FF           ;END OF INPUT BUFFER

;(LEAVE SPACE HERE FOR MORE INPUT FILE BUFFER SPECS)

        .PAGE
;       SYSTEM SPECIFIC AREA

;THE REST OF THIS PAGE IS NOT SAVED BUT RATHER IS BOOTED
;DURING THE ORIGINAL BOOTUP PROCESS. IT REMAINS UNCHANGED
;DURING NORMAL OPERATION.

        .DEF    HERE=SYSPAG+$50
        .LOC    HERE,HERE-BIAS
SYSENF  .BYTE   $FC             ;FLAG SHOWING RE-ENTRY CONDITION
DEVMSK: .BYTE   $01             ;MASK SHOWING VALID UNITS
SYSDEV: .BYTE   0               ;UNIT SYSTEM IS ON
SYSBLK: .WORD   0               ;BLOCK SYSTEM FILE IS IN
SWPBLK: .WORD   0               ;BLOCK SWAP FILE IS IN
SYSDAT: .WORD   0               ;SYSTEM DATE GOES HERE
        .BYTE   0               ;3 LOCS
LINIDX: .WORD   $2FF            ;INPUT LINE POINTER ($FF=NULL)
NOWDEV: .BYTE   0               ;CURRENT BYTE I/O DEVICE
EXECUT: .BYTE   $FF             ;ZERO IF EXEC MODE IS ON
LOWER:  .BYTE   0               ;LOWER CASE SWITCH (O=UPPER)

        .DEF    HERE=SYSPAG+$68 ;LEAVE SPACE FOR LATER
        .LOC    HERE,HERE-BIAS

;I-0 INFORMATION BLOCK FOR UNIT DRIVERS:
UNIT:   .BYTE   0               ;CURRENT UNIT NUMBER
BLKNO:  .WORD   0               ;CURRENT BLOCK NUMBER
NBLKS:  .BYTE   0               ;NUMBER OF BLOCKS TO TRANSFER
FADDR:  .WORD   0               ;ADDRESS POINTER
ENDBLK: .WORD   0               ;AUXILLIARY PARAMETER

;OUTPUT FILE INFORMATION:
OTLBLK: .WORD   0               ;FIRST BLOCK OF OUTPUT FILE
OTHBLK: .WORD   0               ;LAST BLOCK OF OUTPUT FILE
OTFLG:  .BYTE   0               ;STATUS FLAGS
OTNO:   .BYTE   0               ;DIRECTORY NUMBER OF OUTPUT FILE
OTDEV:  .BYTE   0               ;UNIT NUMBER WHICH OUTPUT FILE I
        .BYTE   0               ;SPARE

;INPUT FILE INFORMATION:
INLBLK: .WORD   0               ;FIRST BLOCK OF INPUT FILE
INHBLK: .WORD   0               ;LAST BLOCK OF INPUT FILE
INFLG:  .BYTE   0               ;STATUS FLAGS
INNO:   .BYTE   0               ;DIRECTORY NUMBER OF INPUT FILE
INDEV:  .BYTE   0               ;UNIT NUMBER WHICH INPUT FILE IS
        .BYTE   0               ;SPARE


;SPACE FOR MORE FILES HERE

        .PAGE
        .DEF    HERE=SYSPAG+$C0
        .LOC    HERE,HERE-BIAS

;BYTE I/O DEVICE HANDLER ADDRESS TABLE:
DEVTAB: .WORD   $B5C0           ;0=LINE BUFFERED CONSOLE
        .WORD   $B480           ;1=CONSOLE DEVICE
        .WORD   NULDEV          ;2=PRINTER
        .WORD   $AD00           ;3=DISK FILES
        .WORD   NULDEV          ;4=RS232 SERIAL PORT
        .WORD   NULDEV          ;5=UNUSED
        .WORD   NULDEV          ;6=UNUSED
        .WORD   NULDEV          ;7=NULL DEVICE

;LINK VECTORS TO RESIDENT CODE:
KRENTR: JMP     RENTER          ;BOOT IN APEX (WARM START)
KSAVER: JMP     SAVER           ;PRESERVE CURRENT USER IMAGE
KRELOD: JMP     RELOAD          ;RELOAD APEX (COLD START)
KHAND:  JMP     HANDY           ;LINK TO BYTE I/O DEVICE
KSCAN:  JMP     FSCAN           ;FILE LOOKUP ROUTINE
KRESTD: JMP     RESTD           ;RESET DISK DRIVER
KREAD:  JMP     ADEVRB          ;READ CONTIGUOUS BLOCKS
KWRITE: JMP     DEVWOB          ;WRITE CONTIGUOUS BLOCKS
;LINKS FOR APEX EXEC USE:
KSAVS:  JMP     SAVESC          ;SAVE A SWAPPED MEMORY IMAGE
KRUN:   JMP     RUN             ;RUN A MEMORY IMAGE
KSAVA:  JMP     SAVEA           ;SAVE A MEMORY IMAGE
KGET:   JMP     GET             ;GET A MEMORY IMAGE

        .END
-------------------------------------------------------------------------------



