\APEX.XPL
\*** APEX V1.0 APRIL 1980 ***

\	COPYRIGHT 1980 BY P. BOYLE


'CODE'
ABS=0,		REM=2,		RESERVE=3,	SWAP=4,
CHIN=7,		CHOUT=8,	SKIP=9,
INTOUT=11,	TEXT=12,	INITI=13,	INITO=14,
CLOSE=15,	FRUN=28,	FSAVE=29,	FWRITE=30,
FREAD=31,	FASAVE=27,	FGET=26,
SPACE=18,	RAN=1,		ABORT=16,
REBEGIN=6,	RERUN=19;


\THE DIRECTORY
'ADDRESS'
	PRDEV,	\DEVICE ASSOSIATED WITH PRNAM
	TITLE,	\TITLE OF THE VOLUME
	PRNAME,	\THE REMEMBERED FILE
	FNAME,	\THE FILE NAMES
	FSTAT,	\THE FILE STATUS
	FLAGS,	\SPECIAL REQUEST FLAGS
	FREE1;	\UNUSED
\INTEGER ARRAYS IN THE DIRECTORY
'INTEGER'
	PMAXB,	\DISK SIZE, MAX BLOCK NUMBER
	DIRDAT,	\DIRECTORY DATE
	VOLUME,	\UNIQUE DISK ID NUMBER
	FDATE,	\DATE OF FILES
	FBLK,	\THE FIRST BLOCK
	LBLK;	\THE LAST BLOCK

\SOME ABSOLUTE ADDRES
'ADDRESS'
	COMPAG,PARM,IOPAG;

\THE SYSTEM GLOBALS:
'ADDRESS'
	RNAM,	\DEFAULT FILE NAME
	STAB,	\SORT POINTER ARRAY
	LOCNAM;	\LOCAL NAME OF FILE

'INTEGER'
	DRVSET,	\DRIVE SPECIFIED FLAG
	PAKFLG,	\PACKING WANTED?
	BAKFLG,	\BACKUPS WANTED?
	CHKFLG,	\CHECKS WANTED?
	RDEV,	\DEFAULT FILE DEVICE
	LOCDEV,	\DEVICE USER ASKED FOR
	DIRDEV,	\DEVICE WE HAVE THE DIRECTORY OF
	SYSDEV,	\THE SYSTEM DEVICE CURRENTLY
	DONE,	\KLUGE
	BLKSIZ,	\SIZE OF A BLOCK IN BYTES
	DIRSIZ,	\DIR SIZE
	SWAPSIZ,\SWAPPING SIZE
	DIRBLK,	\WHERE DIRECT IS
	SWAPBLK,\SWAPPING AREA
	SYSBLK,	\WHERE SYSTEM IS
	USERBLK,\FIRST USER BLOCK
	BACKBLK,\BLOCK TO PU BACKUP DIR IN
	SYSLEN,	\HOLDS LENGTH OF SYSTEM AREA ON DEVICE
	FIRBLK,	\FIRST BLOCK OF FILE
	LASBLK,	\LAST BLOCK OF FILE
	FLNO,	\NUMBER OF FILE
	ACTDEV,	\HOLDS DEVICE NUMBER OF ACTIVE DEVICE
	MAXBLK,	\HIGHEST BLOCK
	MAXFL,	\HIGHEST FILE NO
	CHAR,	\INPUT CHARACTER
	SWAPFLG,\=0 IF SWAPPING AREA IS INVALID
	SWITCH,	\USER FILE SWITCH
	ARG1,	\USER ARGUMENT
	ARG2,	\USER ARGUMENT
	SPECIAL,\SPECIAL BITS IN PROGRAM FILE REQUEST
	SYSDAT,	\SYSTEM DATE
	INSIZE,	\SIZE OF LAST OPENED INFILE
	INDATE,	\DATE OF LAST INFILE
	MAXSTB,	\SIZE OF STAB ARRAY
	GOTFIL,	\NAME SAW A FILE
	FILENO;	\RUN FILE NUMBER

\FOR MAIN
'INTEGER'HASH,I,L;



\ASCII CONSTANTS
'DEFINE'CR=13,EOF=26,TAB=9,BEL=7,FORM=12;

\FILE STATUS IN THE DIRECTORY
'DEFINE' NULL=0,TENTATIVE=255,REPLACE=254,VALID=1;

\FILE STATUS IN COMM AREA
'DEFINE' NOFILE=0,SETUP=1,CLOSED=255;

\SYSTEM REENTRY CONDITIONS
'DEFINE' SWAPIN=254,SAVEIN=255,BOOTIN=253,RELOAD=252;

\FAILED FLAG
'DEFINE' NONE=65535;

\DEFINE SOME OFFSETS INTO COMM PAGE

'DEFINE'
	STRTOFF=$15,		\USER BASE ADDRESS
	SIZEOFF=$17,		\PROGRAM SIZE IN PAGES
	DFOOFF=$21,		\DEFAULT EXT FOR OUTPUT FILE
	DFIOFF=$24,		\DEFAULT EXT FOR INPUT FILE
	DFSOFF=$27;		\SPECIAL DEFAULT FLAG BYTE

\DEFINE SOME OFFSETS INTO SYSTEM PAGE

'DEFINE'
	OTLBKL=$70,		\LOW BLOCK NUMBER
	OTLBKH=$71,
	OTHBKL=$72,		\HIGH BLOCK NUMBER
	OTHBKH=$73,
	OTFLG=$74,		\OUTPUT FILE STATUS FLAGS
	OTNO=$75,		\OUTPUT FILE NUMBER IN DIRECTORY
	OTDEV=$76,		\DEVICE NUMBER OUTPUT FILE IS ON

	INLBKL=$78,		\LOW BLOCK NUMBER
	INLBKH=$79,
	INHBKL=$7A,		\HIGH BLOCK NUMBER
	INHBKH=$7B,
	INFLG=$7C,		\INPUT FILE STATUS FLAG
	INNO=$7D,		\INPUT FILE NUMBER IN DIRECTORY
	INDEV=$7E,		\DEVICE NUMBER INPUT FILE IS ON

	SYSENT=$50,		\HOW WE REENTER THE SYSTEM
	OKDRVS=$51,		\TO GET UNIT PERMIT MASK
	DEFDEV=$52,		\THE SYSTEM UNIT NUMBER
	SYBLKX=$53		\THE SYSTEM BLOCK
	SWBLKX=$55		\THE SWAP BLOCK
	DATOFF=$57,		\OFFSETS TO SYSTEM DATE
	DATOF1=$58,
	DATOF2=$59;




	'PROCEDURE'NEXT;
	'BEGIN'
	CHAR:=CHIN(0);
	'IF' CHAR=^/ 'THEN' [SWITCH:=CHIN(0);NEXT];
	'IF'CHAR>=^a & CHAR<=^z'THEN'CHAR:=CHAR-32;
	'END';






	'PROCEDURE'CRLF;
	SKIP(0);






	'PROCEDURE'STR(TXT);
	'ADDRESS'TXT;
	TEXT(0,TXT);




	'PROCEDURE'NUM(I);
	'INTEGER'I;
	INTOUT(0,I);


	'PROCEDURE'NUMERIC;
	'EXIT'CHAR>=^0 & CHAR<=^9;



	'PROCEDURE'HEX;
	'EXIT'NUMERIC ! (CHAR>=^A & CHAR<=^Z);



	'PROCEDURE'NUMBER;
	'INTEGER'I,ADD;
'BEGIN'
'WHILE'('NOT'NUMERIC)&(CHAR#^$)'DO'NEXT;
I:=0;
'IF'CHAR=^$'THEN'
	'BEGIN'
	NEXT;
	'WHILE'HEX'DO'
		'BEGIN'
		'IF'CHAR<^A'THEN'ADD:=CHAR-^0
		'ELSE'ADD:=CHAR-^A+10;
		I:=I*16+ADD;
		NEXT;
		'END';
	'END'
'ELSE'
	'WHILE'NUMERIC'DO'[I:=I*10+CHAR-^0;NEXT];

'EXIT'I;
'END';


	'PROCEDURE'ALPH;

\CHECK FOR ALPHANUMERIC OR "?"
'EXIT'NUMERIC!(CHAR>=^A&CHAR<=^Z)!CHAR=^?;


	'PROCEDURE'ERROR(LINE);
'ADDRESS'LINE;
'BEGIN'
CHOUT(0,BEL);
STR("NOPE-");STR(LINE);
PARM(SYSENT):=BOOTIN;
REBEGIN;
'END';


	'PROCEDURE'FILERR;
'ADDRESS'LINE;
'BEGIN'
CHOUT(0,BEL);
STR("I CANT FIND ");
NUM(LOCDEV);
CHOUT(0,^:);
'FOR'I:=0,7'DO'
	'IF'LOCNAM(I)#^ 
	'THEN'CHOUT(0,LOCNAM(I));
'IF'LOCNAM(8)#^ 'THEN'
	'BEGIN'
	CHOUT(0,^.);
	'FOR'I:=8,10'DO'
		CHOUT(0,LOCNAM(I));
	'END';
PARM(SYSENT):=BOOTIN;
REBEGIN;
'END';





	'PROCEDURE'VALDRV(DRV);
'INTEGER'DRV,MASK,I;
'BEGIN'
'IF'DRV<0 ! DRV>7'THEN'ERROR("BAD UNIT NUMBER")
'ELSE'	'BEGIN'
	MASK:=1;
	'FOR'I:=1,DRV'DO'MASK:=MASK+MASK;
	'IF'(MASK&PARM(OKDRVS))=0'THEN'
		ERROR("YOU DONT HAVE THAT UNIT");
	'END';
'END';


	'PROCEDURE'NAME(DEFAULT,DDEV);
'ADDRESS'DEFAULT,DDEV;
'INTEGER'K;

'BEGIN'
\READ IN A FILE NAME. INTO LOCFILE. SET TO DEFAULT EXTENTION
\IF NONE WAS GIVEN.  EXPAND *'S INTO FIELDS OF ?'S.
\LEAVE CHAR SET THE TERMINATION CHARACTER - FILE OR NOT.
\LEAVE THE NAME FIELD SET TO BLANKS IF NO FILE.
\THERE IS NO FILE IF CHAR IS RETURN OR A NON ALPHA IS
\THE FIRST NON-BLANK SEEN.  ALSO SET SWITCHES IF ANY.

'IF'CHAR#CR'THEN'NEXT;
GOTFIL:='FALSE';
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'
	'BEGIN'
	LOCDEV:=NUMBER;
	DRVSET:='TRUE';
	'END'
'ELSE'[LOCDEV:=DDEV;DRVSET:='FALSE'];
VALDRV(LOCDEV);
'IF'CHAR=^:'THEN'[NEXT;GOTFIL:='TRUE'];
K:=0;
'IF'CHAR#^*'THEN'
	'BEGIN'
	'WHILE'ALPH'DO'
		'BEGIN'
		LOCNAM(K):=CHAR;
		'IF'K<8'THEN'K:=K+1;
		NEXT;
		GOTFIL:='TRUE';
		'END';
	'FOR'K:=K,7'DO'LOCNAM(K):=^ ;
	'END'
'ELSE'
	'BEGIN'
	'FOR'K:=0,7'DO'LOCNAM(K):=^?;
	NEXT;
	GOTFIL:='TRUE';
	'END';

K:=8;
'IF'CHAR=^.'THEN'
	'BEGIN'
	GOTFIL:='TRUE';
	NEXT;
	'IF'CHAR#^*'THEN'
		'BEGIN'
		'WHILE'ALPH'DO'
			'BEGIN'
			LOCNAM(K):=CHAR;
			'IF'K<11'THEN'K:=K+1;
			NEXT;
			'END';
		'FOR'K:=K,10'DO'LOCNAM(K):=^ ;
		'END'
	'ELSE'['FOR'K:=8,10'DO'LOCNAM(K):=^?;NEXT];
	'END'
'ELSE''BEGIN'
	LOCNAM(8):=DEFAULT(0);
	LOCNAM(9):=DEFAULT(1);
	LOCNAM(10):=DEFAULT(2)&127;
	K:=11;
	'END';
'IF'LOCNAM(0)=^ 'THEN'
   'FOR'K:=0,7'DO'LOCNAM(K):=RNAM(K);

'IF'CHAR=^='THEN'
	'BEGIN'
	ARG1:=NUMBER;
	'IF'CHAR=^,'THEN'ARG2:=NUMBER
	'ELSE'ARG2:=NONE;
	'END'
'ELSE'[ARG1:=NONE;ARG2:=NONE];
'END';\NAME






	'PROCEDURE'PRDAT(DAT);
	'INTEGER'DAT,DAY,MO;

'BEGIN'
'IF'DAT<=0'THEN'[STR("NO DATE");'EXIT'];
DAT:=DAT/32;DAY:=REM(0);
DAT:=DAT/16;MO:=REM(0);
NUM(MO);CHOUT(0,^-);
NUM(DAY);CHOUT(0,^-);
NUM(DAT+76);
'IF'MO<10'THEN'CHOUT(0,^ );
'IF'DAY<10'THEN'CHOUT(0,^ );
'END';


	'FPROC'DODAT;

	'PROCEDURE'RDDIR(DEV);
	'INTEGER'DEV,CHECK;

'BEGIN'
VALDRV(DEV);
DIRDEV:=DEV;
FREAD(DEV,DIRBLK,FNAME,DIRSIZ);
MAXBLK:=PMAXB(0);
'IF'DEV#SYSDEV'THEN''EXIT';
\IS SYSTEM DATE VALID?
CHECK:='NOT'(PARM(DATOFF)&PARM(DATOF1));
CHECK:=$FF&CHECK;
CHECK:=PARM(DATOF2) = CHECK;
\IF SO SET IT UP
'IF'CHECK'THEN'
   SYSDAT:=PARM(DATOFF)+SWAP(PARM(DATOF1))
\ELSE GET IT FROM THE DISK
'ELSE''BEGIN'
	STR("DATE FROM SYSTEM UNIT: ");
	SYSDAT:=DIRDAT(0);
	PARM(DATOFF):=SYSDAT;
	PARM(DATOF1):=SWAP(SYSDAT);
	PARM(DATOF2):='NOT'(PARM(DATOFF)&PARM(DATOF1));
	DODAT;
	CRLF;
	'END';
'END';


	'PROCEDURE'CHKDIR(DEV);
'INTEGER'DEV;
'BEGIN'
'IF'DIRDEV=DEV'THEN''EXIT';
RDDIR(DEV);
'END';



	'PROCEDURE'WRTDIR;
	'INTEGER'BLK;
	'DEFINE'VOLOFF=458;

'BEGIN'
BLK:=RESERVE(DIRSIZ*BLKSIZ);
FREAD(DIRDEV,DIRBLK,BLK,DIRSIZ);
'IF' BLK(VOLOFF) # VOLUME(0) 'THEN'
	ERROR("YOU CHANGED DISKS!");
DIRDAT(0):=SYSDAT;
FWRITE(DIRDEV,DIRBLK,FNAME,DIRSIZ);
'END';



	'PROCEDURE'LOOKUP(FILE);
	'INTEGER'FILE,L;

'BEGIN'
\LOOKUP THE FILENAME IN LOCFILE BEGINNING AT
\DIRECTORY ENTRY NUMBER FILE.
\TAKE ? AS WILD
CHKDIR(LOCDEV);
'LOOP'	'BEGIN'
	'IF'FSTAT(FILE)=VALID'THEN'
		'BEGIN'
		L:=0;
		'LOOP'	'BEGIN'
			'IF'(LOCNAM(L)#^?)&(FNAME(FILE*11+L)#LOCNAM(L))
			'THEN''QUIT';
			L:=L+1;
			'IF'L>=11'THEN''QUIT';
			'END';
		'IF'L=11'THEN''QUIT'\WE HAVE IT\;
		'END';
	FILE:=FILE+1;
	'IF'FILE>MAXFL'THEN''QUIT';
	'END';
'EXIT''IF'FILE<=MAXFL'THEN'FILE'ELSE'NONE;
'END';\LOOKUP


	'PROCEDURE'PRNAM(FILE);
	'ADDRESS'FILE;
	'INTEGER'K;

'BEGIN'
'FOR'K:=0,7'DO'CHOUT(0,FILE(K));
CHOUT(0,^.);
'FOR'K:=8,10'DO'CHOUT(0,FILE(K));
'END';






	'PROCEDURE'PRINT(FILE,FLAG);
	'INTEGER'FILE,FLAG,MIN,MAX,K,SIZE;

'BEGIN'
PRNAM(FNAME+FILE*11);
MIN:=FBLK(FILE);
MAX:=LBLK(FILE);
SIZE:=MAX-MIN+1;
STR("  ");NUM(SIZE);
'IF'SIZE<10'THEN'CHOUT(0,^ );
'IF'SIZE<100'THEN'CHOUT(0,^ );
'IF''NOT'FLAG'THEN''EXIT';
CHOUT(0,^ );
PRDAT(FDATE(FILE));
CHOUT(0,^ );
NUM(MIN);
CHOUT(0,^-);NUM(MAX);
'END';


	'PROCEDURE'PRTDEV(FILE);
	'INTEGER'FILE;
'BEGIN'
NUM(DIRDEV);
CHOUT(0,^:);
PRINT(FILE,'FALSE');
'END';







	'PROCEDURE'DODAT;
	'INTEGER'DAY,MO,YR,DAYWRD,X;

'BEGIN'
DAYWRD:=RESERVE(14);
DAYWRD(0):="MON";
DAYWRD(1):="TUE";
DAYWRD(2):="WED";
DAYWRD(3):="THR";
DAYWRD(4):="FRI";
DAYWRD(5):="SAT";
DAYWRD(6):="SUN";
'IF'SYSDAT<=0'THEN''EXIT';
YR:=SYSDAT/32;DAY:=REM(0);
YR:=YR/16;MO:=REM(0);
'IF'MO<=2'THEN'[MO:=MO+10;YR:=YR-1]'ELSE'MO:=MO-2;
X:=REM(((26*MO-2)/10+DAY+YR+YR/4+60)/7);
STR(DAYWRD(X));CHOUT(0,^ );PRDAT(SYSDAT);
'END';



	'PROCEDURE'RDDAT;
	'INTEGER'MO,DAY,FILE,DOFIL;

'BEGIN'
DOFIL:=(CHAR=^ );
NAME(RNAM+8,ACTDEV);
'IF'DOFIL'THEN'
	'BEGIN'
	FILE:=LOOKUP(0);
	'IF'FILE#NONE'THEN'FDATE(FILE):=SYSDAT
	'ELSE'FILERR;
	STR(" REDATE: ");
	PRTDEV(FILE);
	CRLF;
	WRTDIR;
	'END'
'ELSE'
	'BEGIN'
	CHKDIR(SYSDEV);
	'REPEAT'
		'BEGIN'
		STR("ENTER NEW DATE ");
		MO:=NUMBER;
		DAY:=NUMBER;
		SYSDAT:=((NUMBER-76)*16+MO)*32+DAY;
		DIRDAT(0):=SYSDAT;
		PARM(DATOFF):=SYSDAT;
		PARM(DATOF1):=SWAP(SYSDAT);
		PARM(DATOF2):='NOT'(PARM(DATOFF)&PARM(DATOF1));
		'END'
	'UNTIL'SYSDAT>0;
	STR("TODAY IS: ");DODAT;CRLF;
	WRTDIR;
	'END';
'END';



	'PROCEDURE'SORT;
	'INTEGER'I,J,T;

'BEGIN'\BUBBLE SORT THE FILES INTO ACENDING FBLK
J:=0;
'FOR'I:=0,MAXFL'DO'
	'IF' FSTAT(I)=VALID'THEN'
		[STAB(J):=I;J:=J+1];
MAXSTB:=J-1;
'FOR'I:=0,MAXSTB-1'DO'
'IF'FBLK(STAB(I+1))<FBLK(STAB(I))'THEN'
	\WE ARE OUT OF ORDER SO...
	'BEGIN'
	J:=I;
	'REPEAT''BEGIN'
		T:=STAB(J);
		STAB(J):=STAB(J+1);
		STAB(J+1):=T;
		J:=J-1;
		'END'
	'UNTIL'(FBLK(STAB(J))<FBLK(STAB(J+1)))!(J<0);
	'END';
'END';






	'PROCEDURE'EMSIZ(I);
	'INTEGER'I;
'BEGIN'
FIRBLK:='IF'I<0'THEN'USERBLK'ELSE'(LBLK(STAB(I))+1);
LASBLK:='IF'(MAXSTB<0)!(MAXSTB=I)'THEN'MAXBLK'ELSE'
	(FBLK(STAB(I+1))-1);
'EXIT''IF'LASBLK>=FIRBLK'THEN'LASBLK-FIRBLK+1'ELSE'0;
'END';






	'PROCEDURE'BIGBLK;
	'INTEGER'LMAX,FMAX,I,SIZE;

'BEGIN'
\FIND THE BIGEST EMPTY-SET FIRBLK AND LASBLK TO IT
SORT;
LMAX:=EMSIZ(-1);
FMAX:=-1;
'FOR'I:=0,MAXSTB'DO'
	'BEGIN'
	SIZE:=EMSIZ(I);
	'IF'SIZE>LMAX'THEN'[LMAX:=SIZE;FMAX:=I];	
	'END';
'IF'LMAX=0'THEN''EXIT'0;
'EXIT'EMSIZ(FMAX);
'END';






	'PROCEDURE'SHOWDIR;
	'INTEGER'I,SUM,END,START,K,FILENO,A,FLAG;

'BEGIN'
K:=0;
CHOUT(0,FORM);
DODAT;STR("  ");
STR("V:");NUM(VOLUME(0));
STR("  UNIT:");NUM(DIRDEV);
CRLF;STR(TITLE);CRLF;
'IF'GOTFIL'THEN'
	'BEGIN'
	FLAG:='TRUE';
	FILENO:=LOOKUP(0);
	'WHILE'FILENO#NONE'DO'
		'BEGIN'
		FLAG:='FALSE';
		CRLF;
		PRINT(FILENO,'TRUE');
		K:=K+1;
		'IF' K=14 'THEN' A:=CHIN(0);
		FILENO:=LOOKUP(FILENO+1);
		'END';
	'IF'FLAG'THEN'ERROR("NO FILES OF THAT FORM");
	'END'
'ELSE''BEGIN'
	SORT;
	'FOR'I:=0,MAXSTB'DO'
		'BEGIN'
		'IF'SWITCH#^L'THEN'
			'BEGIN'
			'IF' REM(K/2)=0 'THEN' CRLF 'ELSE' STR("    ");
			PRNAM(FNAME+STAB(I)*11);
			'END'
		'ELSE'
			'BEGIN'
			CRLF;
			PRINT(STAB(I),'TRUE');
			'IF' K=17 'THEN' A:=CHIN(0);
			'END';
		K:=K+1;
		'END';
	'END';
SUM:=MAXBLK-USERBLK+1;
'FOR'I:=0,MAXFL'DO'
	'IF'FSTAT(I)=VALID'THEN'
		'BEGIN'
 		END:=LBLK(I);
		START:=FBLK(I);
		SUM:=SUM-(END-START+1);
		'END';
'IF'SUM<0'THEN'SUM:=0;
CRLF;STR("FREE: ");
NUM(SUM);
STR("   MAX: ");
NUM(BIGBLK);
CRLF;
CRLF;
'END';



	'PROCEDURE'DIR;

'BEGIN'
NAME(RNAM+8,ACTDEV);
CHKDIR(LOCDEV);
SHOWDIR;
'END';




	'PROCEDURE'FIND(SIZE);
	'INTEGER'SIZE,I;

'BEGIN'
\FIND FIXED SIZE SPACE, SET FIRST AND LAST BLOCK TO IT
'IF'SIZE<=0'THEN'ERROR("UNREASONABLE FILE SIZE");
SORT;
I:=-1;
'WHILE'EMSIZ(I)<SIZE & I<=MAXSTB'DO'I:=I+1;
LASBLK:=FIRBLK+SIZE-1;
'EXIT'I<=MAXSTB;
'END';






	'PROCEDURE'VERIFY;

'BEGIN'
STR(" - VERIFY? ");
INITI(0);
'EXIT'CHIN(0)=^Y;
'END';






	'PROCEDURE'ZERO;
	'INTEGER'I,J;

'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'ACTDEV:=NUMBER;
CHKDIR(ACTDEV);
STR("ABOUT TO ZERO UNIT ");
NUM(DIRDEV);
'IF''NOT'VERIFY'THEN''EXIT';
'FOR'I:=0,MAXFL'DO'FSTAT(I):=NULL;
WRTDIR;
'END';






	'PROCEDURE'NEWTITLE;
	'INTEGER'I;

'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'ACTDEV:=NUMBER;
CHKDIR(ACTDEV);		\MAKE SURE WE HAVE A VALID DIRECTORY
I:=0;
'WHILE''NOT'ALPH'DO'NEXT;
'WHILE'CHAR#CR'DO'
	'BEGIN'
	TITLE(I):=CHAR;
	'IF'I<31'THEN'I:=I+1;
	NEXT;
	'END';
I:=I-1;
TITLE(I):=TITLE(I)+128;
VOLUME(0):=ABS(SYSDAT*256+RAN(256));
FWRITE(DIRDEV,DIRBLK,FNAME,DIRSIZ);
'END';






	'PROCEDURE'CLEAR(FILE);
	'INTEGER'FILE,MIN,MAX,I;

'BEGIN'
\REMOVE A ENTRY FROM THE DIRECTORY
'IF'FSTAT(FILE)#VALID'THEN''EXIT';
FSTAT(FILE):=NULL;
STR("REMOVING ");
PRTDEV(FILE);
CRLF;
'END';






	'PROCEDURE'REMOVE;
	'INTEGER'FILENO;
'BEGIN'
\REMOVE ANY COLLISIONS WITH LOCFILE
FILENO:=LOOKUP(0);
'IF'FILENO#NONE'THEN'CLEAR(FILENO);
'END';






	'PROCEDURE'GETNAM(FILE);
	'INTEGER'FILE,I;

'FOR'I:=0,10'DO'LOCNAM(I):=FNAME(FILE*11+I);


	'PROCEDURE'NAMECHECK;
	'INTEGER'K;
'BEGIN'
'IF'(LOCNAM(8)=^B)&(LOCNAM(9)=^A)&(LOCNAM(10)=^K)
'THEN'
ERROR("YOU MAY NOT MAKE BAK FILES");
'FOR'K:=0,10'DO'
	'IF'LOCNAM(K)=^?'THEN'
	ERROR("FILE NAME FUZZY");
'END';



	'PROCEDURE'ENTER;
	'INTEGER'K;

'BEGIN'
\ENTER A TENTATIVE FILE AND ITS BLOCKS INTO THE DIRECTORY
\DONT RESERVE THE BLOCKS, DONT MARK IT VALID

NAMECHECK;

\FIND AN EMPTY DIR SLOT
FLNO:=0;
'WHILE'FSTAT(FLNO)=VALID'DO'
	'BEGIN'
	FLNO:=FLNO+1;
	'IF'FLNO>MAXFL'THEN'
	ERROR("DIRECTORY FULL");
	'END';
\NOW COPY THE NAME INTO IT
'FOR'K:=0,10'DO'FNAME(FLNO*11+K):=LOCNAM(K);
FBLK(FLNO):=FIRBLK;
LBLK(FLNO):=LASBLK;
FSTAT(FLNO):='IF'(SPECIAL&1)&BAKFLG
	'THEN'TENTATIVE'ELSE'REPLACE;
FDATE(FLNO):='IF'SPECIAL&4'THEN'INDATE'ELSE'SYSDAT;
'END';






  'PROCEDURE'COPY(FBLK,TBLK,SIZE);
  'INTEGER'FBLK,TBLK,SIZE,BUFSIZ,XFER;
  'ADDRESS'BUFFER;

'BEGIN'\CHECK ONLY IF TBLK<0
'IF'TBLK>0 & FBLK<TBLK'THEN'
ERROR("COPY TROUBLE");
BUFSIZ:=$40;
BUFFER:=$2000;\USE HIRES

'WHILE' SIZE > 0 'DO'
  'BEGIN'
  XFER:='IF'SIZE>BUFSIZ'THEN'BUFSIZ'ELSE'SIZE;
  FREAD(LOCDEV,FBLK,BUFFER,XFER);
  FBLK:=FBLK+XFER;
  'IF' TBLK >= 0 'THEN'
	'BEGIN'
	FWRITE(LOCDEV,TBLK,BUFFER,XFER);
	TBLK:=TBLK+XFER;
	'END';
  SIZE:=SIZE-XFER;
  'END';
SWAPFLG:='FALSE';
'END';\COPY






	'PROCEDURE'PACK(FILE);
	'INTEGER'FILE,SIZE;

'BEGIN'
'IF''NOT'PAKFLG'THEN''EXIT';\PACKING IS OFF
SIZE:=LBLK(FILE)-FBLK(FILE)+1;
'IF''NOT'FIND(SIZE)'THEN''EXIT';
'IF'FBLK(FILE)<=FIRBLK'THEN''EXIT';
\WE CAN PACK IT, SO.....
STR("PACKING: ");
PRTDEV(FILE);
CRLF;
COPY(FBLK(FILE),FIRBLK,SIZE);
FBLK(FILE):=FIRBLK;
LBLK(FILE):=LASBLK;
'END';\PACK






	'PROCEDURE'CLOFIL(FILE,PAF);
	'INTEGER'FILE,PAF,S;

'BEGIN'
\CLOSE THE TENTATIVE FILE BY DIRECTORY NUMBER
\ASSUME IT HAS BEEN ENTERED - REMOVE COLLISIONS
S:=FSTAT(FILE);
'IF'(S#TENTATIVE)&(S#REPLACE)'THEN'
	'BEGIN'
	CRLF;
	STR("FILE NOT OPEN");
	CRLF;
	'EXIT';
	'END';
GETNAM(FILE);
REMOVE;
FSTAT(FILE):=VALID;
STR("CLOSING: ");
PRTDEV(FILE);
CRLF;
'IF'PAF'THEN'PACK(FILE);
'IF'CHKFLG'THEN'COPY(FBLK(FILE),-1,LBLK(FILE)-FBLK(FILE)+1);
'END';






	'PROCEDURE'MAKE;
	'INTEGER'K,FILENO,TEXT;
	'ADDRESS'BLOCK;
'BEGIN'
'IF'CHAR#^ 'THEN'ERROR("MAKE WHAT?");
NAME(RNAM+8,ACTDEV);

FILENO:=LOOKUP(0);
'IF' FILENO#NONE 'THEN'
	'BEGIN'
	STR("I WILL MUNCH OLD ONE! ");
	'IF' 'NOT' VERIFY 'THEN' 'EXIT'
		'ELSE' REMOVE;
	'END';
'IF'ARG1=NONE'THEN'
	'BEGIN'
	ARG1:=1;
	ARG2:=NONE;
	TEXT:='TRUE';
	'END'
'ELSE'TEXT:='FALSE';

'IF'ARG2=NONE'THEN'
	'BEGIN'
	'IF''NOT'FIND(ARG1)'THEN'
	ERROR("NOT ENOUGH SPACE ON THAT UNIT");
	'END'
'ELSE'	'BEGIN'
	FIRBLK:=ARG2;
	LASBLK:=ARG2+ARG1-1;
	'END';
ENTER;
'IF'TEXT'THEN'
	'BEGIN'
	BLOCK:=RESERVE(256);
	BLOCK(0):=$1A;
	FWRITE(LOCDEV,FIRBLK,BLOCK,1);	
	'END';
CLOFIL(FLNO,'FALSE');
WRTDIR;
'END';






	'PROCEDURE'DELETE;
	'INTEGER'FLAG,FILENO;

'BEGIN'
NAME("BAK",ACTDEV);
'IF''NOT'GOTFIL'THEN'
	ERROR("DELETE WHAT?");
FLAG:='FALSE';
FILENO:=LOOKUP(0);
'WHILE'FILENO#NONE'DO'
	'BEGIN'
	CLEAR(FILENO);
	FLAG:='TRUE';
	FILENO:=LOOKUP(FILENO+1);
	'END';
'IF'FLAG'THEN'
	'BEGIN'
	'IF'VERIFY'THEN'WRTDIR'ELSE'RDDIR(LOCDEV);
	'END'
'ELSE'ERROR("NO SUCH FILES FOUND");
'END';



	'PROCEDURE'SAVE;
	'INTEGER'SIZE;
	'ADDRESS'BLOCK;

'BEGIN'
'IF'CHAR#^ 'THEN'ERROR("SAVE AS WHAT?");
NAME("SAV",ACTDEV);
'IF''NOT'SWAPFLG'THEN'
ERROR("SAVED AREA IS NOT VALID");
BLOCK:=RESERVE(256);
FREAD(SYSDEV,SWAPBLK,BLOCK,1);
'IF'ARG1#NONE'THEN'
	'BEGIN'
	'IF'ARG2=NONE'THEN'
	  ERROR("WHAT ENDING ADDRESS?");
	BLOCK(STRTOFF):=ARG1;
	BLOCK(STRTOFF+1):=SWAP(ARG1);
	SIZE:=$FF&SWAP(ARG2-ARG1);
	BLOCK(SIZEOFF):=SIZE+1;
	FWRITE(SYSDEV,SWAPBLK,BLOCK,1);
	'END';
SIZE:=1+BLOCK(SIZEOFF);
CHKDIR(LOCDEV);
'IF''NOT'FIND(SIZE)'THEN'
   ERROR("NOT ENOUGH SPACE ON THAT UNIT");
ENTER;
WRTDIR;
PARM(INFLG):=NOFILE;
PARM(INNO):=FLNO;
PARM(INDEV):=LOCDEV;
FSAVE(LOCDEV,FIRBLK);
'END';






	'PROCEDURE'DEFEXT(EXT);
	'ADDRESS'EXT;
	'INTEGER'I;

'BEGIN'
'IF'LOCNAM(8)#^@'THEN''EXIT';
'FOR'I:=0,2'DO'LOCNAM(I+8):=EXT(I);
LOCNAM(10):=LOCNAM(10)&127;
EXT(2):=EXT(2)!128;
STR(EXT);CRLF;
'END';






	'PROCEDURE'OPENOT;
	'INTEGER'FILENO;

'BEGIN'
\IF SWITCH IS R THEN OPEN EXISTING FILE ELSE
\OPEN THE BIGGEST POSSIBLE TENTATIVE
\AS AN OUTPUT FILE FOR USER
\USE THE NAME IN LOCFILE
'IF'LOCNAM(0)=^ 'THEN''EXIT';
CHKDIR(LOCDEV);
'IF'SWITCH=^R'THEN'
	'BEGIN'
	FILENO:=LOOKUP(0);
	'IF'FILENO=NONE'THEN'FILERR;
	PARM(OTLBKL):=FBLK(FILENO);
	PARM(OTLBKH):=SWAP(FBLK(FILENO));
	PARM(OTHBKL):=LBLK(FILENO);
	PARM(OTHBKH):=SWAP(LBLK(FILENO));
	PARM(OTFLG):=SETUP;
	PARM(OTNO):=FILENO;
	PARM(OTDEV):=LOCDEV;
	STR("OUTFILE: ");
	PRTDEV(FILENO);
	CRLF;
	'END'
'ELSE'	'BEGIN'
	BIGBLK;
	ENTER;
	'IF'(SPECIAL&2)&((LASBLK-FIRBLK)<INSIZE)
		'THEN'ERROR("YOUR OUT FILE IS TOO SMALL");
	WRTDIR;
	PARM(OTLBKL):=FIRBLK;
	PARM(OTLBKH):=SWAP(FIRBLK);
	PARM(OTHBKL):=LASBLK;
	PARM(OTHBKH):=SWAP(LASBLK);
	PARM(OTFLG):=SETUP;
	PARM(OTNO):=FLNO;
	PARM(OTDEV):=LOCDEV;
	STR("OUTFILE: ");
	PRTDEV(FLNO);
	CRLF;
	'END';
FWRITE(DIRDEV,BACKBLK,FNAME,DIRSIZ);
'END';\OPENOT






	'PROCEDURE'OPENIN;
	'INTEGER'FILENO;

'BEGIN'
\OPEN USERS INPUT FILE
'IF'LOCNAM(0)=^ 'THEN''EXIT';
CHKDIR(LOCDEV);
FILENO:=LOOKUP(0);
'IF'FILENO=NONE'THEN'FILERR;
PARM(INLBKL):=FBLK(FILENO);
PARM(INLBKH):=SWAP(FBLK(FILENO));
PARM(INHBKL):=LBLK(FILENO);
PARM(INHBKH):=SWAP(LBLK(FILENO));
PARM(INFLG):=SETUP;
PARM(INNO):=FILENO;
PARM(INDEV):=LOCDEV;
INSIZE:=LBLK(FILENO)-FBLK(FILENO);
INDATE:=FDATE(FILENO);
STR(" INFILE: ");
PRTDEV(FILENO);
CRLF;
'END';






	'PROCEDURE'OPEN(DEFO,DEFI);
	'ADDRESS'DEFO,DEFI,OUTNAM;
	'INTEGER'I,OUTDEV,INFL,OTFL;

'BEGIN'
'IF'(DEFO(0)=^ )&(DEFI(0)=^ )'THEN''EXIT';

'IF'CHAR#^ 'THEN''EXIT';
INFL:='FALSE';OTFL:='FALSE';

OUTNAM:=RESERVE(11);
NAME("@@@",ACTDEV);
'IF'GOTFIL'THEN'OTFL:='TRUE';
'IF'CHAR=^<'THEN'
	'BEGIN'
	'FOR'I:=0,10'DO'OUTNAM(I):=LOCNAM(I);
	OUTDEV:=LOCDEV;
	NAME("@@@",ACTDEV);
	'IF'GOTFIL'THEN'INFL:='TRUE';
	'END'
'ELSE'
	'BEGIN'
	'FOR'I:=0,7'DO'OUTNAM(I):=LOCNAM(I);
	OUTDEV:=LOCDEV;
	OUTNAM(8):=^@;
	INFL:='TRUE';OTFL:='TRUE';
	'END';

'IF'LOCNAM(8)=^@'THEN'
	'IF'DEFI(0)#^@'THEN''FOR'I:=0,2'DO'LOCNAM(8+I):=DEFI(I)
	'ELSE''FOR'I:=8,10'DO'LOCNAM(I):=RNAM(I);
'IF'INFL & (DEFI(0)#^ )'THEN'OPENIN;

'IF'OUTNAM(8)=^@'THEN'
	'IF'DEFO(0)#^@'THEN''FOR'I:=0,2'DO'OUTNAM(8+I):=DEFO(I)
	'ELSE''FOR'I:=8,10'DO'OUTNAM(I):=LOCNAM(I);
'FOR'I:=0,10'DO'LOCNAM(I):=OUTNAM(I);
LOCDEV:=OUTDEV;
'IF'OTFL & (DEFO(0)#^ )'THEN'OPENOT;

'END';\OPEN






	'PROCEDURE'BACKDIR;
'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'ACTDEV:=NUMBER;
'IF'SWITCH=^B'THEN'
	'BEGIN'
	STR("BACKING DIRECTORY ON UNIT ");
	NUM(ACTDEV);
	CRLF;
	FREAD(ACTDEV,DIRBLK,FNAME,DIRSIZ);
	FWRITE(ACTDEV,BACKBLK,FNAME,DIRSIZ);
	'END'
'ELSE''BEGIN'
	FREAD(ACTDEV,BACKBLK,FNAME,DIRSIZ);
	DIRDEV:=ACTDEV;
	MAXBLK:=PMAXB(0);
	'IF'SWITCH=^W'THEN'
		'BEGIN'
		FWRITE(ACTDEV,DIRBLK,FNAME,DIRSIZ);
		STR("DIRECTORY RE-WRITTEN ON UNIT ");
		NUM(ACTDEV);CRLF;
		'END'
	'ELSE'	'BEGIN'
		GOTFIL:='FALSE';
		SHOWDIR;
		'END';
	'END';
DIRDEV:=$FF;
'END';






	'PROCEDURE'RUN(RUNFL);
	'INTEGER'RUNFL,FIRBLK,I,DEV;
	'ADDRESS'BLOCK,DEFO,DEFI;

'BEGIN'
BLOCK:=RESERVE(256);
DEFO:=RESERVE(3);
DEFI:=RESERVE(3);
FIRBLK:=FBLK(RUNFL);
FREAD(ACTDEV,FIRBLK,BLOCK,1);
'FOR'I:=0,2'DO'[DEFO(I):=BLOCK(DFOOFF+I)];
'FOR'I:=0,2'DO'[DEFI(I):=BLOCK(DFIOFF+I)];
SPECIAL:=BLOCK(DFSOFF);
DEV:=ACTDEV;
ACTDEV:=RDEV;
OPEN(DEFO,DEFI);
CRLF;
FRUN(DEV,FIRBLK);
'END';



	'PROCEDURE'GET;
	'INTEGER'FILENO;

'BEGIN'
'IF'CHAR#^ 'THEN'
	ERROR("GET WHAT?");
NAME("SAV",ACTDEV);
FILENO:=LOOKUP(0);
'IF'FILENO=NONE'THEN'FILERR;
FGET(LOCDEV,FBLK(FILENO));
'END';






	'PROCEDURE'INIT;
	'INTEGER'I,FILE;
	'ADDRESS'SYSFIL;
'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'ACTDEV:=NUMBER;
STR("RE-WRITE SYSTEM ON UNIT ");
NUM(ACTDEV);
'IF''NOT'VERIFY'THEN''EXIT';
LOCDEV:=ACTDEV;
SYSFIL:="SYSTEM  SYS";
'FOR'I:=0,9'DO'LOCNAM(I):=SYSFIL(I);
LOCNAM(10):=SYSFIL(10)&$7F;
FILE:=LOOKUP(0);
'IF'FILE=NONE'THEN'
   ERROR("SYSTEM FILE MUST PRE-EXIST");
FASAVE(LOCDEV,FBLK(FILE));
'END';



	'PROCEDURE'RESTART(I);
	'INTEGER'I;

'BEGIN'
'IF''NOT'SWAPFLG'THEN'
	'BEGIN'
	STR("I WILL SWAP TO UNKNOWN STATE");
	'IF''NOT'VERIFY'THEN''EXIT';
	'END';
'IF'I'THEN'FRUN(SYSDEV,SWAPBLK)'ELSE'FGET(SYSDEV,SWAPBLK);
'END';




	'PROCEDURE'RENAME;
	'INTEGER'I,FILENO,DEV;
	'ADDRESS'TEMP;

'BEGIN'
TEMP:=RESERVE(11);
NAME(RNAM+8,ACTDEV);
NAMECHECK;
'IF'('NOT'GOTFIL)!(CHAR#^<)'THEN'
ERROR("UNCLEAR SYNTAX");
FILENO:=LOOKUP(0);
'IF'FILENO#NONE'THEN'
ERROR("FILE NAME IN USE");
'FOR'I:=0,10'DO'TEMP(I):=LOCNAM(I);

DEV:=LOCDEV;
NAME(RNAM+8,DEV);
'IF'DEV#LOCDEV'THEN'
ERROR("CANNOT CHANGE UNIT");
'IF'TEMP(8)=^@'THEN''FOR'I:=8,10'DO'TEMP(I):=LOCNAM(I);
FILENO:=LOOKUP(0);
'IF'FILENO=NONE'THEN'FILERR;
STR("RENAME: ");
PRTDEV(FILENO);
CRLF;
'FOR'I:=0,10'DO'FNAME(FILENO*11+I):=TEMP(I);
STR(" TO BE: ");
PRTDEV(FILENO);
CRLF;
WRTDIR;
'END';



	'PROCEDURE'UPDATE;
	'INTEGER'I,FL,RSAV,FILENO;

'BEGIN'
ACTDEV:=PARM(OTDEV);
LOCDEV:=ACTDEV;
CHKDIR(ACTDEV);
FL:=PARM(OTNO);
'IF'FSTAT(FL)=TENTATIVE'THEN'
	'BEGIN'
	GETNAM(FL);
	FILENO:=LOOKUP(0);
	'IF'FILENO#NONE'THEN'
		'BEGIN'
		\RESOLVE THE COLLISION
		RSAV:=FILENO;
		LOCNAM(8):=^B;LOCNAM(9):=^A;LOCNAM(10):=^K;
		FILENO:=LOOKUP(0);
		'IF'FILENO#NONE'THEN'CLEAR(FILENO);
		STR("BACKING: ");
		PRTDEV(RSAV);
		CRLF;
		I:=RSAV*11+8;
		FNAME(I):=^B;
		FNAME(I+1):=^A;
		FNAME(I+2):=^K;
		'END';
	'END'
'ELSE''IF'FSTAT(FL)#REPLACE'THEN''EXIT';
LBLK(FL):=PARM(OTHBKL)+SWAP(PARM(OTHBKH));
CLOFIL(FL,'TRUE');
WRTDIR;
'END';






	'PROCEDURE'FIXSAV;
	'INTEGER'FL;

'BEGIN'
LOCDEV:=PARM(INDEV);
CHKDIR(LOCDEV);
FL:=PARM(INNO);
CLOFIL(FL,'FALSE');
WRTDIR;
'END';






	'PROCEDURE'LIST;
	'INTEGER'CHAR;

'BEGIN'
OPEN("   ","@@@");
'IF'PARM(INFLG)#SETUP'THEN'FILERR;
INITI(3);
CRLF;
'LOOP'	'BEGIN'
	CHAR:=CHIN(3);
	'IF'CHAR=EOF'THEN''QUIT';
	CHOUT(0,CHAR);
	'END';
PARM(OTFLG):=NOFILE;
PARM(INFLG):=NOFILE;
CRLF;
'END';\LIST






	'PROCEDURE'SHOW(TXT,FLAG);
	'ADDRESS'TXT;
	'INTEGER'FLAG;

'BEGIN'
STR(TXT);CHOUT(0,9);
'IF'FLAG'THEN'CHOUT(0,^T)'ELSE'CHOUT(0,^F);
'END';






	'PROCEDURE'DEFFILE;
	'INTEGER'K,DEV;

'BEGIN'
NAME(RNAM+8,RDEV);
STR("DEFAULT NAME: ");
'IF'GOTFIL'THEN'
	'BEGIN'
	CHKDIR(SYSDEV);
	'FOR'K:=0,10'DO'RNAM(K):=LOCNAM(K);
	'FOR'K:=0,10'DO'PRNAME(K):=LOCNAM(K);
	RDEV:=LOCDEV;
	PRDEV(0):=LOCDEV;
	WRTDIR;
	'END';
INTOUT(0,RDEV);STR(":");PRNAM(RNAM);CRLF;
SHOW("PACK:",PAKFLG);CRLF;
SHOW("BACKUP:",BAKFLG);CRLF;
SHOW("CHECK:",CHKFLG);CRLF;
'END';





	'PROCEDURE'SETFLAG(FL);
	'INTEGER'FL;
'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;

HASH:=CHAR;
NEXT;
HASH:=HASH+SWAP(CHAR);

CHKDIR(SYSDEV);

      'IF'HASH=^P+SWAP(^A)'THEN'[FLAGS(0):=FL;PAKFLG:=FL]
'ELSE''IF'HASH=^B+SWAP(^A)'THEN'[FLAGS(1):=FL;BAKFLG:=FL]
'ELSE''IF'HASH=^C+SWAP(^H)'THEN'[FLAGS(2):=FL;CHKFLG:=FL]
'ELSE' ERROR("FLAG DOES NOT EXIST");
WRTDIR;
'END';


	'PROCEDURE'SETDRV(DEV);
'INTEGER'DEV;
'BEGIN'
VALDRV(DEV);

SYSDEV:=DEV;
RDDIR(DEV);

RDEV:=PRDEV(0);

'FOR'I:=0,10'DO'RNAM(I):=PRNAME(I);
PAKFLG:=FLAGS(0);
BAKFLG:=FLAGS(1);
CHKFLG:=FLAGS(2);
'END';





	'PROCEDURE'DRIVE;
'INTEGER'DR;
'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'
	'BEGIN'
	DR:=NUMBER;
	SETDRV(DR);
	PARM(DEFDEV):=SYSDEV;
	ABORT;
	'END';

STR("SYSTEM UNIT:");
NUM(SYSDEV);
CRLF;
'END';


	'PROCEDURE'SIZER;
'BEGIN'
'WHILE'CHAR=^ 'DO'NEXT;
'IF'NUMERIC'THEN'ACTDEV:=NUMBER;
'IF'CHAR=^:'THEN'NEXT;

CHKDIR(ACTDEV);
'IF'CHAR=^='THEN'
	'BEGIN'
	MAXBLK:=NUMBER-1;
	PMAXB(0):=MAXBLK;
	WRTDIR;
	'END';
STR("UNIT ");
NUM(ACTDEV);
STR(" HAS SIZE ");
NUM(MAXBLK+1);
CRLF;
'END';
		


'BEGIN'\MAIN PROC\
\SETUP ABSOLUTE ADDRESSES
PARM:=$BF00;	\LOCATION OF RESIDENT SYSTEM PAGE
COMPAG:=$BF00;	\LOCATION OF PROGRAM DEPENDENT COMMUNICATIONS PAGE

BLKSIZ:=256;			\SIZE OF A BLOCK IN BYTES

SWAPBLK:=COMPAG(SWBLKX)+SWAP(COMPAG(SWBLKX+1));
SYSBLK:=COMPAG(SYBLKX)+SWAP(COMPAG(SYBLKX+1));
DIRBLK:=9;			\LOCATION OF DIRECTORY BLOCK
DIRSIZ:=4;			\SIZE OF DIRECTORY IN "BLKSIZ" BLOCKS
BACKBLK:=DIRBLK+DIRSIZ;		\LOCATION OF BACKUP DIRECTORY
USERBLK:=BACKBLK+DIRSIZ;	\START OF USER FILE SPACE

MAXFL:=47;	\SELECT SO THAT DIRSIZ IS RIGHT


\RESERVE THE ARRAYS
I:=(MAXFL+1)*2;
\BLOCKS 0-2
FNAME:=RESERVE((MAXFL+1)*11);
FSTAT:=RESERVE(MAXFL+1);
FBLK:=RESERVE(I);
LBLK:=RESERVE(I);
\BLOCK 3
FREE1:=RESERVE(74);
PRDEV:=RESERVE(1);
PMAXB:=RESERVE(2);
PRNAME:=RESERVE(11);
TITLE:=RESERVE(60);
VOLUME:=RESERVE(2);
DIRDAT:=RESERVE(2);
FDATE:=RESERVE(I);
FLAGS:=RESERVE(8);

\NON DIR ARRAYS
LOCNAM:=RESERVE(11);
STAB:=RESERVE(48);
RNAM:=RESERVE(11);

CRLF;


'IF''NOT'RERUN'THEN'
	[STR("APEX V1.0");CRLF];
SYSDEV:=0;
SETDRV(PARM(DEFDEV));
'IF' PARM(SYSENT)=RELOAD 'THEN'
	'BEGIN'
	STR("RELOADED FROM UNIT ");NUM(SYSDEV);CRLF;
	'END';

'IF'PARM(OTFLG)=CLOSED'THEN'[UPDATE;PARM(OTFLG):=NOFILE];
SWAPFLG:='FALSE';
'IF'PARM(SYSENT)=SAVEIN'THEN'
	'BEGIN'
	FIXSAV;
	SWAPFLG:='TRUE';
	PARM(INFLG):=NOFILE;
	'END'
'ELSE''IF'PARM(SYSENT)=SWAPIN'THEN'SWAPFLG:='TRUE';

PARM(OTFLG):=NOFILE;PARM(INFLG):=NOFILE;
\COMMAND DECODER
'LOOP'
	'BEGIN'\COMMAND LOOP
	SWITCH:=^ ;
	SPECIAL:=1;
	INSIZE:=0;
	INDATE:=SYSDAT;		\DEFAULT DATE
	STR("APX>");
	INITI(0);
	CHAR:=^ ;
	NAME("SAV",SYSDEV);
'IF'GOTFIL'THEN'
'BEGIN'\IS COMMAND
	ACTDEV:=LOCDEV;
	FILENO:=LOOKUP(0);
	'IF'FILENO#NONE'THEN'RUN(FILENO)
	'ELSE'
	'BEGIN'\NOT A RUN
	'IF'DRVSET'THEN'FILERR
		'ELSE'ACTDEV:=RDEV;
	HASH:=LOCNAM(0)+SWAP(LOCNAM(1));
	DONE:='FALSE';

'IF'HASH=^Z+SWAP(^E)'THEN'ZERO
'ELSE'
'IF'HASH=^M+SWAP(^A)'THEN'MAKE
'ELSE'
'IF'HASH=^D+SWAP(^I)'THEN'DIR
'ELSE'
'IF'HASH=^D+SWAP(^E)'THEN'DELETE
'ELSE'
'IF'HASH=^S+SWAP(^A)'THEN'SAVE
'ELSE'
'IF'HASH=^O+SWAP(^P)'THEN'OPEN("@@@","@@@")
'ELSE'
'IF'HASH=^I+SWAP(^N)'THEN'INIT
'ELSE'
'IF'HASH=^S+SWAP(^T)'THEN'RESTART('TRUE')
'ELSE'
'IF'HASH=^S+SWAP(^W)'THEN'RESTART('FALSE')
'ELSE'
'IF'HASH=^G+SWAP(^E)'THEN'GET
'ELSE'
'IF'HASH=^R+SWAP(^E)'THEN'RENAME
'ELSE'
'IF'HASH=^C+SWAP(^L)'THEN'UPDATE
'ELSE'
'IF'HASH=^L+SWAP(^I)'THEN'LIST
'ELSE'
'IF'HASH=^T+SWAP(^I)'THEN'NEWTITLE
'ELSE'
'IF'HASH=^D+SWAP(^F)'THEN'DEFFILE
'ELSE'
'IF'HASH=^D+SWAP(^A)'THEN'RDDAT
'ELSE'
'IF'HASH=^B+SWAP(^D)'THEN'BACKDIR
'ELSE'
'IF'HASH=^D+SWAP(^O)'THEN'SETFLAG('TRUE')
'ELSE'
'IF'HASH=^N+SWAP(^O)'THEN'SETFLAG('FALSE')
'ELSE'
'IF'HASH=^S+SWAP(^Y)'THEN'DRIVE
'ELSE'
'IF'HASH=^S+SWAP(^I)'THEN'SIZER
'ELSE'
'IF'HASH=^N+SWAP(^E)'THEN'SETDRV(PARM(DEFDEV))

'ELSE'
[CHOUT(0,BEL);STR("I BEG YOUR PARDON?");CRLF];
	'END';\NOT A RUN
'END';\IS COMMAND

	'END';\COMMAND LOOP
'END';\OF ALL
