module ramcard(mclk28,reset_in,strobe,addr,ram_addr, we, card_ram_we,card_ram_rd, bank1);
    input mclk28;
    input reset_in, strobe;
    input [15:0] addr;
    output [15:0] ram_addr;
    input we;
    output card_ram_we;
    output card_ram_rd;
	 output bank1;

	 reg bank1, read_en, write_en, pre_wr_en;
	 wire Dxxx;

	 always @(posedge mclk28) begin
		 if(reset_in) begin
		 	bank1 <= 0;
			read_en <= 0;
			write_en <= 1;
			pre_wr_en <= 0;
		 end else begin
			 if((addr[15:4] == 'hC08) & strobe) begin 
			 	bank1 <= addr[3]; 
			   pre_wr_en <= addr[0] & ~we; 
				write_en <= addr[0] & pre_wr_en & ~we; 
				read_en <= ~(addr[0]	^ addr[1]);
			 end
		 end
	 end

	 assign Dxxx = (addr[15:12] == 4'b1101);
	 assign ram_addr = {addr[15:13], addr[12] & ~(bank1 & Dxxx)  , addr[11:0]};
	 assign card_ram_we = write_en;
	 assign card_ram_rd = read_en;

endmodule
