module lores_color_map( nibble, RGB_val);

input [3:0] nibble;
output reg [11:0] RGB_val;

/*
Color    Color Register    Master Color
Name         Value            Value
---------------------------------------
Black         $0              $0000		
Deep Red      $1              $0D03		
Dark Blue     $2              $0009		
Purple        $3              $0D2D		
Dark Green    $4              $0072		
Dark Gray     $5              $0555		
Medium Blue   $6              $022F		
Light Blue    $7              $06AF		
Brown         $8              $0850		
Orange        $9              $0F60		
Light Gray    $A              $0AAA		
Pink          $B              $0F98		
Light Green   $C              $01D0		
Yellow        $D              $0FF0		
Aquamarine    $E              $04F9		
White         $F              $0FFF		
---------------------------------------
*/


	always @* begin
		case (nibble)
			4'b0000: RGB_val <= 12'h000;
			4'b0001: RGB_val <= 12'hD03;
			4'b0010: RGB_val <= 12'h009;
			4'b0011: RGB_val <= 12'hD2D;
			4'b0100: RGB_val <= 12'h072;
			4'b0101: RGB_val <= 12'h555;
			4'b0110: RGB_val <= 12'h22f;
			4'b0111: RGB_val <= 12'h6af;
			4'b1000: RGB_val <= 12'h850;
			4'b1001: RGB_val <= 12'hf60;
			4'b1010: RGB_val <= 12'haaa;
			4'b1011: RGB_val <= 12'hf98;
			4'b1100: RGB_val <= 12'h1d0;
			4'b1101: RGB_val <= 12'hff0;
			4'b1110: RGB_val <= 12'h4f9;
			4'b1111: RGB_val <= 12'hfff;			
		endcase
	end	
endmodule
